# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr

class PaymentWebhookCustomerEntity(BaseModel):
    """
    customer details object in webhook
    """
    customer_name: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = None
    customer_email: Optional[StrictStr] = None
    customer_phone: Optional[StrictStr] = None
    __properties = ["customer_name", "customer_id", "customer_email", "customer_phone"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaymentWebhookCustomerEntity:
        """Create an instance of PaymentWebhookCustomerEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentWebhookCustomerEntity:
        """Create an instance of PaymentWebhookCustomerEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaymentWebhookCustomerEntity.parse_obj(obj)

        _obj = PaymentWebhookCustomerEntity.parse_obj({
            "customer_name": obj.get("customer_name"),
            "customer_id": obj.get("customer_id"),
            "customer_email": obj.get("customer_email"),
            "customer_phone": obj.get("customer_phone")
        })
        return _obj


