# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr

class PaymentWebhookErrorEntity(BaseModel):
    """
    error details present in the webhook
    """
    error_code: Optional[StrictStr] = None
    error_description: Optional[StrictStr] = None
    error_reason: Optional[StrictStr] = None
    error_source: Optional[StrictStr] = None
    error_code_raw: Optional[StrictStr] = None
    error_description_raw: Optional[StrictStr] = None
    __properties = ["error_code", "error_description", "error_reason", "error_source", "error_code_raw", "error_description_raw"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PaymentWebhookErrorEntity:
        """Create an instance of PaymentWebhookErrorEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentWebhookErrorEntity:
        """Create an instance of PaymentWebhookErrorEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PaymentWebhookErrorEntity.parse_obj(obj)

        _obj = PaymentWebhookErrorEntity.parse_obj({
            "error_code": obj.get("error_code"),
            "error_description": obj.get("error_description"),
            "error_reason": obj.get("error_reason"),
            "error_source": obj.get("error_source"),
            "error_code_raw": obj.get("error_code_raw"),
            "error_description_raw": obj.get("error_description_raw")
        })
        return _obj


