# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class RateLimitError(BaseModel):
    """
    Error when rate limit is breached for your api
    """
    message: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    type: Optional[StrictStr] = Field(None, description="rate_limit_error")
    __properties = ["message", "code", "type"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('rate_limit_error'):
            raise ValueError("must be one of enum values ('rate_limit_error')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RateLimitError:
        """Create an instance of RateLimitError from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RateLimitError:
        """Create an instance of RateLimitError from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RateLimitError.parse_obj(obj)

        _obj = RateLimitError.parse_obj({
            "message": obj.get("message"),
            "code": obj.get("code"),
            "type": obj.get("type")
        })
        return _obj


