# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, validator
from cashfree_pg.models.refund_speed import RefundSpeed
from cashfree_pg.models.vendor_split import VendorSplit

class RefundEntity(BaseModel):
    """
    The refund entity
    """
    cf_payment_id: Optional[StrictInt] = Field(None, description="Cashfree Payments ID of the payment for which refund is initiated")
    cf_refund_id: Optional[StrictStr] = Field(None, description="Cashfree Payments ID for a refund")
    order_id: Optional[StrictStr] = Field(None, description="Merchant’s order Id of the order for which refund is initiated")
    refund_id: Optional[StrictStr] = Field(None, description="Merchant’s refund ID of the refund")
    entity: Optional[StrictStr] = Field(None, description="Type of object")
    refund_amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Amount that is refunded")
    refund_currency: Optional[StrictStr] = Field(None, description="Currency of the refund amount")
    refund_note: Optional[StrictStr] = Field(None, description="Note added by merchant for the refund")
    refund_status: Optional[StrictStr] = Field(None, description="This can be one of [\"SUCCESS\", \"PENDING\", \"CANCELLED\", \"ONHOLD\", \"FAILED\"]")
    refund_arn: Optional[StrictStr] = Field(None, description="The bank reference number for refund")
    refund_charge: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="Charges in INR for processing refund")
    status_description: Optional[StrictStr] = Field(None, description="Description of refund status")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Key-value pair that can be used to store additional information about the entity. Maximum 5 key-value pairs")
    refund_splits: Optional[conlist(VendorSplit)] = None
    refund_type: Optional[StrictStr] = Field(None, description="This can be one of [\"PAYMENT_AUTO_REFUND\", \"MERCHANT_INITIATED\", \"UNRECONCILED_AUTO_REFUND\"]")
    refund_mode: Optional[StrictStr] = Field(None, description="Method or speed of processing refund")
    created_at: Optional[StrictStr] = Field(None, description="Time of refund creation")
    processed_at: Optional[StrictStr] = Field(None, description="Time when refund was processed successfully")
    refund_speed: Optional[RefundSpeed] = None
    __properties = ["cf_payment_id", "cf_refund_id", "order_id", "refund_id", "entity", "refund_amount", "refund_currency", "refund_note", "refund_status", "refund_arn", "refund_charge", "status_description", "metadata", "refund_splits", "refund_type", "refund_mode", "created_at", "processed_at", "refund_speed"]

    @validator('entity')
    def entity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('refund'):
            raise ValueError("must be one of enum values ('refund')")
        return value

    @validator('refund_status')
    def refund_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('SUCCESS', 'PENDING', 'CANCELLED', 'ONHOLD'):
            raise ValueError("must be one of enum values ('SUCCESS', 'PENDING', 'CANCELLED', 'ONHOLD')")
        return value

    @validator('refund_type')
    def refund_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PAYMENT_AUTO_REFUND', 'MERCHANT_INITIATED', 'UNRECONCILED_AUTO_REFUND'):
            raise ValueError("must be one of enum values ('PAYMENT_AUTO_REFUND', 'MERCHANT_INITIATED', 'UNRECONCILED_AUTO_REFUND')")
        return value

    @validator('refund_mode')
    def refund_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('STANDARD', 'INSTANT'):
            raise ValueError("must be one of enum values ('STANDARD', 'INSTANT')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RefundEntity:
        """Create an instance of RefundEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in refund_splits (list)
        _items = []
        if self.refund_splits:
            for _item in self.refund_splits:
                if _item:
                    _items.append(_item.to_dict())
            _dict['refund_splits'] = _items
        # override the default output from pydantic by calling `to_dict()` of refund_speed
        if self.refund_speed:
            _dict['refund_speed'] = self.refund_speed.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RefundEntity:
        """Create an instance of RefundEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RefundEntity.parse_obj(obj)

        _obj = RefundEntity.parse_obj({
            "cf_payment_id": obj.get("cf_payment_id"),
            "cf_refund_id": obj.get("cf_refund_id"),
            "order_id": obj.get("order_id"),
            "refund_id": obj.get("refund_id"),
            "entity": obj.get("entity"),
            "refund_amount": obj.get("refund_amount"),
            "refund_currency": obj.get("refund_currency"),
            "refund_note": obj.get("refund_note"),
            "refund_status": obj.get("refund_status"),
            "refund_arn": obj.get("refund_arn"),
            "refund_charge": obj.get("refund_charge"),
            "status_description": obj.get("status_description"),
            "metadata": obj.get("metadata"),
            "refund_splits": [VendorSplit.from_dict(_item) for _item in obj.get("refund_splits")] if obj.get("refund_splits") is not None else None,
            "refund_type": obj.get("refund_type"),
            "refund_mode": obj.get("refund_mode"),
            "created_at": obj.get("created_at"),
            "processed_at": obj.get("processed_at"),
            "refund_speed": RefundSpeed.from_dict(obj.get("refund_speed")) if obj.get("refund_speed") is not None else None
        })
        return _obj


