# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class UPIAuthorizeDetails(BaseModel):
    """
    object when you are using preauth in UPI in order pay
    """
    approve_by: Optional[StrictStr] = Field(None, description="Time by which this authorization should be approved by the customer.")
    start_time: Optional[StrictStr] = Field(None, description="This is the time when the UPI one time mandate will start")
    end_time: Optional[StrictStr] = Field(None, description="This is the time when the UPI mandate will be over. If the mandate has not been executed by this time, the funds will be returned back to the customer after this time.")
    __properties = ["approve_by", "start_time", "end_time"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UPIAuthorizeDetails:
        """Create an instance of UPIAuthorizeDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UPIAuthorizeDetails:
        """Create an instance of UPIAuthorizeDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UPIAuthorizeDetails.parse_obj(obj)

        _obj = UPIAuthorizeDetails.parse_obj({
            "approve_by": obj.get("approve_by"),
            "start_time": obj.get("start_time"),
            "end_time": obj.get("end_time")
        })
        return _obj


