# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import unittest
import datetime

import cashfree_pg
from cashfree_pg.models.order_entity import OrderEntity  # noqa: E501
from cashfree_pg.rest import ApiException

class TestOrderEntity(unittest.TestCase):
    """OrderEntity unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test OrderEntity
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # uncomment below to create an instance of `OrderEntity`
        """
        model = cashfree_pg.models.order_entity.OrderEntity()  # noqa: E501
        if include_optional :
            return OrderEntity(
                cf_order_id = 56, 
                order_id = '', 
                entity = '', 
                order_currency = '', 
                order_amount = 1.337, 
                order_status = '', 
                payment_session_id = '', 
                order_expiry_time = datetime.datetime.strptime('2013-10-20 19:20:30.00', '%Y-%m-%d %H:%M:%S.%f'), 
                order_note = '', 
                created_at = '2022-08-16T14:45:38+05:30', 
                order_splits = [
                    {"vendor_id":"Vendor01","amount":100.12,"description":"order amount should be more than equal to 100.12"}
                    ], 
                customer_details = {"customer_id":"7112AAA812234","customer_email":"john@cashfree.com","customer_phone":"9908734801","customer_name":"John Doe","customer_bank_account_number":"1518121112","customer_bank_ifsc":"XITI0000001","customer_bank_code":3333}, 
                order_meta = cashfree_pg.models.order_meta.OrderMeta(
                    return_url = 'https://example.com/return?order_id={order_id}', 
                    notify_url = 'https://example.com/cf_notify', 
                    payment_methods = cc,dc,upi, ), 
                payments = cashfree_pg.models.payment_url_object.PaymentURLObject(
                    url = 'https://sandbox.cashfree.com/pg/orders/order_271vovQ3PTZAx3fDI0xtZbC4jkPET/payments', ), 
                settlements = cashfree_pg.models.settlement_url_object.SettlementURLObject(
                    url = 'https://sandbox.cashfree.com/pg/orders/order_271vovQ3PTZAx3fDI0xtZbC4jkPET/settlements', ), 
                refunds = cashfree_pg.models.refund_url_object.RefundURLObject(
                    url = 'https://sandbox.cashfree.com/pg/orders/order_271vovQ3PTZAx3fDI0xtZbC4jkPET/refunds', ), 
                order_tags = {"product":"Laptop","shipping_address":"123 Main St"}
            )
        else :
            return OrderEntity(
        )
        """

    def testOrderEntity(self):
        """Test OrderEntity"""
        # inst_req_only = self.make_instance(include_optional=False)
        # inst_req_and_optional = self.make_instance(include_optional=True)

if __name__ == '__main__':
    unittest.main()
