"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnBackend = exports.MinTlsVersion = exports.MaxTlsVersion = exports.toJson_CfnBackendProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnBackendProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnBackendProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Address': obj.address,
        'AutoLoadbalance': obj.autoLoadbalance,
        'BetweenBytesTimeout': obj.betweenBytesTimeout,
        'ClientCert': obj.clientCert,
        'Comment': obj.comment,
        'ConnectTimeout': obj.connectTimeout,
        'FirstByteTimeout': obj.firstByteTimeout,
        'Healthcheck': obj.healthcheck,
        'Ipv4': obj.ipv4,
        'Ipv6': obj.ipv6,
        'MaxConn': obj.maxConn,
        'MaxTlsVersion': obj.maxTlsVersion,
        'MinTlsVersion': obj.minTlsVersion,
        'Name': obj.name,
        'OverrideHost': obj.overrideHost,
        'Port': obj.port,
        'RequestCondition': obj.requestCondition,
        'Shield': obj.shield,
        'SslCaCert': obj.sslCaCert,
        'SslCertHostname': obj.sslCertHostname,
        'SslCheckCert': obj.sslCheckCert,
        'SslCiphers': obj.sslCiphers,
        'SslClientCert': obj.sslClientCert,
        'SslClientKey': obj.sslClientKey,
        'SslSniHostname': obj.sslSniHostname,
        'UseSsl': obj.useSsl,
        'Weight': obj.weight,
        'ServiceId': obj.serviceId,
        'BackendName': obj.backendName,
        'VersionId': obj.versionId,
        'CreatedAt': obj.createdAt?.toISOString(),
        'UpdatedAt': obj.updatedAt?.toISOString(),
        'DeletedAt': obj.deletedAt?.toISOString(),
        'Version': obj.version,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnBackendProps = toJson_CfnBackendProps;
/* eslint-enable max-len, quote-props */
/**
 * Maximum allowed TLS version on SSL connections to this backend. If your backend server is not able to negotiate a connection meeting this constraint, a synthetic 503 error response will be generated.
 *
 * @schema MaxTlsVersion
 */
var MaxTlsVersion;
(function (MaxTlsVersion) {
    /** 1 */
    MaxTlsVersion["VALUE_1"] = "1";
    /** 1.0 */
    MaxTlsVersion["VALUE_1_0"] = "1.0";
    /** 1.1 */
    MaxTlsVersion["VALUE_1_1"] = "1.1";
    /** 1.2 */
    MaxTlsVersion["VALUE_1_2"] = "1.2";
    /** 1.3 */
    MaxTlsVersion["VALUE_1_3"] = "1.3";
})(MaxTlsVersion = exports.MaxTlsVersion || (exports.MaxTlsVersion = {}));
/**
 * Minimum allowed TLS version on SSL connections to this backend. If your backend server is not able to negotiate a connection meeting this constraint, a synthetic 503 error response will be generated.
 *
 * @schema MinTlsVersion
 */
var MinTlsVersion;
(function (MinTlsVersion) {
    /** 1 */
    MinTlsVersion["VALUE_1"] = "1";
    /** 1.0 */
    MinTlsVersion["VALUE_1_0"] = "1.0";
    /** 1.1 */
    MinTlsVersion["VALUE_1_1"] = "1.1";
    /** 1.2 */
    MinTlsVersion["VALUE_1_2"] = "1.2";
    /** 1.3 */
    MinTlsVersion["VALUE_1_3"] = "1.3";
})(MinTlsVersion = exports.MinTlsVersion || (exports.MinTlsVersion = {}));
/**
 * A CloudFormation `Fastly::Services::Backend`
 *
 * @cloudformationResource Fastly::Services::Backend
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
class CfnBackend extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Services::Backend`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnBackend.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnBackendProps(props) });
        this.props = props;
    }
}
exports.CfnBackend = CfnBackend;
_a = JSII_RTTI_SYMBOL_1;
CfnBackend[_a] = { fqn: "@cdk-cloudformation/fastly-services-backend.CfnBackend", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnBackend.CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Backend";
//# sourceMappingURL=data:application/json;base64,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