# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AuthenticatorArgs', 'Authenticator']

@pulumi.input_type
class AuthenticatorArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 provider_auth_port: Optional[pulumi.Input[int]] = None,
                 provider_hostname: Optional[pulumi.Input[str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Authenticator resource.
        :param pulumi.Input[str] key: A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        :param pulumi.Input[str] name: Name of the authenticator.
        :param pulumi.Input[int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_hostname: Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] settings: Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        :param pulumi.Input[str] status: Status of the authenticator. Default is `ACTIVE`.
        """
        pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_auth_port is not None:
            pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_hostname is not None:
            pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_shared_secret is not None:
            pulumi.set(__self__, "provider_shared_secret", provider_shared_secret)
        if provider_user_name_template is not None:
            pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authenticator.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> Optional[pulumi.Input[int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_auth_port")

    @provider_auth_port.setter
    def provider_auth_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provider_auth_port", value)

    @property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_hostname")

    @provider_hostname.setter
    def provider_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_hostname", value)

    @property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> Optional[pulumi.Input[str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_shared_secret")

    @provider_shared_secret.setter
    def provider_shared_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_shared_secret", value)

    @property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_user_name_template")

    @provider_user_name_template.setter
    def provider_user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_user_name_template", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the authenticator. Default is `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _AuthenticatorState:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_auth_port: Optional[pulumi.Input[int]] = None,
                 provider_hostname: Optional[pulumi.Input[str]] = None,
                 provider_instance_id: Optional[pulumi.Input[str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[str]] = None,
                 provider_type: Optional[pulumi.Input[str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Authenticator resources.
        :param pulumi.Input[str] key: A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        :param pulumi.Input[str] name: Name of the authenticator.
        :param pulumi.Input[int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_hostname: Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_instance_id: App Instance ID.
        :param pulumi.Input[str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_type: The type of Authenticator. Values include: `"password"`, `"security_question"`, `"phone"`, `"email"`, `"app"`, `"federated"`, and `"security_key"`.
        :param pulumi.Input[str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] settings: Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        :param pulumi.Input[str] status: Status of the authenticator. Default is `ACTIVE`.
        :param pulumi.Input[str] type: Type of the Authenticator.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider_auth_port is not None:
            pulumi.set(__self__, "provider_auth_port", provider_auth_port)
        if provider_hostname is not None:
            pulumi.set(__self__, "provider_hostname", provider_hostname)
        if provider_instance_id is not None:
            pulumi.set(__self__, "provider_instance_id", provider_instance_id)
        if provider_shared_secret is not None:
            pulumi.set(__self__, "provider_shared_secret", provider_shared_secret)
        if provider_type is not None:
            pulumi.set(__self__, "provider_type", provider_type)
        if provider_user_name_template is not None:
            pulumi.set(__self__, "provider_user_name_template", provider_user_name_template)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the authenticator.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> Optional[pulumi.Input[int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_auth_port")

    @provider_auth_port.setter
    def provider_auth_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provider_auth_port", value)

    @property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> Optional[pulumi.Input[str]]:
        """
        Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_hostname")

    @provider_hostname.setter
    def provider_hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_hostname", value)

    @property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @provider_instance_id.setter
    def provider_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_instance_id", value)

    @property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> Optional[pulumi.Input[str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_shared_secret")

    @provider_shared_secret.setter
    def provider_shared_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_shared_secret", value)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Authenticator. Values include: `"password"`, `"security_question"`, `"phone"`, `"email"`, `"app"`, `"federated"`, and `"security_key"`.
        """
        return pulumi.get(self, "provider_type")

    @provider_type.setter
    def provider_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_type", value)

    @property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> Optional[pulumi.Input[str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_user_name_template")

    @provider_user_name_template.setter
    def provider_user_name_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_user_name_template", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the authenticator. Default is `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Authenticator.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Authenticator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_auth_port: Optional[pulumi.Input[int]] = None,
                 provider_hostname: Optional[pulumi.Input[str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to configure different authenticators.

        > **NOTE:** An authenticator can only be deleted if it's not in use by any policy.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.Authenticator("test",
            key="security_question",
            settings=json.dumps({
                "allowedFor": "recovery",
            }))
        ```

        ## Import

        Okta authenticator can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/authenticator:Authenticator example <authenticator_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        :param pulumi.Input[str] name: Name of the authenticator.
        :param pulumi.Input[int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_hostname: Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] settings: Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        :param pulumi.Input[str] status: Status of the authenticator. Default is `ACTIVE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthenticatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.

        This resource allows you to configure different authenticators.

        > **NOTE:** An authenticator can only be deleted if it's not in use by any policy.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_okta as okta

        test = okta.Authenticator("test",
            key="security_question",
            settings=json.dumps({
                "allowedFor": "recovery",
            }))
        ```

        ## Import

        Okta authenticator can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/authenticator:Authenticator example <authenticator_id>
        ```

        :param str resource_name: The name of the resource.
        :param AuthenticatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthenticatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider_auth_port: Optional[pulumi.Input[int]] = None,
                 provider_hostname: Optional[pulumi.Input[str]] = None,
                 provider_shared_secret: Optional[pulumi.Input[str]] = None,
                 provider_user_name_template: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthenticatorArgs.__new__(AuthenticatorArgs)

            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            __props__.__dict__["provider_auth_port"] = provider_auth_port
            __props__.__dict__["provider_hostname"] = provider_hostname
            __props__.__dict__["provider_shared_secret"] = provider_shared_secret
            __props__.__dict__["provider_user_name_template"] = provider_user_name_template
            __props__.__dict__["settings"] = settings
            __props__.__dict__["status"] = status
            __props__.__dict__["provider_instance_id"] = None
            __props__.__dict__["provider_type"] = None
            __props__.__dict__["type"] = None
        super(Authenticator, __self__).__init__(
            'okta:index/authenticator:Authenticator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            provider_auth_port: Optional[pulumi.Input[int]] = None,
            provider_hostname: Optional[pulumi.Input[str]] = None,
            provider_instance_id: Optional[pulumi.Input[str]] = None,
            provider_shared_secret: Optional[pulumi.Input[str]] = None,
            provider_type: Optional[pulumi.Input[str]] = None,
            provider_user_name_template: Optional[pulumi.Input[str]] = None,
            settings: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Authenticator':
        """
        Get an existing Authenticator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key: A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        :param pulumi.Input[str] name: Name of the authenticator.
        :param pulumi.Input[int] provider_auth_port: The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_hostname: Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_instance_id: App Instance ID.
        :param pulumi.Input[str] provider_shared_secret: An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] provider_type: The type of Authenticator. Values include: `"password"`, `"security_question"`, `"phone"`, `"email"`, `"app"`, `"federated"`, and `"security_key"`.
        :param pulumi.Input[str] provider_user_name_template: Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        :param pulumi.Input[str] settings: Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        :param pulumi.Input[str] status: Status of the authenticator. Default is `ACTIVE`.
        :param pulumi.Input[str] type: Type of the Authenticator.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthenticatorState.__new__(_AuthenticatorState)

        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["provider_auth_port"] = provider_auth_port
        __props__.__dict__["provider_hostname"] = provider_hostname
        __props__.__dict__["provider_instance_id"] = provider_instance_id
        __props__.__dict__["provider_shared_secret"] = provider_shared_secret
        __props__.__dict__["provider_type"] = provider_type
        __props__.__dict__["provider_user_name_template"] = provider_user_name_template
        __props__.__dict__["settings"] = settings
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return Authenticator(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        A human-readable string that identifies the authenticator. Possible values inclue: `"duo"`, `"external_idp"`, `"google_otp"`, `"okta_email"`, `"okta_password"`, `"okta_verify"`, `"onprem_mfa"`, `"phone_number"`, `"rsa_token"`, `"security_question"`, `"webauthn"`, and `"yubikey_token"`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the authenticator.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerAuthPort")
    def provider_auth_port(self) -> pulumi.Output[Optional[int]]:
        """
        The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured. Default is `9000`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_auth_port")

    @property
    @pulumi.getter(name="providerHostname")
    def provider_hostname(self) -> pulumi.Output[Optional[str]]:
        """
        Server host name or IP address. Default is `"localhost"`. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_hostname")

    @property
    @pulumi.getter(name="providerInstanceId")
    def provider_instance_id(self) -> pulumi.Output[str]:
        """
        App Instance ID.
        """
        return pulumi.get(self, "provider_instance_id")

    @property
    @pulumi.getter(name="providerSharedSecret")
    def provider_shared_secret(self) -> pulumi.Output[Optional[str]]:
        """
        An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_shared_secret")

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> pulumi.Output[str]:
        """
        The type of Authenticator. Values include: `"password"`, `"security_question"`, `"phone"`, `"email"`, `"app"`, `"federated"`, and `"security_key"`.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="providerUserNameTemplate")
    def provider_user_name_template(self) -> pulumi.Output[Optional[str]]:
        """
        Username template expected by the provider. Used only for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "provider_user_name_template")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[str]]:
        """
        Settings for the authenticator. Settings object contains values based on Authenticator key. It is not used for authenticators with type `"security_key"`.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Status of the authenticator. Default is `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the Authenticator.
        """
        return pulumi.get(self, "type")

