# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['GroupMembershipsArgs', 'GroupMemberships']

@pulumi.input_type
class GroupMembershipsArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 users: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a GroupMemberships resource.
        :param pulumi.Input[str] group_id: Okta group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        Okta group ID.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _GroupMembershipsState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering GroupMemberships resources.
        :param pulumi.Input[str] group_id: Okta group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Okta group ID.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "users", value)


class GroupMemberships(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource to manage a set of memberships for a specific group.

        This resource will allow you to bulk manage group membership in Okta for a given group. This offers an interface to pass multiple users into a single resource call, for better API resource usage. Effectively this is the same as using the `group.Membership` resource several times with a single group and different users. If you need a relationship of a single user to many groups, please use the `UserGroupMemberships` resource.

        When using this with a `user.User` resource, you should add a lifecycle ignore for group memberships to avoid conflicts in desired state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test_group = okta.group.Group("testGroup", description="testing, testing")
        test_group_memberships = okta.GroupMemberships("testGroupMemberships",
            group_id=test_group.id,
            users=[
                okta_user["test1"]["id"],
                okta_user["test2"]["id"],
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_id: Okta group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupMembershipsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource to manage a set of memberships for a specific group.

        This resource will allow you to bulk manage group membership in Okta for a given group. This offers an interface to pass multiple users into a single resource call, for better API resource usage. Effectively this is the same as using the `group.Membership` resource several times with a single group and different users. If you need a relationship of a single user to many groups, please use the `UserGroupMemberships` resource.

        When using this with a `user.User` resource, you should add a lifecycle ignore for group memberships to avoid conflicts in desired state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test_group = okta.group.Group("testGroup", description="testing, testing")
        test_group_memberships = okta.GroupMemberships("testGroupMemberships",
            group_id=test_group.id,
            users=[
                okta_user["test1"]["id"],
                okta_user["test2"]["id"],
            ])
        ```

        :param str resource_name: The name of the resource.
        :param GroupMembershipsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupMembershipsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupMembershipsArgs.__new__(GroupMembershipsArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
        super(GroupMemberships, __self__).__init__(
            'okta:index/groupMemberships:GroupMemberships',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'GroupMemberships':
        """
        Get an existing GroupMemberships resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_id: Okta group ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] users: The list of Okta user IDs which the group should have membership managed for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupMembershipsState.__new__(_GroupMembershipsState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["users"] = users
        return GroupMemberships(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        Okta group ID.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of Okta user IDs which the group should have membership managed for.
        """
        return pulumi.get(self, "users")

