# CHANGELOG


## v1.15.2 (2025-03-20)

### Bug Fixes

- **ci**: Correct CI/CD workflow naming
  ([`84d8397`](https://github.com/MountainGod2/chaturbate_poller/commit/84d8397138114c2999769e1cba16ecf9894344f9))


## v1.15.1 (2025-03-20)

### Bug Fixes

- Remove obsolete CI, CD, and Docker build workflows
  ([`5ee58e7`](https://github.com/MountainGod2/chaturbate_poller/commit/5ee58e7112b2b7a024b74232bf57b4bc1c97d07d))

### Chores

- **ci**: Rename workflow file
  ([`019051a`](https://github.com/MountainGod2/chaturbate_poller/commit/019051af5f5a1aa5745cc90e25aba31efc7f49e1))


## v1.15.0 (2025-03-20)

### Features

- **ci**: Add workflows for continuous integration, deployment, and Docker build
  ([`1d3af21`](https://github.com/MountainGod2/chaturbate_poller/commit/1d3af21eeed1b96e1251b2ca3ccd850f724cbc73))


## v1.14.6 (2025-03-20)

### Bug Fixes

- **ci**: Update PyPI publish action to use the latest release version
  ([`a74a8c2`](https://github.com/MountainGod2/chaturbate_poller/commit/a74a8c27b9bee741e44eeed0e946fde12baa47f2))


## v1.14.5 (2025-03-20)

### Bug Fixes

- **ci**: Adjust concurrency cancellation logic for non-tag references
  ([`fa9f446`](https://github.com/MountainGod2/chaturbate_poller/commit/fa9f44672cd164bf6bbe85b943432a1c99d33914))

### Chores

- **deps**: Lock file maintenance
  ([#274](https://github.com/MountainGod2/chaturbate_poller/pull/274),
  [`25646f8`](https://github.com/MountainGod2/chaturbate_poller/commit/25646f82b0d4b2e0632d96489d197613a59c9d61))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.14.4 (2025-03-20)

### Bug Fixes

- **ci**: Improve CI/CD workflow structure and enhance code quality checks
  ([`9045c6d`](https://github.com/MountainGod2/chaturbate_poller/commit/9045c6deef0d2709418687f54862b5927f2da894))

- **ci**: Refine CI/CD workflow by optimizing job steps and enhancing clarity
  ([`5a05c53`](https://github.com/MountainGod2/chaturbate_poller/commit/5a05c5350fb2c94f1d2d9bcc1b09eb05aaafab0a))

- **ci**: Streamline CI/CD workflow by removing unnecessary steps and improving clarity
  ([`cf5c3e4`](https://github.com/MountainGod2/chaturbate_poller/commit/cf5c3e4bc3dd9546f6f5f347a4d9a25c8e9d9e9b))

- **ci**: Update CI/CD workflow
  ([`5346606`](https://github.com/MountainGod2/chaturbate_poller/commit/53466065a94a0aba24878ca39c57717891c68a61))

- **ci**: Update CI/CD workflow to streamline CodeQL analysis and improve documentation build
  process
  ([`ab67369`](https://github.com/MountainGod2/chaturbate_poller/commit/ab67369278438282cb36be5a76d661355474cd9d))

### Chores

- Update type casting for nested dictionary in InfluxDBHandler
  ([`32e2850`](https://github.com/MountainGod2/chaturbate_poller/commit/32e28500b9de268e1b00119bca9029ca4748042c))


## v1.14.3 (2025-03-19)

### Bug Fixes

- Remove combined CI/CD and Docker build workflow
  ([`2e27810`](https://github.com/MountainGod2/chaturbate_poller/commit/2e278104946d6e0327564ab314a3df20cf173686))


## v1.14.2 (2025-03-19)

### Bug Fixes

- **ci**: Rename CI/CD/build workflow and update README badge
  ([`083af29`](https://github.com/MountainGod2/chaturbate_poller/commit/083af297dfd5b00961592c1d9a7d7820f05946fc))

### Chores

- Add changelog URL to pyproject.toml
  ([`3dcc807`](https://github.com/MountainGod2/chaturbate_poller/commit/3dcc80794f4d32e981057548a74531e5621cdbf8))


## v1.14.1 (2025-03-19)

### Bug Fixes

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.8
  ([#272](https://github.com/MountainGod2/chaturbate_poller/pull/272),
  [`caab56d`](https://github.com/MountainGod2/chaturbate_poller/commit/caab56d1d9477c65b179d65c3e8a30de268010ba))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Chores

- Remove CODEOWNERS file
  ([`14df0b0`](https://github.com/MountainGod2/chaturbate_poller/commit/14df0b0202788fec8f68560a54bc5b3701681ce9))

- **ci**: Add merge_group event to workflow triggers
  ([`4cc9e0b`](https://github.com/MountainGod2/chaturbate_poller/commit/4cc9e0b8166c93f5bcb18ead6bc820b56a832995))

- **ci**: Combine ci.yml and cd.ml workflows
  ([#270](https://github.com/MountainGod2/chaturbate_poller/pull/270),
  [`ed79a21`](https://github.com/MountainGod2/chaturbate_poller/commit/ed79a219344f0d0c652619ba0ae7a197ec0ded7b))

* chore(ci): combine ci.yml and cd.ml workflows for improved CI/CD process

* chore(ci): allow CI/CD workflow to trigger on develop branch

- **ci**: Consolidate workflows ([#271](https://github.com/MountainGod2/chaturbate_poller/pull/271),
  [`ca319ea`](https://github.com/MountainGod2/chaturbate_poller/commit/ca319ea0853e11abea128f03c92e95c63ac9d091))

* chore(ci): consolidate Docker build workflow into combined CI/CD workflow

* chore: remove stale issue and PR workflow

- **deps**: Lock file maintenance
  ([#266](https://github.com/MountainGod2/chaturbate_poller/pull/266),
  [`1a4dd9d`](https://github.com/MountainGod2/chaturbate_poller/commit/1a4dd9df0097ecc705647faf1ab29eaf5fe727f9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#269](https://github.com/MountainGod2/chaturbate_poller/pull/269),
  [`e8c38df`](https://github.com/MountainGod2/chaturbate_poller/commit/e8c38df048961dddcd2f1ae9de28b6f249fca079))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.11.0
  ([#265](https://github.com/MountainGod2/chaturbate_poller/pull/265),
  [`1bb23d7`](https://github.com/MountainGod2/chaturbate_poller/commit/1bb23d77bb63e2de0461cd8411b829a66fe1a1b0))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.7
  ([#268](https://github.com/MountainGod2/chaturbate_poller/pull/268),
  [`c703dea`](https://github.com/MountainGod2/chaturbate_poller/commit/c703dea2ad8e1e18decc8692e4a587949ea154e1))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.14.0 (2025-03-16)

### Chores

- **deps**: Lock file maintenance
  ([#264](https://github.com/MountainGod2/chaturbate_poller/pull/264),
  [`910a14d`](https://github.com/MountainGod2/chaturbate_poller/commit/910a14d5f51a8babd78e084e5fd69910610623f2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **tests**: Update pytest configuration for improved test path handling
  ([`f1501d1`](https://github.com/MountainGod2/chaturbate_poller/commit/f1501d196f4065cd708545fa0878aadcd4e1dd2a))

### Features

- **example**: Enhance interactive user input for Chaturbate API integration
  ([`07167d8`](https://github.com/MountainGod2/chaturbate_poller/commit/07167d8dbcafd4b58edfb5e2068b0ab9b15f695f))

### Refactoring

- Update import statements for consistency and clarity
  ([`64a1cd2`](https://github.com/MountainGod2/chaturbate_poller/commit/64a1cd2a8c2a6efd041ec07cc0c179fd6e9bcbc2))

- **event**: Extract method pattern into a constant for clarity
  ([`3e10b1b`](https://github.com/MountainGod2/chaturbate_poller/commit/3e10b1b80a85963b76aee545213e988b371cb2d8))


## v1.13.1 (2025-03-15)

### Bug Fixes

- **deps**: Update dependency rich-click to v1.8.8
  ([#256](https://github.com/MountainGod2/chaturbate_poller/pull/256),
  [`4a441d2`](https://github.com/MountainGod2/chaturbate_poller/commit/4a441d28197b98b3dab00a4590032829b11cc615))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Chores

- **deps**: Lock file maintenance
  ([#261](https://github.com/MountainGod2/chaturbate_poller/pull/261),
  [`dc7a219`](https://github.com/MountainGod2/chaturbate_poller/commit/dc7a2198e61c12bb7656c06d57b11c819a3ccb94))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#263](https://github.com/MountainGod2/chaturbate_poller/pull/263),
  [`62cbd24`](https://github.com/MountainGod2/chaturbate_poller/commit/62cbd24f0e0b1e95a7e77445baaf91327a692d5e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.6
  ([#262](https://github.com/MountainGod2/chaturbate_poller/pull/262),
  [`ae85c8d`](https://github.com/MountainGod2/chaturbate_poller/commit/ae85c8de157bc465daa5c02921a11eabf91f46ea))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update rich-click to 1.8.7 and pylint to 3.3.5
  ([`9272def`](https://github.com/MountainGod2/chaturbate_poller/commit/9272def534bcb62d65a0603db315715596e752f8))


## v1.13.0 (2025-03-09)

### Chores

- Update exclude patterns in pyproject.toml for better build management
  ([`6aff594`](https://github.com/MountainGod2/chaturbate_poller/commit/6aff5943d712e889fafb6bf1b293c012eb7872d1))

- Update renovate.json
  ([`987cd7b`](https://github.com/MountainGod2/chaturbate_poller/commit/987cd7b9a86e2edef78d425bb53ebc50b771c9fc))

- **ci**: Integrate CodeQL analysis in CI workflow
  ([#259](https://github.com/MountainGod2/chaturbate_poller/pull/259),
  [`5f02bb4`](https://github.com/MountainGod2/chaturbate_poller/commit/5f02bb4e964d4f9f9899b96c130354bf53d5d821))

- **deps**: Enable auto-approval for dependency updates in Renovate configuration
  ([`101757a`](https://github.com/MountainGod2/chaturbate_poller/commit/101757a8a4c0bd3ce5424a8c234bbfca9d17ff8b))

- **deps**: Lock file maintenance
  ([#242](https://github.com/MountainGod2/chaturbate_poller/pull/242),
  [`321bb80`](https://github.com/MountainGod2/chaturbate_poller/commit/321bb80930591180619a986acd43fb5b03270438))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#243](https://github.com/MountainGod2/chaturbate_poller/pull/243),
  [`50c66bc`](https://github.com/MountainGod2/chaturbate_poller/commit/50c66bca4dc99399130b76ea2f3defe1ec91b34e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#244](https://github.com/MountainGod2/chaturbate_poller/pull/244),
  [`73fe82c`](https://github.com/MountainGod2/chaturbate_poller/commit/73fe82cf09824eec6d524663cf5b7b4f02a9fefd))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#245](https://github.com/MountainGod2/chaturbate_poller/pull/245),
  [`208ee37`](https://github.com/MountainGod2/chaturbate_poller/commit/208ee37fa680d34a1930600276600938c0ee7d0b))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#247](https://github.com/MountainGod2/chaturbate_poller/pull/247),
  [`3aab482`](https://github.com/MountainGod2/chaturbate_poller/commit/3aab48217c11aff6af55f04afe4fe2fe23fde362))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#249](https://github.com/MountainGod2/chaturbate_poller/pull/249),
  [`71b6868`](https://github.com/MountainGod2/chaturbate_poller/commit/71b68686c5efcf777f35ff0696f3aad77437051c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#251](https://github.com/MountainGod2/chaturbate_poller/pull/251),
  [`3e7b7d5`](https://github.com/MountainGod2/chaturbate_poller/commit/3e7b7d54e39c169e9b44b79778e6bb7424d7bb80))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#253](https://github.com/MountainGod2/chaturbate_poller/pull/253),
  [`70d1955`](https://github.com/MountainGod2/chaturbate_poller/commit/70d1955f4b5758c323229ce3aa7e9d972d4c5b4f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#254](https://github.com/MountainGod2/chaturbate_poller/pull/254),
  [`6b78c59`](https://github.com/MountainGod2/chaturbate_poller/commit/6b78c596fe16ccfb17726abbc04043753ee0be54))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#257](https://github.com/MountainGod2/chaturbate_poller/pull/257),
  [`0f202db`](https://github.com/MountainGod2/chaturbate_poller/commit/0f202db71fa932e27b2e940351037e016bb5c114))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Pin dependencies to specific versions for consistency
  ([`e250de1`](https://github.com/MountainGod2/chaturbate_poller/commit/e250de17320422b50af53b00d4f7294a18cf5ad4))

- **deps**: Remove commit message prefix from Renovate configuration
  ([`48775b9`](https://github.com/MountainGod2/chaturbate_poller/commit/48775b9887dcf83340cfac6e7a685d97c3e01052))

- **deps**: Update dependency ruff to v0.9.10
  ([#252](https://github.com/MountainGod2/chaturbate_poller/pull/252),
  [`725dd7c`](https://github.com/MountainGod2/chaturbate_poller/commit/725dd7c50570ac146d5500753e05f4ce639dda5f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.4
  ([#246](https://github.com/MountainGod2/chaturbate_poller/pull/246),
  [`61bf30f`](https://github.com/MountainGod2/chaturbate_poller/commit/61bf30f68dfe1c7262811b73333da367a8f0f6b9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.5
  ([#250](https://github.com/MountainGod2/chaturbate_poller/pull/250),
  [`90eb142`](https://github.com/MountainGod2/chaturbate_poller/commit/90eb14201ae0e6afd0191f63cd4130fa7243c07a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update Renovate configuration for improved dependency management
  ([`446e31d`](https://github.com/MountainGod2/chaturbate_poller/commit/446e31d982c24385474f2c395d61b9a1f7bce1b6))

### Continuous Integration

- Optimize documentation build command by enabling parallel jobs
  ([`ee408c5`](https://github.com/MountainGod2/chaturbate_poller/commit/ee408c533037e2abd44eeda4a7bcd3c8fa35c51c))

### Documentation

- Update build command in README for Sphinx documentation
  ([`3d10302`](https://github.com/MountainGod2/chaturbate_poller/commit/3d10302dfee6a4d972d43e43bceec6a358ee175e))

- **readme**: Add InfluxDB integration section with sample queries and usage examples
  ([`0750869`](https://github.com/MountainGod2/chaturbate_poller/commit/0750869798ed552e5ff553508b61363e3f16ed65))

- **README**: Change code block syntax from flux to text for clarity
  ([`4856234`](https://github.com/MountainGod2/chaturbate_poller/commit/4856234a828a06c22d4868a657bb8fc2a5f6db4d))

### Features

- Add environment variable checks for username and token in examples
  ([#260](https://github.com/MountainGod2/chaturbate_poller/pull/260),
  [`8aa3f33`](https://github.com/MountainGod2/chaturbate_poller/commit/8aa3f33776c05d1ebe8048ee5263d65c6730f1bd))

### Refactoring

- Change is_anon type from Literal to str in format_tip_event function
  ([`ba7f45f`](https://github.com/MountainGod2/chaturbate_poller/commit/ba7f45ff3ab497310a07b9ebefe4c8cd3e58d339))

- Enhance InfluxDBHandler initialization to handle None values gracefully
  ([`989fc63`](https://github.com/MountainGod2/chaturbate_poller/commit/989fc6323581dc165e570f288ef90f60e9ec8338))

- Improve signal handling setup and logging in SignalHandler class
  ([`250effa`](https://github.com/MountainGod2/chaturbate_poller/commit/250effac1e9602af1d71762466503f343673ef26))

- Simplify signal handler setup in SignalHandler class
  ([`314c63e`](https://github.com/MountainGod2/chaturbate_poller/commit/314c63ecade4a24b7e1b820199357d95d80889c6))

- Update get method in ConfigManager to support None as default value
  ([`ed08afb`](https://github.com/MountainGod2/chaturbate_poller/commit/ed08afb2b0721e1cd8f23b1bfa0ba064df13b019))

- Update logging and event handling for clarity and type safety
  ([`44a8590`](https://github.com/MountainGod2/chaturbate_poller/commit/44a85905d79d2286ccb6a7c04f6864f8cf27d2ed))

- Update sanitize_sensitive_data return type to remove int
  ([`e4cf161`](https://github.com/MountainGod2/chaturbate_poller/commit/e4cf16135d21612d418424ac74eb787627e96df1))

- Update version retrieval to specify distribution name for chaturbate_poller
  ([`43874a6`](https://github.com/MountainGod2/chaturbate_poller/commit/43874a67ea86b49e91d43b32a8e200d31c84a659))

- **client**: Update import statement for Response to improve clarity
  ([`232c577`](https://github.com/MountainGod2/chaturbate_poller/commit/232c5770fd994f65bb79f6b71857801c8a4762fc))

- **config**: Update type hints for config dictionary and environment variables
  ([`c238c5c`](https://github.com/MountainGod2/chaturbate_poller/commit/c238c5ce1483adf42e921a88ac9be6a91752d2f0))

- **docker**: Enhance Docker Compose setup with improved InfluxDB configuration and health checks
  ([`1d052ac`](https://github.com/MountainGod2/chaturbate_poller/commit/1d052ace2440902e708c66d04975167c42bf6cc6))

- **docs**: Add type hints for extensions, version, release, autoapi_dirs, and exclude_patterns
  ([`c4a5d1b`](https://github.com/MountainGod2/chaturbate_poller/commit/c4a5d1b275275c9672093be46dbd8e048823bb30))

- **format_messages**: Enhance type hints for event formatting functions and improve type safety
  ([`f1cda53`](https://github.com/MountainGod2/chaturbate_poller/commit/f1cda53f823759def51c9794f574c8fb0cc4f9b0))

- **influxdb**: Introduce TypedDict for structured data and enhance type hints for nested
  dictionaries
  ([`1431a41`](https://github.com/MountainGod2/chaturbate_poller/commit/1431a4191496e4d53078b9d0808f782d77c44acf))

- **influxdb_handler**: Update InfluxDB handler to use HTTP API and improve data formatting
  ([`83c6185`](https://github.com/MountainGod2/chaturbate_poller/commit/83c618570cf83cee45bd733aa7a94f41f8754381))

- **logging**: Change type hints from Any to object for log data structures
  ([`2d5ff09`](https://github.com/MountainGod2/chaturbate_poller/commit/2d5ff09aceb6de97d96fcde41ca1d125be1a9728))

- **logging**: Specify logger type as Logger for improved type safety
  ([`a869ca1`](https://github.com/MountainGod2/chaturbate_poller/commit/a869ca1e4a2438734dfe4414ef76c9e818c3e0d1))

- **scripts**: Update command path for chaturbate_poller script
  ([`f7fb343`](https://github.com/MountainGod2/chaturbate_poller/commit/f7fb3436477bc8e28300abc61252b3ef2f55c113))

- **signal_handler**: Enhance type annotations for clarity and consistency
  ([`1b08584`](https://github.com/MountainGod2/chaturbate_poller/commit/1b08584776e3e47aad1e635f30fe1b4cf80cd417))


## v1.12.1 (2025-02-28)

### Bug Fixes

- **models**: Simplify field definitions and remove unused validators
  ([`8e4788d`](https://github.com/MountainGod2/chaturbate_poller/commit/8e4788dfbb986d5609c7ffa229e4c56d7b4a2e8c))

### Chores

- **deps**: Lock file maintenance
  ([#240](https://github.com/MountainGod2/chaturbate_poller/pull/240),
  [`411e69f`](https://github.com/MountainGod2/chaturbate_poller/commit/411e69f39c3ab6be91791e3696332d26b518b93a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.12.0 (2025-02-27)

### Chores

- **deps**: Update dependency ruff to v0.9.7
  ([#230](https://github.com/MountainGod2/chaturbate_poller/pull/230),
  [`17915b9`](https://github.com/MountainGod2/chaturbate_poller/commit/17915b9a93f2a8d65f927f2a29bfa0711fdd29ab))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.3
  ([#235](https://github.com/MountainGod2/chaturbate_poller/pull/235),
  [`28d2d05`](https://github.com/MountainGod2/chaturbate_poller/commit/28d2d05fd1e36d4dda5721237e14becb5c6bb798))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **pre-commit**: Remove autopep8 hook from configuration
  ([`79670de`](https://github.com/MountainGod2/chaturbate_poller/commit/79670de7fe50f69c1c032de42896c1125a75e499))

### Features

- **cli**: Add shorthand option for verbose logging
  ([`39d4eee`](https://github.com/MountainGod2/chaturbate_poller/commit/39d4eee340ede236ab572ac9ceee3afeb5c680ae))

### Refactoring

- **models**: Enhance validation patterns and remove redundant validators
  ([`269fd62`](https://github.com/MountainGod2/chaturbate_poller/commit/269fd621439065b1660840447bcb30ee8b58835e))

fixes: #238


## v1.11.5 (2025-02-26)

### Bug Fixes

- **deps**: Update dependency rich-click to v1.8.6
  ([#228](https://github.com/MountainGod2/chaturbate_poller/pull/228),
  [`af70351`](https://github.com/MountainGod2/chaturbate_poller/commit/af703516a2d90fa03d73e79e6cd48dc679f18817))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.11.4 (2025-02-26)

### Bug Fixes

- **signal_handler**: Added support for Windows systems
  ([#237](https://github.com/MountainGod2/chaturbate_poller/pull/237),
  [`7cab87e`](https://github.com/MountainGod2/chaturbate_poller/commit/7cab87e9c06a7b03efa13b73d3c450022ac34412))

### Chores

- **deps**: Lock file maintenance
  ([#236](https://github.com/MountainGod2/chaturbate_poller/pull/236),
  [`a55853f`](https://github.com/MountainGod2/chaturbate_poller/commit/a55853f3a68096e35090106634b0d4b8b1c48ad9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.11.3 (2025-02-26)

### Bug Fixes

- **user**: Add "few" to valid recentTips options
  ([#234](https://github.com/MountainGod2/chaturbate_poller/pull/234),
  [`be339dd`](https://github.com/MountainGod2/chaturbate_poller/commit/be339dd0632624091e9b4b408ed7b936150396ad))

### Chores

- **deps**: Lock file maintenance
  ([`eb5b7ed`](https://github.com/MountainGod2/chaturbate_poller/commit/eb5b7ed5dceefaa91e8068af15b53f92a5d23093))

- **deps**: Lock file maintenance
  ([#229](https://github.com/MountainGod2/chaturbate_poller/pull/229),
  [`a44676b`](https://github.com/MountainGod2/chaturbate_poller/commit/a44676b2a0f760d93c346931e7811259755798d2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#231](https://github.com/MountainGod2/chaturbate_poller/pull/231),
  [`4760a74`](https://github.com/MountainGod2/chaturbate_poller/commit/4760a7452553f292da57925bcc32b49cc6e1fd7e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency bandit to v1.8.3
  ([#224](https://github.com/MountainGod2/chaturbate_poller/pull/224),
  [`954bade`](https://github.com/MountainGod2/chaturbate_poller/commit/954bade5a9cd5393482a80931075c9505084bcd0))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.20.0
  ([#220](https://github.com/MountainGod2/chaturbate_poller/pull/220),
  [`f0af2aa`](https://github.com/MountainGod2/chaturbate_poller/commit/f0af2aabf345cd5d0192d9d50d60ff5d4e360bc8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.6.2
  ([#216](https://github.com/MountainGod2/chaturbate_poller/pull/216),
  [`27e9a3a`](https://github.com/MountainGod2/chaturbate_poller/commit/27e9a3acd7ea22ddc09c72514e4a71bd86dfa034))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update sonarsource/sonarqube-scan-action action to v5
  ([#222](https://github.com/MountainGod2/chaturbate_poller/pull/222),
  [`0dcf40d`](https://github.com/MountainGod2/chaturbate_poller/commit/0dcf40df6c96c2415a9f770bd630074592d97f61))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **workflows**: Enhance workflow descriptions and improve naming consistency
  ([`629313d`](https://github.com/MountainGod2/chaturbate_poller/commit/629313db24a5d6ab2cc3df3c69217645f819cc0b))

### Documentation

- Update pull request template for clarity and consistency
  ([`9fb1dcd`](https://github.com/MountainGod2/chaturbate_poller/commit/9fb1dcd2360c12b1b5439775bfc59811c3eab91c))


## v1.11.2 (2025-02-22)

### Bug Fixes

- **deps**: Update dependency sphinx-autoapi to v3.6.0
  ([#226](https://github.com/MountainGod2/chaturbate_poller/pull/226),
  [`de8f07b`](https://github.com/MountainGod2/chaturbate_poller/commit/de8f07b156ab01c0fdadbf7f479073fc32cd3045))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Chores

- Update copyright year in LICENSE file
  ([`949ebb7`](https://github.com/MountainGod2/chaturbate_poller/commit/949ebb7bd24c3eabf3d46a6e22e53e4d9020a8e1))

- **deps**: Lock file maintenance
  ([#218](https://github.com/MountainGod2/chaturbate_poller/pull/218),
  [`0f7d2ae`](https://github.com/MountainGod2/chaturbate_poller/commit/0f7d2ae6f9cd5ef488b3a4d557985bf01e568621))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#219](https://github.com/MountainGod2/chaturbate_poller/pull/219),
  [`98e2e59`](https://github.com/MountainGod2/chaturbate_poller/commit/98e2e594fb90b1de24dbb9019970ab4b2d2b74a8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#221](https://github.com/MountainGod2/chaturbate_poller/pull/221),
  [`7c5c475`](https://github.com/MountainGod2/chaturbate_poller/commit/7c5c475b11e0a2a8b0791f3193649e73df3da514))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#223](https://github.com/MountainGod2/chaturbate_poller/pull/223),
  [`4f0e585`](https://github.com/MountainGod2/chaturbate_poller/commit/4f0e5855e1cb494966781dfbfc477eeccd526bea))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#225](https://github.com/MountainGod2/chaturbate_poller/pull/225),
  [`2b82cf4`](https://github.com/MountainGod2/chaturbate_poller/commit/2b82cf44de389908648001ea254a141196c1593c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#227](https://github.com/MountainGod2/chaturbate_poller/pull/227),
  [`9589f59`](https://github.com/MountainGod2/chaturbate_poller/commit/9589f59f9bcee3dafee340412167f58a9cb91477))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.11.1 (2025-02-12)

### Bug Fixes

- Update import paths for ConfigManager to reflect new module structure
  ([`2135a7a`](https://github.com/MountainGod2/chaturbate_poller/commit/2135a7acc88b2e453baacfe3ba1b69cba39a27fd))

### Chores

- Update version to 1.11.0 and add noqa comments in logging module
  ([`de93e72`](https://github.com/MountainGod2/chaturbate_poller/commit/de93e721c4f4587419ce91e7a63412c622ca462d))

- **deps**: Lock file maintenance
  ([#217](https://github.com/MountainGod2/chaturbate_poller/pull/217),
  [`dba2b46`](https://github.com/MountainGod2/chaturbate_poller/commit/dba2b460bd4c32d6b79e9b76e9439b4f8c27cf26))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update optional dependencies to latest versions
  ([`2712867`](https://github.com/MountainGod2/chaturbate_poller/commit/2712867354db9c84a00d01b82b6c70efdf481843))


## v1.11.0 (2025-02-11)

### Chores

- **deps**: Lock file maintenance
  ([#214](https://github.com/MountainGod2/chaturbate_poller/pull/214),
  [`7c936af`](https://github.com/MountainGod2/chaturbate_poller/commit/7c936af5acfd773e3519a3644112cd22ca69157d))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- **structure**: Reorganize project structure and add new modules for logging, database, and models
  ([`8c8d1eb`](https://github.com/MountainGod2/chaturbate_poller/commit/8c8d1eb9287bfd4c6d23a5ccb84c02f833b71791))


## v1.10.0 (2025-02-09)

### Chores

- Add empty py.typed file to comply with PEP 561
  ([`b9defd2`](https://github.com/MountainGod2/chaturbate_poller/commit/b9defd22bf68fe66022369f7c2dfe3815be3abb8))

- Remove unused type stubs for json_log_formatter and phue
  ([`c58b26d`](https://github.com/MountainGod2/chaturbate_poller/commit/c58b26d20a6dd3efacfea793b8f5908e1696927c))

- Update PR scheduling in renovate.json
  ([`c4f4d7a`](https://github.com/MountainGod2/chaturbate_poller/commit/c4f4d7a922694fc5312e8573ec688d344c701550))

- Update renovate.json
  ([`83c8e87`](https://github.com/MountainGod2/chaturbate_poller/commit/83c8e87d31595414895c7387e10204133ad6b761))

- **config**: Migrate config .github/renovate.json
  ([#211](https://github.com/MountainGod2/chaturbate_poller/pull/211),
  [`219c15f`](https://github.com/MountainGod2/chaturbate_poller/commit/219c15f00a4b6aeefe1673d59aecdd72e0ae5aad))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Remove json-log-formatter dependency from project
  ([`920e23f`](https://github.com/MountainGod2/chaturbate_poller/commit/920e23f9bda101d13586bf1b0601fc616fce14bb))

- **deps**: Update dependency hatchling to v1.27.0
  ([#208](https://github.com/MountainGod2/chaturbate_poller/pull/208),
  [`6a07bc0`](https://github.com/MountainGod2/chaturbate_poller/commit/6a07bc0caed00fafa4f79b93ab55e91edfa63992))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency mypy to v1.15.0
  ([#213](https://github.com/MountainGod2/chaturbate_poller/pull/213),
  [`d951441`](https://github.com/MountainGod2/chaturbate_poller/commit/d951441766f399dd72c56242ba9170f9c571291e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.18.1
  ([#209](https://github.com/MountainGod2/chaturbate_poller/pull/209),
  [`9466c12`](https://github.com/MountainGod2/chaturbate_poller/commit/9466c120d6ad9c9f8c7b02fd190e9ffbafd1ad5f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.9.5
  ([#207](https://github.com/MountainGod2/chaturbate_poller/pull/207),
  [`bdfc545`](https://github.com/MountainGod2/chaturbate_poller/commit/bdfc545e06413cf0fba9bd27959fc6022f7d4c8f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.29
  ([#212](https://github.com/MountainGod2/chaturbate_poller/pull/212),
  [`9663598`](https://github.com/MountainGod2/chaturbate_poller/commit/96635989b4da829ce09e6205e0198bdf14a1f7f2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- **logging**: Implement custom JSON formatter and enhance logging configuration
  ([`7f60484`](https://github.com/MountainGod2/chaturbate_poller/commit/7f60484a5091fb988c6d21af24b36cfffdb56512))

### Refactoring

- Streamline data flattening in InfluxDBHandler
  ([`437dee6`](https://github.com/MountainGod2/chaturbate_poller/commit/437dee6304ec5a831e9a9d922a54b76d90168eeb))

### Testing

- Replace Mock with mock.Mock in test cases for consistency and improve coverage
  ([`b4a41e0`](https://github.com/MountainGod2/chaturbate_poller/commit/b4a41e03a671b66e7b6cda36b9e863af8db2ec11))


## v1.9.1 (2025-02-04)

### Bug Fixes

- Update pyproject.toml version pinning
  ([`5f6e1c5`](https://github.com/MountainGod2/chaturbate_poller/commit/5f6e1c567940c87201fcb184aac4685794846c58))


## v1.9.0 (2025-02-04)

### Features

- Improved dependencies and coverage settings
  ([`9c19c8b`](https://github.com/MountainGod2/chaturbate_poller/commit/9c19c8b33241bb593cb779365c704cdac453cd13))


## v1.8.4 (2025-02-04)

### Bug Fixes

- Add type stubs for json_log_formatter and phue modules
  ([`e9679f2`](https://github.com/MountainGod2/chaturbate_poller/commit/e9679f244ca59bec965860764436da531df566c4))

### Chores

- Update optional dependencies in pyproject.toml and uv.lock for improved documentation and examples
  ([`83a177d`](https://github.com/MountainGod2/chaturbate_poller/commit/83a177dbb49a2aa5dbe3d8d5a330162788170d8d))

- Update Renovate configuration to enhance dependency management and vulnerability alerts
  ([`1a3b50c`](https://github.com/MountainGod2/chaturbate_poller/commit/1a3b50ce5106d214a75737012b63dbfec6d03069))

- **config**: Migrate config .github/renovate.json
  ([#206](https://github.com/MountainGod2/chaturbate_poller/pull/206),
  [`847be0f`](https://github.com/MountainGod2/chaturbate_poller/commit/847be0ffb2630d35d11366cf4a1f9acae694a350))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#205](https://github.com/MountainGod2/chaturbate_poller/pull/205),
  [`5450e72`](https://github.com/MountainGod2/chaturbate_poller/commit/5450e72e70ace64d58cf45838caaffa1ab2f15ce))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Code Style

- Add noqa comments to suppress preview linting warnings in event handler and logging filter methods
  ([`e7500ec`](https://github.com/MountainGod2/chaturbate_poller/commit/e7500ec0bde839b382753d6a59ea27de8b8ee603))

- Add return type hint for main function to improve type safety
  ([`5006927`](https://github.com/MountainGod2/chaturbate_poller/commit/5006927d4015722f34c30fc673b1b3db398ab0bd))

- Add type hint for tasks list in SignalHandler to improve type safety
  ([`866f9a8`](https://github.com/MountainGod2/chaturbate_poller/commit/866f9a80555d1c91e3dbd740b2839a5f3c4df6ae))

- Add type hints for event handling functions to improve type safety and clarity
  ([`e19ff9d`](https://github.com/MountainGod2/chaturbate_poller/commit/e19ff9d117b01d0f850b33cde9ab24aeebc4be65))

- Add type hints for InfluxDBHandler fields and update Point usage for improved type safety
  ([`0e9d9ab`](https://github.com/MountainGod2/chaturbate_poller/commit/0e9d9abc4cffa77ba79c639cc24d1b383c811e3a))

- Add type hints to mock parameters in test cases for improved clarity
  ([`e73e974`](https://github.com/MountainGod2/chaturbate_poller/commit/e73e9741a6e52c7c0b85f681c1f7f067c542f5a8))

- Remove unnecessary exclude entries from mypy
  ([`e3ddde0`](https://github.com/MountainGod2/chaturbate_poller/commit/e3ddde07620605c601127df4bf6d5a8734f5dbc6))

- Reorganize pyproject.toml for improved clarity and structure
  ([`80c12f2`](https://github.com/MountainGod2/chaturbate_poller/commit/80c12f2ed422f290ea6ad3380735b00296d7f2c3))

- Update light handling in HueController for improved type safety and clarity
  ([`4124fbb`](https://github.com/MountainGod2/chaturbate_poller/commit/4124fbb034024c7ac982ce8f7eeb9a667c59d2ac))

- Update type hints for ChaturbateClient properties to improve clarity and type safety
  ([`b60e019`](https://github.com/MountainGod2/chaturbate_poller/commit/b60e0193f19b7d1d7c1447869c7f1159aa3fa9c7))

- Update type hints to suppress mypy warnings for purposeful type errors in test utility functions
  ([`60dcbcd`](https://github.com/MountainGod2/chaturbate_poller/commit/60dcbcd19b670c4431d16ec223e974b84988eb9c))

### Documentation

- Update link format for Changelog in index.md
  ([`74b0a75`](https://github.com/MountainGod2/chaturbate_poller/commit/74b0a75dec131003fdfc2e356ae80eb75f2baac1))

### Refactoring

- Remove unnecessary 'out/' entry from .gitignore
  ([`5fca9b1`](https://github.com/MountainGod2/chaturbate_poller/commit/5fca9b1fa235a79aef791172981107a8ea3b394d))

### Testing

- Update assertions to access HTTP status code values
  ([`845c065`](https://github.com/MountainGod2/chaturbate_poller/commit/845c065fff7f2b9c3b025ee44b86a77711a43c5d))


## v1.8.3 (2025-02-01)

### Bug Fixes

- Set default values to None for optional fields in models
  ([`ec103f6`](https://github.com/MountainGod2/chaturbate_poller/commit/ec103f65d9fbece7270af44aef1f3d162a35cac8))

### Chores

- Add new lint ignore rule for copyright notice and update per-file ignores
  ([`78bcfcf`](https://github.com/MountainGod2/chaturbate_poller/commit/78bcfcfa5ae7fb560cc0ac7d339e1e162e3f0a48))

- Change log level from info to debug for event fetching
  ([`03df34e`](https://github.com/MountainGod2/chaturbate_poller/commit/03df34e263b74657327fc64657862fc6ae21a8d5))

- Update renovate configuration for improved dependency management
  ([`e0c6124`](https://github.com/MountainGod2/chaturbate_poller/commit/e0c6124d601e0085e4e629cc6cc7ab41d9f7b9a1))

- Update renovate.json
  ([`179d86a`](https://github.com/MountainGod2/chaturbate_poller/commit/179d86a21cfbfdf22958e362e4045cd530c2e02e))

- Update renovate.json ([#203](https://github.com/MountainGod2/chaturbate_poller/pull/203),
  [`4fed189`](https://github.com/MountainGod2/chaturbate_poller/commit/4fed1899fd2da6178585b861d5445702d396b3fb))

- **deps**: Lock file maintenance
  ([#181](https://github.com/MountainGod2/chaturbate_poller/pull/181),
  [`2bf2c45`](https://github.com/MountainGod2/chaturbate_poller/commit/2bf2c4595649404349b4260f4656b408f2980b90))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#190](https://github.com/MountainGod2/chaturbate_poller/pull/190),
  [`3d4752d`](https://github.com/MountainGod2/chaturbate_poller/commit/3d4752db1389b7e6b30092f7aad5417f846afe3d))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#194](https://github.com/MountainGod2/chaturbate_poller/pull/194),
  [`7ed7e27`](https://github.com/MountainGod2/chaturbate_poller/commit/7ed7e275bd9b6d9d7cc4ba73662d78648c73460e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#199](https://github.com/MountainGod2/chaturbate_poller/pull/199),
  [`abcd94d`](https://github.com/MountainGod2/chaturbate_poller/commit/abcd94d102427efd7c35a1310d15ccf295e1e3ac))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency bandit to v1.8.2
  ([#189](https://github.com/MountainGod2/chaturbate_poller/pull/189),
  [`b7355d3`](https://github.com/MountainGod2/chaturbate_poller/commit/b7355d332bde412693d41774e9232e6dcd327371))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pre-commit to v4.1.0
  ([#195](https://github.com/MountainGod2/chaturbate_poller/pull/195),
  [`21054fd`](https://github.com/MountainGod2/chaturbate_poller/commit/21054fdfb3b8f1538423cdead5f6f1ca67f2836e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pydantic to v2.10.5
  ([#183](https://github.com/MountainGod2/chaturbate_poller/pull/183),
  [`5bd5f9b`](https://github.com/MountainGod2/chaturbate_poller/commit/5bd5f9bc4667036a22f9b089728d5a7fdaa89cc5))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pydantic to v2.10.6
  ([#196](https://github.com/MountainGod2/chaturbate_poller/pull/196),
  [`df8c6e3`](https://github.com/MountainGod2/chaturbate_poller/commit/df8c6e3dda40d5fefc49ef3597b17cf70e89074f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pylint to v3.3.4
  ([#200](https://github.com/MountainGod2/chaturbate_poller/pull/200),
  [`6d63889`](https://github.com/MountainGod2/chaturbate_poller/commit/6d63889b85935b299f2aea52321544094b1fcc03))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pytest-asyncio to v0.25.2
  ([#178](https://github.com/MountainGod2/chaturbate_poller/pull/178),
  [`104e874`](https://github.com/MountainGod2/chaturbate_poller/commit/104e874f77dc77eef4c91f709e06294f77a2f0cf))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pytest-asyncio to v0.25.3
  ([#201](https://github.com/MountainGod2/chaturbate_poller/pull/201),
  [`2224f23`](https://github.com/MountainGod2/chaturbate_poller/commit/2224f234307be0f0b24121ff6dab7e530cbe9c13))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.16.0
  ([#187](https://github.com/MountainGod2/chaturbate_poller/pull/187),
  [`e559a6b`](https://github.com/MountainGod2/chaturbate_poller/commit/e559a6b201d10809b967748f90f4d791b1be55c4))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.16.1
  ([#188](https://github.com/MountainGod2/chaturbate_poller/pull/188),
  [`18d7a4d`](https://github.com/MountainGod2/chaturbate_poller/commit/18d7a4decbc7dba07e19d52e63341a62469e2a9f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.17.0
  ([#198](https://github.com/MountainGod2/chaturbate_poller/pull/198),
  [`b419986`](https://github.com/MountainGod2/chaturbate_poller/commit/b4199869e7b50e3abaf41528e47d4ad2c0a79095))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.8.6
  ([#179](https://github.com/MountainGod2/chaturbate_poller/pull/179),
  [`77b2fc7`](https://github.com/MountainGod2/chaturbate_poller/commit/77b2fc7165d265f90251311fc055b0743f07b85a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.9.0
  ([#184](https://github.com/MountainGod2/chaturbate_poller/pull/184),
  [`2d891a8`](https://github.com/MountainGod2/chaturbate_poller/commit/2d891a8c6f2dd541decc524285edf5d9f084c9f2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.9.1
  ([#185](https://github.com/MountainGod2/chaturbate_poller/pull/185),
  [`157e476`](https://github.com/MountainGod2/chaturbate_poller/commit/157e476e8610efcf6e6272de12d6fee22337d13a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.9.3
  ([#193](https://github.com/MountainGod2/chaturbate_poller/pull/193),
  [`f80dff2`](https://github.com/MountainGod2/chaturbate_poller/commit/f80dff2ea3def1eea0ffdc9c6adfbe6143b3fa9f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.9.4
  ([#204](https://github.com/MountainGod2/chaturbate_poller/pull/204),
  [`f773663`](https://github.com/MountainGod2/chaturbate_poller/commit/f7736633adf9eed1802136f2b91afa9307ca6801))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency to latest version
  ([`bf14607`](https://github.com/MountainGod2/chaturbate_poller/commit/bf1460732c184eb8c158b47398937f98a284aae1))

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.16
  ([#182](https://github.com/MountainGod2/chaturbate_poller/pull/182),
  [`8933361`](https://github.com/MountainGod2/chaturbate_poller/commit/89333616efd59b1314bde9993e7466c2a0f04279))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.18
  ([#186](https://github.com/MountainGod2/chaturbate_poller/pull/186),
  [`1805519`](https://github.com/MountainGod2/chaturbate_poller/commit/1805519cc9e875e3ee7f28eed948fc96fc8700b9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.19
  ([#191](https://github.com/MountainGod2/chaturbate_poller/pull/191),
  [`c676a3c`](https://github.com/MountainGod2/chaturbate_poller/commit/c676a3cacc2a21a883117f6a009bd3ce518fa972))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.24
  ([#192](https://github.com/MountainGod2/chaturbate_poller/pull/192),
  [`0bbd13a`](https://github.com/MountainGod2/chaturbate_poller/commit/0bbd13adf5c45be8790d26e8a31be0fc29c25faa))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.26
  ([#202](https://github.com/MountainGod2/chaturbate_poller/pull/202),
  [`c7bf7c4`](https://github.com/MountainGod2/chaturbate_poller/commit/c7bf7c4c445b7687073eac1ba9651264b6bd4ec1))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update pypa/gh-action-pypi-publish action to v1.12.4
  ([#197](https://github.com/MountainGod2/chaturbate_poller/pull/197),
  [`3f3f080`](https://github.com/MountainGod2/chaturbate_poller/commit/3f3f0805c70c8b7c9936a750a5fc66a2e5696819))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Refactoring

- Convert async functions to synchronous where appropriate and improve error handling in Hue Bridge
  setup
  ([`b9f178b`](https://github.com/MountainGod2/chaturbate_poller/commit/b9f178b9483f88e964564df3959ec95c9175a694))

- Enhance event handling and logging in simple_poller example
  ([`e50a0ba`](https://github.com/MountainGod2/chaturbate_poller/commit/e50a0ba3a2b9c04442584c2798098172f01f0fd2))

- **cli, format_messages, logging**: Streamline error handling and enhance logging configuration
  ([`446a750`](https://github.com/MountainGod2/chaturbate_poller/commit/446a750a1089d36deab02d347fea5db8461f0dd3))

- **hue_light_control**: Implement color setting and revert functionality
  ([`b31f36c`](https://github.com/MountainGod2/chaturbate_poller/commit/b31f36c0dbc86061e299c7d9c95a9f50e05474e3))

### Testing

- **cli**: Remove redundant assertion for invalid timeout value
  ([`76aacdd`](https://github.com/MountainGod2/chaturbate_poller/commit/76aacdd4f8a9169bf94648fcd1c20ad4e3d7a26c))


## v1.8.2 (2025-01-05)

### Bug Fixes

- **cli**: Use constant for API timeout in CLI options
  ([`642d03f`](https://github.com/MountainGod2/chaturbate_poller/commit/642d03fc763c483811ab140639bbcaf5cc40e0de))

### Chores

- Bump chaturbate-poller version to 1.8.1
  ([`3cfd66f`](https://github.com/MountainGod2/chaturbate_poller/commit/3cfd66f9be4cc181dead429a80a021915769b859))

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.14
  ([#180](https://github.com/MountainGod2/chaturbate_poller/pull/180),
  [`49f9042`](https://github.com/MountainGod2/chaturbate_poller/commit/49f90422ad05f11c73568b26b0aa22f2bdbbaabb))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Refactoring

- **chaturbate_client**: Enhance error handling and improve documentation
  ([`b1d82d8`](https://github.com/MountainGod2/chaturbate_poller/commit/b1d82d8b0471fd41bf567de769f8cd3721c452b9))

- **chaturbate_poller**: Enhance docstrings and improve error handling in polling functions
  ([`eaf0e69`](https://github.com/MountainGod2/chaturbate_poller/commit/eaf0e69738a7a1b2448d4f9e14e463f878465248))

- **chaturbate_utils**: Improve retry logic and enhance error handling messages
  ([`a685cb7`](https://github.com/MountainGod2/chaturbate_poller/commit/a685cb7f2ef8b462ca18b8aa361f943c8773d96d))

- **constants**: Consolidate API timeout and retry settings in constants
  ([`4ddbe28`](https://github.com/MountainGod2/chaturbate_poller/commit/4ddbe280a62ae97e63b99f8dfd4b93bc59d63e4d))

- **tests**: Improve error messages in event fetching and utility tests
  ([`ab0e6ba`](https://github.com/MountainGod2/chaturbate_poller/commit/ab0e6bacd3cb6fa77019a6b6be6132ef54d0d435))


## v1.8.1 (2025-01-03)

### Bug Fixes

- Add example dependencies for phue and tenacity in pyproject.toml and uv.lock
  ([`e087a0a`](https://github.com/MountainGod2/chaturbate_poller/commit/e087a0adfee21ffad47f0cde9e91fc8cc8b227ac))

### Chores

- Update project metadata in pyproject.toml and uv.lock
  ([`272010d`](https://github.com/MountainGod2/chaturbate_poller/commit/272010d8a34d3bc5a02d54e6de6bba65116e18da))

- **deps**: Update pytest-asyncio to v0.25.1 and ruff to v0.8.5
  ([`21267ce`](https://github.com/MountainGod2/chaturbate_poller/commit/21267cecd792ed803307efaeb2ab59c4a3965815))


## v1.8.0 (2025-01-01)

### Bug Fixes

- Add example dependencies for phue and tenacity in pyproject.toml and uv.lock
  ([`0aafd85`](https://github.com/MountainGod2/chaturbate_poller/commit/0aafd85ebe5f1aeded7aad873af9838ab330221d))

- Update CI workflow to sync all extras and adjust documentation build command
  ([`bbb516b`](https://github.com/MountainGod2/chaturbate_poller/commit/bbb516b32735746c42e6acb74fd26596b1787849))

### Chores

- **deps**: Update dependency mypy to v1.14.1
  ([#177](https://github.com/MountainGod2/chaturbate_poller/pull/177),
  [`7294516`](https://github.com/MountainGod2/chaturbate_poller/commit/72945166d8988bafc8e322afa673a2e4be9c95f7))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- Enhance event handling in examples with rich logging and error management
  ([`3118bf6`](https://github.com/MountainGod2/chaturbate_poller/commit/3118bf6b0d816d7f19199df9afeb1b2bf657bc3f))


## v1.7.3 (2024-12-30)

### Bug Fixes

- Update CI workflow to build documentation using Sphinx
  ([`f6a663b`](https://github.com/MountainGod2/chaturbate_poller/commit/f6a663b41647962ba223955227d3a108446dbffd))

- Update CI workflow to include extra argument for Sphinx documentation build
  ([`9c3e698`](https://github.com/MountainGod2/chaturbate_poller/commit/9c3e69899d6dfcd943b9c7f37e3ffb5c71691e22))

- Update Read the Docs configuration and remove Makefile and batch files
  ([`005e66d`](https://github.com/MountainGod2/chaturbate_poller/commit/005e66df414b319e20a2f3a693958dfe463dd962))

### Chores

- Add CODEOWNERS file to define code ownership
  ([`3b3dafa`](https://github.com/MountainGod2/chaturbate_poller/commit/3b3dafa68fa49ca91e8a885b64f91151c45f728e))

- Enable assignees from code owners in Renovate configuration
  ([`b0c89a6`](https://github.com/MountainGod2/chaturbate_poller/commit/b0c89a6991b88e5bcd16c4e5f5a72adfa56b0536))

- Update Renovate configuration and pre-commit hooks
  ([`7b3a621`](https://github.com/MountainGod2/chaturbate_poller/commit/7b3a62160567df7c99b278a51c5c0341e60e5d47))

- **deps**: Lock file maintenance
  ([#161](https://github.com/MountainGod2/chaturbate_poller/pull/161),
  [`d033e1b`](https://github.com/MountainGod2/chaturbate_poller/commit/d033e1bb25b2cde83e08485f58383b56bcdd634c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#171](https://github.com/MountainGod2/chaturbate_poller/pull/171),
  [`078fcf6`](https://github.com/MountainGod2/chaturbate_poller/commit/078fcf6e89b032cf6089486c9f5f3b0a55302fa7))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#174](https://github.com/MountainGod2/chaturbate_poller/pull/174),
  [`16e4f2f`](https://github.com/MountainGod2/chaturbate_poller/commit/16e4f2f26a7a4ff40ecb15abba391778acf06bb7))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#175](https://github.com/MountainGod2/chaturbate_poller/pull/175),
  [`eca8d25`](https://github.com/MountainGod2/chaturbate_poller/commit/eca8d250ad69acb6b4ca3855fd19ef0581076147))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update astral-sh/setup-uv action to v5
  ([#169](https://github.com/MountainGod2/chaturbate_poller/pull/169),
  [`5d1e3a3`](https://github.com/MountainGod2/chaturbate_poller/commit/5d1e3a39f018c57d8f84e70864cef3da6962acf8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency mypy to v1.14.0
  ([#170](https://github.com/MountainGod2/chaturbate_poller/pull/170),
  [`9c9fd24`](https://github.com/MountainGod2/chaturbate_poller/commit/9c9fd24ae172348f8a1cd40ee11df33127a0865f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pylint to v3.3.3
  ([#172](https://github.com/MountainGod2/chaturbate_poller/pull/172),
  [`967640b`](https://github.com/MountainGod2/chaturbate_poller/commit/967640bdf6811854fb220786392deabafc17daae))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency respx to v0.22.0
  ([#167](https://github.com/MountainGod2/chaturbate_poller/pull/167),
  [`18e2a67`](https://github.com/MountainGod2/chaturbate_poller/commit/18e2a673fbabd10238d8b6874157cd1906ad99b8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.10
  ([#164](https://github.com/MountainGod2/chaturbate_poller/pull/164),
  [`db6ba9f`](https://github.com/MountainGod2/chaturbate_poller/commit/db6ba9f1083cd6f638ab4667c93babbdc0150391))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.11
  ([#168](https://github.com/MountainGod2/chaturbate_poller/pull/168),
  [`573c2dd`](https://github.com/MountainGod2/chaturbate_poller/commit/573c2dd9df486bde8b434bb049d8d12412d69bfb))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.13
  ([#173](https://github.com/MountainGod2/chaturbate_poller/pull/173),
  [`a82b97f`](https://github.com/MountainGod2/chaturbate_poller/commit/a82b97f8fd82622243d003fb5f21b94613eeb5a5))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update pydantic to 2.10.4 and ruff to 0.8.4
  ([`e5d195f`](https://github.com/MountainGod2/chaturbate_poller/commit/e5d195fcc1de976834c201aec1fedf81b61e8074))

- **docs**: Update file names and improve documentation structure
  ([`c39c456`](https://github.com/MountainGod2/chaturbate_poller/commit/c39c4565fe9ef881460eea22a14ab323cfc4188a))

- **pre-commit**: Update hooks and add new linting and formatting tools
  ([#176](https://github.com/MountainGod2/chaturbate_poller/pull/176),
  [`081e4c7`](https://github.com/MountainGod2/chaturbate_poller/commit/081e4c7af53ac897e56c54eafc4d0617b4228e0d))

* chore(pre-commit): update hooks and add new linting and formatting tools

* chore(deps): remove unused dependencies from lock file

* chore(deps): remove unused dependency and update autopep8 configuration

* chore: remove unnecessary line from pull request template

* chore: add blank line for improved readability in event handler

* test: enhance sanitization filter tests for log messages

* chore: remove unused myst_enable_extensions configuration

- **renovate**: Update renovate.json5
  ([#163](https://github.com/MountainGod2/chaturbate_poller/pull/163),
  [`9438e9b`](https://github.com/MountainGod2/chaturbate_poller/commit/9438e9b3cfce03f4a26023471b58358344fbd1ee))

### Documentation

- Enhance README and documentation structure for clarity and usability
  ([`bdc0239`](https://github.com/MountainGod2/chaturbate_poller/commit/bdc0239675fea63a9fa25f3923c343288d0d59b5))

- Update README.md
  ([`96f7414`](https://github.com/MountainGod2/chaturbate_poller/commit/96f7414b8fffba6ded7b80dedbd78e5b1127cdbf))

- **README**: Add Python and Docker image version badges
  ([`9efc172`](https://github.com/MountainGod2/chaturbate_poller/commit/9efc1729852d5ccf33b28bf12ec52361418c4791))

- **README**: Refine project description for clarity and conciseness
  ([`c1524de`](https://github.com/MountainGod2/chaturbate_poller/commit/c1524debc3a04e10062345f0f95a77df04ce38c5))

- **README**: Update badge labels and add Docker image version and size badges
  ([`2a1b9ea`](https://github.com/MountainGod2/chaturbate_poller/commit/2a1b9ea36244ebcd787b794c97241c2e65518e35))

- **README**: Update Docker image badges to include links for version and size
  ([`e84a8a9`](https://github.com/MountainGod2/chaturbate_poller/commit/e84a8a9f14c0378372d5a6d8bf5936bbb82e16f0))

### Refactoring

- Disable pylint warnings for functions with too many arguments
  ([`fc738c3`](https://github.com/MountainGod2/chaturbate_poller/commit/fc738c38b12f11e769dca745ab4c880561ed7077))

- Improve error handling and logging in CLI and signal handler
  ([`16a978e`](https://github.com/MountainGod2/chaturbate_poller/commit/16a978ebd81245757cd209217fc44728582b5862))

- Move CLI logic to a separate module and simplify main module
  ([`93553f5`](https://github.com/MountainGod2/chaturbate_poller/commit/93553f59a57c5327b2ddf5afbcce999f0292271a))

- Streamline message formatting logic and improve readability
  ([`05a72ad`](https://github.com/MountainGod2/chaturbate_poller/commit/05a72ade5d11886e40b6a9c27c1e4973b9870523))

- **cli**: Remove unused Console import and related code
  ([`d0d1140`](https://github.com/MountainGod2/chaturbate_poller/commit/d0d1140185e4b5a405f24a368f5e27afff202655))

- **logging**: Enhance logging configuration and improve docstrings
  ([`80f92cc`](https://github.com/MountainGod2/chaturbate_poller/commit/80f92cc2f62be9bc8dcd094593b6118ebb75b9ef))

- **signal_handler**: Improve setup method to prevent multiple calls and enhance logging
  ([`b070e8b`](https://github.com/MountainGod2/chaturbate_poller/commit/b070e8b68db0a9aae70bd15696087d097e73ce6d))

### Testing

- Add unit tests for flattening dictionaries and signal handling
  ([`f12d320`](https://github.com/MountainGod2/chaturbate_poller/commit/f12d320fea2662269fb11cfa4ea396de3424aa0e))


## v1.7.2 (2024-12-17)

### Bug Fixes

- **cli**: Remove JSON output option from logging configuration
  ([`b4baac5`](https://github.com/MountainGod2/chaturbate_poller/commit/b4baac5d68e88e87017e09099339ae1b1c96d51c))


## v1.7.1 (2024-12-17)

### Bug Fixes

- **logging**: Refactor logging configuration and improve verbosity handling
  ([`1029f1f`](https://github.com/MountainGod2/chaturbate_poller/commit/1029f1f1049dff27b9c0bb50108abb23710781da))


## v1.7.0 (2024-12-17)

### Chores

- **dependencies**: Pin dependencies to specific versions in pyproject.toml
  ([`684b9f9`](https://github.com/MountainGod2/chaturbate_poller/commit/684b9f93e05886fb0f478641143a1745d45397fc))

- **dependencies**: Pin optional dependencies and build system requirements to specific versions in
  pyproject.toml
  ([`f2b8cbd`](https://github.com/MountainGod2/chaturbate_poller/commit/f2b8cbdd8a7e1361cf2204e27d2d19ffc34ba973))

- **deps**: Lock file maintenance
  ([#141](https://github.com/MountainGod2/chaturbate_poller/pull/141),
  [`0967849`](https://github.com/MountainGod2/chaturbate_poller/commit/09678490735c4602faf53cb45540d93f55fbf8c8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#156](https://github.com/MountainGod2/chaturbate_poller/pull/156),
  [`0b6b38c`](https://github.com/MountainGod2/chaturbate_poller/commit/0b6b38cf13f01dbc4fff3c2fc935d63da6d31824))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#159](https://github.com/MountainGod2/chaturbate_poller/pull/159),
  [`e8763d6`](https://github.com/MountainGod2/chaturbate_poller/commit/e8763d66c566d4da4b676fd6f98c0659c0e03d12))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency bandit to v1.8.0
  ([#144](https://github.com/MountainGod2/chaturbate_poller/pull/144),
  [`f894798`](https://github.com/MountainGod2/chaturbate_poller/commit/f89479878f2af53910c69dc9801ff0f80335f97d))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency hatchling to v1.26.3
  ([#155](https://github.com/MountainGod2/chaturbate_poller/pull/155),
  [`94592e3`](https://github.com/MountainGod2/chaturbate_poller/commit/94592e3b0ffb8f058c9e88f69a9e7c95508adba0))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency hatchling to v1.27.0
  ([#158](https://github.com/MountainGod2/chaturbate_poller/pull/158),
  [`f1c1ac4`](https://github.com/MountainGod2/chaturbate_poller/commit/f1c1ac46d934df4382607c9d07a9702c694435a8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency httpx to v0.28.1
  ([#145](https://github.com/MountainGod2/chaturbate_poller/pull/145),
  [`61064a9`](https://github.com/MountainGod2/chaturbate_poller/commit/61064a9bc2361f57bf33324db454626fef6e3853))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency influxdb-client to v1.48.0
  ([#146](https://github.com/MountainGod2/chaturbate_poller/pull/146),
  [`8c5677e`](https://github.com/MountainGod2/chaturbate_poller/commit/8c5677e2ba21c4c39cc0b984d5c64164be14dd20))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pydantic to v2.10.3
  ([#147](https://github.com/MountainGod2/chaturbate_poller/pull/147),
  [`0eab148`](https://github.com/MountainGod2/chaturbate_poller/commit/0eab148bb9d2784fd5d0b78c4e233a0200573110))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pylint to v3.3.2
  ([#148](https://github.com/MountainGod2/chaturbate_poller/pull/148),
  [`3fd8edd`](https://github.com/MountainGod2/chaturbate_poller/commit/3fd8eddb79f875755e2bb9a4d54d717a35adf77c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pytest to v8.3.4
  ([#149](https://github.com/MountainGod2/chaturbate_poller/pull/149),
  [`cf6c15c`](https://github.com/MountainGod2/chaturbate_poller/commit/cf6c15c22bc230ad1384cd92c8bf21e03e7de446))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pytest-asyncio to v0.25.0
  ([#150](https://github.com/MountainGod2/chaturbate_poller/pull/150),
  [`33bb122`](https://github.com/MountainGod2/chaturbate_poller/commit/33bb122071c4cf6ae0e54d964280c016db795966))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.15.1
  ([#151](https://github.com/MountainGod2/chaturbate_poller/pull/151),
  [`8052b90`](https://github.com/MountainGod2/chaturbate_poller/commit/8052b90be10cb4ffb0e27565b9e4abfc026f2c69))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency python-semantic-release to v9.15.2
  ([#160](https://github.com/MountainGod2/chaturbate_poller/pull/160),
  [`0176e04`](https://github.com/MountainGod2/chaturbate_poller/commit/0176e04115a8d9eee96a22467954a7c729f02798))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency rich to v13.9.4
  ([#152](https://github.com/MountainGod2/chaturbate_poller/pull/152),
  [`35656f0`](https://github.com/MountainGod2/chaturbate_poller/commit/35656f0567aac778ba2c1384f82fd37ee18db55b))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency rich-click to v1.8.5
  ([#153](https://github.com/MountainGod2/chaturbate_poller/pull/153),
  [`3fc960e`](https://github.com/MountainGod2/chaturbate_poller/commit/3fc960ecced596cb9bc825f1c47ce3d79a9fad28))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency ruff to v0.8.3
  ([#154](https://github.com/MountainGod2/chaturbate_poller/pull/154),
  [`444ffdc`](https://github.com/MountainGod2/chaturbate_poller/commit/444ffdc6bbceba4709df29a0606b6ccd42dee206))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency sphinx-autoapi to v3.4.0
  ([#142](https://github.com/MountainGod2/chaturbate_poller/pull/142),
  [`a9a3eb3`](https://github.com/MountainGod2/chaturbate_poller/commit/a9a3eb36d9377c1683ea8ee21767faa9ce05e3ec))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency sphinx-rtd-theme to v3.0.2
  ([#143](https://github.com/MountainGod2/chaturbate_poller/pull/143),
  [`d9a616d`](https://github.com/MountainGod2/chaturbate_poller/commit/d9a616d017b2107ed3d9d01afd6d540e8ea8289c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.9
  ([#157](https://github.com/MountainGod2/chaturbate_poller/pull/157),
  [`8963926`](https://github.com/MountainGod2/chaturbate_poller/commit/89639262bb5e381d87afaed2971ebecdc91fcbed))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- Remove unused correlation ID generation and improve logging levels
  ([`987a0f7`](https://github.com/MountainGod2/chaturbate_poller/commit/987a0f7501396a2839da035e0e2c4610fac3ade5))


## v1.6.0 (2024-12-13)

### Bug Fixes

- **dependencies**: Update optional dependencies to use minimum version specifications in
  pyproject.toml
  ([`06f1c1d`](https://github.com/MountainGod2/chaturbate_poller/commit/06f1c1d99ae388719116f58326618348452202fa))

### Chores

- **dependencies**: Update version specifications for optional dependencies in pyproject.toml
  ([`5fdfdb3`](https://github.com/MountainGod2/chaturbate_poller/commit/5fdfdb3231480a3a6d4428eab49d3db293c03561))

### Features

- **logging**: Implement correlation ID generation and logging filter
  ([`03bbe52`](https://github.com/MountainGod2/chaturbate_poller/commit/03bbe520ab8689c26db62ee10791ee1def7021bd))


## v1.5.8 (2024-12-13)

### Bug Fixes

- **constants**: Add CLOUDFLARE_ERROR to HTTP status code definitions in ChaturbateUtils
  ([`0c7acc5`](https://github.com/MountainGod2/chaturbate_poller/commit/0c7acc50658401dd341f25f897bf362c31f146db))

- **imports**: Update import paths for InfluxDBClient and Point in influxdb_handler.py
  ([`c901685`](https://github.com/MountainGod2/chaturbate_poller/commit/c9016854f7220c9ffb8f3e6d1158daa38ab8aba8))

### Refactoring

- **constants**: Simplify HTTP status code definitions and add CLOUDFLARE_ERROR
  ([`3379a9c`](https://github.com/MountainGod2/chaturbate_poller/commit/3379a9c0765d69875e9d1d7ff273d4b1d399ea8a))


## v1.5.7 (2024-12-12)

### Bug Fixes

- **imports**: Consolidate imports from chaturbate_poller in example scripts
  ([#140](https://github.com/MountainGod2/chaturbate_poller/pull/140),
  [`454f089`](https://github.com/MountainGod2/chaturbate_poller/commit/454f089f3af39d8a1f6f5fd524a5c232e1339597))

### Chores

- **dependencies**: Add labels to dependency dashboard configuration
  ([`a0bc93e`](https://github.com/MountainGod2/chaturbate_poller/commit/a0bc93efa6e7cd762748b3a14b71fd0ed05fc828))

- **dependencies**: Enable dependency dashboard in Renovate configuration
  ([`425dcbe`](https://github.com/MountainGod2/chaturbate_poller/commit/425dcbe1fe1ee38287353af126eb689b0b10d37c))

- **dependencies**: Remove old Renovate configuration and add new simplified version
  ([`04eaff6`](https://github.com/MountainGod2/chaturbate_poller/commit/04eaff63480001162b5b6af8769c97ddb1f8e02d))

- **dependencies**: Update Renovate configuration to adjust schedules and disable automerge
  ([`c09df02`](https://github.com/MountainGod2/chaturbate_poller/commit/c09df023a56fa2db0fb5eb8df79f376c9289046b))

- **dependencies**: Update Renovate configuration to set all schedules to "at any time"
  ([`23e2ab2`](https://github.com/MountainGod2/chaturbate_poller/commit/23e2ab22ab2d31bedbce6e77542d67d8da5512fc))

- **deps**: Lock file maintenance
  ([#138](https://github.com/MountainGod2/chaturbate_poller/pull/138),
  [`d60c822`](https://github.com/MountainGod2/chaturbate_poller/commit/d60c822eb48a895f75eede868106aa92eb7a60ec))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update ghcr.io/astral-sh/uv docker tag to v0.5.8
  ([#139](https://github.com/MountainGod2/chaturbate_poller/pull/139),
  [`cfb2760`](https://github.com/MountainGod2/chaturbate_poller/commit/cfb27600b56710f969bbb344302d16db6ca1f7e9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **docker**: Add UV image version in Dockerfile
  ([`f628c05`](https://github.com/MountainGod2/chaturbate_poller/commit/f628c0583a69339f33a50a6586e590eeb460c4a7))


## v1.5.6 (2024-12-10)

### Bug Fixes

- **docker**: Simplify entrypoint script permissions command in Dockerfile
  ([`e0b9903`](https://github.com/MountainGod2/chaturbate_poller/commit/e0b9903ba865efe3f50a5192a11c7e4f00fbbe03))

### Chores

- **docker**: Refine Dockerfile structure and improve comments for clarity
  ([`81d63a6`](https://github.com/MountainGod2/chaturbate_poller/commit/81d63a6a20ded31924d07ff8a9378c342af99f3e))


## v1.5.5 (2024-12-10)

### Bug Fixes

- **logging**: Adjust Rich error handling settings for improved output formatting
  ([`d11f06a`](https://github.com/MountainGod2/chaturbate_poller/commit/d11f06a1483b604033b86ee719a8d89e6652b2f2))

- **logging**: Improve error handling for log directory creation
  ([`3621be5`](https://github.com/MountainGod2/chaturbate_poller/commit/3621be5e16acedc415c0016b41d8e5bcfe9a9337))

### Chores

- **deps**: Lock file maintenance
  ([#137](https://github.com/MountainGod2/chaturbate_poller/pull/137),
  [`28df53c`](https://github.com/MountainGod2/chaturbate_poller/commit/28df53c6dcc5814f34d088a6a9d19ecabf80e997))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update pypa/gh-action-pypi-publish action to v1.12.3
  ([#136](https://github.com/MountainGod2/chaturbate_poller/pull/136),
  [`397b78b`](https://github.com/MountainGod2/chaturbate_poller/commit/397b78b36fbfe3394c71e91a597a95b85091c4fb))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **docker**: Remove unnecessary runtime dependencies and logs directory creation
  ([`6282015`](https://github.com/MountainGod2/chaturbate_poller/commit/6282015e0ce4bbc3a5934427a6f34a3930d6c013))

- **renovate**: Improve formatting and structure in renovate.json
  ([`34b99cc`](https://github.com/MountainGod2/chaturbate_poller/commit/34b99cc39457a1b52550e5cea4e87d7ba8839f98))

- **renovate**: Streamline formatting and structure in renovate.json
  ([`7458ad6`](https://github.com/MountainGod2/chaturbate_poller/commit/7458ad6f148cdedd9d449869451f48992c215e04))


## v1.5.4 (2024-12-09)

### Bug Fixes

- **docker**: Simplify user and group creation in Dockerfile
  ([`435575d`](https://github.com/MountainGod2/chaturbate_poller/commit/435575d21a1f41f241f64317e45dfc0b7287d22a))


## v1.5.3 (2024-12-09)

### Bug Fixes

- **docker**: Prevent duplicate group creation in Dockerfile
  ([`9444667`](https://github.com/MountainGod2/chaturbate_poller/commit/944466796c3ed62022b436f2272734c5f4ca80ab))


## v1.5.2 (2024-12-09)

### Bug Fixes

- **docker**: Create logs directory and set proper permissions for non-root user
  ([`84f13a1`](https://github.com/MountainGod2/chaturbate_poller/commit/84f13a1dba7b9425e3248321c7d4dd0b2f64debe))


## v1.5.1 (2024-12-09)

### Bug Fixes

- **logging**: Enhance log directory setup and improve logging configuration
  ([`bbe5ea6`](https://github.com/MountainGod2/chaturbate_poller/commit/bbe5ea6a31f8a832046791da46d08c91cfa65c5b))


## v1.5.0 (2024-12-09)

### Chores

- Create logs directory for the application
  ([`1df65ef`](https://github.com/MountainGod2/chaturbate_poller/commit/1df65ef44f8d45716c8e8576a786914000d33e41))

- **deps**: Lock file maintenance
  ([#135](https://github.com/MountainGod2/chaturbate_poller/pull/135),
  [`7f57a3f`](https://github.com/MountainGod2/chaturbate_poller/commit/7f57a3f2f8985ad7d7dd5f72091238765a9987c7))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Update renovate.json
  ([`792fe3f`](https://github.com/MountainGod2/chaturbate_poller/commit/792fe3fd8073d968e235a442a24f3280e1fe0e2b))

### Features

- Enhance documentation and improve CLI command descriptions
  ([`eb94912`](https://github.com/MountainGod2/chaturbate_poller/commit/eb949120ad536d7ca0560105ce5471d2490fd55e))


## v1.4.8 (2024-12-08)

### Bug Fixes

- **ci**: Improve CI job naming and clean up docker build workflow
  ([`f681daf`](https://github.com/MountainGod2/chaturbate_poller/commit/f681daf16225bd17ff164f36c84826aa0829bdb2))

### Chores

- **deps**: Lock file maintenance
  ([#132](https://github.com/MountainGod2/chaturbate_poller/pull/132),
  [`f623626`](https://github.com/MountainGod2/chaturbate_poller/commit/f6236264ac73034a6da4984e846c8e511e3d6fe2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#134](https://github.com/MountainGod2/chaturbate_poller/pull/134),
  [`3f2e50f`](https://github.com/MountainGod2/chaturbate_poller/commit/3f2e50fb75f30adbb73700dbcb68093f78308676))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.4.7 (2024-12-07)

### Bug Fixes

- **ci**: Update documentation build command to include extras
  ([`af85bf3`](https://github.com/MountainGod2/chaturbate_poller/commit/af85bf325df0c616f3d3428a57824776e7295158))

### Chores

- Enable automerge for Renovate lock file maintenance schedule
  ([`f02b6a2`](https://github.com/MountainGod2/chaturbate_poller/commit/f02b6a20416a58260f2a3a20a2e1a14dc8efd932))

- Enable lock file maintenance for Chaturbate Poller in Renovate config
  ([`21d5ddf`](https://github.com/MountainGod2/chaturbate_poller/commit/21d5ddf462b4863c98425b62e2986a1476d85c2e))

- Remove outdated requirements file from documentation
  ([`0bffa28`](https://github.com/MountainGod2/chaturbate_poller/commit/0bffa286790876c9dd48a64f3062c4c1d78d1714))

- Update Renovate configuration for improved dependency management
  ([`afcd609`](https://github.com/MountainGod2/chaturbate_poller/commit/afcd609e6528f695884368d7491c56fbb96a7da2))

- Update Renovate configuration to separate minor, patch, and major dependency updates
  ([`a6ffa6b`](https://github.com/MountainGod2/chaturbate_poller/commit/a6ffa6b7a8859b9e576edf31ffc6a2ea6712ec53))

- Update Renovate lock file maintenance schedule for improved efficiency
  ([`2f6695f`](https://github.com/MountainGod2/chaturbate_poller/commit/2f6695f7018799c246a0e2491c66f41f113b4a2c))

- Update Renovate lock file maintenance schedule to run every minute
  ([`6f10143`](https://github.com/MountainGod2/chaturbate_poller/commit/6f10143e5e5dc13efb177e03e5947a2c61bd5357))

- **deps**: Add optional documentation dependencies to uv.lock
  ([`94de0d0`](https://github.com/MountainGod2/chaturbate_poller/commit/94de0d04558011fec9b6f383a2f1cf97997b35a2))

- **deps**: Lock file maintenance
  ([#131](https://github.com/MountainGod2/chaturbate_poller/pull/131),
  [`3f727f7`](https://github.com/MountainGod2/chaturbate_poller/commit/3f727f7a358e22cadf4725919299f047e947e0a6))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update optional dependencies for documentation in pyproject.toml
  ([`6749e2e`](https://github.com/MountainGod2/chaturbate_poller/commit/6749e2e0a14a26ae6bfc12d24d7d9edb60e76bdc))

- **docs**: Add optional dependencies for documentation and update Read the Docs configuration
  ([`6fbbc31`](https://github.com/MountainGod2/chaturbate_poller/commit/6fbbc31eedf4f89ccaaf7ce85a28b82d90ec2d9c))

- **docs**: Remove unnecessary commands from Read the Docs configuration
  ([`ac7cf21`](https://github.com/MountainGod2/chaturbate_poller/commit/ac7cf2184e894e0caf56b923a5620f6eadf54559))

- **docs**: Update Python version to 3.13 and adjust build commands
  ([`1409449`](https://github.com/MountainGod2/chaturbate_poller/commit/140944915d4c0a1962b2b824a6dcbd83be430e0d))

- **docs**: Update Read the Docs configuration to simplify documentation build command
  ([`e99ab5b`](https://github.com/MountainGod2/chaturbate_poller/commit/e99ab5bba5e5703db338200303e8f28013a0f2b1))

- **docs**: Update sync command in README to include all extras
  ([`5693119`](https://github.com/MountainGod2/chaturbate_poller/commit/5693119227a33640525418678eee0a9b59e4a62d))

### Documentation

- Update README instructions for setting up environment and dependencies
  ([`9e14322`](https://github.com/MountainGod2/chaturbate_poller/commit/9e143220b59ac5c6d6b09e1577015ca8831abd73))

### Refactoring

- Simplify docstrings in enumeration classes for clarity
  ([`3910963`](https://github.com/MountainGod2/chaturbate_poller/commit/391096300235bfe8e73e11fa75f6fa055545a099))

- **logging**: Remove correlation_id from log record formatting
  ([`4bb63e8`](https://github.com/MountainGod2/chaturbate_poller/commit/4bb63e8e799aed8e107bb76fb46ee2a00411ac11))


## v1.4.6 (2024-12-06)

### Bug Fixes

- Add non-root user and group to Dockerfile for improved security
  ([`334e4d3`](https://github.com/MountainGod2/chaturbate_poller/commit/334e4d3345e98eb1b3cff6b62e1b8ce0bc965638))

### Chores

- Add group name and schedule for Chaturbate Poller in Renovate config
  ([`6d18029`](https://github.com/MountainGod2/chaturbate_poller/commit/6d18029330921350110dc26b11920647306ae3b6))


## v1.4.5 (2024-12-06)

### Bug Fixes

- Add SBOM support to Docker build and remove outdated annotations
  ([`af558b4`](https://github.com/MountainGod2/chaturbate_poller/commit/af558b4c8bfcbf885ef35729962614be745a5876))


## v1.4.4 (2024-12-06)

### Bug Fixes

- Update Docker build annotations for improved formatting
  ([`ea4fedd`](https://github.com/MountainGod2/chaturbate_poller/commit/ea4fedd32ca9391a5807a43ff9e7ea5bfd9aa3d7))


## v1.4.3 (2024-12-05)

### Bug Fixes

- Add annotations to Docker build for improved image metadata
  ([`2762b4c`](https://github.com/MountainGod2/chaturbate_poller/commit/2762b4c7a68f1152a0c435b424b700ff0baa856d))

### Chores

- Remove unnecessary labels from Dockerfile for cleaner metadata
  ([`9c54b47`](https://github.com/MountainGod2/chaturbate_poller/commit/9c54b47d94ce78afa2162bb1fab6ebd31243202e))


## v1.4.2 (2024-12-05)

### Bug Fixes

- Enhance Dockerfile metadata with additional labels for better documentation
  ([`de5b2bc`](https://github.com/MountainGod2/chaturbate_poller/commit/de5b2bc3afa598ac3c1282afbe3862919bc7f54d))

### Chores

- Change lock file maintenance schedule to hourly
  ([`d83958a`](https://github.com/MountainGod2/chaturbate_poller/commit/d83958a29228e7cf1db823272bddd660f23f7475))

- Move lock file maintenance configuration to package rules for better organization
  ([`3a00faa`](https://github.com/MountainGod2/chaturbate_poller/commit/3a00faa41788d5e2931d7c12cefea57dd08f7958))

- Refine Renovate configuration for lock file maintenance and dependency rules
  ([`e22015e`](https://github.com/MountainGod2/chaturbate_poller/commit/e22015ecb7161ae5a2c2bda61e96787b9d16c59f))

- Remove hourly schedule for chaturbate-poller in Renovate configuration
  ([`1e332ed`](https://github.com/MountainGod2/chaturbate_poller/commit/1e332ed40155cf20a465c20b6f6610aef89110d6))

- Update chaturbate-poller version to 1.4.1 in uv.lock
  ([`b326343`](https://github.com/MountainGod2/chaturbate_poller/commit/b3263432738bbd4e66a741f01c38e8cc2cb895a1))

- Update cron schedule comment in stale.yml for clarity
  ([`8970ede`](https://github.com/MountainGod2/chaturbate_poller/commit/8970ede3ca3cf3faef4a17bf961115bdeab2f8ff))

- Update lock file maintenance schedule to 'before 5am'
  ([`e997b44`](https://github.com/MountainGod2/chaturbate_poller/commit/e997b445637f811c8e784a2a38db5a1e6c0d1af1))

- Update lock file maintenance schedule to 'every 1 hour'
  ([`275dffb`](https://github.com/MountainGod2/chaturbate_poller/commit/275dffb21069663b3deeea094ccc5291fc4a2aa3))

- Update lock file maintenance schedule to 'every day at 3am'
  ([`594e38f`](https://github.com/MountainGod2/chaturbate_poller/commit/594e38f5fc32b85a31e4d0d56f863a30ea13c901))

- Update lock file maintenance schedule to 'every hour' and disable automerge
  ([`27b6913`](https://github.com/MountainGod2/chaturbate_poller/commit/27b6913fd9e45dda233ddcb495a73802ad666a82))

- Update lock file maintenance schedule to 'every weekday and weekend at 03:00'
  ([`6ec379e`](https://github.com/MountainGod2/chaturbate_poller/commit/6ec379ee42b511a07c3ba7f151e096101d663afd))

- Update Renovate configuration to enable automerge for lock file maintenance and match specific
  package names
  ([`1909d94`](https://github.com/MountainGod2/chaturbate_poller/commit/1909d94a7b645fabd48d35a4e535c84fba608b01))

- Update Renovate schedule for chaturbate-poller to run every 10 minutes
  ([`762b5bb`](https://github.com/MountainGod2/chaturbate_poller/commit/762b5bbf3032c640fa8c01bf1b54418fc6dcf117))

- Update Renovate schedule for chaturbate-poller to run hourly
  ([`12a448b`](https://github.com/MountainGod2/chaturbate_poller/commit/12a448b005f87a6f3a16003725829ba01c05e5b3))

- Update SonarCloud action to use the latest version in CI workflow
  ([`d98786c`](https://github.com/MountainGod2/chaturbate_poller/commit/d98786cc215913ee76f393000abac81c03f0151c))

### Testing

- Add environment variable clearing in config manager tests
  ([#128](https://github.com/MountainGod2/chaturbate_poller/pull/128),
  [`2c74ad6`](https://github.com/MountainGod2/chaturbate_poller/commit/2c74ad692ac7ec8f99c59245ad9f69fc3d966b12))

* refactor: enhance model documentation and validation in chaturbate_poller

* test: add environment variable clearing in config manager tests

* test: simplify context manager usage in test_start_polling_verbose

* test: improve exception handling in giveup_handler tests


## v1.4.1 (2024-12-04)

### Bug Fixes

- Update documentation link in pyproject.toml
  ([`efa0ad7`](https://github.com/MountainGod2/chaturbate_poller/commit/efa0ad71a3c276501392fc98ee547f85fc9a240d))

### Build System

- Remove annotations from docker-build.yml
  ([`81acdc1`](https://github.com/MountainGod2/chaturbate_poller/commit/81acdc1f491b5df5c001e8053bead8af23800ee7))

### Chores

- **deps**: Lock file maintenance
  ([#126](https://github.com/MountainGod2/chaturbate_poller/pull/126),
  [`d6c89ff`](https://github.com/MountainGod2/chaturbate_poller/commit/d6c89ffe236fb5fb6ffbfa93e264c314190ba4e0))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update actions/attest-build-provenance action to v2
  ([#125](https://github.com/MountainGod2/chaturbate_poller/pull/125),
  [`0c44eda`](https://github.com/MountainGod2/chaturbate_poller/commit/0c44eda692e27c60cff6327675da854242616018))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.4.0 (2024-12-03)

### Bug Fixes

- Add checkout step to CI workflow for improved dependency installation
  ([`095e3f2`](https://github.com/MountainGod2/chaturbate_poller/commit/095e3f24d39c61260907921847ce677d49ca7584))

- Add checkout step to CI workflow for improved dependency installation
  ([`0dac63d`](https://github.com/MountainGod2/chaturbate_poller/commit/0dac63dcdb403712eb8b12ba86915dd123624f20))

- Set fetch-depth to 0 in checkout step for complete history retrieval
  ([`5a5a7b4`](https://github.com/MountainGod2/chaturbate_poller/commit/5a5a7b48e51f0bd497a77ffe341cd870875151e9))

- Update install-dependencies workflow to use Python 3.13 and streamline CI configuration
  ([`20fc874`](https://github.com/MountainGod2/chaturbate_poller/commit/20fc8745c285234390acd77ee65f23c593c768e2))

- Update path for install-dependencies action in CI workflow
  ([`d518625`](https://github.com/MountainGod2/chaturbate_poller/commit/d518625dd8ccaa469ebb636d521a46cb6f130b90))

- Update path for install-dependencies workflow in CI configuration
  ([`397236b`](https://github.com/MountainGod2/chaturbate_poller/commit/397236b61048db8773bde8ff7b14ff869a5806fc))

- Update python version in CI workflow and remove unused docker build workflow
  ([`61a8ac4`](https://github.com/MountainGod2/chaturbate_poller/commit/61a8ac45fd5b379a91caf609e91e522f813f49ed))

### Chores

- **deps**: Lock file maintenance
  ([#124](https://github.com/MountainGod2/chaturbate_poller/pull/124),
  [`a2db49d`](https://github.com/MountainGod2/chaturbate_poller/commit/a2db49dc5149b1274c049387d5856e76e7f3b6c4))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- Refactor CI workflows to modularize dependency installation and improve stale issue management
  ([`144dee8`](https://github.com/MountainGod2/chaturbate_poller/commit/144dee8ee3806dec3bfce003f2489b84e831a7c6))

### Refactoring

- Consolidate CI workflows and enhance deployment process with Docker integration
  ([`c1fc32f`](https://github.com/MountainGod2/chaturbate_poller/commit/c1fc32fd832ac89c2213b4af287980c86396925b))

- Rename install-dependencies job and remove redundant checkout step
  ([`44a1dc1`](https://github.com/MountainGod2/chaturbate_poller/commit/44a1dc14af69399b0f40a9ff5f13418aabf3f75a))


## v1.3.0 (2024-12-03)

### Features

- Add annotations for Docker image metadata in workflow
  ([`f729125`](https://github.com/MountainGod2/chaturbate_poller/commit/f72912568c89fd2d062ea7c97948cbb9cdc39ab4))


## v1.2.2 (2024-12-03)

### Bug Fixes

- Simplify Docker build workflow by removing unused tag type
  ([`6b5be65`](https://github.com/MountainGod2/chaturbate_poller/commit/6b5be65b49a3a1e1be93b10cc21b0691b7e75849))

### Build System

- Remove unused tag type from Docker build workflow configuration
  ([`675c697`](https://github.com/MountainGod2/chaturbate_poller/commit/675c697474279d83c28da91d25a28cfbb7c51078))

### Chores

- **deps**: Lock file maintenance
  ([#123](https://github.com/MountainGod2/chaturbate_poller/pull/123),
  [`6829e6e`](https://github.com/MountainGod2/chaturbate_poller/commit/6829e6e58484e1c3398e16bb3e74b17f7fe431ce))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v1.2.1 (2024-12-03)

### Bug Fixes

- Remove unused rich-click styling configurations and update usage examples in CLI documentation
  ([#121](https://github.com/MountainGod2/chaturbate_poller/pull/121),
  [`e33d595`](https://github.com/MountainGod2/chaturbate_poller/commit/e33d595300c99c6ef66f576b1cc57c983c90e9f5))

* refactor: improve docstrings and comments for clarity in main module

* fix: remove unused rich-click styling configurations and update usage examples in CLI
  documentation

### Chores

- Increase verbosity of pytest output in configuration
  ([`82c1edb`](https://github.com/MountainGod2/chaturbate_poller/commit/82c1edbadd71774759626195ec5da3fb9d199e8a))

- Update Python version in SonarQube configuration to include 3.13
  ([`6c75049`](https://github.com/MountainGod2/chaturbate_poller/commit/6c7504972d07a6fab58c0e975f0ab1fef1a22bbe))

- **deps**: Lock file maintenance
  ([`96904a3`](https://github.com/MountainGod2/chaturbate_poller/commit/96904a3d414a1eb682e504207956bc612a550ffd))

- **deps**: Lock file maintenance
  ([#114](https://github.com/MountainGod2/chaturbate_poller/pull/114),
  [`2ad2ed4`](https://github.com/MountainGod2/chaturbate_poller/commit/2ad2ed40d856d74403d6a5037a8bb50db6809ebf))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#115](https://github.com/MountainGod2/chaturbate_poller/pull/115),
  [`0a35c0f`](https://github.com/MountainGod2/chaturbate_poller/commit/0a35c0fae9cc2bd8df762a70814980692e3ea7eb))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#116](https://github.com/MountainGod2/chaturbate_poller/pull/116),
  [`d3c625e`](https://github.com/MountainGod2/chaturbate_poller/commit/d3c625eb3be8a4ac6274c6e2626cfeaa9d796681))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#117](https://github.com/MountainGod2/chaturbate_poller/pull/117),
  [`8b68fed`](https://github.com/MountainGod2/chaturbate_poller/commit/8b68fedc3cf24da7aad03a0460e15cf7c299f5f3))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update astral-sh/setup-uv action to v4
  ([#107](https://github.com/MountainGod2/chaturbate_poller/pull/107),
  [`7e65968`](https://github.com/MountainGod2/chaturbate_poller/commit/7e65968b6af067441ad40482ef17e4900cb127af))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency sphinx-autoapi to v3.4.0
  ([#113](https://github.com/MountainGod2/chaturbate_poller/pull/113),
  [`8e8c603`](https://github.com/MountainGod2/chaturbate_poller/commit/8e8c603ba9fe3c2dab04392aefcc622636cd50a3))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Add deployment step for documentation to GitHub Pages for Python 3.13
  ([`2f4bd13`](https://github.com/MountainGod2/chaturbate_poller/commit/2f4bd139eb1ce280e24b82d4d807a1fa971f2c78))

- Refactor CI workflow to enhance code quality checks and streamlin…
  ([#109](https://github.com/MountainGod2/chaturbate_poller/pull/109),
  [`18f41d6`](https://github.com/MountainGod2/chaturbate_poller/commit/18f41d68610e8c0b093f59697bc33ff8335d94bb))

* ci: refactor CI workflow to enhance code quality checks and streamline documentation deployment

* ci: restore unit tests step in CI workflow for improved code validation

* ci: add unit tests with coverage and upload coverage report as artifact

* ci: update unit test command to include coverage report and restrict artifact upload to Python
  3.13

* ci: enhance CI workflow to conditionally run unit tests with coverage and upload reports to
  Codecov

* ci: fix spacing in unit test command for improved readability

* ci: simplify unit test command by removing conditional coverage flag

* ci: refactor CI workflow to streamline unit tests and coverage reporting

- Remove old GitHub Pages deployment step and add new upload artifact step
  ([`06565d8`](https://github.com/MountainGod2/chaturbate_poller/commit/06565d8f1209aa5ac3913d9498e0a91916cef2e0))

- Remove UV cache upload step from CI workflow
  ([`4a46269`](https://github.com/MountainGod2/chaturbate_poller/commit/4a462691795b5c4325e8b354b94d76ee49749674))

- Update CI workflow to improve Python version handling and streamline documentation deployment
  ([#112](https://github.com/MountainGod2/chaturbate_poller/pull/112),
  [`02c1263`](https://github.com/MountainGod2/chaturbate_poller/commit/02c126346770d28842a1a90ecffd9e3d9a4b5272))

* ci: update CI workflow to improve Python version handling and streamline documentation deployment

* docs(README.md): add example images of usage (#110) (#111)

* docs(README.md): add example images of usage

* chore: update README.md

* ci: update workflow to include 'develop' branch and refine conditions for documentation and
  coverage uploads

* ci: restrict CI workflow to only trigger on 'main' branch

- Update GitHub Pages deployment job to include documentation path
  ([`93593cd`](https://github.com/MountainGod2/chaturbate_poller/commit/93593cd9deb20091650063f89f301dd117918827))

- Update upload-artifact action to v4 in CI workflow
  ([`ff104f6`](https://github.com/MountainGod2/chaturbate_poller/commit/ff104f6df2f6f991fcac5e08c1ba76a4a362f5f3))

- Update workflow to include pull request types and add GitHub token for SonarCloud
  ([`5a84ada`](https://github.com/MountainGod2/chaturbate_poller/commit/5a84adad9db01a47094b5d88eed8ecb266cbd9af))

- Update workflows to use Ubuntu 24.04 for all jobs
  ([`3fc369e`](https://github.com/MountainGod2/chaturbate_poller/commit/3fc369e8bea602c365396cdea1d4fb8b7d1d9f28))

- Update workflows to use Ubuntu 24.04 for all jobs
  ([#118](https://github.com/MountainGod2/chaturbate_poller/pull/118),
  [`f5eca04`](https://github.com/MountainGod2/chaturbate_poller/commit/f5eca04f00fb0518e940dd8e16b147b83ba78aa9))

### Documentation

- Update CONTRIBUTING.md to reflect installation changes and testing commands
  ([`420d3e2`](https://github.com/MountainGod2/chaturbate_poller/commit/420d3e208f8000474ea34881763cf4142fdfc7fb))

- **example**: Update example notebook to reflect changes in ChaturbateClient usage and output
  handling
  ([`b8654e3`](https://github.com/MountainGod2/chaturbate_poller/commit/b8654e38142b58800812b98ac22e941fc5c7d460))

- **README**: Update example ChaturbateClient usage to include testbed parameter and change print to
  use model_dump
  ([`3b2c4a6`](https://github.com/MountainGod2/chaturbate_poller/commit/3b2c4a62b24893d0fdad0ed39f8d62b3bcce20ee))

- **README.md**: Add example images of usage
  ([#110](https://github.com/MountainGod2/chaturbate_poller/pull/110),
  [`5c8e276`](https://github.com/MountainGod2/chaturbate_poller/commit/5c8e276dfef1d3e2ebb01df504a037cfd5ed0b7d))

* docs(README.md): add example images of usage

* chore: update README.md

### Refactoring

- Add pragma comments to functions for better coverage tracking
  ([`7531d16`](https://github.com/MountainGod2/chaturbate_poller/commit/7531d1663b9910732fa89dba000e2399cb8e444b))

- Simplify method calls in ChaturbateClient and ChaturbateUtils
  ([`2b216a0`](https://github.com/MountainGod2/chaturbate_poller/commit/2b216a06107ed120cd2f7e0bf758da1ab6dda8b8))

- **models**: Update BaseModel inheritance to support enum serialization and adjust media type
  handling
  ([`99db781`](https://github.com/MountainGod2/chaturbate_poller/commit/99db7811423fb6db44f9475a9bad02856a04435c))

### Testing

- Add verbose log level test and improve coverage for non-string message handling
  ([`f7f5ead`](https://github.com/MountainGod2/chaturbate_poller/commit/f7f5ead6d4ba39ecd6377cfd6f1c678a6f92105a))

- Enhance backoff handler tests with TypedDict and additional scenarios
  ([`9be0339`](https://github.com/MountainGod2/chaturbate_poller/commit/9be03394c6838dac7fd6136f8d44e3055c068db3))

- Enhance ConfigManager tests for environment file existence
  ([`1cb624c`](https://github.com/MountainGod2/chaturbate_poller/commit/1cb624c04b6fab119184beaa6023a362b8bfc570))

- Update giveup_handler test with specific error message and URL
  ([`3b37af5`](https://github.com/MountainGod2/chaturbate_poller/commit/3b37af5a7dd6e3f9b02c6ec2b9608aa16c9d3a81))


## v1.2.0 (2024-11-27)

### Bug Fixes

- Replace PollingError with TimeoutError in ChaturbateClient
  ([`a9ec665`](https://github.com/MountainGod2/chaturbate_poller/commit/a9ec665cce2bac5a400d5006c3c861fcafec6d6e))

- Replace PollingError with TimeoutError in test cases for ChaturbateClient
  ([`3c6b195`](https://github.com/MountainGod2/chaturbate_poller/commit/3c6b195244ad68e90a0ba06c9c6567b3f8aea487))

### Chores

- **deps**: Lock file maintenance
  ([#105](https://github.com/MountainGod2/chaturbate_poller/pull/105),
  [`9ecaf9d`](https://github.com/MountainGod2/chaturbate_poller/commit/9ecaf9def975892d606d3a51ff6f0618c59a06d5))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#106](https://github.com/MountainGod2/chaturbate_poller/pull/106),
  [`4c3dd11`](https://github.com/MountainGod2/chaturbate_poller/commit/4c3dd11d4511cd6c72e81d3f3d65b24468e0088d))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance
  ([#108](https://github.com/MountainGod2/chaturbate_poller/pull/108),
  [`e0d61ff`](https://github.com/MountainGod2/chaturbate_poller/commit/e0d61ff0ed8c876f3e8f55922221155434498e45))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- Enhance error handling and improve CLI options for Chaturbate Poller
  ([`b50f18a`](https://github.com/MountainGod2/chaturbate_poller/commit/b50f18ab84a85a0eb11428870dc33da27e40eba9))

### Refactoring

- Enhance CLI interface and improve user prompts for Chaturbate Poller
  ([`7269c68`](https://github.com/MountainGod2/chaturbate_poller/commit/7269c686093e5bd070cc565ca9347cdac8c96d8b))


## v1.1.5 (2024-11-21)

### Bug Fixes

- Update Event model fields to require values for method, object, and id
  ([`eda0e60`](https://github.com/MountainGod2/chaturbate_poller/commit/eda0e60cb8095252ce5554c466421df03703598f))


## v1.1.4 (2024-11-21)

### Bug Fixes

- Update Docker build workflow to use registry caching for improved performance
  ([`96b3255`](https://github.com/MountainGod2/chaturbate_poller/commit/96b325534c2d98de101c50d0286a400059d685a6))


## v1.1.3 (2024-11-21)

### Bug Fixes

- Optimize Docker build workflow by adding caching and simplifying image digest handling
  ([`96555e6`](https://github.com/MountainGod2/chaturbate_poller/commit/96555e6a7b8b183bcef883be6ff3e59dbe9a468a))


## v1.1.2 (2024-11-21)

### Bug Fixes

- Remove platform matrix from Docker build workflow
  ([`fc8446d`](https://github.com/MountainGod2/chaturbate_poller/commit/fc8446de18a8f45c12146dee3fa35014c9c3265b))

### Chores

- **deps**: Lock file maintenance
  ([`e69d116`](https://github.com/MountainGod2/chaturbate_poller/commit/e69d116afd9855bdf089ffafba639026ec7ba1af))


## v1.1.1 (2024-11-21)

### Bug Fixes

- Streamline exception handling and improve event processing count in main polling function
  ([`b185c80`](https://github.com/MountainGod2/chaturbate_poller/commit/b185c8079b062e170b8ddae5d797e8ade0743976))

### Chores

- Add type=sha tag to Docker build workflow
  ([`6accbb6`](https://github.com/MountainGod2/chaturbate_poller/commit/6accbb660ae1116513ee0471b369c71305a3f2db))

- **deps**: Remove schema URL from lock file maintenance configuration in Renovate
  ([`aba818d`](https://github.com/MountainGod2/chaturbate_poller/commit/aba818de20c756ccecc1b5ceb7c6990251f0104b))


## v1.1.0 (2024-11-20)

### Bug Fixes

- Specify type for stop_future in main function
  ([`ac2f1a6`](https://github.com/MountainGod2/chaturbate_poller/commit/ac2f1a65cc2e28a44c6aa2e4e0a68b8abf7bac97))

- Update default command in docker entrypoint to include python3 execution
  ([`976a4c1`](https://github.com/MountainGod2/chaturbate_poller/commit/976a4c1e2724f83c7bb0e77e969f6eb329dcd19a))

- Update test command in Docker workflow to display help instead of version
  ([`024b4d5`](https://github.com/MountainGod2/chaturbate_poller/commit/024b4d5a1b4b0d20bacd0a23dea54fa38a7ba134))

### Chores

- **deps**: Add schema URL to lock file maintenance configuration in Renovate
  ([`85e04bb`](https://github.com/MountainGod2/chaturbate_poller/commit/85e04bb557ef65d6f24868effa4655b25f0cdc80))

- **deps**: Lock file maintenance
  ([#103](https://github.com/MountainGod2/chaturbate_poller/pull/103),
  [`75f9465`](https://github.com/MountainGod2/chaturbate_poller/commit/75f9465693c76ec3dcd37182af68aa0309dddb54))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- **codecov**: Enhance CI workflow with Codecov integration and add junit.xml to .gitignore
  ([#104](https://github.com/MountainGod2/chaturbate_poller/pull/104),
  [`e7d2985`](https://github.com/MountainGod2/chaturbate_poller/commit/e7d29852838bd3962622fe5d635b8d050676595d))

* ci(codecov): enhance CI workflow with Codecov integration and add junit.xml to .gitignore

* chore: update job name for Codecov upload in CI workflow

### Features

- Enhance logging setup with verbose option and refactor InfluxDB configuration prompts
  ([`64c84a8`](https://github.com/MountainGod2/chaturbate_poller/commit/64c84a8a7eaafbfa5fabf23f6693af719e1f54d9))


## v1.0.1 (2024-11-19)

### Bug Fixes

- Adjust console width for improved output readability
  ([`fee5845`](https://github.com/MountainGod2/chaturbate_poller/commit/fee584546e85d2c728d3877de739907d755ff1a0))

- Enhance command options with verbose logging and database integration
  ([`9adc6a9`](https://github.com/MountainGod2/chaturbate_poller/commit/9adc6a90f44a78423621e50d1dc52230f07590ee))

- Update build command to include installation of uv package
  ([`155c14e`](https://github.com/MountainGod2/chaturbate_poller/commit/155c14ec27a9c2beadf9d5a43f6b3ab04a69fa78))


## v1.0.0 (2024-11-18)

### Chores

- **deps**: Lock file maintenance
  ([`e55aac6`](https://github.com/MountainGod2/chaturbate_poller/commit/e55aac6d0becceca8acc6e16800dafdfd1387189))


## v0.20.0 (2024-11-19)

### Bug Fixes

- Update Docker image test command to display help information
  ([`59567aa`](https://github.com/MountainGod2/chaturbate_poller/commit/59567aa361a6d788e7d40fe7ffbfe5b8483b97d7))

### Chores

- Lock file maintenance
  ([`832feee`](https://github.com/MountainGod2/chaturbate_poller/commit/832feee20ab4d4907b7036317c11449465deaba8))

### Features

- Enhance CLI documentation and improve console output formatting
  ([`d50d427`](https://github.com/MountainGod2/chaturbate_poller/commit/d50d427dc497e1aa202f5d9c376d963d87dce464))


## v0.19.4 (2024-11-19)

### Bug Fixes

- Enhance CLI with improved help messages and progress indicators
  ([`95482fa`](https://github.com/MountainGod2/chaturbate_poller/commit/95482fabf155f221ee58e0e6bafca18e1ad1b956))

### Chores

- **deps**: Lock file maintenance
  ([#102](https://github.com/MountainGod2/chaturbate_poller/pull/102),
  [`d9a9410`](https://github.com/MountainGod2/chaturbate_poller/commit/d9a9410deec1ab30837ba587a23799abcabea43a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.19.3 (2024-11-16)

### Bug Fixes

- Update subject-name in Docker build workflow to use full registry path
  ([`941ee19`](https://github.com/MountainGod2/chaturbate_poller/commit/941ee19ba8730843760c4938c3604122ff527e89))


## v0.19.2 (2024-11-16)

### Bug Fixes

- Update Docker image test command to use --version
  ([`1fc25e7`](https://github.com/MountainGod2/chaturbate_poller/commit/1fc25e75f63f19435ea888e5f273ae9ecf758c61))


## v0.19.1 (2024-11-15)

### Bug Fixes

- Add attestations permission to CD workflow
  ([`7053804`](https://github.com/MountainGod2/chaturbate_poller/commit/705380466591646e26d71deedf3757981fa4b497))

- Add id-token and attestations permissions to Docker build workflow
  ([`63ac1a0`](https://github.com/MountainGod2/chaturbate_poller/commit/63ac1a06abc6bb0fa957b64a36f5e3fc72e8d027))


## v0.19.0 (2024-11-15)

### Features

- Add build provenance attestation to CI workflows
  ([`6409459`](https://github.com/MountainGod2/chaturbate_poller/commit/6409459d04a4bf8d57d375c6dc325ddda2373369))


## v0.18.0 (2024-11-15)

### Bug Fixes

- Simplify Docker entrypoint script by removing command echo
  ([`c409b03`](https://github.com/MountainGod2/chaturbate_poller/commit/c409b036ded97180c04283f6598b21259e8685e1))

### Features

- Update Docker build workflow to enable semver pattern for major version
  ([`ef6404a`](https://github.com/MountainGod2/chaturbate_poller/commit/ef6404aff1f1826c52cde5eff5dab507f4346b2f))


## v0.17.4 (2024-11-15)

### Bug Fixes

- Update Docker image test command to include --help option
  ([`515b215`](https://github.com/MountainGod2/chaturbate_poller/commit/515b215afb8b0fb67b1fb258b38370457ce58853))

### Chores

- **deps**: Lock file maintenence
  ([`40dd675`](https://github.com/MountainGod2/chaturbate_poller/commit/40dd6750cfb39749cf686f1ef632c83fd7123803))


## v0.17.3 (2024-11-15)

### Bug Fixes

- Update GitHub Actions workflows to use GH_PAT and adjust documentation deployment for Python 3.13
  ([`2619cc3`](https://github.com/MountainGod2/chaturbate_poller/commit/2619cc3cee243e2b7753cd3efde492b1944d2f34))


## v0.17.2 (2024-11-15)

### Bug Fixes

- Update GitHub Actions to use GITHUB_TOKEN and add Docker image testing
  ([`11a40ea`](https://github.com/MountainGod2/chaturbate_poller/commit/11a40ea38184e2b043b2c4012979456b7aba79e5))

### Chores

- **deps**: Lock file maintenance
  ([#101](https://github.com/MountainGod2/chaturbate_poller/pull/101),
  [`75ca51c`](https://github.com/MountainGod2/chaturbate_poller/commit/75ca51c4339b8efa1f1ed2dbf5b59222af8f71e2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update codecov/codecov-action action to v5
  ([#100](https://github.com/MountainGod2/chaturbate_poller/pull/100),
  [`7475bb6`](https://github.com/MountainGod2/chaturbate_poller/commit/7475bb6cf670070dbc348026d5ae6161e5f38fb2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency sphinx-rtd-theme to v3.0.2
  ([#99](https://github.com/MountainGod2/chaturbate_poller/pull/99),
  [`cd9ebf0`](https://github.com/MountainGod2/chaturbate_poller/commit/cd9ebf0cabbeadb1430b72e17b2d69c29c9cf83f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.17.1 (2024-11-15)

### Bug Fixes

- Remove debug step and build provenance attestation from CI workflow
  ([`4d1201e`](https://github.com/MountainGod2/chaturbate_poller/commit/4d1201e9c0be6f10dceda0afa349d4acc59c7bf6))


## v0.17.0 (2024-11-15)

### Features

- Add build provenance attestation step to CI workflow
  ([`a9f368c`](https://github.com/MountainGod2/chaturbate_poller/commit/a9f368c298e9c87dda2f32cdecc58675721a0c7b))


## v0.16.9 (2024-11-15)

### Bug Fixes

- Disable attestations in TestPyPI publish workflow and add debug step for generated files
  ([`49f6a5c`](https://github.com/MountainGod2/chaturbate_poller/commit/49f6a5c3520c1378ccfa5001c1b9d07db8edf8fb))


## v0.16.8 (2024-11-15)

### Bug Fixes

- Update GitHub token for semantic release workflow
  ([`06c98d5`](https://github.com/MountainGod2/chaturbate_poller/commit/06c98d5894798579ff2601cf17420a33797297f2))

- Update PyPI publish action to version 1.12.2
  ([`81e1354`](https://github.com/MountainGod2/chaturbate_poller/commit/81e13540852711b6779704761ef7ad86a962ab48))


## v0.16.7 (2024-11-15)

### Bug Fixes

- Add attestations to PyPI publish workflow
  ([`faae4e5`](https://github.com/MountainGod2/chaturbate_poller/commit/faae4e5ae1375f3f494feca5e7a3588d8041aa30))

### Chores

- **deps**: Lock file maintenance ([#95](https://github.com/MountainGod2/chaturbate_poller/pull/95),
  [`a20a8ef`](https://github.com/MountainGod2/chaturbate_poller/commit/a20a8ef3c95f0f2d00889e0ee26ac136fcd1b9d9))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance ([#96](https://github.com/MountainGod2/chaturbate_poller/pull/96),
  [`2c86580`](https://github.com/MountainGod2/chaturbate_poller/commit/2c86580b37c8169eee0d60add6264a41c01d8bd6))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance ([#97](https://github.com/MountainGod2/chaturbate_poller/pull/97),
  [`0fa21e2`](https://github.com/MountainGod2/chaturbate_poller/commit/0fa21e2f8d1a9409d6067193ae9a3eb56c139782))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance ([#98](https://github.com/MountainGod2/chaturbate_poller/pull/98),
  [`4614334`](https://github.com/MountainGod2/chaturbate_poller/commit/4614334f5e228ce1c9acfb7a9be042158c9d78af))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Documentation

- Update README layout and formatting
  ([`45fc101`](https://github.com/MountainGod2/chaturbate_poller/commit/45fc101d8d6a613cfac5f9176239941d36cf11df))


## v0.16.6 (2024-11-09)

### Bug Fixes

- Increase console width for better output visibility
  ([`85374e1`](https://github.com/MountainGod2/chaturbate_poller/commit/85374e1555150056186b3473c706a5960fa6f8db))

### Chores

- **deps**: Lock file maintenance ([#94](https://github.com/MountainGod2/chaturbate_poller/pull/94),
  [`32cae39`](https://github.com/MountainGod2/chaturbate_poller/commit/32cae39ba9ac9d0d116d56b12c61a36fb789db0a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.16.5 (2024-11-06)

### Bug Fixes

- Remove concurrency from CI workflow
  ([`b18d9da`](https://github.com/MountainGod2/chaturbate_poller/commit/b18d9da96511297f26e0cf466f7aa2a892735f6b))

### Chores

- Update concurrency in CD and CI workflows
  ([`1c353b6`](https://github.com/MountainGod2/chaturbate_poller/commit/1c353b6ec6bbdbc67a549f82a1b25429d8885f2f))

- Update Docker build workflow to use pypa/gh-action-pypi-publish v1.12.1
  ([`dae7db6`](https://github.com/MountainGod2/chaturbate_poller/commit/dae7db602845e4f05fa937dd9a26a16a16d511ea))

- **deps**: Lock file maintenance ([#92](https://github.com/MountainGod2/chaturbate_poller/pull/92),
  [`6b715e4`](https://github.com/MountainGod2/chaturbate_poller/commit/6b715e4a8de6800f4c0aeba4fae889c8b518b4ab))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update pypa/gh-action-pypi-publish action to v1.12.0
  ([#91](https://github.com/MountainGod2/chaturbate_poller/pull/91),
  [`7e1bf04`](https://github.com/MountainGod2/chaturbate_poller/commit/7e1bf04cf73de805bff27319b888809a3238e69b))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.16.4 (2024-11-06)

### Bug Fixes

- Update Docker build workflow to include push events on the main branch and tags
  ([`65b29df`](https://github.com/MountainGod2/chaturbate_poller/commit/65b29dfb001079056ede36043fa3bb085d219e22))

- Update Docker build workflow to include token for authentication
  ([`34c3981`](https://github.com/MountainGod2/chaturbate_poller/commit/34c398167ddc42029532a5a336532d507ca15a34))


## v0.16.3 (2024-11-06)

### Bug Fixes

- Update Docker build workflow to include push events on the main branch
  ([`e0db35c`](https://github.com/MountainGod2/chaturbate_poller/commit/e0db35c6c5ff326ac8e9edd5d1640f215bd6f85d))

### Chores

- **deps**: Lock file maintenance
  ([`f385670`](https://github.com/MountainGod2/chaturbate_poller/commit/f3856708572f65ef5072d5c227d9fe27fe7723ad))


## v0.16.2 (2024-11-06)

### Bug Fixes

- Update Docker build workflow to include push events on the main branch
  ([`04ca7db`](https://github.com/MountainGod2/chaturbate_poller/commit/04ca7db0d0cd79796300d50f64b95f980823d897))


## v0.16.1 (2024-11-06)

### Bug Fixes

- Update Docker build workflow to include tag events
  ([`eb98dd5`](https://github.com/MountainGod2/chaturbate_poller/commit/eb98dd5cc1210521eb48dd14321681bd7040f07a))


## v0.16.0 (2024-11-06)

### Features

- Update repository workflows and quality
  ([`b0d2dcb`](https://github.com/MountainGod2/chaturbate_poller/commit/b0d2dcb2b09fe6820d570b9dcfb6958f8db9a96b))

- Renamed the "Release Deployment" job in the cd.yml workflow to "CD - Release Deployment" for
  clarity. - Added a concurrency group and conditional steps to the cd.yml workflow to only run if
  the previous workflow run was successful. - Renamed the "test" job in the ci.yml workflow to "CI -
  Code Quality and Documentation Build" to better reflect its purpose. - Updated the UV_CACHE_DIR
  environment variable in the ci.yml workflow to include the Python version for better cache
  management. - Renamed the "analyze" job in the codeql.yml workflow to "CodeQL Analysis - Python"
  for clarity. - Added a conditional step to the codeql.yml workflow to only run if the previous
  workflow run was successful. - Updated the build-mode option in the codeql.yml workflow to "none"
  to skip the build step. - Renamed the "docker" job in the docker-build.yml workflow to "Docker
  Image Build and Push" for clarity. - Added conditional steps to the docker-build.yml workflow to
  only run on push events or scheduled cron jobs. - Updated the Docker image metadata in the
  docker-build.yml workflow to use the correct repository owner and image names. - Added a cleanup
  step to the docker-build.yml workflow to remove the Docker Buildx builder after the job completes.
  - Renamed the "stale" job in the stale.yml workflow to "Close Stale Issues and PRs" for clarity. -
  Updated the stale issue and PR messages in the stale.yml workflow to provide more information and
  instructions. - Updated the days-before-stale, days-before-close, and days-before-pr-close options
  in the stale.yml workflow to match the desired stale and close timeframes.

### Refactoring

- Update cd.yml workflow to checkout repository and ensure release branch is up-to-date
  ([`ff07d93`](https://github.com/MountainGod2/chaturbate_poller/commit/ff07d93e65c22b39a1265a82d0e7dec478196210))

- Update Docker build workflow
  ([`e75bcce`](https://github.com/MountainGod2/chaturbate_poller/commit/e75bcced41f0d99dea1efceca3b13c90d8fda159))

Simplify and improve the Docker build workflow by making the following changes: - Update the trigger
  conditions to run on version tags and the main branch - Add support for pull request events - Add
  a step to checkout the repository


## v0.15.13 (2024-11-06)

### Bug Fixes

- Remove unnecessary Docker image publishing steps in cd.yml workflow
  ([`490af4e`](https://github.com/MountainGod2/chaturbate_poller/commit/490af4e18d0bca9c4ceafd4624123288c52b57cb))


## v0.15.12 (2024-11-06)

### Bug Fixes

- Update cd.yml workflow to include Docker image publishing
  ([`de587a6`](https://github.com/MountainGod2/chaturbate_poller/commit/de587a6479fe37c10540fd585a4283559def2bea))


## v0.15.11 (2024-11-06)

### Bug Fixes

- Update console width in main.py
  ([`0a2b0e6`](https://github.com/MountainGod2/chaturbate_poller/commit/0a2b0e65e0553968dd455338b4a4246d438bae80))

### Continuous Integration

- Update cd.yml workflow to include SSH private and public signing keys
  ([`0e6d4d6`](https://github.com/MountainGod2/chaturbate_poller/commit/0e6d4d695a17535cf1000756b34b637b2fbfb36c))


## v0.15.10 (2024-11-06)

### Bug Fixes

- Update Docker Build workflow to improve code checkout and build process
  ([`3e37e9b`](https://github.com/MountainGod2/chaturbate_poller/commit/3e37e9b5a45be77b6b711b0cfd6fb6ba69fc03c1))


## v0.15.9 (2024-11-06)

### Bug Fixes

- Update cd.yml workflow to remove unnecessary release branch setup and improve cron schedule
  ([`370dc57`](https://github.com/MountainGod2/chaturbate_poller/commit/370dc576ae24359a017bce4302dc50077b9650a9))

- Update cd.yml workflow to remove unnecessary release branch setup and improve cron schedule
  ([`f6175d9`](https://github.com/MountainGod2/chaturbate_poller/commit/f6175d9efdd22728e0150fab696463d1e5c69d27))

### Chores

- **deps**: Lock file maintenance ([#88](https://github.com/MountainGod2/chaturbate_poller/pull/88),
  [`beba31c`](https://github.com/MountainGod2/chaturbate_poller/commit/beba31c52c1c29e797f64c68c3ddf928492b7600))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.15.8 (2024-11-05)

### Bug Fixes

- Update cd.yml workflow to include concurrency group for better workflow management
  ([`777fc6d`](https://github.com/MountainGod2/chaturbate_poller/commit/777fc6dcfc8530205a070459975211e33bce81fa))

### Refactoring

- Update cd.yml workflow to use the latest GitHub Actions syntax
  ([`6da07b6`](https://github.com/MountainGod2/chaturbate_poller/commit/6da07b614926de97133df890c52c31ba346acfd3))

- Update cd.yml workflow to use the latest GitHub Actions syntax and add correct release branch
  setup
  ([`0fa5135`](https://github.com/MountainGod2/chaturbate_poller/commit/0fa51356b0ed22f1276bc110c2c496ea30717594))

- Update cd.yml workflow to use the latest GitHub Actions syntax and remove unnecessary release
  branch setup
  ([`6a0ac89`](https://github.com/MountainGod2/chaturbate_poller/commit/6a0ac893f17ebc98c8a8394e24714bd153f5b57a))


## v0.15.7 (2024-11-05)

### Bug Fixes

- Refactor and standardize workflows, and force correct release branch setup
  ([`fc727ed`](https://github.com/MountainGod2/chaturbate_poller/commit/fc727eda5e1eb9c719a41b9185613413e8b1dd1d))

### Chores

- Refactor and standardize workflows
  ([`96101b5`](https://github.com/MountainGod2/chaturbate_poller/commit/96101b527533ca04d1aa170b24358ffbcb136c03))

- Update renovate.json with additional matchUpdateTypes and automerge settings
  ([`3ba582e`](https://github.com/MountainGod2/chaturbate_poller/commit/3ba582ea0bb05f4d7da97dadd1c49edda4ec1779))

- Update renovate.json with additional matchUpdateTypes and automerge settings
  ([`daebc8a`](https://github.com/MountainGod2/chaturbate_poller/commit/daebc8a8b45f4331638c2fd1de144a60f1513a0c))

- **deps**: Lock file maintenance
  ([`87a848b`](https://github.com/MountainGod2/chaturbate_poller/commit/87a848b86797254ebec6091e81aaf8bedc4e338b))

- **deps**: Update pypa/gh-action-pypi-publish action to v1.12.0
  ([#87](https://github.com/MountainGod2/chaturbate_poller/pull/87),
  [`8309d11`](https://github.com/MountainGod2/chaturbate_poller/commit/8309d115c66695e2857eb905481762308718dbc8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.15.6 (2024-11-03)

### Bug Fixes

- Update CD workflow to include signing artifacts and disable attestations
  ([`a48c6eb`](https://github.com/MountainGod2/chaturbate_poller/commit/a48c6ebbca0799a87a07338df0bde877c272f008))

### Chores

- **deps**: Lock file maintenance ([#84](https://github.com/MountainGod2/chaturbate_poller/pull/84),
  [`4a3ddfe`](https://github.com/MountainGod2/chaturbate_poller/commit/4a3ddfe2eabb44532b928135f979cc4862ed96dc))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>


## v0.15.5 (2024-11-03)

### Bug Fixes

- Remove unnecessary steps from CD workflow
  ([`6b16a50`](https://github.com/MountainGod2/chaturbate_poller/commit/6b16a50e00ec2f2b8bb4fa3cd9fe8310b2cbb674))


## v0.15.4 (2024-11-03)

### Bug Fixes

- Update CD workflow to include signing artifacts
  ([`f7c8248`](https://github.com/MountainGod2/chaturbate_poller/commit/f7c82482041161c9fe10ba7c1a365282733177d6))


## v0.15.3 (2024-11-03)

### Bug Fixes

- Update CD workflow to include dependency syncing and build attestation
  ([`70a13a0`](https://github.com/MountainGod2/chaturbate_poller/commit/70a13a0d4b758aa8dde0cf743039c6ac38239259))

### Continuous Integration

- Update CD workflow to include dependency syncing and build attestation
  ([`09bd9dd`](https://github.com/MountainGod2/chaturbate_poller/commit/09bd9dd205d8e09d66c55217fdf931a0d84ea026))


## v0.15.2 (2024-11-03)

### Bug Fixes

- Update permissions in CD workflow
  ([`f6a84c3`](https://github.com/MountainGod2/chaturbate_poller/commit/f6a84c3db4e85b1cfdbf6aa29bc0e170d9816e5f))


## v0.15.1 (2024-11-03)

### Bug Fixes

- Add dependency sync step to CD workflow
  ([`3281998`](https://github.com/MountainGod2/chaturbate_poller/commit/3281998ec9e28859515e41026d70358715e29601))

### Continuous Integration

- Update stale workflow to close issues and PRs after 15 days
  ([`96890ba`](https://github.com/MountainGod2/chaturbate_poller/commit/96890ba2b2cdad48ca6becd889b08cbc47430c2d))

- Renamed the workflow to "Close Stale Issues and PRs" - Updated the stale issue message to close
  issues after 15 days of inactivity - Updated the stale PR message to reopen PRs after 30 days of
  inactivity - Adjusted the days before closing issues to 15


## v0.15.0 (2024-11-03)

### Chores

- **deps**: Lock file maintenance ([#83](https://github.com/MountainGod2/chaturbate_poller/pull/83),
  [`af4584a`](https://github.com/MountainGod2/chaturbate_poller/commit/af4584a69a92f61308a8f31f2dc3cc504f33395a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Features

- Add workflow to close stale issues and PRs
  ([`91f983b`](https://github.com/MountainGod2/chaturbate_poller/commit/91f983b49afc54485ab29fd9459db089408fa38f))


## v0.14.5 (2024-11-02)

### Bug Fixes

- Update Python Semantic Release action to use python-semantic-release@v9
  ([`ae62471`](https://github.com/MountainGod2/chaturbate_poller/commit/ae62471396952185c750e990d4930131b53d2c8d))

### Chores

- **deps**: Lock file maintenance ([#82](https://github.com/MountainGod2/chaturbate_poller/pull/82),
  [`6cf209f`](https://github.com/MountainGod2/chaturbate_poller/commit/6cf209f4380d76d5ca5ef6bf3074ecb779802cfd))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Update CI and Docker build workflows for multi-platform support and code quality checks
  ([`8058ffc`](https://github.com/MountainGod2/chaturbate_poller/commit/8058ffc2487222e424641514be0d8d48d0a6fe75))


## v0.14.4 (2024-11-02)

### Bug Fixes

- Update package description and add ChaturbateClient export
  ([`95d4fcd`](https://github.com/MountainGod2/chaturbate_poller/commit/95d4fcd483c2a205d3dae6eb77e6d599271b33ec))

### Chores

- **deps**: Lock file maintenance
  ([`8017f8b`](https://github.com/MountainGod2/chaturbate_poller/commit/8017f8bebd917e28a5728b40fe08d2e24375575b))

### Documentation

- Refactor logging in poll_and_log_events.py and simple_poller.py
  ([`b0b45c1`](https://github.com/MountainGod2/chaturbate_poller/commit/b0b45c1d585a58d5b6321e2bf040e6906bef2a28))

### Refactoring

- Update CD workflow for release deployment
  ([`9b9f24b`](https://github.com/MountainGod2/chaturbate_poller/commit/9b9f24bce039f2f4a382bc6e44d10ded782d17d7))

- Renamed the job name to "CD - Release Deployment" for clarity - Updated step names for better
  readability and consistency - Forced correct release branch during setup - Updated UV environment
  setup - Updated step names for publishing and deploying to TestPyPI and PyPI - Updated step name
  for publishing release to GitHub

- Update CI workflow for code quality checks and documentation build
  ([`432606e`](https://github.com/MountainGod2/chaturbate_poller/commit/432606e1461799edaed9dc406765f80f73cc2ea3))

- Update dependencies in pyproject.toml
  ([`7c80b72`](https://github.com/MountainGod2/chaturbate_poller/commit/7c80b728617d8b3e863032ced7541a17ee0a4075))

- Update Docker build workflow for multi-platform support and cleanup
  ([`f6f70c5`](https://github.com/MountainGod2/chaturbate_poller/commit/f6f70c593d4477e6ff3d28499829ba34d0188bfd))

- Added permissions for read access to contents and write access to packages - Updated strategy
  matrix to include linux/amd64 and linux/arm64 platforms - Updated Docker Meta step name to "Docker
  Meta" - Added driver-opts for network=host in Set up Docker Buildx step - Updated conditions for
  Login to Docker Hub and Login to GHCR steps to only run on push and schedule events - Added
  platforms parameter in Build and Push Docker Image step to build for multiple platforms - Added
  Clean up Buildx step to remove the buildx builder

- Update Dockerfile to use Python 3.13-alpine image and optimize build process
  ([`1b22937`](https://github.com/MountainGod2/chaturbate_poller/commit/1b22937a4d3bd60306e5dac3a42fc28feab6247d))


## v0.14.3 (2024-11-01)

### Bug Fixes

- Update ci.yml to only run test coverage and docs uploading on single matrix instance
  ([`7ba25d0`](https://github.com/MountainGod2/chaturbate_poller/commit/7ba25d0b6dda07b6b17f5abf6ba5cada491062a5))

### Continuous Integration

- Update ci.yml to add Python version to uv cache
  ([`e13ae8d`](https://github.com/MountainGod2/chaturbate_poller/commit/e13ae8d5163440d6283c8983ac37f54d4d5c6c8c))

- Update ci.yml to use Python version in UV cache
  ([`2cd48cd`](https://github.com/MountainGod2/chaturbate_poller/commit/2cd48cd1ba45f988891661265c2bba9f1d5cf621))


## v0.14.2 (2024-11-01)

### Bug Fixes

- Update cd.yml to use GH_PAT instead of GITHUB_TOKEN for authentication
  ([`fa1f53b`](https://github.com/MountainGod2/chaturbate_poller/commit/fa1f53b97664a2aeeee2f10ec414d148af24c4bb))


## v0.14.1 (2024-11-01)

### Bug Fixes

- Update docker-entrypoint.sh to start chaturbate_poller by default
  ([`22dd9d6`](https://github.com/MountainGod2/chaturbate_poller/commit/22dd9d68ae1ef5251e37237ee42fd711849f19a2))

### Chores

- **deps**: Lock file maintenance
  ([`feb7018`](https://github.com/MountainGod2/chaturbate_poller/commit/feb7018efd86686696cf0d059556d712aa00c58d))

### Documentation

- Update Chaturbate Poller description and features in README.md
  ([`d18770a`](https://github.com/MountainGod2/chaturbate_poller/commit/d18770a3eed5c7ee2ac2466ace1fcc37f61647cc))

### Refactoring

- Update configuration manager to support loading environment variables from a specified file
  ([#80](https://github.com/MountainGod2/chaturbate_poller/pull/80),
  [`1aa29e2`](https://github.com/MountainGod2/chaturbate_poller/commit/1aa29e294dec6c4251fb31f872c53912c36997aa))


## v0.14.0 (2024-11-01)

### Chores

- Update .gitignore to exclude .env.bak file
  ([`66b0fe7`](https://github.com/MountainGod2/chaturbate_poller/commit/66b0fe70a054083f3b17dea734942df588d52fdb))

- Update INFLUXDB_BUCKET value in .env.example
  ([`6b36da7`](https://github.com/MountainGod2/chaturbate_poller/commit/6b36da78ec90177ae9c4ee3f0233adfdd424140c))

- **deps**: Lock file maintenance
  ([`bf4086b`](https://github.com/MountainGod2/chaturbate_poller/commit/bf4086b22c8e2e8ccb6ace591670700f1af6da95))

### Documentation

- Update file paths in README and docs
  ([`f04da5c`](https://github.com/MountainGod2/chaturbate_poller/commit/f04da5cc6981d333678738d0e396402ff66c7a16))

### Features

- Update configuration manager to support loading environment variables from a specified file
  ([`83507b4`](https://github.com/MountainGod2/chaturbate_poller/commit/83507b48fa99f81e45031d2c56c463054aa0d23d))

- Refactored the configuration manager to add support for loading environment variables from a
  specified file. This allows for easier management and customization of environment variables.

### Testing

- Add ConfigManager fixture to tests
  ([`241178a`](https://github.com/MountainGod2/chaturbate_poller/commit/241178a07dc9f209b2dc234a2e3d9c3295a6cd48))

This commit adds a new fixture, `config_manager`, to the tests. The fixture is used to initialize
  the `ConfigManager` class with an environment file specified as `.env.example`. This fixture will
  be used in future tests to access and manipulate configuration settings.

Refactor the ConfigManager initialization tests

This commit refactors the initialization tests for the `ConfigManager` class. It adds two new tests:
  `test_init_with_env_variables` and `test_init_with_env_file`.

The `test_init_with_env_variables` test verifies that the `ConfigManager` class can be initialized
  with environment variables. It sets the required environment variables and asserts that the
  `ConfigManager` instance is correctly initialized with the expected values.

The `test_init_with_env_file` test verifies that the `ConfigManager` class can be initialized with
  an environment file. It mocks the existence of the environment file and asserts that the
  `ConfigManager` instance is correctly initialized with the expected values from the file.

These changes improve the test coverage and ensure that the `ConfigManager` class is properly tested
  for different initialization scenarios.


## v0.13.12 (2024-10-31)

### Bug Fixes

- Update ChaturbateUtils class in utils.py to handle missing "wait" and "tries" details
  ([#77](https://github.com/MountainGod2/chaturbate_poller/pull/77),
  [`90e9051`](https://github.com/MountainGod2/chaturbate_poller/commit/90e9051541a93997ab732d26e8bb5d337f041203))

* refactor: Update chaturbate-poller script to use CLI instead of main function

* refactor: Update LICENSE file path in README.md

* chore: Update chaturbate-poller to 0.13.11

* ci: Disable credential persistence in CI workflow

* refactor: Enable linkify extension in Sphinx documentation

* refactor: Add linkify-it-py to Sphinx documentation requirements

* refactor: Update main module import in __main__.py

* refactor: Remove unnecessary exception handling in ChaturbateClient

The code changes remove the unnecessary exception handling for httpx.ReadError in the
  ChaturbateClient class. This exception was previously logged and re-raised, but it is now removed
  from the codebase.

Refactor the exception handling in ChaturbateClient to improve code readability and maintainability.

* refactor: Remove unused AddCorrelationIDFilter class in logging_config.py

* refactor: Update CLI entrypoint in main.py

- Move the CLI entrypoint from the `main` function to a new `cli` function. - Reorder the command
  line options for better readability. - Update the `main` function to call the `cli` function using
  `asyncio.run`.

Refactor the CLI entrypoint in `main.py` to improve code organization and readability.

* refactor: Update models.py to validate next_url as a valid URL

* refactor: Update signal handling in SignalHandler class

- Refactored the setup method in the SignalHandler class to set up signal handlers for SIGINT and
  SIGTERM asynchronously. - Replaced the use of sys.platform with direct calls to add_signal_handler
  to ensure compatibility across platforms. - Updated the handle_signal method to handle signals
  asynchronously. - Modified the _shutdown method to only set the stop_future result and cancel
  tasks if the stop_future is not already done. - Added an await statement before calling
  _cancel_tasks in the _shutdown method to ensure proper cancellation of tasks.

* fix: Update ChaturbateUtils class in utils.py to handle missing "wait" and "tries" details

* refactor: Remove AddCorrelationIDFilter class and update logging configurations

The AddCorrelationIDFilter class in logging_config.py was removed as it was no longer being used.
  Additionally, the logging configurations were updated to handle missing "wait" and "tries" details
  in the ChaturbateUtils class in utils.py. The signal handling in the SignalHandler class was also
  refactored. Lastly, the models.py file was updated to validate the next_url as a valid URL.

* refactor: Remove develop branch from CI workflow


## v0.13.11 (2024-10-31)

### Bug Fixes

- Update CD workflow to disable credential persistence
  ([`47286e0`](https://github.com/MountainGod2/chaturbate_poller/commit/47286e0dd792488f9238e1bb2b2e5e32749f218b))

### Chores

- Update chaturbate-poller version to 0.13.10
  ([`e5ea508`](https://github.com/MountainGod2/chaturbate_poller/commit/e5ea508ee4f2aa1b7c7714dd569ee81ad2ae4a7f))

### Refactoring

- Update CD workflow to force correct release branch on workflow sha
  ([`b9cdadb`](https://github.com/MountainGod2/chaturbate_poller/commit/b9cdadbad288cdd36c9a90403aef68e9d2b39592))

- Update Docker Build workflow to remove branch restriction for push event
  ([`9c08c2e`](https://github.com/MountainGod2/chaturbate_poller/commit/9c08c2e2fd667ae60682f24325fab8896fac7be7))


## v0.13.10 (2024-10-30)

### Bug Fixes

- Disable attestations in PyPI publishing workflows
  ([`4ac8195`](https://github.com/MountainGod2/chaturbate_poller/commit/4ac8195c4c5afff3c74835186f26dc3e9aec5fc6))

### Refactoring

- Update Docker Build workflow to remove branch restriction for push event
  ([`97ff9db`](https://github.com/MountainGod2/chaturbate_poller/commit/97ff9db9d73835f35601b835de937640e1ed4fd7))


## v0.13.9 (2024-10-30)

### Bug Fixes

- Remove unused exceptions in main.py
  ([`e2ccda4`](https://github.com/MountainGod2/chaturbate_poller/commit/e2ccda43539ad71ed1a29cf5152a6e98379d7d73))

### Chores

- Update pytest-cov to version 6.0.0
  ([`07eae75`](https://github.com/MountainGod2/chaturbate_poller/commit/07eae7547898aff2ed2b78c1a1b1aedd1890c549))

- **config**: Migrate config .github/renovate.json
  ([#76](https://github.com/MountainGod2/chaturbate_poller/pull/76),
  [`c1f5d98`](https://github.com/MountainGod2/chaturbate_poller/commit/c1f5d98e71b9c8035253160e76ee15a88e24a9b6))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update pypa/gh-action-pypi-publish action to v1.11.0
  ([#74](https://github.com/MountainGod2/chaturbate_poller/pull/74),
  [`951ca10`](https://github.com/MountainGod2/chaturbate_poller/commit/951ca10415acc4ef12edbc6b2607eceea35c5261))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Refactor Docker Build workflow to trigger on completion of Continuous Deployment workflow
  ([`60bf103`](https://github.com/MountainGod2/chaturbate_poller/commit/60bf1038a90beb15e38194f12f8c72c94c5f958a))

- Update CI workflow to include SonarCloud scan and remove redundant Codecov upload step
  ([`d4e3927`](https://github.com/MountainGod2/chaturbate_poller/commit/d4e392736d6b165091870405160ee2df460b38d1))

### Refactoring

- Remove branch restriction for push event in Docker Build workflow
  ([`7ded9d9`](https://github.com/MountainGod2/chaturbate_poller/commit/7ded9d9d2fd6fd33734a52a34945b1082240410e))

- Remove Codecov upload step from CI workflow
  ([`96ce44f`](https://github.com/MountainGod2/chaturbate_poller/commit/96ce44f2661cac7280385d3f1c7e404f1db73307))

- Update CodeQL workflow to trigger on completion of Continuous Integration workflow
  ([`33fa904`](https://github.com/MountainGod2/chaturbate_poller/commit/33fa904589c1869441068f32837a5c3bab749e25))

- Update Continuous Deployment workflow to trigger on completion of Continuous Integration workflow
  ([`422ea1e`](https://github.com/MountainGod2/chaturbate_poller/commit/422ea1edc61644461a1d14ec224638eeec79c666))


## v0.13.8 (2024-10-30)

### Bug Fixes

- Refactor CI/CD pipeline configuration to use DockerHub secrets
  ([`a46b653`](https://github.com/MountainGod2/chaturbate_poller/commit/a46b6537a3bf28e0ba394ff250e57f50680fca23))


## v0.13.7 (2024-10-30)

### Bug Fixes

- Remove unused concurrency group from CI/CD pipeline configuration
  ([`47004e4`](https://github.com/MountainGod2/chaturbate_poller/commit/47004e425914c60e424e069614cf24043747812b))

### Continuous Integration

- Add concurrency group to CI/CD pipeline configurations
  ([`3018eec`](https://github.com/MountainGod2/chaturbate_poller/commit/3018eec7a14c0701994ee99da2c9390290c2f919))

- Remove unused context from Docker CI/CD pipeline configuration
  ([`d3df17b`](https://github.com/MountainGod2/chaturbate_poller/commit/d3df17b88f458caf77f946588bea1182cff5d347))

- Remove unused context from Docker CI/CD pipeline configuration
  ([`0bb8012`](https://github.com/MountainGod2/chaturbate_poller/commit/0bb8012491b8e62045a32f4fdd8c6907125c0528))

- Update Docker CI/CD pipeline configuration
  ([`1473f6f`](https://github.com/MountainGod2/chaturbate_poller/commit/1473f6f0b97f05213e68dc063b5dbb736b284590))

- Update Docker CI/CD pipeline configuration
  ([`306f568`](https://github.com/MountainGod2/chaturbate_poller/commit/306f56810f6f9d776182fe02a12bed4220149904))

- Update Docker CI/CD pipeline configuration
  ([`2fab95c`](https://github.com/MountainGod2/chaturbate_poller/commit/2fab95c03449bbb4cb773e46e3795eb5ad64f651))

- Update Docker CI/CD pipeline configuration
  ([`85f5eef`](https://github.com/MountainGod2/chaturbate_poller/commit/85f5eef9151c06e93cf322e1473c28212227a396))

- Update Docker CI/CD pipeline configuration
  ([`d4e4efa`](https://github.com/MountainGod2/chaturbate_poller/commit/d4e4efabbd027063318924c479e261cf2a3b3c2b))

- Update Docker CI/CD pipeline configuration
  ([`949d227`](https://github.com/MountainGod2/chaturbate_poller/commit/949d2275dbfa4914c5ed51a0dfa280023d310d74))

- Update Docker CI/CD pipeline configuration to use DockerHub secrets
  ([`74d4b63`](https://github.com/MountainGod2/chaturbate_poller/commit/74d4b63269f5ad2badd911ff1c354b7ef1178fe6))


## v0.13.6 (2024-10-30)

### Bug Fixes

- Update Docker CI/CD pipeline configuration
  ([`b1419f2`](https://github.com/MountainGod2/chaturbate_poller/commit/b1419f272e82c30167c84df9da52d3c29d59c79b))

### Continuous Integration

- Update Docker CI/CD pipeline configuration
  ([`5e553da`](https://github.com/MountainGod2/chaturbate_poller/commit/5e553da472b3b123c1f924b8e14512981fec2f94))

- Update Docker CI/CD pipeline configuration
  ([`4df2ce5`](https://github.com/MountainGod2/chaturbate_poller/commit/4df2ce5094a02426455335ca9afb3470ccbba38c))


## v0.13.5 (2024-10-29)

### Bug Fixes

- Update Docker CI/CD pipeline configuration
  ([`d8f8261`](https://github.com/MountainGod2/chaturbate_poller/commit/d8f826107078c9821bdd98a0f6662051bf19e201))


## v0.13.4 (2024-10-29)

### Bug Fixes

- Update Docker CI/CD pipeline configuration
  ([`fe40025`](https://github.com/MountainGod2/chaturbate_poller/commit/fe40025a64d20f0e818d2aa1ec1460db1d1a9a1a))


## v0.13.3 (2024-10-29)

### Bug Fixes

- Update docker-build.yml
  ([`d2e312b`](https://github.com/MountainGod2/chaturbate_poller/commit/d2e312bea3a2145931d116ee2fba8a9234219baa))


## v0.13.2 (2024-10-29)

### Bug Fixes

- Update CI/CD pipeline configuration and Docker image metadata
  ([`8847b3b`](https://github.com/MountainGod2/chaturbate_poller/commit/8847b3bb88863b6792c795423eab3bf29c4d4b14))

- Update CI/CD pipeline configuration and Docker image metadata
  ([`1b80928`](https://github.com/MountainGod2/chaturbate_poller/commit/1b8092869f66d74624ba5a15eb1d37b7a473e461))


## v0.13.1 (2024-10-29)

### Bug Fixes

- Add recommended VS Code extensions
  ([`5b5ae13`](https://github.com/MountainGod2/chaturbate_poller/commit/5b5ae13c37056472d5f4959f939306fa6f5cc7ea))


## v0.13.0 (2024-10-29)

### Features

- Add recommended VS Code extensions
  ([`e39c0c3`](https://github.com/MountainGod2/chaturbate_poller/commit/e39c0c39ecbf7beeb602957b7c6938e34404fa8e))

### Refactoring

- Update CI/CD pipeline configuration and Docker image metadata
  ([`25a28ef`](https://github.com/MountainGod2/chaturbate_poller/commit/25a28efb7c32199885feb9f40aa76ab4e5acea37))

- Update CI/CD pipeline configuration and Docker image metadata
  ([`4095f65`](https://github.com/MountainGod2/chaturbate_poller/commit/4095f65a4f0d6afe651c4a1b32bcd2b489925edd))

- Update CI/CD pipeline configuration and Docker image metadata
  ([`cb11d36`](https://github.com/MountainGod2/chaturbate_poller/commit/cb11d36253511155794b9500c9c3b20edc85fb52))


## v0.12.6 (2024-10-29)

### Bug Fixes

- Update CI/CD pipeline configuration and add pytest to the build step
  ([`8ab8461`](https://github.com/MountainGod2/chaturbate_poller/commit/8ab84619838704b562e706d0247e5e452d02691a))

### Chores

- Remove dependabot configuration file
  ([`ecbdb7b`](https://github.com/MountainGod2/chaturbate_poller/commit/ecbdb7bab183ac0616e96747c3bff37cffe54410))

- Update pylint configuration
  ([`9d96b17`](https://github.com/MountainGod2/chaturbate_poller/commit/9d96b178aee512539f190dd4400836294a379b4b))

- Update timezone in renovate.json
  ([`244aa49`](https://github.com/MountainGod2/chaturbate_poller/commit/244aa49cc9defd3b05968236ccf755cc4cb7eb06))

- **deps**: Lock file maintenance ([#73](https://github.com/MountainGod2/chaturbate_poller/pull/73),
  [`4d0fef5`](https://github.com/MountainGod2/chaturbate_poller/commit/4d0fef540bb8cc6d21be895c4669ee9b02ba068f))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Update CI/CD pipeline configuration
  ([`1b8ebae`](https://github.com/MountainGod2/chaturbate_poller/commit/1b8ebae829390e4f5291e7de8d89823ca76f62af))

### Refactoring

- Add EventHandler import and add type hints
  ([`0bdbcdd`](https://github.com/MountainGod2/chaturbate_poller/commit/0bdbcdd6770d62efdbb7d45f77a104c78b78875a))

- Update CI/CD pipeline configuration
  ([`3682e54`](https://github.com/MountainGod2/chaturbate_poller/commit/3682e54e38566ad64d84e6c0d3abc7218fa36c67))

- Update CI/CD pipeline configuration and add commit SHA to Docker image metadata
  ([`bd8ae46`](https://github.com/MountainGod2/chaturbate_poller/commit/bd8ae46135a65df6001434afc44360fde8fdc673))

- Update CI/CD pipeline configuration and add platform matrix
  ([`e35e4c3`](https://github.com/MountainGod2/chaturbate_poller/commit/e35e4c3ee8542c583bbf89fe7ef17564c53f8280))

- Update CI/CD pipeline configuration and add platform matrix
  ([`b363808`](https://github.com/MountainGod2/chaturbate_poller/commit/b363808e236ebf99dc18ee6a65f57050122997d2))

- Update CI/CD pipeline configuration and add SonarCloud scan step
  ([`00e9975`](https://github.com/MountainGod2/chaturbate_poller/commit/00e9975eb23f4ea99b980f668180ec0040dad53a))

- Update CI/CD pipeline configuration and Docker image metadata
  ([`724f83d`](https://github.com/MountainGod2/chaturbate_poller/commit/724f83d279cf205e38758335b265553bc245fb22))

- Update CI/CD pipeline configuration and Docker image metadata
  ([`7f26324`](https://github.com/MountainGod2/chaturbate_poller/commit/7f26324fddc43ed6cc284fca8a50106e92dbc668))

- Update CI/CD pipeline configuration, add platform matrix, and generate Docker image metadata
  ([`da6c1b8`](https://github.com/MountainGod2/chaturbate_poller/commit/da6c1b8ef9bba16127e333046cfdf74d761beb4b))

- Update CI/CD pipeline configuration, add platform matrix, and generate Docker image metadata
  ([`4510336`](https://github.com/MountainGod2/chaturbate_poller/commit/45103368d7b8d152c1f77759e3a06038373215bd))

- Update CodeQL workflow configuration
  ([`2056371`](https://github.com/MountainGod2/chaturbate_poller/commit/2056371b290d03ba3415f9780fa5a6f473c76970))


## v0.12.5 (2024-10-27)

### Bug Fixes

- Update renovate.json configuration
  ([`5d9364f`](https://github.com/MountainGod2/chaturbate_poller/commit/5d9364fea99fa1e8d20b97c21a734ff916752a2c))

### Build System

- Update CI/CD/Build Pipeline configuration
  ([`75942e4`](https://github.com/MountainGod2/chaturbate_poller/commit/75942e4a931df2ba27c9c452879d1aa2187d2210))

### Chores

- Update chaturbate-poller version to 0.12.4
  ([`e92bf51`](https://github.com/MountainGod2/chaturbate_poller/commit/e92bf51dca1212321f7e0975b97a1adef278a910))

- **deps**: Lock file maintenance ([#72](https://github.com/MountainGod2/chaturbate_poller/pull/72),
  [`04e6bae`](https://github.com/MountainGod2/chaturbate_poller/commit/04e6bae280810b5ec412a284045e8da9894d5b7e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>


## v0.12.4 (2024-10-27)

### Bug Fixes

- Update chaturbate-poller version to 0.12.3
  ([`4e9dfe1`](https://github.com/MountainGod2/chaturbate_poller/commit/4e9dfe1c0d3163654f2032963905e323c7403db0))

### Build System

- Enable pushing Docker image in ci-cd-build.yml
  ([`69a08dc`](https://github.com/MountainGod2/chaturbate_poller/commit/69a08dc53dd28fd1c2c3919f32881e861bed2c4d))


## v0.12.3 (2024-10-27)

### Bug Fixes

- Update chaturbate-poller version to 0.12.2
  ([`3c3f0f8`](https://github.com/MountainGod2/chaturbate_poller/commit/3c3f0f8eae9646236428c3cf35e7ad08de7a48ee))

### Refactoring

- Update dependencies in ci-cd-build.yml
  ([`26f265d`](https://github.com/MountainGod2/chaturbate_poller/commit/26f265d73dc2ba3b7ab5213947dda8e73eaa2f49))


## v0.12.2 (2024-10-27)

### Bug Fixes

- Update CI/CD pipeline configuration
  ([`1554c6c`](https://github.com/MountainGod2/chaturbate_poller/commit/1554c6c6014218be12099e19e68890a774ae9445))

Simplify the name of the CI/CD pipeline from "CI/CD/Build Pipeline" to "CI/CD Pipeline" for clarity
  and consistency. Also, update the Python versions in the ci-cd.yml file to use Python 3.11.
  Additionally, modify the installation process to upgrade pip and install the project dependencies
  from the requirements.txt file. These changes aim to improve the continuous integration and
  deployment process.

### Chores

- Update chaturbate-poller version to 0.12.1
  ([`0608144`](https://github.com/MountainGod2/chaturbate_poller/commit/0608144065cb52f34e905f87e273eec90008e33f))

- Update pre-commit hooks and ruff version
  ([`22adc4b`](https://github.com/MountainGod2/chaturbate_poller/commit/22adc4b47a4a9172168dae3465c1ad459b3a4b21))

### Continuous Integration

- Remove unnecessary pip install command in ci-cd.yml
  ([`4c3d4aa`](https://github.com/MountainGod2/chaturbate_poller/commit/4c3d4aad547180632c0e79a9e7df0c2ad4d4d836))

- Update ci-cd.yml for continuous deployment improvements
  ([`a5587ea`](https://github.com/MountainGod2/chaturbate_poller/commit/a5587ea944ec0388ec50db3298298ac2cf91c598))

### Refactoring

- Simplify dependency installation in ci-cd.yml
  ([`37d7a2e`](https://github.com/MountainGod2/chaturbate_poller/commit/37d7a2e5347042f3afa6406eea24d7f3d9ce33e7))

- Simplify dependency installation in ci-cd.yml
  ([`a302290`](https://github.com/MountainGod2/chaturbate_poller/commit/a302290a96d3671671f08e08e9ff0289f64e637b))

- Update Python versions in ci-cd.yml
  ([`e281274`](https://github.com/MountainGod2/chaturbate_poller/commit/e281274abb7ceec0571a0962c28eca7df1de2c3a))


## v0.12.1 (2024-10-27)

### Bug Fixes

- Update Sphinx documentation configuration
  ([`706c9e4`](https://github.com/MountainGod2/chaturbate_poller/commit/706c9e495a4cd7cc4ccdb9cd781e50e8eff03730))

### Chores

- Add Renovate configuration file for dependency updates
  ([`f1779b8`](https://github.com/MountainGod2/chaturbate_poller/commit/f1779b881d3d8dd2590bd700f65b7059be4b92d4))

- Fix Renovate action path
  ([`53e470f`](https://github.com/MountainGod2/chaturbate_poller/commit/53e470f110f6fe23a7f93ef0ef46707792620c20))

- Remove orjson dependency from requirements.txt and pyproject.toml
  ([`8c4ddda`](https://github.com/MountainGod2/chaturbate_poller/commit/8c4dddabc7c1fbe70efd1b82d786c378534673d3))

- Update pydantic-core version to 2.23.4 in requirements.txt
  ([#55](https://github.com/MountainGod2/chaturbate_poller/pull/55),
  [`686981f`](https://github.com/MountainGod2/chaturbate_poller/commit/686981f2c1e129539315d0ea72a9d8535f03c036))

* chore: update pydantic-core version to 2.23.4 in requirements.txt

* chore: update chaturbate-poller version to 0.12.0 in uv.lock

* chore: update Renovate schedule to run every day

* chore: update Renovate schedule to run every hour

- Update renovate action and token handling in renovate.yml
  ([`0238e88`](https://github.com/MountainGod2/chaturbate_poller/commit/0238e8808ca72b8e285233b8597d067c63d2a12c))

- Update rich library and enable traceback for better error handling
  ([`9584596`](https://github.com/MountainGod2/chaturbate_poller/commit/95845966b5621e3aae8e4787203a22cb32b94692))

- **deps**: Add hatchling dependency to pyproject.toml and uv.lock
  ([`37bb0a3`](https://github.com/MountainGod2/chaturbate_poller/commit/37bb0a3e5c32f0b5c183b0080a87fcba7018823d))

- **deps**: Lock file maintenance ([#62](https://github.com/MountainGod2/chaturbate_poller/pull/62),
  [`0fe72b1`](https://github.com/MountainGod2/chaturbate_poller/commit/0fe72b16262543a2837c09b3c5782bb3191e93c7))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance ([#64](https://github.com/MountainGod2/chaturbate_poller/pull/64),
  [`03fe1b0`](https://github.com/MountainGod2/chaturbate_poller/commit/03fe1b07238f605837b716efe997fe711d0b06e1))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Lock file maintenance ([#69](https://github.com/MountainGod2/chaturbate_poller/pull/69),
  [`3141bbb`](https://github.com/MountainGod2/chaturbate_poller/commit/3141bbbe65c3a2e1fcc3e201fb9d214a7322c916))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update astral-sh/setup-uv action to v3.2.0
  ([#63](https://github.com/MountainGod2/chaturbate_poller/pull/63),
  [`04baf00`](https://github.com/MountainGod2/chaturbate_poller/commit/04baf00f77197d0075142695a2d2576330e91c0a))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency influxdb-client to v1.47.0
  ([#58](https://github.com/MountainGod2/chaturbate_poller/pull/58),
  [`ff43d7f`](https://github.com/MountainGod2/chaturbate_poller/commit/ff43d7f46cf099a21dedf2a1835787f7ef0e124c))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency pydantic-core to v2.25.0
  ([#59](https://github.com/MountainGod2/chaturbate_poller/pull/59),
  [`4107df6`](https://github.com/MountainGod2/chaturbate_poller/commit/4107df6cb862e305a8b53a09e5a072926c9616a8))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency rich to v13.9.3
  ([#57](https://github.com/MountainGod2/chaturbate_poller/pull/57),
  [`7e301da`](https://github.com/MountainGod2/chaturbate_poller/commit/7e301dad13d46b068928275f8b8016eeb3a23bd2))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dependency sphinx-autoapi to v3.3.3
  ([#68](https://github.com/MountainGod2/chaturbate_poller/pull/68),
  [`9829b76`](https://github.com/MountainGod2/chaturbate_poller/commit/9829b76384c1766e4e2fa3b05d5f4002995c936e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

- **deps**: Update dev dependencies in uv.lock
  ([`a4477e0`](https://github.com/MountainGod2/chaturbate_poller/commit/a4477e02d4f849eb564d38785a5b8c58deeb10cd))

- **deps**: Update python docker tag to v3.13
  ([#60](https://github.com/MountainGod2/chaturbate_poller/pull/60),
  [`7d3e382`](https://github.com/MountainGod2/chaturbate_poller/commit/7d3e38243b5668f786f846fa7ec571d07309729e))

Co-authored-by: renovate[bot] <29139614+renovate[bot]@users.noreply.github.com>

### Continuous Integration

- Remove Renovate configuration files and workflow
  ([`87baf0f`](https://github.com/MountainGod2/chaturbate_poller/commit/87baf0f1d0915f417b0127137c1aea4c909cb187))

- Update ci-cd.yml for continuous deployment improvements
  ([`3f1596f`](https://github.com/MountainGod2/chaturbate_poller/commit/3f1596fe8aa2bc7038ef43eb66d447326ad3fabc))

- Update renovate.json to include automerge
  ([`c580187`](https://github.com/MountainGod2/chaturbate_poller/commit/c580187d74176cfb74af8d155b8b53a623b24fa0))

### Documentation

- Add documentation requirements
  ([`c593347`](https://github.com/MountainGod2/chaturbate_poller/commit/c59334758d18a4d719f1dbaa86e73f0671dd59e4))

Added myst-nb, sphinx-autoapi, and sphinx-rtd-theme to the requirements.txt file in the docs
  directory.

### Refactoring

- Remove unused import in logging_config.py
  ([`df14863`](https://github.com/MountainGod2/chaturbate_poller/commit/df14863feda4790b70a7992c9fb9c80a8272fff0))

- Remove unused import in test_logging_configurations.py
  ([`8bdaa7b`](https://github.com/MountainGod2/chaturbate_poller/commit/8bdaa7b5a55b89028b6d9a6dc191bc3349bafa4a))

- Update .github/renovate.json to remove unnecessary matchFileNames
  ([`4a9bca5`](https://github.com/MountainGod2/chaturbate_poller/commit/4a9bca5d9bbce131f46203e3d272a7d15fa8195f))

- Update ChaturbateClient usage in example.ipynb
  ([`7438f82`](https://github.com/MountainGod2/chaturbate_poller/commit/7438f82dc0e78272e1e19e02fdffd7e9d0947757))

- Update dependencies in pyproject.toml and uv.lock
  ([`110249e`](https://github.com/MountainGod2/chaturbate_poller/commit/110249e118a4bd308a47fb16c5ffafba07c1592f))

- Update dependencies in pyproject.toml and uv.lock
  ([`5591e79`](https://github.com/MountainGod2/chaturbate_poller/commit/5591e790cd6acc5be43dda27247526d639e95299))

- Update dependency groups in pyproject.toml
  ([`cd505c6`](https://github.com/MountainGod2/chaturbate_poller/commit/cd505c61a4c6f2de0d0c2c18dc2497c28f124bbb))

- Update dev dependencies handling in pyproject.toml
  ([`5144ef0`](https://github.com/MountainGod2/chaturbate_poller/commit/5144ef0b8d8bec5c72ffc5d6b874ed88cd971f81))

- Update Docker image metadata generation in ci-cd.yml
  ([`d5db182`](https://github.com/MountainGod2/chaturbate_poller/commit/d5db182a1875b23cfb0c3eca3687c51439087b94))

- Update documentation dependency handling
  ([`37e8d6c`](https://github.com/MountainGod2/chaturbate_poller/commit/37e8d6c19c1cd32183c07e0b27b51e90a6b2f55c))

- Update linting configuration for documentation files
  ([`02bf428`](https://github.com/MountainGod2/chaturbate_poller/commit/02bf428f40ac322a6018fbf9cb9687f4855cdaa7))

- Update logging configuration in chaturbate_poller module
  ([`48001eb`](https://github.com/MountainGod2/chaturbate_poller/commit/48001ebefc7f49249228846cc083b73034c232f5))

- Update renovate.json to include docs/requirements.txt in Python dependencies group
  ([`5e9e9de`](https://github.com/MountainGod2/chaturbate_poller/commit/5e9e9dea258f7d3804e9aa52aa98b3c943b10aef))

- Update uv pip commands in Dockerfile
  ([`0526cf8`](https://github.com/MountainGod2/chaturbate_poller/commit/0526cf8e4910c9e84345ae078c2cfbade9bb5a3a))

- Update uv pip commands in Dockerfile
  ([`d291b00`](https://github.com/MountainGod2/chaturbate_poller/commit/d291b0045c0676a9af91d5c9f33ce47906defd52))

### Testing

- Update logging configuration in test_logging_configurations.py
  ([`b3aeef9`](https://github.com/MountainGod2/chaturbate_poller/commit/b3aeef9ee906ae14e7d00f90be87f222bcefa730))


## v0.12.0 (2024-10-24)

### Build System

- Add multi-platform build support in ci-cd-build.yml
  ([`a5238e6`](https://github.com/MountainGod2/chaturbate_poller/commit/a5238e6d08a51c444b26635b77796e876025fefc))

### Chores

- Update chaturbate-poller version to 0.11.7
  ([`556cedd`](https://github.com/MountainGod2/chaturbate_poller/commit/556cedda34618a7693068d4a88dd728f5016aaf3))

### Continuous Integration

- Add documentation upload step in ci-cd-build.yml
  ([`4ceff49`](https://github.com/MountainGod2/chaturbate_poller/commit/4ceff497d2d57d0f045d90c8b8f4e2d980148e3b))

### Features

- Add Renovate configuration files and workflow
  ([#54](https://github.com/MountainGod2/chaturbate_poller/pull/54),
  [`4cb5a93`](https://github.com/MountainGod2/chaturbate_poller/commit/4cb5a932f1bf22452f42f58422d40170de0465b5))

* feat: add Renovate configuration files and workflow

Add `.github/renovate-config.json` and `.github/renovate.yml` files to configure Renovate for
  automated dependency updates. The `renovate-config.json` file specifies the schedule for updating
  Python and Docker dependencies, while the `renovate.yml` file sets up a GitHub Actions workflow
  for running Renovate.

* fix: update Renovate configuration file path in .github/renovate.yml

### Refactoring

- Correct import order in test_miscellaneous.py
  ([`986741f`](https://github.com/MountainGod2/chaturbate_poller/commit/986741f662d43a95cfead757b4c47e18b11cb44d))

- Update dependencies for workflows in ci-cd-build.yml
  ([`7104421`](https://github.com/MountainGod2/chaturbate_poller/commit/7104421205a18401cf0c1e5b9677a9b02dd5f1ad))

- Update multi-platform build support in ci-cd-build.yml
  ([`f81b2c6`](https://github.com/MountainGod2/chaturbate_poller/commit/f81b2c6cd5cad13cadec00c6931d2751d0f98801))


## v0.11.7 (2024-10-24)

### Bug Fixes

- Add error handling for HTTPStatusError and TimeoutException in ChaturbateClient
  ([`849d6e0`](https://github.com/MountainGod2/chaturbate_poller/commit/849d6e02ad416b3eb1280e8736940864b98e46d7))

### Build System

- **deps**: Bump pydantic-core from 2.24.1 to 2.24.2
  ([#53](https://github.com/MountainGod2/chaturbate_poller/pull/53),
  [`3a14747`](https://github.com/MountainGod2/chaturbate_poller/commit/3a14747b04ccd9f0f2a7e10ace6941e40893cf02))

Bumps [pydantic-core](https://github.com/pydantic/pydantic-core) from 2.24.1 to 2.24.2. - [Release
  notes](https://github.com/pydantic/pydantic-core/releases) -
  [Commits](https://github.com/pydantic/pydantic-core/compare/v2.24.1...v2.24.2)

--- updated-dependencies: - dependency-name: pydantic-core dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump setuptools from 75.1.0 to 75.2.0
  ([#52](https://github.com/MountainGod2/chaturbate_poller/pull/52),
  [`97ac405`](https://github.com/MountainGod2/chaturbate_poller/commit/97ac405df91bf6e6e9e0c3b531ee24f79540cfbb))

Bumps [setuptools](https://github.com/pypa/setuptools) from 75.1.0 to 75.2.0. - [Release
  notes](https://github.com/pypa/setuptools/releases) -
  [Changelog](https://github.com/pypa/setuptools/blob/main/NEWS.rst) -
  [Commits](https://github.com/pypa/setuptools/compare/v75.1.0...v75.2.0)

--- updated-dependencies: - dependency-name: setuptools dependency-type: direct:production

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

### Chores

- Fix whitespace in logging_config.py
  ([`406ffc2`](https://github.com/MountainGod2/chaturbate_poller/commit/406ffc24afbc1ff6cdd2aaa5297e933999f2e477))

- Update chaturbate-poller version to 0.11.6 in uv.lock
  ([`aef6c80`](https://github.com/MountainGod2/chaturbate_poller/commit/aef6c80d2f1bf8af5aad838011c3de015ecbb225))

- Update dependencies in requirements.txt
  ([`90c3ae3`](https://github.com/MountainGod2/chaturbate_poller/commit/90c3ae3441717ee323cd3de0a9f77feb895bbea0))

### Documentation

- Update docstrings throughout program modules
  ([`cf5f866`](https://github.com/MountainGod2/chaturbate_poller/commit/cf5f866d3021e289cf7d16aff6bd2a429f27e9cf))

- Update README.md
  ([`819ac6e`](https://github.com/MountainGod2/chaturbate_poller/commit/819ac6e5e7c3c387d7443599956676b7dd968f21))

- Update README.md
  ([`87692de`](https://github.com/MountainGod2/chaturbate_poller/commit/87692de90379bfa35683659b346bd1322a6947a8))

### Refactoring

- Add logging for HTTPStatusError in ChaturbateClient and ChaturbateUtils
  ([`bcb0349`](https://github.com/MountainGod2/chaturbate_poller/commit/bcb03496f2d1305ee2f07902edfc2cbf8ef71342))

- Add logging for HTTPStatusError in ChaturbateUtils
  ([`7eb00f6`](https://github.com/MountainGod2/chaturbate_poller/commit/7eb00f6553ef423a13ab0ad5f98b40dfa76eaa3d))

- Add logging for PollingError in main.py
  ([`409a096`](https://github.com/MountainGod2/chaturbate_poller/commit/409a096d7ddd7370506d2e234a3b64414f31fda4))

- Add test for setup create directory in logging_configurations.py
  ([`1cf3e60`](https://github.com/MountainGod2/chaturbate_poller/commit/1cf3e60ffa447a1d364360e3ba93f61d57b7b05d))

- Fix error handling in test_event_fetching.py and test_miscellaneous.py
  ([`e0a9cf8`](https://github.com/MountainGod2/chaturbate_poller/commit/e0a9cf85d5e900a3bae649da8807709c0eacd760))

- Improve docstrings and typing
  ([`62d49fe`](https://github.com/MountainGod2/chaturbate_poller/commit/62d49fe1e16c0e2488565a37ddc1680c05440a23))

- Improve docstrings and typing
  ([`a5b8482`](https://github.com/MountainGod2/chaturbate_poller/commit/a5b8482b3cb992ad22ab425f35fef1f6e77bc377))

- Update logging level in main.py
  ([`02e7282`](https://github.com/MountainGod2/chaturbate_poller/commit/02e728292e8cbafdf5c385966adbf0b32e76d242))

Adjust the check in the main.py file to ensure debug logging is enabled when the verbose flag is
  set.

- Update logging message in ChaturbateUtils
  ([`4696954`](https://github.com/MountainGod2/chaturbate_poller/commit/4696954377b2802018b609db53fa427b906493c2))

- Update logging message in ChaturbateUtils
  ([`bc56c65`](https://github.com/MountainGod2/chaturbate_poller/commit/bc56c659fdf6808a4bdab9c9b623195bb1b0318a))

- Update README.md
  ([`b09e83f`](https://github.com/MountainGod2/chaturbate_poller/commit/b09e83fd7f80320fd9832007f3d24f07d24af2be))


## v0.11.6 (2024-10-19)

### Bug Fixes

- Update logging configuration and ensure log directory exists
  ([`4f9911a`](https://github.com/MountainGod2/chaturbate_poller/commit/4f9911aff70b55a5ed64a7f93dc8ddcc5c54f2fc))

### Chores

- Remove unused examples/__init__.py file
  ([`5f9ca49`](https://github.com/MountainGod2/chaturbate_poller/commit/5f9ca49f0b2563f4d62a3878ad3c86859a2ea116))

- Update chaturbate-poller version to 0.11.5 in uv.lock
  ([`e6dc24d`](https://github.com/MountainGod2/chaturbate_poller/commit/e6dc24d53dd00d895e76df65ede73f45bcc6bad4))

- Update dependencies in pyproject.toml and uv.lock
  ([`2cd21b3`](https://github.com/MountainGod2/chaturbate_poller/commit/2cd21b3950aef205dd0cfdc68d92071cf13b65b2))

### Refactoring

- Simplify logging format in logging_config.py
  ([`a6b59e4`](https://github.com/MountainGod2/chaturbate_poller/commit/a6b59e43ff8ecfbca45274289c566cad9faa1555))

- Update ChaturbateUtils backoff and giveup handlers
  ([`6b1420f`](https://github.com/MountainGod2/chaturbate_poller/commit/6b1420f7d8fb125b6b3f8e6242ebb07a58eb1b73))

- Simplify the ChaturbateUtils class by converting the backoff_handler and giveup_handler methods to
  static methods

- Update event handling in ChaturbateClient
  ([`be56b30`](https://github.com/MountainGod2/chaturbate_poller/commit/be56b3067f9d4dbc4a05cc12d2ea1fa1e607e5ed))

- Update event handling in examples
  ([`566b8d3`](https://github.com/MountainGod2/chaturbate_poller/commit/566b8d34f7b7361d10c855fa5250c848cc7d61f7))

- Refactor event handling in the `event_handler_large_tips.py` and `formatted_event_messages.py`
  examples to improve code readability and maintainability. - Remove unused imports and logging
  statements. - Update code comments for better understanding.

- Update event handling in test_event_fetching.py
  ([`626e80a`](https://github.com/MountainGod2/chaturbate_poller/commit/626e80afecf83255e8f550d3090ffa90c72c7cb6))

- Updated the event handling in the test_event_fetching.py file to improve code readability and
  maintainability.

- Update HttpStatusCode enumeration in constants.py
  ([`4d3a5ee`](https://github.com/MountainGod2/chaturbate_poller/commit/4d3a5ee2f7ee09417948c35f55c16677aca98b6e))

- Update logging configuration and add correlation ID
  ([`ce8c44f`](https://github.com/MountainGod2/chaturbate_poller/commit/ce8c44feb46c15f85bc35a434a9f8115d4be0d86))

- Update the logging configuration in `logging_config.py` to include a custom JSON formatter and a
  filter to sanitize sensitive data. - Add a new filter to add a correlation ID to log records. -
  Modify the `CustomFormatter` to include the correlation ID in the log format. - Add a new function
  `setup_logging()` to set up the logging configuration.

- Update logging configuration, add correlation ID, and handle exceptions in ChaturbateClient
  ([`31e888f`](https://github.com/MountainGod2/chaturbate_poller/commit/31e888fb3ea4bfa9c7964c3fc06175c537d601a5))

- Update main.py to handle signal interruptions gracefully
  ([`ec2661f`](https://github.com/MountainGod2/chaturbate_poller/commit/ec2661f7668053442fa6ae18dbd27272fda39da6))

- Update PollingError and add new exceptions
  ([`fcd5849`](https://github.com/MountainGod2/chaturbate_poller/commit/fcd58492164f9ef47c0972cf02f1b96719724f5f))

- Update the base exception PollingError to have a more descriptive docstring. - Add new exceptions
  AuthenticationError and NotFoundError with default error messages.


## v0.11.5 (2024-10-17)

### Bug Fixes

- Update next_url field validation in EventsAPIResponse model
  ([`8d706f4`](https://github.com/MountainGod2/chaturbate_poller/commit/8d706f4322778c24caa7fd7cbe132b871d165267))

### Build System

- Refactor Dockerfile to use --no-cache-dir flag when installing uv package
  ([`e6f1f7e`](https://github.com/MountainGod2/chaturbate_poller/commit/e6f1f7e68a221b9c72cffe14d357798ad59883f3))

### Chores

- Update chaturbate-poller version to 0.11.4 in uv.lock
  ([`7fa6248`](https://github.com/MountainGod2/chaturbate_poller/commit/7fa62485742e1d2a40043a6c8d91616214f59c49))

- Update copyright year in LICENSE file
  ([`0dbcd2b`](https://github.com/MountainGod2/chaturbate_poller/commit/0dbcd2b9ca9f95990f7f53bc5923ced644ddff08))

### Testing

- Added EventsAPIResponse next_url validation checks
  ([`402702f`](https://github.com/MountainGod2/chaturbate_poller/commit/402702f296ad5b251fecc2866c3e6a2aee4a8162))


## v0.11.4 (2024-10-17)

### Bug Fixes

- Refactor Python version requirement to >= 3.11 and update depend…
  ([#51](https://github.com/MountainGod2/chaturbate_poller/pull/51),
  [`10c813e`](https://github.com/MountainGod2/chaturbate_poller/commit/10c813e0736df9a21f32fddde2463a9c3a6152f3))

* fix: refactor Python version requirement to >= 3.11 and update dependencies in pyproject.toml

* refactor: update Dockerfile to include LICENSE file


## v0.11.3 (2024-10-16)

### Bug Fixes

- Refactor Python version requirement to >= 3.11 and update dependencies in pyproject.toml
  ([`ac459fd`](https://github.com/MountainGod2/chaturbate_poller/commit/ac459fd351c8163e42092bc3286dd0c5b9806767))

### Build System

- Refactor Dockerfile for improved build process and reduced image size
  ([`2f63791`](https://github.com/MountainGod2/chaturbate_poller/commit/2f63791c79f55a1e2688f20d17fb37c577416df0))

- **deps**: Bump anyio from 4.6.0 to 4.6.2.post1
  ([#50](https://github.com/MountainGod2/chaturbate_poller/pull/50),
  [`4197daa`](https://github.com/MountainGod2/chaturbate_poller/commit/4197daad3e65966d6b90279726f5d4507ac50f63))

Bumps [anyio](https://github.com/agronholm/anyio) from 4.6.0 to 4.6.2.post1. - [Release
  notes](https://github.com/agronholm/anyio/releases) -
  [Changelog](https://github.com/agronholm/anyio/blob/master/docs/versionhistory.rst) -
  [Commits](https://github.com/agronholm/anyio/compare/4.6.0...4.6.2.post1)

--- updated-dependencies: - dependency-name: anyio dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

- **deps**: Bump pydantic-core from 2.23.4 to 2.24.1
  ([#48](https://github.com/MountainGod2/chaturbate_poller/pull/48),
  [`bdf5a56`](https://github.com/MountainGod2/chaturbate_poller/commit/bdf5a56981cd5519da2c07700c778d40303bf6dd))

Bumps [pydantic-core](https://github.com/pydantic/pydantic-core) from 2.23.4 to 2.24.1. - [Release
  notes](https://github.com/pydantic/pydantic-core/releases) -
  [Commits](https://github.com/pydantic/pydantic-core/compare/v2.23.4...v2.24.1)

--- updated-dependencies: - dependency-name: pydantic-core dependency-type: direct:production

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump sphinx-rtd-theme from 3.0.0 to 3.0.1
  ([#49](https://github.com/MountainGod2/chaturbate_poller/pull/49),
  [`dedb7f8`](https://github.com/MountainGod2/chaturbate_poller/commit/dedb7f85a5faba2e052df76be75eddfbf28832bc))

Bumps [sphinx-rtd-theme](https://github.com/readthedocs/sphinx_rtd_theme) from 3.0.0 to 3.0.1. -
  [Changelog](https://github.com/readthedocs/sphinx_rtd_theme/blob/master/docs/changelog.rst) -
  [Commits](https://github.com/readthedocs/sphinx_rtd_theme/compare/3.0.0...3.0.1)

--- updated-dependencies: - dependency-name: sphinx-rtd-theme dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

### Refactoring

- Update Python version requirement to >=3.11
  ([`f85d944`](https://github.com/MountainGod2/chaturbate_poller/commit/f85d944d1833a2e99b0391cfa0d8f465ac062e03))


## v0.11.2 (2024-10-12)

### Bug Fixes

- Refactor Dockerfile to optimize file copying and installation process
  ([`97ee293`](https://github.com/MountainGod2/chaturbate_poller/commit/97ee2931608c1059448a12f3027061fbbd9e2493))

### Refactoring

- Update click import to use rich_click
  ([`f92801d`](https://github.com/MountainGod2/chaturbate_poller/commit/f92801d7d13cecf201925fffbfda5829d627c828))

- Update logging configuration to ensure log directory exists
  ([`bb967f4`](https://github.com/MountainGod2/chaturbate_poller/commit/bb967f4024281d5a20a981407168b0182751f4bf))

- Update Python version requirement to >=3.10
  ([`49a4b6f`](https://github.com/MountainGod2/chaturbate_poller/commit/49a4b6f13e7a782fa4e6bf7cf8bcb814460040e8))

- Update Python version requirement to >=3.10
  ([`0a6eba1`](https://github.com/MountainGod2/chaturbate_poller/commit/0a6eba1c788004e245b07b22ec55a08fd2bf4a6b))

- Update Python version requirement to >=3.11
  ([`d5665cc`](https://github.com/MountainGod2/chaturbate_poller/commit/d5665cc7d5e68f54b915c62cff948e06bf8c3515))

### Testing

- Refactor test_backoff_handlers.py to use numeric HTTP status codes instead of HttpStatusCode enum
  ([`834ad93`](https://github.com/MountainGod2/chaturbate_poller/commit/834ad9379e7d5c744c2715ff40dafcfe1784d5a3))


## v0.11.1 (2024-10-12)

### Bug Fixes

- Refactor import statements in chaturbate_client.py and event_handler.py
  ([`e6a7111`](https://github.com/MountainGod2/chaturbate_poller/commit/e6a71116d3f58c2dd3a6f3f71b3514edb657ef7c))

### Chores

- Update .gitignore file
  ([`9ca6fa4`](https://github.com/MountainGod2/chaturbate_poller/commit/9ca6fa428d89d6c2a08b5b1186a574fea07a6bbb))

- Update chaturbate-poller version to 0.11.0
  ([`7c5334a`](https://github.com/MountainGod2/chaturbate_poller/commit/7c5334a1ffa5a07f1d9e65becfc2884c15fcb403))

### Refactoring

- Update HttpStatusCode enum in constants.py
  ([`93fee7e`](https://github.com/MountainGod2/chaturbate_poller/commit/93fee7eef1fd5db84db6658216a3fe6f761c6b59))

Update the HttpStatusCode enum in constants.py to include additional HTTP status codes and provide
  clear attribute descriptions.

- Update import statements in tests
  ([`d4d86d8`](https://github.com/MountainGod2/chaturbate_poller/commit/d4d86d8656f4fa0ca1f8f48400307df008829053))

### Testing

- Update tests and add HttpStatusCode enum to test_backoff_handlers.py
  ([`a3712d7`](https://github.com/MountainGod2/chaturbate_poller/commit/a3712d734349dffc6550a913dd59ff4f54f744e9))


## v0.11.0 (2024-10-11)

### Bug Fixes

- Handle server errors and raise RetryError
  ([`1dca0b0`](https://github.com/MountainGod2/chaturbate_poller/commit/1dca0b0c1041225b2b8351cd1033a1fdb043d300))

When a server error occurs, a RetryError is raised with the message "Giving up after server error".
  This ensures that the request is retried when encountering server errors.

### Chores

- Add rich and rich-click dependencies in pyproject.toml and uv.lock
  ([`55216c5`](https://github.com/MountainGod2/chaturbate_poller/commit/55216c54e6384deb71a8fe80b839ec7a092f9e59))

- Update chaturbate-poller version to 0.10.4 in uv.lock and pyproject.toml
  ([`48ae136`](https://github.com/MountainGod2/chaturbate_poller/commit/48ae13616075e86b585190be0ad910341e5fd91e))

- Update dependencies in requirements.txt and uv.lock
  ([`2a122d4`](https://github.com/MountainGod2/chaturbate_poller/commit/2a122d4af92c916d3b79099ac26b7c8749a17b49))

- Update pypa/gh-action-pypi-publish action to latest version in ci-cd-build.yml
  ([`fd60bac`](https://github.com/MountainGod2/chaturbate_poller/commit/fd60bac6d21e5bb74839d28077c761e299d25dd7))

- Update pypa/gh-action-pypi-publish to version 1.10.3 in ci-cd-build.yml
  ([`16bf816`](https://github.com/MountainGod2/chaturbate_poller/commit/16bf81640b846942f1cc8b73429f1e246544ee07))

### Features

- Add RetryError exception for Chaturbate Poller
  ([`0a27f41`](https://github.com/MountainGod2/chaturbate_poller/commit/0a27f412d7f564df46ceb0da7f1992433a593bad))

### Refactoring

- Rename RetryError to PollingError in exceptions.py
  ([`0c5ecc7`](https://github.com/MountainGod2/chaturbate_poller/commit/0c5ecc7b297c140b83e4a320f5513b8cd85b79c4))

- Update console logging configuration
  ([`18d7c54`](https://github.com/MountainGod2/chaturbate_poller/commit/18d7c5419cf111d574d0a0f9bcb5c90d92da4d97))

Update the console logging configuration in `logging_config.py` to use `RichHandler` from the
  `rich.logging` module. This change enables the use of rich formatting and tracebacks in console
  logs. The `sanitize_sensitive_data` filter is also applied to the console handler.

- Update console logging configuration and dependencies
  ([`8a0cddd`](https://github.com/MountainGod2/chaturbate_poller/commit/8a0cddde102c70bab3fb745bfd57d3417d1b6ee2))

- Refactor the console logging configuration in the Chaturbate Poller.

- Update error handling and dependencies in Chaturbate Poller
  ([`00babab`](https://github.com/MountainGod2/chaturbate_poller/commit/00babab18c3cc79c3d5b96671de34d6fb41310a5))

- Update error handling in ChaturbateClient
  ([`36bf673`](https://github.com/MountainGod2/chaturbate_poller/commit/36bf67336ee90e855e3146dfd090f4535af76dc5))

Refactor the error handling in the ChaturbateClient class to improve logging and error reporting.
  Instead of logging the full HTTP error response, sanitize the sensitive data in the URL and log a
  more generic error message. This change enhances the readability and security of the code.

- Update error handling in ChaturbateUtils
  ([`4717ab3`](https://github.com/MountainGod2/chaturbate_poller/commit/4717ab3044094a94f2c9e582a247ab068f25f42f))

Refactor the error handling logic in the ChaturbateUtils class. The code now properly handles
  different server error codes and raises the appropriate PollingError exception. This improves the
  error reporting and makes the code more robust.

- Update error handling in InfluxDBHandler
  ([`536f40d`](https://github.com/MountainGod2/chaturbate_poller/commit/536f40dc84341fe69eb25bc31e1db788c33123d4))

- Update signal handling in SignalHandler
  ([`84d4e6e`](https://github.com/MountainGod2/chaturbate_poller/commit/84d4e6e5eea0faaab3d311ccee9b66ddc9126826))

Update the signal handling in the SignalHandler class in signal_handler.py. Instead of logging a
  debug message when receiving a signal, it now logs an info message with the received signal name.
  Additionally, when cancelling running tasks, it now logs the number of tasks being cancelled.

### Testing

- Handle server errors and raise RetryError in backoff handlers and event fetching
  ([`0c7d34e`](https://github.com/MountainGod2/chaturbate_poller/commit/0c7d34ebe0aba389fa14b53ad302016fb5cd72c2))

- Update exception names in test_backoff_handlers.py and test_event_fetching.py
  ([`216dc6f`](https://github.com/MountainGod2/chaturbate_poller/commit/216dc6fb15a1cbe7fe8a3719fa4f93c06a226c3f))


## v0.10.4 (2024-10-09)

### Bug Fixes

- Update pyproject.toml to include chaturbate-poller version from uv.lock in version_toml
  ([`eb113a1`](https://github.com/MountainGod2/chaturbate_poller/commit/eb113a1dcca21d3dd4c25e8e474d955665258985))

### Chores

- Update chaturbate-poller version to 0.10.3 in uv.lock
  ([`b884fe4`](https://github.com/MountainGod2/chaturbate_poller/commit/b884fe405a625f6c31bf5c46f6464831619ffaea))

### Refactoring

- Remove poetry.lock to complete transition to using uv to manage package
  ([`16dbc58`](https://github.com/MountainGod2/chaturbate_poller/commit/16dbc58491c434f067b41238d987fe159a7fbd37))


## v0.10.3 (2024-10-09)

### Bug Fixes

- Update GitHub Releases publishing action
  ([`ca687c8`](https://github.com/MountainGod2/chaturbate_poller/commit/ca687c8057fe275aec2e6ab23e00a8931130d9bb))

### Chores

- Update chaturbate-poller version to 0.10.2
  ([`f3d27f1`](https://github.com/MountainGod2/chaturbate_poller/commit/f3d27f189e5be60b05c9b910de7597ef3cdb6602))


## v0.10.2 (2024-10-09)

### Bug Fixes

- Update Dockerfile to use alpine-based image and improve dependency management
  ([#47](https://github.com/MountainGod2/chaturbate_poller/pull/47),
  [`35746f0`](https://github.com/MountainGod2/chaturbate_poller/commit/35746f021a1b0048d28efa16008db949059a0cba))

### Build System

- Update Dockerfile and docker-entrypoint.sh
  ([`6009538`](https://github.com/MountainGod2/chaturbate_poller/commit/600953837ec78f343441bc30fb5bf340dbbeebc6))

Update the Dockerfile to install tini and update the entrypoint script to use tini as the
  entrypoint.

### Chores

- Remove unnecessary whitespace in test_config_manager.py
  ([`4656543`](https://github.com/MountainGod2/chaturbate_poller/commit/4656543c7ea9d64800c9916d2701588153056558))

- Update uv.lock
  ([`83206a6`](https://github.com/MountainGod2/chaturbate_poller/commit/83206a6b597ad727c6caf7cf4809e3a504d4b280))

- Update uv.lock and dependencies
  ([`cf240a8`](https://github.com/MountainGod2/chaturbate_poller/commit/cf240a8a8f3c959b42df53155ba2cf9a7eab9408))

Update the required version of `uv` to `0.4.19` and other dependencies to their latest versions.

### Refactoring

- Add signal handling to gracefully stop Chaturbate Poller
  ([`2a6476c`](https://github.com/MountainGod2/chaturbate_poller/commit/2a6476c1f3d983bb46a3e70b1542fb4516ea48fc))

This commit adds signal handling to the Chaturbate Poller application, allowing it to gracefully
  stop when receiving a signal. It creates an asyncio event loop, sets up a signal handler, and
  waits for a stop signal to be received before closing the event loop. This ensures that the
  application can be stopped cleanly without interrupting any ongoing tasks.

- Remove redundant build and continuous deployment workflows
  ([#45](https://github.com/MountainGod2/chaturbate_poller/pull/45),
  [`cb43fdc`](https://github.com/MountainGod2/chaturbate_poller/commit/cb43fdce05bc72018b459639743afb3023e4fbf7))

* refactor: remove redundant build and continuous deployment workflows

* refactor: update CI/CD workflow to fetch full commit history

- Update CI/CD workflow badge link in README.md
  ([`97fc5bc`](https://github.com/MountainGod2/chaturbate_poller/commit/97fc5bce552d8f958df1169f50c68325e8a489b9))

- Update CI/CD workflow dependencies in ci-cd-build.yml
  ([`98a25b3`](https://github.com/MountainGod2/chaturbate_poller/commit/98a25b338cffbc2450535419b262e72ea95e6118))

- Update Dockerfile entrypoint
  ([`463780f`](https://github.com/MountainGod2/chaturbate_poller/commit/463780f9e833886b78f710171b1ab1b9bedf42c5))

- Update Dockerfile to install uv and dependencies
  ([#46](https://github.com/MountainGod2/chaturbate_poller/pull/46),
  [`8182be0`](https://github.com/MountainGod2/chaturbate_poller/commit/8182be025be1448e4e44da72e9441cac63fb7107))

* refactor: update Dockerfile to install uv and dependencies

- Updated the Dockerfile to include a new stage for installing uv and its dependencies. - Set the
  working directory and copied the project files into the image. - Modified the uv sync command to
  exclude dev dependencies. - Prepared the final runtime image with the virtual environment from the
  builder stage. - Set the docker-entrypoint.sh script as executable and copied it into the image. -
  Set environment variables for the virtual environment. - Updated the default entrypoint. - Updated
  .gitignore

* refactor: raise ValueError with error message when CB_USERNAME and CB_TOKEN are not provided

* refactor: add signal handling to gracefully stop Chaturbate Poller

- Updated the `SignalHandler` class in `signal_handler.py` to include signal handling for gracefully
  stopping the Chaturbate Poller. - Added a check in the `handle_signal` method to only create a
  shutdown task if the `stop_future` is not done. - Removed the unnecessary `run_until_complete`
  call in the `handle_signal` method when the `stop_future` is already done.


## v0.10.1 (2024-10-07)

### Bug Fixes

- Add dependencies between build and cd workflows
  ([#44](https://github.com/MountainGod2/chaturbate_poller/pull/44),
  [`5321c9b`](https://github.com/MountainGod2/chaturbate_poller/commit/5321c9b5e637b3cf043f32034e5d9f63a0739f35))

This commit adds the "needs" keyword to the build and cd workflows in the GitHub Actions
  configuration. This ensures that the cd workflow will only run after the build workflow has
  successfully completed. This dependency ensures that the Docker image is built and pushed to the
  GitHub Container Registry before the release and deployment steps are executed.

Refactor the workflows to include the "needs" keyword for better workflow coordination and
  dependency management.


## v0.10.0 (2024-10-07)

### Build System

- **deps**: Bump httpcore from 1.0.5 to 1.0.6
  ([#42](https://github.com/MountainGod2/chaturbate_poller/pull/42),
  [`0915ba9`](https://github.com/MountainGod2/chaturbate_poller/commit/0915ba9cf44e365db5011979d55709c26f9dd433))

Bumps [httpcore](https://github.com/encode/httpcore) from 1.0.5 to 1.0.6. - [Release
  notes](https://github.com/encode/httpcore/releases) -
  [Changelog](https://github.com/encode/httpcore/blob/master/CHANGELOG.md) -
  [Commits](https://github.com/encode/httpcore/compare/1.0.5...1.0.6)

--- updated-dependencies: - dependency-name: httpcore dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

- **deps**: Bump sphinx-rtd-theme from 2.0.0 to 3.0.0
  ([#41](https://github.com/MountainGod2/chaturbate_poller/pull/41),
  [`14194bc`](https://github.com/MountainGod2/chaturbate_poller/commit/14194bc2ff8e525bd206e2e65f4ad20defad3680))

Bumps [sphinx-rtd-theme](https://github.com/readthedocs/sphinx_rtd_theme) from 2.0.0 to 3.0.0. -
  [Changelog](https://github.com/readthedocs/sphinx_rtd_theme/blob/master/docs/changelog.rst) -
  [Commits](https://github.com/readthedocs/sphinx_rtd_theme/compare/2.0.0...3.0.0)

--- updated-dependencies: - dependency-name: sphinx-rtd-theme dependency-type: direct:production

update-type: version-update:semver-major ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

### Chores

- Update version in uv.lock
  ([`4c5d9f2`](https://github.com/MountainGod2/chaturbate_poller/commit/4c5d9f27f6c2a9b521ec06af190621280fb0a2d2))

### Features

- Add GitHub workflows for building and deploying Docker image and continuous deployment
  ([#43](https://github.com/MountainGod2/chaturbate_poller/pull/43),
  [`d1938db`](https://github.com/MountainGod2/chaturbate_poller/commit/d1938dbb3035405a79d63e80a56f1d8e5cfa4189))

- Added a new file `.github/workflows/build.yml` for building and deploying Docker image to GitHub
  Container Registry. - Added a new file `.github/workflows/cd.yml` for handling release and
  deployment. - Deleted the file `.github/workflows/ci-cd.yml`. - Added a new file
  `.github/workflows/ci.yml` for continuous integration.

These changes introduce GitHub workflows to automate the build, deployment, and continuous
  integration processes for the project.


## v0.9.7 (2024-10-07)

### Bug Fixes

- Streamline build package installation in CI/CD workflow
  ([`04a119c`](https://github.com/MountainGod2/chaturbate_poller/commit/04a119c01dde2413fe6547125e4a28b1db036dd1))

- Update build_command in pyproject.toml to include uv install
  ([`1044423`](https://github.com/MountainGod2/chaturbate_poller/commit/10444234e4c04fb527c4c755dc40e2bc0d30be2b))

### Build System

- Remove build step for distribution packages in CI/CD workflow and add build_command to
  semantic_release config in pyproject.toml
  ([`bc4aaab`](https://github.com/MountainGod2/chaturbate_poller/commit/bc4aaab8f704483c1662ec9dd5e72732fe1f8a1f))

### Chores

- Update cache key format in CI/CD workflow
  ([`95c3495`](https://github.com/MountainGod2/chaturbate_poller/commit/95c3495dc21fe8ac2afd07d07335852422ae5eb9))

- Update CI/CD workflow to build documentation and deploy to GitHub Pages
  ([`af369f0`](https://github.com/MountainGod2/chaturbate_poller/commit/af369f081b949911823ef759dd0583849a571c5f))

- Update version in uv.lock
  ([`245bf89`](https://github.com/MountainGod2/chaturbate_poller/commit/245bf89371166472aa57cf5d5296614ebb0f0037))


## v0.9.6 (2024-10-07)

### Bug Fixes

- Update Python Semantic Release to version 9.10.0 and build distribution packages
  ([#40](https://github.com/MountainGod2/chaturbate_poller/pull/40),
  [`06b3845`](https://github.com/MountainGod2/chaturbate_poller/commit/06b3845d2801f9f4e9b9f8d3815bb82c566bab23))

### Build System

- Add step to install build package in CI/CD workflow
  ([`a2d1567`](https://github.com/MountainGod2/chaturbate_poller/commit/a2d15675c9546e4853436ca12226ab157e910cc9))

- Streamline build package installation in CI/CD workflow
  ([`e6368a8`](https://github.com/MountainGod2/chaturbate_poller/commit/e6368a8b16aa86b4807414a9cc6800d88db84455))

### Chores

- Update version in uv.lock
  ([`548db4a`](https://github.com/MountainGod2/chaturbate_poller/commit/548db4acaeb821e0f852fa446bfe54ad651ef783))


## v0.9.5 (2024-10-05)

### Bug Fixes

- Refactor log directory instantation into main.py
  ([`ac45973`](https://github.com/MountainGod2/chaturbate_poller/commit/ac459731f920245224f4c6a708ad7aca0c5ec0fb))

### Refactoring

- Remove unused code and simplify ConfigManager initialization
  ([`a505522`](https://github.com/MountainGod2/chaturbate_poller/commit/a505522b07d4588459b65556a140919a7d43f3fc))

- Update examples
  ([`8dcb0ec`](https://github.com/MountainGod2/chaturbate_poller/commit/8dcb0ecca6ab675b39d55cb82665d5d0d706ee80))

- Update lint configuration in pyproject.toml
  ([`5153b40`](https://github.com/MountainGod2/chaturbate_poller/commit/5153b40c895735ea0783542e06043f2af1cb6d71))

- Update pyproject.toml and uv.lock to remove pyyaml
  ([`b42d90b`](https://github.com/MountainGod2/chaturbate_poller/commit/b42d90bd75808764202b9c4940745a635f7bc22d))


## v0.9.4 (2024-10-05)

### Bug Fixes

- Update logging throughout program
  ([#39](https://github.com/MountainGod2/chaturbate_poller/pull/39),
  [`df0e9d5`](https://github.com/MountainGod2/chaturbate_poller/commit/df0e9d57abe0477b21b0646f0452cf845bf6b68f))

### Chores

- Update chaturbate-poller version to 0.9.3
  ([`32b008c`](https://github.com/MountainGod2/chaturbate_poller/commit/32b008c9a238e16a8dac0c3cda3cfb3e7c260b96))

### Documentation

- Improve documentation
  ([`c334d63`](https://github.com/MountainGod2/chaturbate_poller/commit/c334d636e446c674b7b2fcf5c534496dbdafe75c))

### Refactoring

- Remove unnecessary blank line in signal handler shutdown
  ([`4b1b1fa`](https://github.com/MountainGod2/chaturbate_poller/commit/4b1b1fa7d29f117fb0ccb13ccaef1a1b6c65ef12))

- Update ChaturbateClient initialization and logging
  ([`de610fd`](https://github.com/MountainGod2/chaturbate_poller/commit/de610fd67daccfd61fd9130b914d3cf18e0526e0))

- Update Dockerfile to install uv and sync project dependencies
  ([`80ce181`](https://github.com/MountainGod2/chaturbate_poller/commit/80ce18159413044e075698a708112e9fae877aea))

- Update linting configuration in pyproject.toml
  ([`20cfc0a`](https://github.com/MountainGod2/chaturbate_poller/commit/20cfc0a568e61ce19b1da746d40a352eeba9376f))

- Update logging configuration in tests/conftest.py
  ([`518a3b5`](https://github.com/MountainGod2/chaturbate_poller/commit/518a3b5f33631be855e6a50f7a00c412e00c1dce))

- Update logging in event_handler.py and influxdb_client.py
  ([`7da5ee2`](https://github.com/MountainGod2/chaturbate_poller/commit/7da5ee217090655d333bffb2967304930fef11fa))

- Update source directory in pyproject.toml
  ([`f1c0c6a`](https://github.com/MountainGod2/chaturbate_poller/commit/f1c0c6a67e23f2c110b1870d6718007ee363100f))

- Update source directory in pyproject.toml
  ([`3b85fb8`](https://github.com/MountainGod2/chaturbate_poller/commit/3b85fb84543f26ed8fac0af80707576587e6d258))

### Testing

- Refactor tests into separate scripts to reduce complexity and improve readability
  ([`7c735a3`](https://github.com/MountainGod2/chaturbate_poller/commit/7c735a329b9df0d9d41567d18dd795ca144f7f85))

- Remove unused logger instances in test_main.py and test_signal_handler.py
  ([`1d59397`](https://github.com/MountainGod2/chaturbate_poller/commit/1d593978d5d462ca790860b26b999d00f5b8e463))


## v0.9.3 (2024-10-02)

### Bug Fixes

- Refactor signal handler shutdown and task cancellation
  ([#37](https://github.com/MountainGod2/chaturbate_poller/pull/37),
  [`52ca119`](https://github.com/MountainGod2/chaturbate_poller/commit/52ca11915f18113cecd0d0ddfd9f894123febb37))

* ci: refactor source directory in pyproject.toml

* fix: refactor signal handler shutdown and task cancellation

### Build System

- **deps**: Bump myst-nb from 1.1.1 to 1.1.2
  ([#32](https://github.com/MountainGod2/chaturbate_poller/pull/32),
  [`35b5e25`](https://github.com/MountainGod2/chaturbate_poller/commit/35b5e250710a26797e6ba78465393d9890687c24))

Bumps [myst-nb](https://github.com/executablebooks/myst-nb) from 1.1.1 to 1.1.2. - [Release
  notes](https://github.com/executablebooks/myst-nb/releases) -
  [Changelog](https://github.com/executablebooks/MyST-NB/blob/master/CHANGELOG.md) -
  [Commits](https://github.com/executablebooks/myst-nb/compare/v1.1.1...v1.1.2)

--- updated-dependencies: - dependency-name: myst-nb dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump pydantic-core from 2.23.4 to 2.24.0
  ([#34](https://github.com/MountainGod2/chaturbate_poller/pull/34),
  [`fc71aa7`](https://github.com/MountainGod2/chaturbate_poller/commit/fc71aa72aa06985bcac56ceea54d278bd9eaf073))

Bumps [pydantic-core](https://github.com/pydantic/pydantic-core) from 2.23.4 to 2.24.0. - [Release
  notes](https://github.com/pydantic/pydantic-core/releases) -
  [Commits](https://github.com/pydantic/pydantic-core/compare/v2.23.4...v2.24.0)

--- updated-dependencies: - dependency-name: pydantic-core dependency-type: direct:production

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

- **deps**: Bump sphinx-autoapi from 3.0.0 to 3.3.2
  ([#33](https://github.com/MountainGod2/chaturbate_poller/pull/33),
  [`7cfef9a`](https://github.com/MountainGod2/chaturbate_poller/commit/7cfef9a475d0cf8865ebbc67a01749df60737b3a))

Bumps [sphinx-autoapi](https://github.com/readthedocs/sphinx-autoapi) from 3.0.0 to 3.3.2. -
  [Release notes](https://github.com/readthedocs/sphinx-autoapi/releases) -
  [Changelog](https://github.com/readthedocs/sphinx-autoapi/blob/main/CHANGELOG.rst) -
  [Commits](https://github.com/readthedocs/sphinx-autoapi/compare/v3.0.0...v3.3.2)

--- updated-dependencies: - dependency-name: sphinx-autoapi dependency-type: direct:production

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

Co-authored-by: MountainGod2 <88257202+MountainGod2@users.noreply.github.com>

### Continuous Integration

- Bump chaturbate-poller version to 0.9.2
  ([`9e98a8e`](https://github.com/MountainGod2/chaturbate_poller/commit/9e98a8ea72db2c73f9794768b07bba25a9a539e2))

- Refactor sonar-project.properties: update source directory
  ([`942a728`](https://github.com/MountainGod2/chaturbate_poller/commit/942a72849c4ae0169335736ef070fe11ec2a29fd))

- Refactor sonar-project.properties: update source directory
  ([`e1b4a03`](https://github.com/MountainGod2/chaturbate_poller/commit/e1b4a034b3e532b34b72c044bfc29318b82b8a63))

- Refactor sonar-project.properties: update source directory
  ([`c5b3f06`](https://github.com/MountainGod2/chaturbate_poller/commit/c5b3f061bf46ed952e54e839caf61aad75c21609))

- Refactor sonar-project.properties: update source directory
  ([`541fcce`](https://github.com/MountainGod2/chaturbate_poller/commit/541fccefc1bcef2105077e871ad062078828f552))

- Refactor sonar-project.properties: update source directory
  ([`2eea2d2`](https://github.com/MountainGod2/chaturbate_poller/commit/2eea2d2bf5d66908000e0587a0defcbb1490f5cf))

- Refactor source directory in pyproject.toml
  ([`a4ad7ba`](https://github.com/MountainGod2/chaturbate_poller/commit/a4ad7ba4c65b4190f89551a99a7c6dec480da6fb))

- Refactor source directory in pyproject.toml
  ([`85f20d4`](https://github.com/MountainGod2/chaturbate_poller/commit/85f20d475f8ed265c181cfb7c59db7d82df19c43))

### Refactoring

- Move main function to separate module
  ([#35](https://github.com/MountainGod2/chaturbate_poller/pull/35),
  [`733f8ca`](https://github.com/MountainGod2/chaturbate_poller/commit/733f8ca4bbc43b1932c6350aa98caf29fcfcd0dd))

* refactor: move main function to separate module

* refactor: updated description for project

* refactor: improve signal handling and shutdown process

* refactor: improve logging usage and consistency

* refactor: add constants for pytests

* refactor: simplify signal handler setup

* test: refactor test fixtures and logging in tests

* 0.9.2 (#36)

Automatically generated by python-semantic-release

### Testing

- Refactor test_chaturbate_poller.py: remove unnecessary assert statement
  ([`d34ab03`](https://github.com/MountainGod2/chaturbate_poller/commit/d34ab03a44efd70b31092b9646d046e1da34cb3e))


## v0.9.2 (2024-09-29)

### Bug Fixes

- Remove duplicate depandabot.yml
  ([`5776aca`](https://github.com/MountainGod2/chaturbate_poller/commit/5776aca1332c401a18ab1e5ec168c97d7179dcd0))

### Refactoring

- Refactor format_messages.py to fix tip message formatting
  ([`f2df1a6`](https://github.com/MountainGod2/chaturbate_poller/commit/f2df1a6b26f909b450639c737dcea3d992346240))

- Refactor format_messages.py to improve tip message formatting
  ([`f597021`](https://github.com/MountainGod2/chaturbate_poller/commit/f597021d04b1011e5478e1e00c999f9a4425e4a1))


## v0.9.1 (2024-09-28)

### Bug Fixes

- Fix formatting issue in format_tip_event function
  ([`599d8a4`](https://github.com/MountainGod2/chaturbate_poller/commit/599d8a477bb4f4ddd2a374c0423cf73202e072ad))

- Update test_signal_handler.py ([#31](https://github.com/MountainGod2/chaturbate_poller/pull/31),
  [`52e18b8`](https://github.com/MountainGod2/chaturbate_poller/commit/52e18b8b433ed1efb48178fb380aafec31664501))

### Chores

- Add uv package to cd step
  ([`2cd6b4b`](https://github.com/MountainGod2/chaturbate_poller/commit/2cd6b4b6e43cfe24c721c265a2cc74483ebfc2cb))

- Update ci-cd.yml to remove unnecessary tags in push step
  ([`3667556`](https://github.com/MountainGod2/chaturbate_poller/commit/3667556b8356c066d38cd2e39c8625438fbf3c79))

- Update Python version to 3.12 and use uv as the package manager in ci-cd.yml
  ([#30](https://github.com/MountainGod2/chaturbate_poller/pull/30),
  [`fb14eb1`](https://github.com/MountainGod2/chaturbate_poller/commit/fb14eb18df45d62652d10ab56bd6a0de5bdf9ac3))

### Refactoring

- Add signal handler for SIGINT and SIGTERM signals
  ([`be9f4a6`](https://github.com/MountainGod2/chaturbate_poller/commit/be9f4a61b2ac7c707b3a0ef1bad7be3c06e627a5))

- Fix formatting issue in format_tip_event function
  ([`824c667`](https://github.com/MountainGod2/chaturbate_poller/commit/824c667726caf2d48100d1754db561f3cf09c2be))

- Refactored to use uv as the package manager
  ([#29](https://github.com/MountainGod2/chaturbate_poller/pull/29),
  [`ad3a835`](https://github.com/MountainGod2/chaturbate_poller/commit/ad3a83599d99a253c0d9e1efce9014d29b301262))

* chore: refactored to use uv as the package manager

* chore: update dependencies in requirements.txt

* refactor: update Chaturbate poller utility functions

* chore: update ci-cd.yml to use uv as the package manager and cache uv dependencies

- Update ci-cd.yml to include SSH private and public signing keys
  ([`1034c3d`](https://github.com/MountainGod2/chaturbate_poller/commit/1034c3d930839eb0aa9951747f037a6943f7005c))

- Update ci-cd.yml to set git committer and author information
  ([`c28f230`](https://github.com/MountainGod2/chaturbate_poller/commit/c28f23070d8f77682a9637033160f25310fed8de))

- Update ci-cd.yml to set git committer and author information
  ([`1d9a6e2`](https://github.com/MountainGod2/chaturbate_poller/commit/1d9a6e279b68c42b8633f14e117f528935116efb))

- Update pyproject.toml
  ([`0d70a01`](https://github.com/MountainGod2/chaturbate_poller/commit/0d70a01b39c906577fc61f1c10820104587112b9))


## v0.9.0 (2024-09-27)

### Build System

- Added version tag to Docker build action in ci-cd.yml
  ([`d1633ac`](https://github.com/MountainGod2/chaturbate_poller/commit/d1633ac0e0eb1f319de235a0e250e9b0c866e1b5))

- Fix release action in ci-cd.yml
  ([`53eefb9`](https://github.com/MountainGod2/chaturbate_poller/commit/53eefb9cfdc462bdc106dff361f57f4189fe35f2))

### Continuous Integration

- Corrected ci-cd.yml build action
  ([`40c13b8`](https://github.com/MountainGod2/chaturbate_poller/commit/40c13b8d11ea3a771bcf7dc4dd4760ed93fa0e7a))

### Features

- Added pull request template ([#28](https://github.com/MountainGod2/chaturbate_poller/pull/28),
  [`3e80b23`](https://github.com/MountainGod2/chaturbate_poller/commit/3e80b23549134b081b005e4aabbd7bc5c07476bb))

* chore: update dependencies in pyproject.toml

* chore: update Ruff version to v0.6.7 and add linting and formatting hooks

* feat: added pull request template

### Refactoring

- Add ChaturbateUtils class for Chaturbate poller utility functions
  ([#27](https://github.com/MountainGod2/chaturbate_poller/pull/27),
  [`e4736e7`](https://github.com/MountainGod2/chaturbate_poller/commit/e4736e72e08257768f292a3249a81fb6825426ae))


## v0.8.1 (2024-09-26)

### Bug Fixes

- Update Dockerfile build command
  ([`f3faf6c`](https://github.com/MountainGod2/chaturbate_poller/commit/f3faf6c6a759027e55f303f774a14430ab90ce91))


## v0.8.0 (2024-09-25)

### Chores

- Update semantic-release configuration in pyproject.toml
  ([#25](https://github.com/MountainGod2/chaturbate_poller/pull/25),
  [`e1fd4e8`](https://github.com/MountainGod2/chaturbate_poller/commit/e1fd4e8b9d78e925ae523211a195104d66bea3ab))

### Features

- Refactored docker build to improve speed and reduce size
  ([#26](https://github.com/MountainGod2/chaturbate_poller/pull/26),
  [`af26621`](https://github.com/MountainGod2/chaturbate_poller/commit/af26621ae4243d5aa6ce0d2844577753396b6fed))

* feat: refactored docker build to improve speed and reduce size of final image

* refactor: update docker-entrypoint.sh to print command before execution


## v0.7.5 (2024-09-25)

### Bug Fixes

- Corrected build step in cd action
  ([`16a7b80`](https://github.com/MountainGod2/chaturbate_poller/commit/16a7b808b9c1685eafd61cdea8e7a5e0f3cfc342))

### Chores

- Update python-semantic-release to version 9.8.8
  ([#24](https://github.com/MountainGod2/chaturbate_poller/pull/24),
  [`872aafe`](https://github.com/MountainGod2/chaturbate_poller/commit/872aafe33b5802e520bc96c1952b81f8d7443cf6))

* chore: update python-semantic-release to version 9.8.8

* chore: update Python version to 3.11 in CI/CD workflow


## v0.7.4 (2024-09-24)

### Bug Fixes

- Update tip message handling in format_messages.py
  ([#23](https://github.com/MountainGod2/chaturbate_poller/pull/23),
  [`65ce182`](https://github.com/MountainGod2/chaturbate_poller/commit/65ce1827f7924b7f1e8ac9ec9265dfcc3adcf0de))

* chore: handle NameResolutionError when resolving InfluxDB URL in InfluxDBHandler

* fix: update tip message handling in format_messages.py

* test: add test for handling NameResolutionError in InfluxDBHandler


## v0.7.3 (2024-09-24)

### Bug Fixes

- Update personal token for GitHub Pages deployment
  ([#22](https://github.com/MountainGod2/chaturbate_poller/pull/22),
  [`8f857d4`](https://github.com/MountainGod2/chaturbate_poller/commit/8f857d486d285529a422426abd19456897e3b5db))

* fix: update personal token for GitHub Pages deployment

* chore: enable commit signing in git settings

* chore: added asyncio_default_fixture_loop_scope to pytest.ini options in pyproject.toml

* test: updated URL sanitization in logging tests

### Build System

- **deps**: Bump myst-nb from 1.1.0 to 1.1.1
  ([#19](https://github.com/MountainGod2/chaturbate_poller/pull/19),
  [`7c8a6d2`](https://github.com/MountainGod2/chaturbate_poller/commit/7c8a6d29162bddaf22042f3e3ca425711e530a5c))

Bumps [myst-nb](https://github.com/executablebooks/myst-nb) from 1.1.0 to 1.1.1. - [Release
  notes](https://github.com/executablebooks/myst-nb/releases) -
  [Changelog](https://github.com/executablebooks/MyST-NB/blob/master/CHANGELOG.md) -
  [Commits](https://github.com/executablebooks/myst-nb/compare/v1.1.0...v1.1.1)

--- updated-dependencies: - dependency-name: myst-nb dependency-type: direct:production

update-type: version-update:semver-patch ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps**: Bump sphinx-autoapi from 3.0.0 to 3.3.1
  ([#17](https://github.com/MountainGod2/chaturbate_poller/pull/17),
  [`68ee307`](https://github.com/MountainGod2/chaturbate_poller/commit/68ee3078b21c1061751953ae4806ecad6b91002f))

Bumps [sphinx-autoapi](https://github.com/readthedocs/sphinx-autoapi) from 3.0.0 to 3.3.1. -
  [Release notes](https://github.com/readthedocs/sphinx-autoapi/releases) -
  [Changelog](https://github.com/readthedocs/sphinx-autoapi/blob/main/CHANGELOG.rst) -
  [Commits](https://github.com/readthedocs/sphinx-autoapi/compare/v3.0.0...v3.3.1)

--- updated-dependencies: - dependency-name: sphinx-autoapi dependency-type: direct:production

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump cryptography from 43.0.0 to 43.0.1
  ([`bd143a2`](https://github.com/MountainGod2/chaturbate_poller/commit/bd143a20be4d71784e71260191b40c161595a1b6))

Bumps [cryptography](https://github.com/pyca/cryptography) from 43.0.0 to 43.0.1. -
  [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst) -
  [Commits](https://github.com/pyca/cryptography/compare/43.0.0...43.0.1)

--- updated-dependencies: - dependency-name: cryptography dependency-type: indirect ...

Signed-off-by: dependabot[bot] <support@github.com>

- **deps-dev**: Bump pytest-asyncio from 0.23.8 to 0.24.0
  ([#18](https://github.com/MountainGod2/chaturbate_poller/pull/18),
  [`4258c6a`](https://github.com/MountainGod2/chaturbate_poller/commit/4258c6acb53e9fa18b5ef0e68e6fdfdf3ac2813a))

Bumps [pytest-asyncio](https://github.com/pytest-dev/pytest-asyncio) from 0.23.8 to 0.24.0. -
  [Release notes](https://github.com/pytest-dev/pytest-asyncio/releases) -
  [Commits](https://github.com/pytest-dev/pytest-asyncio/compare/v0.23.8...v0.24.0)

--- updated-dependencies: - dependency-name: pytest-asyncio dependency-type: direct:development

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

- **deps-dev**: Bump ruff from 0.5.7 to 0.6.7
  ([#20](https://github.com/MountainGod2/chaturbate_poller/pull/20),
  [`a177325`](https://github.com/MountainGod2/chaturbate_poller/commit/a177325b0cff8978ecb2164b9fd0c186fece935f))

Bumps [ruff](https://github.com/astral-sh/ruff) from 0.5.7 to 0.6.7. - [Release
  notes](https://github.com/astral-sh/ruff/releases) -
  [Changelog](https://github.com/astral-sh/ruff/blob/main/CHANGELOG.md) -
  [Commits](https://github.com/astral-sh/ruff/compare/0.5.7...0.6.7)

--- updated-dependencies: - dependency-name: ruff dependency-type: direct:development

update-type: version-update:semver-minor ...

Signed-off-by: dependabot[bot] <support@github.com>

Co-authored-by: dependabot[bot] <49699333+dependabot[bot]@users.noreply.github.com>

### Chores

- Remove Renovate configuration and workflow files
  ([#15](https://github.com/MountainGod2/chaturbate_poller/pull/15),
  [`d572d7b`](https://github.com/MountainGod2/chaturbate_poller/commit/d572d7bf51ea79337a376ee2d5bf5c0549ccd390))

- Reorganize pyproject.toml
  ([`1763cbd`](https://github.com/MountainGod2/chaturbate_poller/commit/1763cbd0ea7e648cec9b42615ea2dc33bf8facb9))

- Update dependencies in poetry.lock
  ([`f762e8d`](https://github.com/MountainGod2/chaturbate_poller/commit/f762e8da9b7219cd231352f52b2ba23d4487db89))

- Update Python version to 3.11 in .readthedocs.yml
  ([`32c4b80`](https://github.com/MountainGod2/chaturbate_poller/commit/32c4b809ffe41165b30dc41ff334cc61952ea8e0))

- Update Python version to 3.11 in README.md
  ([`8c42d3b`](https://github.com/MountainGod2/chaturbate_poller/commit/8c42d3b0bee24c3a3e6ecd5251e9200c0d29b914))

- Update SonarCloud GitHub Action to version 3.0.0
  ([`ef6f03f`](https://github.com/MountainGod2/chaturbate_poller/commit/ef6f03f4360c2c472f401578207c0e555b8c1068))

- Update SonarCloud GitHub Action to version 5.9.3
  ([`073ae5d`](https://github.com/MountainGod2/chaturbate_poller/commit/073ae5d215e12f7059f17124734eacfd1041ea18))

### Refactoring

- Update ChaturbateClient timeout parameter name to api_timeout
  ([#21](https://github.com/MountainGod2/chaturbate_poller/pull/21),
  [`e730527`](https://github.com/MountainGod2/chaturbate_poller/commit/e730527c21fe2b2751321e93370e0dc0a7de3d6e))

- Update ConfigManager.get() method to handle default values more efficiently
  ([`948c6bf`](https://github.com/MountainGod2/chaturbate_poller/commit/948c6bf72449eb0dab49a8fea8f14ef4277fd511))


## v0.7.2 (2024-08-15)

### Bug Fixes

- Correct coverage target
  ([`faa955b`](https://github.com/MountainGod2/chaturbate_poller/commit/faa955b41d62bb26f2b543cdb859d4c40f5a7bd7))


## v0.7.1 (2024-08-14)

### Bug Fixes

- Created `config_manager.py` for centralized config management
  ([`1a3bc30`](https://github.com/MountainGod2/chaturbate_poller/commit/1a3bc30e3225a94ce083caefacf1ad27f1ec62c1))

### Chores

- Updated dependencies and modified pytest config options
  ([`456b7d5`](https://github.com/MountainGod2/chaturbate_poller/commit/456b7d5d6d01fff1c12019838ec89656a12550a5))


## v0.7.0 (2024-08-14)

### Chores

- Update dependencies to latest versions and added bandit to dev dependencies
  ([`ec9d763`](https://github.com/MountainGod2/chaturbate_poller/commit/ec9d763e606efc8ed9baa1e16c1f5edb79140ce4))

### Documentation

- Update READMER
  ([`d544a6d`](https://github.com/MountainGod2/chaturbate_poller/commit/d544a6d4f8ede27f36cf42d177d56b7bdcb83cd1))

### Features

- Refactored influxdb support
  ([`f22149a`](https://github.com/MountainGod2/chaturbate_poller/commit/f22149a49897bbc80eca69bb5646f7c9daae1e5e))


## v0.6.11 (2024-08-12)

### Bug Fixes

- Update dependencies
  ([`fc41ff5`](https://github.com/MountainGod2/chaturbate_poller/commit/fc41ff5c597b1268f01b28cbb6a3c6c1c926fa17))

### Chores

- Update tests and expand coverage
  ([`226cc15`](https://github.com/MountainGod2/chaturbate_poller/commit/226cc15033a21dddd899277dc1385be3b6333a1f))


## v0.6.10 (2024-08-12)

### Bug Fixes

- Update influxdb error handling
  ([`efb13ee`](https://github.com/MountainGod2/chaturbate_poller/commit/efb13ee67daa83912e41b39f909e4ef7f8b7fdc7))

- Updated influxdb_client exception handling
  ([`9e874db`](https://github.com/MountainGod2/chaturbate_poller/commit/9e874dbfa08519290852015fbdd8fa43d58e4624))

- Updated influxdb_client exception handling
  ([`c367d56`](https://github.com/MountainGod2/chaturbate_poller/commit/c367d56a45fb3453da0b43844bf38b291096ad65))

### Build System

- Update Dockerfile
  ([`1daf4e7`](https://github.com/MountainGod2/chaturbate_poller/commit/1daf4e7d7c49f208f08ef0f2995576bb8b19b52b))


## v0.6.9 (2024-08-09)

### Bug Fixes

- Updated influxdb_client.py writing
  ([`a7ef3b0`](https://github.com/MountainGod2/chaturbate_poller/commit/a7ef3b073f1ce73583bc8a4758d3e29cded0fe4b))

### Build System

- Update Dockerfile casing
  ([`584e622`](https://github.com/MountainGod2/chaturbate_poller/commit/584e62251b42aa8c29fe1b98b1da3da7c3fbe09e))


## v0.6.8 (2024-08-09)

### Bug Fixes

- Update Dockerfile and update ci-cd.yml
  ([`4529c59`](https://github.com/MountainGod2/chaturbate_poller/commit/4529c5942c2b0ffc4d6d6799eab174983acc1679))


## v0.6.7 (2024-08-09)

### Bug Fixes

- Sanitize logging and refactor giveup log message
  ([`3de1c08`](https://github.com/MountainGod2/chaturbate_poller/commit/3de1c08cde0a612804b9fc1b9b1e08442c5de8c1))

### Continuous Integration

- Updated workflow versions
  ([`7355e10`](https://github.com/MountainGod2/chaturbate_poller/commit/7355e1091b479963e8423f599bf6e90c19800e7e))


## v0.6.6 (2024-08-08)

### Bug Fixes

- Re-added `latest` tag
  ([`0b1f157`](https://github.com/MountainGod2/chaturbate_poller/commit/0b1f157dd3a30596e5604ce8908d0cceb481df6a))


## v0.6.5 (2024-08-08)

### Bug Fixes

- Corrected ci-cd.yml image name for docker build
  ([`06885c8`](https://github.com/MountainGod2/chaturbate_poller/commit/06885c84518227fde0d3b308b35f647a68a0f17e))


## v0.6.4 (2024-08-08)

### Bug Fixes

- Update ci-cd.yml and influxdb_client.py
  ([`42016d0`](https://github.com/MountainGod2/chaturbate_poller/commit/42016d0b76ca5add13a98484c13f0633fbbedb2d))

### Continuous Integration

- Update ci-cd.yml to add tags for docker releases
  ([`e3d6365`](https://github.com/MountainGod2/chaturbate_poller/commit/e3d6365215a3a8e2854f0dcdc0fd54592c7b89de))


## v0.6.3 (2024-08-08)

### Bug Fixes

- Update Dockerfile
  ([`4f4d27e`](https://github.com/MountainGod2/chaturbate_poller/commit/4f4d27e9d3b994cf12b31f1ba8ba1b82d20f157c))


## v0.6.2 (2024-08-08)

### Bug Fixes

- Update influxdb formatting
  ([`bfd31e7`](https://github.com/MountainGod2/chaturbate_poller/commit/bfd31e7cd874312c1186cef642ca02e5fbc603f4))


## v0.6.1 (2024-08-08)

### Bug Fixes

- Added `--no-cache-dir` to pip install
  ([`1aad475`](https://github.com/MountainGod2/chaturbate_poller/commit/1aad4756f33b04a4fa6254022230c6004f599204))

### Documentation

- Updated README.md with CLI and docker examples
  ([`b845176`](https://github.com/MountainGod2/chaturbate_poller/commit/b8451764ec2c79049ea7ae3dc28097841391ca14))


## v0.6.0 (2024-08-08)

### Features

- Added docker functionality
  ([`5323055`](https://github.com/MountainGod2/chaturbate_poller/commit/53230550613f439f3e8fba9e2b067d7d1e387d45))


## v0.5.19 (2024-08-08)

### Bug Fixes

- Broken Dockerfile fix
  ([`5362468`](https://github.com/MountainGod2/chaturbate_poller/commit/53624688f2f733eba146d104ea5a17c47c7afefd))


## v0.5.18 (2024-08-08)

### Bug Fixes

- Simplify Dockerfile logic
  ([`19faf38`](https://github.com/MountainGod2/chaturbate_poller/commit/19faf38f47187ff753cdee06873da44fc2e3e7e1))


## v0.5.17 (2024-08-07)

### Bug Fixes

- Update Dockerfile
  ([`0e646c0`](https://github.com/MountainGod2/chaturbate_poller/commit/0e646c046c648ed100c78c1be381ada073871871))


## v0.5.16 (2024-08-07)

### Bug Fixes

- Update Dockerfile
  ([`93779ea`](https://github.com/MountainGod2/chaturbate_poller/commit/93779ea270538bf2e8b5aed4fbd1b6308bd9ab20))


## v0.5.15 (2024-08-07)

### Bug Fixes

- Update logging and Dockerfile entrypoint
  ([`c252c04`](https://github.com/MountainGod2/chaturbate_poller/commit/c252c0428d6453fdfc438040569bc1bb6874ca7c))


## v0.5.14 (2024-08-07)

### Bug Fixes

- Changed CMD to ENTRYPOINT in Dockerfile
  ([`a4628dd`](https://github.com/MountainGod2/chaturbate_poller/commit/a4628dd3b91f8ce8f18af7e1da9c751d656b14f3))


## v0.5.13 (2024-08-07)

### Bug Fixes

- Updated commandline logic and added testbed flag
  ([`809e7ac`](https://github.com/MountainGod2/chaturbate_poller/commit/809e7ac6b4b046128f5b6fed34a51e443dc9a5bc))


## v0.5.12 (2024-08-06)

### Bug Fixes

- Add exception handling for __main__.py
  ([`7f06b12`](https://github.com/MountainGod2/chaturbate_poller/commit/7f06b1265693ec91b0a25d112bdec84bc7290d1b))

### Continuous Integration

- Fix ci-cd.yml
  ([`51dd935`](https://github.com/MountainGod2/chaturbate_poller/commit/51dd935d5eb954058a603de4d34d1d367b414e7d))

- Update ci-cd.yml to fix failing build
  ([`cb35283`](https://github.com/MountainGod2/chaturbate_poller/commit/cb352838b82ecfa6212a67f8167a0dd37df615f2))

- Updated ci-cd.yml build action
  ([`0e8fae0`](https://github.com/MountainGod2/chaturbate_poller/commit/0e8fae06a00d3e6f2f47518edd9e44a0e01213bd))


## v0.5.11 (2024-08-06)

### Bug Fixes

- Updated ci-cd.yml and Dockerfile
  ([`bff49d9`](https://github.com/MountainGod2/chaturbate_poller/commit/bff49d95c6d86c044b01573fc200edc2eb7fa85c))


## v0.5.10 (2024-08-06)

### Bug Fixes

- Updated Dockerfile and __main__.py
  ([`1f136e6`](https://github.com/MountainGod2/chaturbate_poller/commit/1f136e6c3f7168fdeedd4a13bbe7aff9c470d75e))


## v0.5.9 (2024-08-06)

### Bug Fixes

- Update Dockerfile to install via pip
  ([`15580c9`](https://github.com/MountainGod2/chaturbate_poller/commit/15580c98a8fe6fbb7180f6196fb320cd72c8bd7a))


## v0.5.8 (2024-08-06)

### Bug Fixes

- Modified Dockerfile poetry install command
  ([`2781d9e`](https://github.com/MountainGod2/chaturbate_poller/commit/2781d9ec61c7905e48f7ac3c39de8521217c668c))


## v0.5.7 (2024-08-06)

### Bug Fixes

- Updated docker build
  ([`da606b7`](https://github.com/MountainGod2/chaturbate_poller/commit/da606b7281f2e21a5e11b8443d156fd7b6e3d63c))

### Continuous Integration

- Fix ci-cd.yml checkout
  ([`4b7025f`](https://github.com/MountainGod2/chaturbate_poller/commit/4b7025f30474930bf4605117a7174864b1017ba9))


## v0.5.6 (2024-08-06)

### Bug Fixes

- Updated Dockerfile
  ([`77ce8f5`](https://github.com/MountainGod2/chaturbate_poller/commit/77ce8f52b4547a687313809fe6f2be10b3d8756d))


## v0.5.5 (2024-08-06)

### Bug Fixes

- Updated docker build
  ([`71fa864`](https://github.com/MountainGod2/chaturbate_poller/commit/71fa864a9d89a2e6704aee83c18d53498c976701))


## v0.5.4 (2024-08-06)

### Bug Fixes

- Updated __main__.py
  ([`ccfa8c0`](https://github.com/MountainGod2/chaturbate_poller/commit/ccfa8c075d691a78fff50076b12f9ee0209dbfd9))

- Updated Docker build
  ([`5ab8dc8`](https://github.com/MountainGod2/chaturbate_poller/commit/5ab8dc882f865d87a2553c7895dd038054e007d2))

### Continuous Integration

- Fixed Dockerfile and ci-cd.yml
  ([`50d7373`](https://github.com/MountainGod2/chaturbate_poller/commit/50d7373c9e6675104634172740c22b9f83201f42))


## v0.5.3 (2024-08-06)

### Bug Fixes

- Updated Dockerfile
  ([`50f9254`](https://github.com/MountainGod2/chaturbate_poller/commit/50f92546fea504743e78b8de6c045c75513848a8))


## v0.5.2 (2024-08-06)

### Bug Fixes

- Removed unused argument from __main__.py
  ([`43f3c56`](https://github.com/MountainGod2/chaturbate_poller/commit/43f3c563c61d4c6906fedd0f2b11a5170951c14e))

- Update Dockerfile
  ([`500820e`](https://github.com/MountainGod2/chaturbate_poller/commit/500820e33cde56abb6faffb841f4cf4c64390914))


## v0.5.1 (2024-08-06)

### Bug Fixes

- Updated Dockerfile
  ([`d18d910`](https://github.com/MountainGod2/chaturbate_poller/commit/d18d910b0fca07498be3f1d6ffdf52bedf9f87ef))

### Continuous Integration

- Fix docker build action
  ([`bfab901`](https://github.com/MountainGod2/chaturbate_poller/commit/bfab901183fde36e44f02a0ede41b0316414e6c3))

- Fix docker build action
  ([`a6f4e9a`](https://github.com/MountainGod2/chaturbate_poller/commit/a6f4e9aa078f3c04b61a65729413b859282a48d2))

- Fix syntax
  ([`ced387e`](https://github.com/MountainGod2/chaturbate_poller/commit/ced387e2bd1c5ecc10139847c51c875828422788))

- Merged docker-publish into ci-cd action
  ([`27343d2`](https://github.com/MountainGod2/chaturbate_poller/commit/27343d29e49aa43152121cd7e849cfa0ec5327a7))

- Update Dockerfile
  ([`7fdd7a3`](https://github.com/MountainGod2/chaturbate_poller/commit/7fdd7a32fdd2c217d3237d4d1a9a21bb9cc6846b))

- Update Dockerfile and add validation to build action
  ([`a63390a`](https://github.com/MountainGod2/chaturbate_poller/commit/a63390ace36f7460e2f8dab8830d1cdc7486dc02))


## v0.5.0 (2024-08-05)

### Bug Fixes

- Ensure repository name is lowercase
  ([`1b23d35`](https://github.com/MountainGod2/chaturbate_poller/commit/1b23d35b48d1552e6e0a945a4e9cd0d322b4a444))

### Continuous Integration

- Corrected pyproject.toml
  ([`68f2cc4`](https://github.com/MountainGod2/chaturbate_poller/commit/68f2cc4ab20899a3932615452211bc95c4d3461f))

### Features

- Add initial influxdb functionality
  ([`c94990d`](https://github.com/MountainGod2/chaturbate_poller/commit/c94990d2029f23989cde76711e4616e584c564cc))


## v0.4.0 (2024-08-04)

### Continuous Integration

- Separate sonar test and source directories
  ([`909cd5d`](https://github.com/MountainGod2/chaturbate_poller/commit/909cd5d9144f1fc50ab8e301123f37d9912806c9))

- Update action versions to use Node.js 20
  ([`0c092ae`](https://github.com/MountainGod2/chaturbate_poller/commit/0c092ae6d5ea6905359e7356aea4dcbadaf04c55))

- Update sonar test location and action naming
  ([`956c983`](https://github.com/MountainGod2/chaturbate_poller/commit/956c9831a023bc803b1ab8e52c2853eb6aee9508))

- Updated coverage relative files
  ([`28f2fb7`](https://github.com/MountainGod2/chaturbate_poller/commit/28f2fb75c337761c82cb9539f72bd31ddea6a70f))

### Documentation

- Renamed conduct.md to code_of_conduct.md
  ([`5317617`](https://github.com/MountainGod2/chaturbate_poller/commit/5317617f81d87c45256977c558152472688b415c))

- Update issue templates
  ([`f90bf6f`](https://github.com/MountainGod2/chaturbate_poller/commit/f90bf6f3c1c5f37bfd34b1de9b88c9b0b52927ca))

### Features

- Updated documentation and bumped dependencies
  ([`5f5f37c`](https://github.com/MountainGod2/chaturbate_poller/commit/5f5f37c080b58060fcf9c11eb89b1f05b84bc104))

### Refactoring

- Added pre-commit hooks and standardized whitespaces
  ([`0f15e93`](https://github.com/MountainGod2/chaturbate_poller/commit/0f15e9356da8d4bda36f5bc287cd1781cbaead13))


## v0.3.16 (2024-04-21)

### Bug Fixes

- Updated backoff logger
  ([`c0497ee`](https://github.com/MountainGod2/chaturbate_poller/commit/c0497ee946d6e6f253d29bef820d3c314df1129d))

### Build System

- Changed broken workflow path
  ([`5b567fa`](https://github.com/MountainGod2/chaturbate_poller/commit/5b567fa522a5f163b3fb50f26c1d95f1fa5aca5d))

- Disable failing sonar scan
  ([`dc42bc3`](https://github.com/MountainGod2/chaturbate_poller/commit/dc42bc3c2a2121f22ee338b39eea1f343bbe1a34))

- Fix broken build
  ([`9d59bde`](https://github.com/MountainGod2/chaturbate_poller/commit/9d59bde26803150cb00c61ffb1a0d88b827ed82e))

- Update sonar coverage location
  ([`7fdf198`](https://github.com/MountainGod2/chaturbate_poller/commit/7fdf198ca5f1a53fc4291a59a3fc586799df79ea))

- Update SonarCloud workflow
  ([`d228255`](https://github.com/MountainGod2/chaturbate_poller/commit/d2282559ebe6ed608ef462d9fb366efdf73e108c))

- Updated build workflow
  ([`49d791c`](https://github.com/MountainGod2/chaturbate_poller/commit/49d791ca3f8e2e22225c00f66ea6042301d367d4))

### Continuous Integration

- Update pytest action
  ([`cc14a3b`](https://github.com/MountainGod2/chaturbate_poller/commit/cc14a3ba87d6c166b90e20f8029d319ada8cce70))

### Documentation

- Update badges and sonar properties
  ([`2332e92`](https://github.com/MountainGod2/chaturbate_poller/commit/2332e9282fc0c372d1d062f25cb7524d08b15792))

### Testing

- Refactored tests and updated .gitignore
  ([`086a61d`](https://github.com/MountainGod2/chaturbate_poller/commit/086a61d691a5cf62b05cea255bcf81b66456098b))


## v0.3.15 (2024-04-16)

### Bug Fixes

- Remove unused argument
  ([`e9c315a`](https://github.com/MountainGod2/chaturbate_poller/commit/e9c315a6e5e1ca719aaf40b7e5e974e0163d21a0))

### Documentation

- Update README.md formatting
  ([`173d405`](https://github.com/MountainGod2/chaturbate_poller/commit/173d4053e774e1f3730530e3a61ee0280bcc2a9a))

### Testing

- Updated initialization tests
  ([`1372d0f`](https://github.com/MountainGod2/chaturbate_poller/commit/1372d0f6235dc36688245c5d7980ac0a91bd6a2f))


## v0.3.14 (2024-04-15)

### Bug Fixes

- Corrected python version in .readthedocs.yml
  ([`c6c8135`](https://github.com/MountainGod2/chaturbate_poller/commit/c6c8135c58d5076e59df5ac80c4235eb74fc5bdf))


## v0.3.13 (2024-04-15)

### Bug Fixes

- Updated workflows and restructured docs
  ([`2c0dbcc`](https://github.com/MountainGod2/chaturbate_poller/commit/2c0dbcc9bea8c4152dd28ea03af46604dacd1ff5))

### Build System

- Update myst-nb versioning
  ([`6b1ee57`](https://github.com/MountainGod2/chaturbate_poller/commit/6b1ee57af40ea3f912fc1f3ccccfe001a5331571))

- Update versions
  ([`557ca01`](https://github.com/MountainGod2/chaturbate_poller/commit/557ca01a540e99b4221c9a7c20f324976d78af8b))

- Updated dependabot.yml location
  ([`3323bf1`](https://github.com/MountainGod2/chaturbate_poller/commit/3323bf165b179ddb7c9447b69d31ee39527a59f4))

- Updated pyproject.toml
  ([`7bbf133`](https://github.com/MountainGod2/chaturbate_poller/commit/7bbf1331330d5fadc4454febb623df8919a650b0))

### Documentation

- Added .readthedocs.yaml
  ([`0b178bf`](https://github.com/MountainGod2/chaturbate_poller/commit/0b178bf9cb19ef407b4138cff404fb56c3f0c21f))

- Added badges to README
  ([`319a4e9`](https://github.com/MountainGod2/chaturbate_poller/commit/319a4e95a86793bac97cc559ba48cbd94d09b4a4))

- Added docs group in pyproject.toml
  ([`8d3a733`](https://github.com/MountainGod2/chaturbate_poller/commit/8d3a73389785eddf19a5aee1ccb955fb5ba25b09))

- Bumped required python version
  ([`6693393`](https://github.com/MountainGod2/chaturbate_poller/commit/66933930760de5297f872efd1630d5c8a9f5ed18))

- Update .readthedocs.yaml
  ([`97fd0a3`](https://github.com/MountainGod2/chaturbate_poller/commit/97fd0a31645f2384b066e6bfe389d9fd8ea5dd63))

- Update .readthedocs.yaml
  ([`4720be2`](https://github.com/MountainGod2/chaturbate_poller/commit/4720be276947c746fc546166efd01b851a4d25d6))

- Updated .readthedocs.yaml
  ([`b305368`](https://github.com/MountainGod2/chaturbate_poller/commit/b305368e84b70be2d6984ead8b9872d8e10272fc))

- Updated .readthedocs.yaml
  ([`3cb901a`](https://github.com/MountainGod2/chaturbate_poller/commit/3cb901aaf27f642faa2975dcc6099f2d78352a04))

- Updated .readthedocs.yaml
  ([`6301fba`](https://github.com/MountainGod2/chaturbate_poller/commit/6301fba987037b82a4c5ae50e20f79550e9a0190))

- Updated .readthedocs.yaml
  ([`931356a`](https://github.com/MountainGod2/chaturbate_poller/commit/931356af38899e3c6d2cbfde2c92ebc74612baef))

- Updated .readthedocs.yml
  ([`beb5dc0`](https://github.com/MountainGod2/chaturbate_poller/commit/beb5dc0c4dd45daa958f2f57a843da49bc212f3a))

- Updated ci-cd badge
  ([`953a48d`](https://github.com/MountainGod2/chaturbate_poller/commit/953a48dc9cab16add3af68f626483a2abb445c60))

- Updated versions for doc building
  ([`e4555a8`](https://github.com/MountainGod2/chaturbate_poller/commit/e4555a877de637e8c30a93a63dc2b23266a8c58a))


## v0.3.12 (2024-04-15)

### Bug Fixes

- Corrected backoff on exception
  ([`ef2a686`](https://github.com/MountainGod2/chaturbate_poller/commit/ef2a6862a06ba9c8cc5c36b963c4a94c9bb9e954))

- Updated models.py to define appropriate fields as being optional
  ([`f5e6240`](https://github.com/MountainGod2/chaturbate_poller/commit/f5e624086e3c84f22bc2d5fb0436f6d0f1e8e9a5))

### Documentation

- Added ci-cd badge to README
  ([`245662c`](https://github.com/MountainGod2/chaturbate_poller/commit/245662c020dfb9178b7675bfba8762e2cf111ce9))

- Update example in README
  ([`761a3d5`](https://github.com/MountainGod2/chaturbate_poller/commit/761a3d51996071336e38378b6b602503b0c2386e))

- Updated markdown for example code in README
  ([`0149f71`](https://github.com/MountainGod2/chaturbate_poller/commit/0149f71310a54214d43c673ee489921c6f220bf0))

### Refactoring

- Updated backoff logic
  ([`fb1b171`](https://github.com/MountainGod2/chaturbate_poller/commit/fb1b17119f4757b0b40b2513616c136f537abe27))

- Updated event_handler to use logging instead of printing messages
  ([`f0201fc`](https://github.com/MountainGod2/chaturbate_poller/commit/f0201fcdce635ed36e340f419d11a3909356e378))


## v0.3.11 (2024-04-14)

### Bug Fixes

- Updated backoff logic and updated logging
  ([`0f12c7d`](https://github.com/MountainGod2/chaturbate_poller/commit/0f12c7db530fc7cfe5a4edd28cf39b4e00d93ae4))

### Documentation

- Update examples/
  ([`30cd5ca`](https://github.com/MountainGod2/chaturbate_poller/commit/30cd5ca5298e19b7ecefa86bbdb809832a5f65ed))

### Refactoring

- Adjusted constants and updated exception handling
  ([`df34514`](https://github.com/MountainGod2/chaturbate_poller/commit/df3451466e2583ca60abf024c54b6508bd7d1cb5))

- Updated next_url typing in models.py
  ([`c3cca0c`](https://github.com/MountainGod2/chaturbate_poller/commit/c3cca0c1eb1410275b89d13f56ba62c3a19c01d4))

### Testing

- Added test logs to .gitignore
  ([`29f518c`](https://github.com/MountainGod2/chaturbate_poller/commit/29f518c894fc0cd40afebd96b21f3102720ccf42))

- Update tests logic
  ([`e6ded44`](https://github.com/MountainGod2/chaturbate_poller/commit/e6ded44e47518902a79a74b36a03dae527fac28e))


## v0.3.10 (2024-04-12)

### Bug Fixes

- Adjust backoff log level and refactor client instantiation
  ([`32df166`](https://github.com/MountainGod2/chaturbate_poller/commit/32df16618ad1e6a1ba1c07a83fa218f4889ff279))


## v0.3.9 (2024-04-11)

### Bug Fixes

- Update tests and added raise ValueError for 401 responses
  ([`6956095`](https://github.com/MountainGod2/chaturbate_poller/commit/6956095c2997d2a9dc1ffafdd598b8c45967f4f0))


## v0.3.8 (2024-04-11)

### Bug Fixes

- Changed URL default and added argument to allow the use of the testbed URL for development
  ([`17b074d`](https://github.com/MountainGod2/chaturbate_poller/commit/17b074d1925b93d76170122f67135bb2b6590d58))


## v0.3.7 (2024-04-11)

### Bug Fixes

- Modified http error codes to use an enum
  ([`d67e3ce`](https://github.com/MountainGod2/chaturbate_poller/commit/d67e3ced6c80259901e4f9098099a4157d9cd7be))

### Testing

- Added formatting tests into test_chaturbate_poller.py
  ([`4dd6206`](https://github.com/MountainGod2/chaturbate_poller/commit/4dd6206773d229aee54fe8b9908f1948541fc1a5))


## v0.3.6 (2024-04-10)

### Bug Fixes

- Correct typing and format code
  ([`9cd7688`](https://github.com/MountainGod2/chaturbate_poller/commit/9cd768811402c9a428541b661708eb904071201f))

### Testing

- Refactored test_format_message.py
  ([`4bca906`](https://github.com/MountainGod2/chaturbate_poller/commit/4bca9064657fae333e7a81a881e978a594f7e281))


## v0.3.5 (2024-04-10)

### Bug Fixes

- Added format_messages.py and updated tests
  ([`e57fa63`](https://github.com/MountainGod2/chaturbate_poller/commit/e57fa63c7bd7929f3a4d54970cabb9dda915650b))


## v0.3.4 (2024-04-09)

### Bug Fixes

- Rename files and add logs to .gitignore
  ([`43ed001`](https://github.com/MountainGod2/chaturbate_poller/commit/43ed001ce0e73d14ce05a2476e5084b232347b1e))


## v0.3.3 (2024-04-09)

### Bug Fixes

- Refactored models and added test coverage
  ([`aa69183`](https://github.com/MountainGod2/chaturbate_poller/commit/aa691832303cadeef6cc1ea650c7e23ebecb2014))


## v0.3.2 (2024-04-08)

### Bug Fixes

- Update examples and refactor logging
  ([`47f9208`](https://github.com/MountainGod2/chaturbate_poller/commit/47f92086978ed0344c5d3c3cd70652755b90a8be))


## v0.3.1 (2024-04-07)

### Bug Fixes

- Refactor package and update README.md
  ([`bea835a`](https://github.com/MountainGod2/chaturbate_poller/commit/bea835a387df9775b5274cdacba7f00a14e48c2f))


## v0.3.0 (2024-04-07)

### Features

- Refactored modules and updated docstrings
  ([`17a3a8b`](https://github.com/MountainGod2/chaturbate_poller/commit/17a3a8bb35082da36df87cc1f1031115e9b6f320))

### Testing

- Adjust timeout for test_main.py
  ([`0a3ac67`](https://github.com/MountainGod2/chaturbate_poller/commit/0a3ac673780d7157159121e0917d6970c115078c))


## v0.2.0 (2024-04-04)

### Features

- Refactor chaturbate_poller.py and tests
  ([`99ebad1`](https://github.com/MountainGod2/chaturbate_poller/commit/99ebad18244d69ad6deb1ab436f06be6df369ce9))

### Testing

- Added additional tests to test_main.py
  ([`11dafde`](https://github.com/MountainGod2/chaturbate_poller/commit/11dafde7c0b4ef2afe7a11b4b46e1c205f3dd70b))

- Refactor test_chaturbate_poller.py
  ([`12001bd`](https://github.com/MountainGod2/chaturbate_poller/commit/12001bd1b41d2e3a7a9443e1660f5292d9531a49))


## v0.1.4 (2024-04-03)

### Bug Fixes

- Fixed tests and updated workflows
  ([`0793ff6`](https://github.com/MountainGod2/chaturbate_poller/commit/0793ff686397032f99d7e3155db84003098c488f))

### Testing

- Added user env's to ci-cd.yml test
  ([`4fa745c`](https://github.com/MountainGod2/chaturbate_poller/commit/4fa745c2581e393e2b815962a72fc007f33827ef))

- Update ci-cd.yml
  ([`bb2850b`](https://github.com/MountainGod2/chaturbate_poller/commit/bb2850b8e38d035c52f70a2037bf57fd1433d658))

- Update ci-cd.yml
  ([`2882e5e`](https://github.com/MountainGod2/chaturbate_poller/commit/2882e5e8d6e09440833c19b734aa089fc657be9d))

- Update ci-cd.yml
  ([`94c4f65`](https://github.com/MountainGod2/chaturbate_poller/commit/94c4f652da65855e837492fa13c1f1c66bd864f1))

- Update test_main.py
  ([`6252a3a`](https://github.com/MountainGod2/chaturbate_poller/commit/6252a3a76310fa947cb9fbe4e1e3dd81b7e59b7a))

- Update test_main.py
  ([`c9b932a`](https://github.com/MountainGod2/chaturbate_poller/commit/c9b932a7c3fec214ff197dbf60a960627050cdbb))

- Updated ci-cd.yml
  ([`b0dad36`](https://github.com/MountainGod2/chaturbate_poller/commit/b0dad362fcd21d99bca607b4a90783be31497018))


## v0.1.3 (2024-04-02)

### Bug Fixes

- Correct test_main.py python path
  ([`be8b38f`](https://github.com/MountainGod2/chaturbate_poller/commit/be8b38f8846b3fcdb8ee7a3b62a70a9f65757fb5))

### Build System

- Added CodeQL to ci-cd.yml
  ([`a63da4c`](https://github.com/MountainGod2/chaturbate_poller/commit/a63da4ce25575c81978a02fd692ab93aa337d8cd))

- Added dependabot.yml
  ([`d33aca9`](https://github.com/MountainGod2/chaturbate_poller/commit/d33aca9b40d097f3e12c4b70ec2880c5669222b3))

- Added poetry to dev group dependencies and update poetry.lock
  ([`92cb07f`](https://github.com/MountainGod2/chaturbate_poller/commit/92cb07f179858d6437304aacc3a1f859ce0aa6f3))

- Moved codeql.yml to it's own file
  ([`c967b3e`](https://github.com/MountainGod2/chaturbate_poller/commit/c967b3e5104c1adf2dbb162c6bd956def153301e))

- Update ci-cd.yml
  ([`77c3f93`](https://github.com/MountainGod2/chaturbate_poller/commit/77c3f93d83c7e2928b704ba65b2013cf15715bd8))

### Documentation

- Added SECURITY.md
  ([`2a2785d`](https://github.com/MountainGod2/chaturbate_poller/commit/2a2785d60928caa4fbeed139c910a4d05e977f66))

### Testing

- Added additional coverage for test_main.py
  ([`9f0e075`](https://github.com/MountainGod2/chaturbate_poller/commit/9f0e075266d4cc581442a820a26ba8832c08f05f))

- Added additional coverage for test_main.py
  ([`9b2a0da`](https://github.com/MountainGod2/chaturbate_poller/commit/9b2a0da66152d4306fc9b44d0f7f21f08ac2473e))

- Adjust test_main.py
  ([`2bd6647`](https://github.com/MountainGod2/chaturbate_poller/commit/2bd6647b9ebd5dd552e6493af123b79f0f73ce35))

- Another attempt at fixing the pytest path in ci-cd.yml
  ([`ec55a22`](https://github.com/MountainGod2/chaturbate_poller/commit/ec55a229f6e90957844bc04977cd2a97ab343890))

- Fix python path in test_main.py causing ci to fail
  ([`155cce0`](https://github.com/MountainGod2/chaturbate_poller/commit/155cce072db2a99218923239ef32395cda9ae8bf))

- Fix ruff exceptions
  ([`172e7db`](https://github.com/MountainGod2/chaturbate_poller/commit/172e7dbcd481f350cd54965ee9a9ae72d7dc28f1))

- Fix ruff exceptions after formatting causing ci to fail
  ([`8d86d5f`](https://github.com/MountainGod2/chaturbate_poller/commit/8d86d5f01590dce490947bdd166e33697e40180d))

- Try to fix test_main.py and ci-cd.yml testing
  ([`6cff5b4`](https://github.com/MountainGod2/chaturbate_poller/commit/6cff5b4ca07da3be2e46a30f1f07866dff193ed9))

- Update ci-cd.yml and test_main.py
  ([`54254c2`](https://github.com/MountainGod2/chaturbate_poller/commit/54254c25b546d6a947a0ef915c2b6b6d9478af26))


## v0.1.2 (2024-04-01)

### Bug Fixes

- Update links to repository and docs in pyproject.toml
  ([`3003d16`](https://github.com/MountainGod2/chaturbate_poller/commit/3003d16c9be5d1c25f30e91c1b2a0912475a904e))


## v0.1.1 (2024-04-01)

### Bug Fixes

- Update imports in chaturbate_poller.py
  ([`ade470f`](https://github.com/MountainGod2/chaturbate_poller/commit/ade470f0c2a89361b1fdd32d2ba5a7ee232c6757))

### Build System

- Fix ruff actions
  ([`fbaf8e7`](https://github.com/MountainGod2/chaturbate_poller/commit/fbaf8e7bd3fa58dff2a5157b9005442d080bd7be))

- Update ci-cd.yml to include ruff formatting and linting
  ([`c44acdf`](https://github.com/MountainGod2/chaturbate_poller/commit/c44acdf132220b3668abf81d4a5468720049ec31))

### Testing

- Update test_chaturbate_poller.py
  ([`1cc1855`](https://github.com/MountainGod2/chaturbate_poller/commit/1cc1855d263b6165d568ed6fe38364fe0db925c7))


## v0.1.0 (2024-03-31)

### Build System

- Updated documation build action in ci-cd.yml to ensure all files are updated
  ([`9d679ed`](https://github.com/MountainGod2/chaturbate_poller/commit/9d679ede55fce85d8b2254e88695c4a824cf9335))

### Documentation

- Update README.md
  ([`3f7241f`](https://github.com/MountainGod2/chaturbate_poller/commit/3f7241fb5dfcd0ed15cbc9e10fb67979bd484f80))

### Features

- Add codecov to ci-cd.yml
  ([`9973692`](https://github.com/MountainGod2/chaturbate_poller/commit/9973692f6cea70ea1e64b18a9e3b7cbfa59a4f8a))


## v0.0.1 (2024-03-31)

### Bug Fixes

- Add python-semantic-release to requirements
  ([`1c67a65`](https://github.com/MountainGod2/chaturbate_poller/commit/1c67a658b414202372a01c18cda21c0262622a68))


## v0.0.0 (2024-03-31)
