"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotwireless = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotwireless extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotwireless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoreforlorawan.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotwireless';
        this.accessLevelList = {
            Write: [
                'AssociateAwsAccountWithPartnerAccount',
                'AssociateMulticastGroupWithFuotaTask',
                'AssociateWirelessDeviceWithFuotaTask',
                'AssociateWirelessDeviceWithMulticastGroup',
                'AssociateWirelessDeviceWithThing',
                'AssociateWirelessGatewayWithCertificate',
                'AssociateWirelessGatewayWithThing',
                'CancelMulticastGroupSession',
                'CreateDestination',
                'CreateDeviceProfile',
                'CreateFuotaTask',
                'CreateMulticastGroup',
                'CreateNetworkAnalyzerConfiguration',
                'CreateServiceProfile',
                'CreateWirelessDevice',
                'CreateWirelessGateway',
                'CreateWirelessGatewayTask',
                'CreateWirelessGatewayTaskDefinition',
                'DeleteDestination',
                'DeleteDeviceProfile',
                'DeleteFuotaTask',
                'DeleteMulticastGroup',
                'DeleteNetworkAnalyzerConfiguration',
                'DeleteQueuedMessages',
                'DeleteServiceProfile',
                'DeleteWirelessDevice',
                'DeleteWirelessGateway',
                'DeleteWirelessGatewayTask',
                'DeleteWirelessGatewayTaskDefinition',
                'DisassociateAwsAccountFromPartnerAccount',
                'DisassociateMulticastGroupFromFuotaTask',
                'DisassociateWirelessDeviceFromFuotaTask',
                'DisassociateWirelessDeviceFromMulticastGroup',
                'DisassociateWirelessDeviceFromThing',
                'DisassociateWirelessGatewayFromCertificate',
                'DisassociateWirelessGatewayFromThing',
                'PutResourceLogLevel',
                'ResetAllResourceLogLevels',
                'ResetResourceLogLevel',
                'SendDataToMulticastGroup',
                'SendDataToWirelessDevice',
                'StartBulkAssociateWirelessDeviceWithMulticastGroup',
                'StartBulkDisassociateWirelessDeviceFromMulticastGroup',
                'StartFuotaTask',
                'StartMulticastGroupSession',
                'StartNetworkAnalyzerStream',
                'TestWirelessDevice',
                'UpdateDestination',
                'UpdateEventConfigurationByResourceTypes',
                'UpdateFuotaTask',
                'UpdateLogLevelsByResourceTypes',
                'UpdateMulticastGroup',
                'UpdateNetworkAnalyzerConfiguration',
                'UpdatePartnerAccount',
                'UpdateResourceEventConfiguration',
                'UpdateWirelessDevice',
                'UpdateWirelessGateway'
            ],
            Read: [
                'GetDestination',
                'GetDeviceProfile',
                'GetEventConfigurationByResourceTypes',
                'GetFuotaTask',
                'GetLogLevelsByResourceTypes',
                'GetMulticastGroup',
                'GetMulticastGroupSession',
                'GetNetworkAnalyzerConfiguration',
                'GetPartnerAccount',
                'GetResourceEventConfiguration',
                'GetResourceLogLevel',
                'GetServiceEndpoint',
                'GetServiceProfile',
                'GetWirelessDevice',
                'GetWirelessDeviceStatistics',
                'GetWirelessGateway',
                'GetWirelessGatewayCertificate',
                'GetWirelessGatewayFirmwareInformation',
                'GetWirelessGatewayStatistics',
                'GetWirelessGatewayTask',
                'GetWirelessGatewayTaskDefinition',
                'ListDestinations',
                'ListDeviceProfiles',
                'ListEventConfigurations',
                'ListFuotaTasks',
                'ListMulticastGroups',
                'ListMulticastGroupsByFuotaTask',
                'ListNetworkAnalyzerConfigurations',
                'ListPartnerAccounts',
                'ListQueuedMessages',
                'ListServiceProfiles',
                'ListTagsForResource',
                'ListWirelessDevices',
                'ListWirelessGatewayTaskDefinitions',
                'ListWirelessGateways'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to link partner accounts with Aws account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     */
    toAssociateAwsAccountWithPartnerAccount() {
        return this.to('AssociateAwsAccountWithPartnerAccount');
    }
    /**
     * Grants permission to associate the MulticastGroup with FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateMulticastGroupWithFuotaTask.html
     */
    toAssociateMulticastGroupWithFuotaTask() {
        return this.to('AssociateMulticastGroupWithFuotaTask');
    }
    /**
     * Grants permission to associate the wireless device with FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithFuotaTask.html
     */
    toAssociateWirelessDeviceWithFuotaTask() {
        return this.to('AssociateWirelessDeviceWithFuotaTask');
    }
    /**
     * Grants permission to associate the WirelessDevice with MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithMulticastGroup.html
     */
    toAssociateWirelessDeviceWithMulticastGroup() {
        return this.to('AssociateWirelessDeviceWithMulticastGroup');
    }
    /**
     * Grants permission to associate the wireless device with AWS IoT thing for a given wirelessDeviceId
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessDeviceWithThing.html
     */
    toAssociateWirelessDeviceWithThing() {
        return this.to('AssociateWirelessDeviceWithThing');
    }
    /**
     * Grants permission to associate a WirelessGateway with the IoT Core Identity certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithCertificate.html
     */
    toAssociateWirelessGatewayWithCertificate() {
        return this.to('AssociateWirelessGatewayWithCertificate');
    }
    /**
     * Grants permission to associate the wireless gateway with AWS IoT thing for a given wirelessGatewayId
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateWirelessGatewayWithThing.html
     */
    toAssociateWirelessGatewayWithThing() {
        return this.to('AssociateWirelessGatewayWithThing');
    }
    /**
     * Grants permission to cancel the MulticastGroup session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CancelMulticastGroupSession.html
     */
    toCancelMulticastGroupSession() {
        return this.to('CancelMulticastGroupSession');
    }
    /**
     * Grants permission to create a Destination resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     */
    toCreateDestination() {
        return this.to('CreateDestination');
    }
    /**
     * Grants permission to create a DeviceProfile resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     */
    toCreateDeviceProfile() {
        return this.to('CreateDeviceProfile');
    }
    /**
     * Grants permission to create a FuotaTask resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     */
    toCreateFuotaTask() {
        return this.to('CreateFuotaTask');
    }
    /**
     * Grants permission to create a MulticastGroup resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     */
    toCreateMulticastGroup() {
        return this.to('CreateMulticastGroup');
    }
    /**
     * Grants permission to create a NetworkAnalyzerConfiguration resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateNetworkAnalyzerConfiguration.html
     */
    toCreateNetworkAnalyzerConfiguration() {
        return this.to('CreateNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to create a ServiceProfile resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     */
    toCreateServiceProfile() {
        return this.to('CreateServiceProfile');
    }
    /**
     * Grants permission to create a WirelessDevice resource with given Destination
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     */
    toCreateWirelessDevice() {
        return this.to('CreateWirelessDevice');
    }
    /**
     * Grants permission to create a WirelessGateway resource
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     */
    toCreateWirelessGateway() {
        return this.to('CreateWirelessGateway');
    }
    /**
     * Grants permission to create a task for a given WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTask.html
     */
    toCreateWirelessGatewayTask() {
        return this.to('CreateWirelessGatewayTask');
    }
    /**
     * Grants permission to create a WirelessGateway task definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     */
    toCreateWirelessGatewayTaskDefinition() {
        return this.to('CreateWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to delete a Destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDestination.html
     */
    toDeleteDestination() {
        return this.to('DeleteDestination');
    }
    /**
     * Grants permission to delete a DeviceProfile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteDeviceProfile.html
     */
    toDeleteDeviceProfile() {
        return this.to('DeleteDeviceProfile');
    }
    /**
     * Grants permission to delete the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteFuotaTask.html
     */
    toDeleteFuotaTask() {
        return this.to('DeleteFuotaTask');
    }
    /**
     * Grants permission to delete the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteMulticastGroup.html
     */
    toDeleteMulticastGroup() {
        return this.to('DeleteMulticastGroup');
    }
    /**
     * Grants permission to delete the NetworkAnalyzerConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteNetworkAnalyzerConfiguration.html
     */
    toDeleteNetworkAnalyzerConfiguration() {
        return this.to('DeleteNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to delete QueuedMessages
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteQueuedMessages.html
     */
    toDeleteQueuedMessages() {
        return this.to('DeleteQueuedMessages');
    }
    /**
     * Grants permission to delete a ServiceProfile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteServiceProfile.html
     */
    toDeleteServiceProfile() {
        return this.to('DeleteServiceProfile');
    }
    /**
     * Grants permission to delete a WirelessDevice
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessDevice.html
     */
    toDeleteWirelessDevice() {
        return this.to('DeleteWirelessDevice');
    }
    /**
     * Grants permission to delete a WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGateway.html
     */
    toDeleteWirelessGateway() {
        return this.to('DeleteWirelessGateway');
    }
    /**
     * Grants permission to delete task for a given WirelessGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTask.html
     */
    toDeleteWirelessGatewayTask() {
        return this.to('DeleteWirelessGatewayTask');
    }
    /**
     * Grants permission to delete a WirelessGateway task definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DeleteWirelessGatewayTaskDefinition.html
     */
    toDeleteWirelessGatewayTaskDefinition() {
        return this.to('DeleteWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to disassociate an AWS account from a partner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateAwsAccountFromPartnerAccount.html
     */
    toDisassociateAwsAccountFromPartnerAccount() {
        return this.to('DisassociateAwsAccountFromPartnerAccount');
    }
    /**
     * Grants permission to disassociate the MulticastGroup from FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateMulticastGroupFromFuotaTask.html
     */
    toDisassociateMulticastGroupFromFuotaTask() {
        return this.to('DisassociateMulticastGroupFromFuotaTask');
    }
    /**
     * Grants permission to disassociate the wireless device from FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromFuotaTask.html
     */
    toDisassociateWirelessDeviceFromFuotaTask() {
        return this.to('DisassociateWirelessDeviceFromFuotaTask');
    }
    /**
     * Grants permission to disassociate the wireless device from MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromMulticastGroup.html
     */
    toDisassociateWirelessDeviceFromMulticastGroup() {
        return this.to('DisassociateWirelessDeviceFromMulticastGroup');
    }
    /**
     * Grants permission to disassociate a wireless device from a AWS IoT thing
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessDeviceFromThing.html
     */
    toDisassociateWirelessDeviceFromThing() {
        return this.to('DisassociateWirelessDeviceFromThing');
    }
    /**
     * Grants permission to disassociate a WirelessGateway from a IoT Core Identity certificate
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromCertificate.html
     */
    toDisassociateWirelessGatewayFromCertificate() {
        return this.to('DisassociateWirelessGatewayFromCertificate');
    }
    /**
     * Grants permission to disassociate a WirelessGateway from a IoT Core thing
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iot:DescribeThing
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_DisassociateWirelessGatewayFromThing.html
     */
    toDisassociateWirelessGatewayFromThing() {
        return this.to('DisassociateWirelessGatewayFromThing');
    }
    /**
     * Grants permission to get the Destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDestination.html
     */
    toGetDestination() {
        return this.to('GetDestination');
    }
    /**
     * Grants permission to get the DeviceProfile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetDeviceProfile.html
     */
    toGetDeviceProfile() {
        return this.to('GetDeviceProfile');
    }
    /**
     * Grants permission to get event configuration by resource types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetEventConfigurationByResourceTypes.html
     */
    toGetEventConfigurationByResourceTypes() {
        return this.to('GetEventConfigurationByResourceTypes');
    }
    /**
     * Grants permission to get the FuotaTask
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetFuotaTask.html
     */
    toGetFuotaTask() {
        return this.to('GetFuotaTask');
    }
    /**
     * Grants permission to get log levels by resource types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetLogLevelsByResourceTypes.html
     */
    toGetLogLevelsByResourceTypes() {
        return this.to('GetLogLevelsByResourceTypes');
    }
    /**
     * Grants permission to get the MulticastGroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroup.html
     */
    toGetMulticastGroup() {
        return this.to('GetMulticastGroup');
    }
    /**
     * Grants permission to get the MulticastGroup session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetMulticastGroupSession.html
     */
    toGetMulticastGroupSession() {
        return this.to('GetMulticastGroupSession');
    }
    /**
     * Grants permission to get the NetworkAnalyzerConfiguration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetNetworkAnalyzerConfiguration.html
     */
    toGetNetworkAnalyzerConfiguration() {
        return this.to('GetNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to get the associated PartnerAccount
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetPartnerAccount.html
     */
    toGetPartnerAccount() {
        return this.to('GetPartnerAccount');
    }
    /**
     * Grants permission to get an event configuration for an identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceEventConfiguration.html
     */
    toGetResourceEventConfiguration() {
        return this.to('GetResourceEventConfiguration');
    }
    /**
     * Grants permission to get resource log level
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetResourceLogLevel.html
     */
    toGetResourceLogLevel() {
        return this.to('GetResourceLogLevel');
    }
    /**
     * Grants permission to retrieve the customer account specific endpoint for CUPS protocol connection or LoRaWAN Network Server (LNS) protocol connection, and optionally server trust certificate in PEM format
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceEndpoint.html
     */
    toGetServiceEndpoint() {
        return this.to('GetServiceEndpoint');
    }
    /**
     * Grants permission to get the ServiceProfile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetServiceProfile.html
     */
    toGetServiceProfile() {
        return this.to('GetServiceProfile');
    }
    /**
     * Grants permission to get the WirelessDevice
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDevice.html
     */
    toGetWirelessDevice() {
        return this.to('GetWirelessDevice');
    }
    /**
     * Grants permission to get statistics info for a given WirelessDevice
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessDeviceStatistics.html
     */
    toGetWirelessDeviceStatistics() {
        return this.to('GetWirelessDeviceStatistics');
    }
    /**
     * Grants permission to get the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGateway.html
     */
    toGetWirelessGateway() {
        return this.to('GetWirelessGateway');
    }
    /**
     * Grants permission to get the IoT Core Identity certificate id associated with the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayCertificate.html
     */
    toGetWirelessGatewayCertificate() {
        return this.to('GetWirelessGatewayCertificate');
    }
    /**
     * Grants permission to get Current firmware version and other information for the WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayFirmwareInformation.html
     */
    toGetWirelessGatewayFirmwareInformation() {
        return this.to('GetWirelessGatewayFirmwareInformation');
    }
    /**
     * Grants permission to get statistics info for a given WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayStatistics.html
     */
    toGetWirelessGatewayStatistics() {
        return this.to('GetWirelessGatewayStatistics');
    }
    /**
     * Grants permission to get the task for a given WirelessGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTask.html
     */
    toGetWirelessGatewayTask() {
        return this.to('GetWirelessGatewayTask');
    }
    /**
     * Grants permission to get the given WirelessGateway task definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_GetWirelessGatewayTaskDefinition.html
     */
    toGetWirelessGatewayTaskDefinition() {
        return this.to('GetWirelessGatewayTaskDefinition');
    }
    /**
     * Grants permission to list information of available Destinations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDestinations.html
     */
    toListDestinations() {
        return this.to('ListDestinations');
    }
    /**
     * Grants permission to list information of available DeviceProfiles based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListDeviceProfiles.html
     */
    toListDeviceProfiles() {
        return this.to('ListDeviceProfiles');
    }
    /**
     * Grants permission to list information of available event configurations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListEventConfigurations.html
     */
    toListEventConfigurations() {
        return this.to('ListEventConfigurations');
    }
    /**
     * Grants permission to list information of available FuotaTasks based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListFuotaTasks.html
     */
    toListFuotaTasks() {
        return this.to('ListFuotaTasks');
    }
    /**
     * Grants permission to list information of available MulticastGroups based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroups.html
     */
    toListMulticastGroups() {
        return this.to('ListMulticastGroups');
    }
    /**
     * Grants permission to list information of available MulticastGroups by FuotaTask based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListMulticastGroupsByFuotaTask.html
     */
    toListMulticastGroupsByFuotaTask() {
        return this.to('ListMulticastGroupsByFuotaTask');
    }
    /**
     * Grants permission to list information of available NetworkAnalyzerConfigurations based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListNetworkAnalyzerConfigurations.html
     */
    toListNetworkAnalyzerConfigurations() {
        return this.to('ListNetworkAnalyzerConfigurations');
    }
    /**
     * Grants permission to list the available partner accounts
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListPartnerAccounts.html
     */
    toListPartnerAccounts() {
        return this.to('ListPartnerAccounts');
    }
    /**
     * Grants permission to list the Queued Messages
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListQueuedMessages.html
     */
    toListQueuedMessages() {
        return this.to('ListQueuedMessages');
    }
    /**
     * Grants permission to list information of available ServiceProfiles based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListServiceProfiles.html
     */
    toListServiceProfiles() {
        return this.to('ListServiceProfiles');
    }
    /**
     * Grants permission to list all tags for a given resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list information of available WirelessDevices based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessDevices.html
     */
    toListWirelessDevices() {
        return this.to('ListWirelessDevices');
    }
    /**
     * Grants permission to list information of available WirelessGateway task definitions based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGatewayTaskDefinitions.html
     */
    toListWirelessGatewayTaskDefinitions() {
        return this.to('ListWirelessGatewayTaskDefinitions');
    }
    /**
     * Grants permission to list information of available WirelessGateways based on the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ListWirelessGateways.html
     */
    toListWirelessGateways() {
        return this.to('ListWirelessGateways');
    }
    /**
     * Grants permission to put resource log level
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_PutResourceLogLevel.html
     */
    toPutResourceLogLevel() {
        return this.to('PutResourceLogLevel');
    }
    /**
     * Grants permission to reset all resource log levels
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetAllResourceLogLevels.html
     */
    toResetAllResourceLogLevels() {
        return this.to('ResetAllResourceLogLevels');
    }
    /**
     * Grants permission to reset resource log level
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_ResetResourceLogLevel.html
     */
    toResetResourceLogLevel() {
        return this.to('ResetResourceLogLevel');
    }
    /**
     * Grants permission to send data to the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToMulticastGroup.html
     */
    toSendDataToMulticastGroup() {
        return this.to('SendDataToMulticastGroup');
    }
    /**
     * Grants permission to send the decrypted application data frame to the target device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_SendDataToWirelessDevice.html
     */
    toSendDataToWirelessDevice() {
        return this.to('SendDataToWirelessDevice');
    }
    /**
     * Grants permission to associate the WirelessDevices with MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkAssociateWirelessDeviceWithMulticastGroup.html
     */
    toStartBulkAssociateWirelessDeviceWithMulticastGroup() {
        return this.to('StartBulkAssociateWirelessDeviceWithMulticastGroup');
    }
    /**
     * Grants permission to bulk disassociate the WirelessDevices from MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartBulkDisassociateWirelessDeviceFromMulticastGroup.html
     */
    toStartBulkDisassociateWirelessDeviceFromMulticastGroup() {
        return this.to('StartBulkDisassociateWirelessDeviceFromMulticastGroup');
    }
    /**
     * Grants permission to start the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartFuotaTask.html
     */
    toStartFuotaTask() {
        return this.to('StartFuotaTask');
    }
    /**
     * Grants permission to start the MulticastGroup session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_StartMulticastGroupSession.html
     */
    toStartMulticastGroupSession() {
        return this.to('StartMulticastGroupSession');
    }
    /**
     * Grants permission to start NetworkAnalyzer stream
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/connect-iot-lorawan-network-analyzer-api.html
     */
    toStartNetworkAnalyzerStream() {
        return this.to('StartNetworkAnalyzerStream');
    }
    /**
     * Grants permission to tag a given resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to simulate a provisioned device to send an uplink data with payload of 'Hello'
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_TestWirelessDevice.html
     */
    toTestWirelessDevice() {
        return this.to('TestWirelessDevice');
    }
    /**
     * Grants permission to remove the given tags from the resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a Destination resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateDestination.html
     */
    toUpdateDestination() {
        return this.to('UpdateDestination');
    }
    /**
     * Grants permission to update event configuration by resource types
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateEventConfigurationByResourceTypes.html
     */
    toUpdateEventConfigurationByResourceTypes() {
        return this.to('UpdateEventConfigurationByResourceTypes');
    }
    /**
     * Grants permission to update the FuotaTask
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateFuotaTask.html
     */
    toUpdateFuotaTask() {
        return this.to('UpdateFuotaTask');
    }
    /**
     * Grants permission to update log levels by resource types
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateLogLevelsByResourceTypes.html
     */
    toUpdateLogLevelsByResourceTypes() {
        return this.to('UpdateLogLevelsByResourceTypes');
    }
    /**
     * Grants permission to update the MulticastGroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateMulticastGroup.html
     */
    toUpdateMulticastGroup() {
        return this.to('UpdateMulticastGroup');
    }
    /**
     * Grants permission to update the NetworkAnalyzerConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateNetworkAnalyzerConfiguration.html
     */
    toUpdateNetworkAnalyzerConfiguration() {
        return this.to('UpdateNetworkAnalyzerConfiguration');
    }
    /**
     * Grants permission to update a partner account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdatePartnerAccount.html
     */
    toUpdatePartnerAccount() {
        return this.to('UpdatePartnerAccount');
    }
    /**
     * Grants permission to update an event configuration for an identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateResourceEventConfiguration.html
     */
    toUpdateResourceEventConfiguration() {
        return this.to('UpdateResourceEventConfiguration');
    }
    /**
     * Grants permission to update a WirelessDevice resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessDevice.html
     */
    toUpdateWirelessDevice() {
        return this.to('UpdateWirelessDevice');
    }
    /**
     * Grants permission to update a WirelessGateway resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_UpdateWirelessGateway.html
     */
    toUpdateWirelessGateway() {
        return this.to('UpdateWirelessGateway');
    }
    /**
     * Adds a resource of type WirelessDevice to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessDevice.html
     *
     * @param wirelessDeviceId - Identifier for the wirelessDeviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessDevice(wirelessDeviceId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessDevice/${wirelessDeviceId}`);
    }
    /**
     * Adds a resource of type WirelessGateway to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGateway.html
     *
     * @param wirelessGatewayId - Identifier for the wirelessGatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessGateway(wirelessGatewayId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessGateway/${wirelessGatewayId}`);
    }
    /**
     * Adds a resource of type DeviceProfile to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDeviceProfile.html
     *
     * @param deviceProfileId - Identifier for the deviceProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDeviceProfile(deviceProfileId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:DeviceProfile/${deviceProfileId}`);
    }
    /**
     * Adds a resource of type ServiceProfile to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateServiceProfile.html
     *
     * @param serviceProfileId - Identifier for the serviceProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onServiceProfile(serviceProfileId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:ServiceProfile/${serviceProfileId}`);
    }
    /**
     * Adds a resource of type Destination to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateDestination.html
     *
     * @param destinationName - Identifier for the destinationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDestination(destinationName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:Destination/${destinationName}`);
    }
    /**
     * Adds a resource of type SidewalkAccount to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_AssociateAwsAccountWithPartnerAccount.html
     *
     * @param sidewalkAccountId - Identifier for the sidewalkAccountId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSidewalkAccount(sidewalkAccountId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:SidewalkAccount/${sidewalkAccountId}`);
    }
    /**
     * Adds a resource of type WirelessGatewayTaskDefinition to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateWirelessGatewayTaskDefinition.html
     *
     * @param wirelessGatewayTaskDefinitionId - Identifier for the wirelessGatewayTaskDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWirelessGatewayTaskDefinition(wirelessGatewayTaskDefinitionId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:WirelessGatewayTaskDefinition/${wirelessGatewayTaskDefinitionId}`);
    }
    /**
     * Adds a resource of type FuotaTask to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateFuotaTask.html
     *
     * @param fuotaTaskId - Identifier for the fuotaTaskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFuotaTask(fuotaTaskId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:FuotaTask/${fuotaTaskId}`);
    }
    /**
     * Adds a resource of type MulticastGroup to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateMulticastGroup.html
     *
     * @param multicastGroupId - Identifier for the multicastGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMulticastGroup(multicastGroupId, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:MulticastGroup/${multicastGroupId}`);
    }
    /**
     * Adds a resource of type NetworkAnalyzerConfiguration to the statement
     *
     * https://docs.aws.amazon.com/iot-wireless/2020-11-22/apireference/API_CreateNetworkAnalyzerConfiguration.html
     *
     * @param networkAnalyzerConfigurationName - Identifier for the networkAnalyzerConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkAnalyzerConfiguration(networkAnalyzerConfigurationName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iotwireless:${region || '*'}:${account || '*'}:NetworkAnalyzerConfiguration/${networkAnalyzerConfigurationName}`);
    }
    /**
     * Adds a resource of type thing to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onThing(thingName, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iot:${region || '*'}:${account || '*'}:thing/${thingName}`);
    }
    /**
     * Adds a resource of type cert to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html
     *
     * @param certificate - Identifier for the certificate.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCert(certificate, account, region, partition) {
        return this.on(`arn:${partition || Iotwireless.defaultPartition}:iot:${region || '*'}:${account || '*'}:cert/${certificate}`);
    }
}
exports.Iotwireless = Iotwireless;
_a = JSII_RTTI_SYMBOL_1;
Iotwireless[_a] = { fqn: "iam-floyd.Iotwireless", version: "0.391.0" };
//# sourceMappingURL=data:application/json;base64,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