# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendConfigCaArgs', 'SecretBackendConfigCa']

@pulumi.input_type
class SecretBackendConfigCaArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 pem_bundle: pulumi.Input[str]):
        """
        The set of arguments for constructing a SecretBackendConfigCa resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] pem_bundle: The key and certificate PEM bundle
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "pem_bundle", pem_bundle)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> pulumi.Input[str]:
        """
        The key and certificate PEM bundle
        """
        return pulumi.get(self, "pem_bundle")

    @pem_bundle.setter
    def pem_bundle(self, value: pulumi.Input[str]):
        pulumi.set(self, "pem_bundle", value)


@pulumi.input_type
class _SecretBackendConfigCaState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 pem_bundle: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendConfigCa resources.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] pem_bundle: The key and certificate PEM bundle
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[pulumi.Input[str]]:
        """
        The key and certificate PEM bundle
        """
        return pulumi.get(self, "pem_bundle")

    @pem_bundle.setter
    def pem_bundle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_bundle", value)


class SecretBackendConfigCa(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 pem_bundle: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a SecretBackendConfigCa resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] pem_bundle: The key and certificate PEM bundle
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendConfigCaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SecretBackendConfigCa resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SecretBackendConfigCaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendConfigCaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 pem_bundle: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendConfigCaArgs.__new__(SecretBackendConfigCaArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if pem_bundle is None and not opts.urn:
                raise TypeError("Missing required property 'pem_bundle'")
            __props__.__dict__["pem_bundle"] = pem_bundle
        super(SecretBackendConfigCa, __self__).__init__(
            'vault:pkiSecret/secretBackendConfigCa:SecretBackendConfigCa',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            pem_bundle: Optional[pulumi.Input[str]] = None) -> 'SecretBackendConfigCa':
        """
        Get an existing SecretBackendConfigCa resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] pem_bundle: The key and certificate PEM bundle
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendConfigCaState.__new__(_SecretBackendConfigCaState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["pem_bundle"] = pem_bundle
        return SecretBackendConfigCa(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> pulumi.Output[str]:
        """
        The key and certificate PEM bundle
        """
        return pulumi.get(self, "pem_bundle")

