import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 */
export interface CfnListenerProps {
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     * @external
     */
    readonly defaultActions: Array<CfnListener.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     * @external
     */
    readonly loadBalancerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     * @external
     */
    readonly port: number;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     * @external
     */
    readonly protocol: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.AlpnPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy
     * @external
     */
    readonly alpnPolicy?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     * @external
     */
    readonly certificates?: Array<CfnListener.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     * @external
     */
    readonly sslPolicy?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare class CfnListener extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::Listener";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListener;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.DefaultActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-defaultactions
     * @external
     */
    defaultActions: Array<CfnListener.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.LoadBalancerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-loadbalancerarn
     * @external
     */
    loadBalancerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-port
     * @external
     */
    port: number;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-protocol
     * @external
     */
    protocol: string;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.AlpnPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-alpnpolicy
     * @external
     */
    alpnPolicy: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.Certificates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-certificates
     * @external
     */
    certificates: Array<CfnListener.CertificateProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::Listener.SslPolicy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html#cfn-elasticloadbalancingv2-listener-sslpolicy
     * @external
     */
    sslPolicy: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::Listener`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         * @external
         */
        readonly authenticateCognitoConfig?: CfnListener.AuthenticateCognitoConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.AuthenticateOidcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         * @external
         */
        readonly authenticateOidcConfig?: CfnListener.AuthenticateOidcConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.FixedResponseConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         * @external
         */
        readonly fixedResponseConfig?: CfnListener.FixedResponseConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.ForwardConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-forwardconfig
         * @external
         */
        readonly forwardConfig?: CfnListener.ForwardConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.Order`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         * @external
         */
        readonly order?: number;
        /**
         * `CfnListener.ActionProperty.RedirectConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         * @external
         */
        readonly redirectConfig?: CfnListener.RedirectConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ActionProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListener.ActionProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html
     * @external
     */
    interface AuthenticateCognitoConfigProperty {
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         * @external
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         * @external
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         * @external
         */
        readonly scope?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         * @external
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         * @external
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         * @external
         */
        readonly userPoolArn: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         * @external
         */
        readonly userPoolClientId: string;
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         * @external
         */
        readonly userPoolDomain: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html
     * @external
     */
    interface AuthenticateOidcConfigProperty {
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         * @external
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         * @external
         */
        readonly authorizationEndpoint: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         * @external
         */
        readonly issuer: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         * @external
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Scope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         * @external
         */
        readonly scope?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         * @external
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         * @external
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         * @external
         */
        readonly tokenEndpoint: string;
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         * @external
         */
        readonly userInfoEndpoint: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     * @external
     */
    interface CertificateProperty {
        /**
         * `CfnListener.CertificateProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         * @external
         */
        readonly certificateArn?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html
     * @external
     */
    interface FixedResponseConfigProperty {
        /**
         * `CfnListener.FixedResponseConfigProperty.ContentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         * @external
         */
        readonly contentType?: string;
        /**
         * `CfnListener.FixedResponseConfigProperty.MessageBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         * @external
         */
        readonly messageBody?: string;
        /**
         * `CfnListener.FixedResponseConfigProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html
     * @external
     */
    interface ForwardConfigProperty {
        /**
         * `CfnListener.ForwardConfigProperty.TargetGroupStickinessConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroupstickinessconfig
         * @external
         */
        readonly targetGroupStickinessConfig?: CfnListener.TargetGroupStickinessConfigProperty | cdk.IResolvable;
        /**
         * `CfnListener.ForwardConfigProperty.TargetGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-forwardconfig.html#cfn-elasticloadbalancingv2-listener-forwardconfig-targetgroups
         * @external
         */
        readonly targetGroups?: Array<CfnListener.TargetGroupTupleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html
     * @external
     */
    interface RedirectConfigProperty {
        /**
         * `CfnListener.RedirectConfigProperty.Host`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         * @external
         */
        readonly host?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         * @external
         */
        readonly port?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnListener.RedirectConfigProperty.Query`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         * @external
         */
        readonly query?: string;
        /**
         * `CfnListener.RedirectConfigProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html
     * @external
     */
    interface TargetGroupStickinessConfigProperty {
        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.DurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-durationseconds
         * @external
         */
        readonly durationSeconds?: number;
        /**
         * `CfnListener.TargetGroupStickinessConfigProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listener-targetgroupstickinessconfig-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::Listener
 */
export declare namespace CfnListener {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html
     * @external
     */
    interface TargetGroupTupleProperty {
        /**
         * `CfnListener.TargetGroupTupleProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListener.TargetGroupTupleProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-targetgrouptuple.html#cfn-elasticloadbalancingv2-listener-targetgrouptuple-weight
         * @external
         */
        readonly weight?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 * @external
 */
export interface CfnListenerCertificateProps {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     * @external
     */
    readonly certificates: Array<CfnListenerCertificate.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     * @external
     */
    readonly listenerArn: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerCertificate
 */
export declare class CfnListenerCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::ListenerCertificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListenerCertificate;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     * @external
     */
    certificates: Array<CfnListenerCertificate.CertificateProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     * @external
     */
    listenerArn: string;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerCertificate
 */
export declare namespace CfnListenerCertificate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     * @external
     */
    interface CertificateProperty {
        /**
         * `CfnListenerCertificate.CertificateProperty.CertificateArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         * @external
         */
        readonly certificateArn?: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 */
export interface CfnListenerRuleProps {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     * @external
     */
    readonly actions: Array<CfnListenerRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     * @external
     */
    readonly conditions: Array<CfnListenerRule.RuleConditionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     * @external
     */
    readonly listenerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     * @external
     */
    readonly priority: number;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare class CfnListenerRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::ListenerRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnListenerRule;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Actions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions
     * @external
     */
    actions: Array<CfnListenerRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Conditions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions
     * @external
     */
    conditions: Array<CfnListenerRule.RuleConditionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.ListenerArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn
     * @external
     */
    listenerArn: string;
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerRule.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority
     * @external
     */
    priority: number;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::ListenerRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnListenerRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateCognitoConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig
         * @external
         */
        readonly authenticateCognitoConfig?: CfnListenerRule.AuthenticateCognitoConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.AuthenticateOidcConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig
         * @external
         */
        readonly authenticateOidcConfig?: CfnListenerRule.AuthenticateOidcConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.FixedResponseConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig
         * @external
         */
        readonly fixedResponseConfig?: CfnListenerRule.FixedResponseConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.ForwardConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-forwardconfig
         * @external
         */
        readonly forwardConfig?: CfnListenerRule.ForwardConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.Order`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-order
         * @external
         */
        readonly order?: number;
        /**
         * `CfnListenerRule.ActionProperty.RedirectConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig
         * @external
         */
        readonly redirectConfig?: CfnListenerRule.RedirectConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ActionProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListenerRule.ActionProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-actions.html#cfn-elasticloadbalancingv2-listener-actions-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html
     * @external
     */
    interface AuthenticateCognitoConfigProperty {
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams
         * @external
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest
         * @external
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.Scope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope
         * @external
         */
        readonly scope?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionCookieName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename
         * @external
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.SessionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout
         * @external
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn
         * @external
         */
        readonly userPoolArn: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid
         * @external
         */
        readonly userPoolClientId: string;
        /**
         * `CfnListenerRule.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain
         * @external
         */
        readonly userPoolDomain: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html
     * @external
     */
    interface AuthenticateOidcConfigProperty {
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams
         * @external
         */
        readonly authenticationRequestExtraParams?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint
         * @external
         */
        readonly authorizationEndpoint: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Issuer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer
         * @external
         */
        readonly issuer: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest
         * @external
         */
        readonly onUnauthenticatedRequest?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.Scope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope
         * @external
         */
        readonly scope?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionCookieName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename
         * @external
         */
        readonly sessionCookieName?: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.SessionTimeout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout
         * @external
         */
        readonly sessionTimeout?: number;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.TokenEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint
         * @external
         */
        readonly tokenEndpoint: string;
        /**
         * `CfnListenerRule.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint
         * @external
         */
        readonly userInfoEndpoint: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html
     * @external
     */
    interface FixedResponseConfigProperty {
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.ContentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype
         * @external
         */
        readonly contentType?: string;
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.MessageBody`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody
         * @external
         */
        readonly messageBody?: string;
        /**
         * `CfnListenerRule.FixedResponseConfigProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html
     * @external
     */
    interface ForwardConfigProperty {
        /**
         * `CfnListenerRule.ForwardConfigProperty.TargetGroupStickinessConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroupstickinessconfig
         * @external
         */
        readonly targetGroupStickinessConfig?: CfnListenerRule.TargetGroupStickinessConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.ForwardConfigProperty.TargetGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroups
         * @external
         */
        readonly targetGroups?: Array<CfnListenerRule.TargetGroupTupleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html
     * @external
     */
    interface HostHeaderConfigProperty {
        /**
         * `CfnListenerRule.HostHeaderConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html
     * @external
     */
    interface HttpHeaderConfigProperty {
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.HttpHeaderName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername
         * @external
         */
        readonly httpHeaderName?: string;
        /**
         * `CfnListenerRule.HttpHeaderConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html
     * @external
     */
    interface HttpRequestMethodConfigProperty {
        /**
         * `CfnListenerRule.HttpRequestMethodConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html
     * @external
     */
    interface PathPatternConfigProperty {
        /**
         * `CfnListenerRule.PathPatternConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html
     * @external
     */
    interface QueryStringConfigProperty {
        /**
         * `CfnListenerRule.QueryStringConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values
         * @external
         */
        readonly values?: Array<CfnListenerRule.QueryStringKeyValueProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html
     * @external
     */
    interface QueryStringKeyValueProperty {
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnListenerRule.QueryStringKeyValueProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html
     * @external
     */
    interface RedirectConfigProperty {
        /**
         * `CfnListenerRule.RedirectConfigProperty.Host`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host
         * @external
         */
        readonly host?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port
         * @external
         */
        readonly port?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Protocol`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol
         * @external
         */
        readonly protocol?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.Query`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query
         * @external
         */
        readonly query?: string;
        /**
         * `CfnListenerRule.RedirectConfigProperty.StatusCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode
         * @external
         */
        readonly statusCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html
     * @external
     */
    interface RuleConditionProperty {
        /**
         * `CfnListenerRule.RuleConditionProperty.Field`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-field
         * @external
         */
        readonly field?: string;
        /**
         * `CfnListenerRule.RuleConditionProperty.HostHeaderConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig
         * @external
         */
        readonly hostHeaderConfig?: CfnListenerRule.HostHeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpHeaderConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig
         * @external
         */
        readonly httpHeaderConfig?: CfnListenerRule.HttpHeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.HttpRequestMethodConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig
         * @external
         */
        readonly httpRequestMethodConfig?: CfnListenerRule.HttpRequestMethodConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.PathPatternConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig
         * @external
         */
        readonly pathPatternConfig?: CfnListenerRule.PathPatternConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.QueryStringConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig
         * @external
         */
        readonly queryStringConfig?: CfnListenerRule.QueryStringConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.SourceIpConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig
         * @external
         */
        readonly sourceIpConfig?: CfnListenerRule.SourceIpConfigProperty | cdk.IResolvable;
        /**
         * `CfnListenerRule.RuleConditionProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-conditions.html#cfn-elasticloadbalancingv2-listenerrule-conditions-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html
     * @external
     */
    interface SourceIpConfigProperty {
        /**
         * `CfnListenerRule.SourceIpConfigProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html
     * @external
     */
    interface TargetGroupStickinessConfigProperty {
        /**
         * `CfnListenerRule.TargetGroupStickinessConfigProperty.DurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-durationseconds
         * @external
         */
        readonly durationSeconds?: number;
        /**
         * `CfnListenerRule.TargetGroupStickinessConfigProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::ListenerRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::ListenerRule
 */
export declare namespace CfnListenerRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html
     * @external
     */
    interface TargetGroupTupleProperty {
        /**
         * `CfnListenerRule.TargetGroupTupleProperty.TargetGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-targetgrouparn
         * @external
         */
        readonly targetGroupArn?: string;
        /**
         * `CfnListenerRule.TargetGroupTupleProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-weight
         * @external
         */
        readonly weight?: number;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 * @external
 */
export interface CfnLoadBalancerProps {
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     * @external
     */
    readonly ipAddressType?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     * @external
     */
    readonly loadBalancerAttributes?: Array<CfnLoadBalancer.LoadBalancerAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     * @external
     */
    readonly scheme?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     * @external
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     * @external
     */
    readonly subnetMappings?: Array<CfnLoadBalancer.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     * @external
     */
    readonly subnets?: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     * @external
     */
    readonly type?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 */
export declare class CfnLoadBalancer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::LoadBalancer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLoadBalancer;
    /**
     * @external
     * @cloudformationAttribute CanonicalHostedZoneID
     */
    readonly attrCanonicalHostedZoneId: string;
    /**
     * @external
     * @cloudformationAttribute DNSName
     */
    readonly attrDnsName: string;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerFullName
     */
    readonly attrLoadBalancerFullName: string;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerName
     */
    readonly attrLoadBalancerName: string;
    /**
     * @external
     * @cloudformationAttribute SecurityGroups
     */
    readonly attrSecurityGroups: string[];
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.IpAddressType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-ipaddresstype
     * @external
     */
    ipAddressType: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.LoadBalancerAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes
     * @external
     */
    loadBalancerAttributes: Array<CfnLoadBalancer.LoadBalancerAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Scheme`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-scheme
     * @external
     */
    scheme: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-securitygroups
     * @external
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.SubnetMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmappings
     * @external
     */
    subnetMappings: Array<CfnLoadBalancer.SubnetMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-subnets
     * @external
     */
    subnets: string[] | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticLoadBalancingV2::LoadBalancer.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html#cfn-elasticloadbalancingv2-loadbalancer-type
     * @external
     */
    type: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLoadBalancerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html
     * @external
     */
    interface LoadBalancerAttributeProperty {
        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnLoadBalancer.LoadBalancerAttributeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-loadbalancerattributes.html#cfn-elasticloadbalancingv2-loadbalancer-loadbalancerattributes-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::LoadBalancer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-loadbalancer.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::LoadBalancer
 */
export declare namespace CfnLoadBalancer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html
     * @external
     */
    interface SubnetMappingProperty {
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.AllocationId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-allocationid
         * @external
         */
        readonly allocationId?: string;
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.PrivateIPv4Address`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-privateipv4address
         * @external
         */
        readonly privateIPv4Address?: string;
        /**
         * `CfnLoadBalancer.SubnetMappingProperty.SubnetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-loadbalancer-subnetmapping.html#cfn-elasticloadbalancingv2-loadbalancer-subnetmapping-subnetid
         * @external
         */
        readonly subnetId: string;
    }
}
/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 * @external
 */
export interface CfnTargetGroupProps {
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckenabled
     * @external
     */
    readonly healthCheckEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckIntervalSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckintervalseconds
     * @external
     */
    readonly healthCheckIntervalSeconds?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckpath
     * @external
     */
    readonly healthCheckPath?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckport
     * @external
     */
    readonly healthCheckPort?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckprotocol
     * @external
     */
    readonly healthCheckProtocol?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthchecktimeoutseconds
     * @external
     */
    readonly healthCheckTimeoutSeconds?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthyThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthythresholdcount
     * @external
     */
    readonly healthyThresholdCount?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Matcher`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-matcher
     * @external
     */
    readonly matcher?: CfnTargetGroup.MatcherProperty | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-protocol
     * @external
     */
    readonly protocol?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattributes
     * @external
     */
    readonly targetGroupAttributes?: Array<CfnTargetGroup.TargetGroupAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targets
     * @external
     */
    readonly targets?: Array<CfnTargetGroup.TargetDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targettype
     * @external
     */
    readonly targetType?: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.UnhealthyThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-unhealthythresholdcount
     * @external
     */
    readonly unhealthyThresholdCount?: number;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-vpcid
     * @external
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 */
export declare class CfnTargetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ElasticLoadBalancingV2::TargetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTargetGroup;
    /**
     * @external
     * @cloudformationAttribute LoadBalancerArns
     */
    readonly attrLoadBalancerArns: string[];
    /**
     * @external
     * @cloudformationAttribute TargetGroupFullName
     */
    readonly attrTargetGroupFullName: string;
    /**
     * @external
     * @cloudformationAttribute TargetGroupName
     */
    readonly attrTargetGroupName: string;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckenabled
     * @external
     */
    healthCheckEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckIntervalSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckintervalseconds
     * @external
     */
    healthCheckIntervalSeconds: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPath`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckpath
     * @external
     */
    healthCheckPath: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckPort`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckport
     * @external
     */
    healthCheckPort: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckProtocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthcheckprotocol
     * @external
     */
    healthCheckProtocol: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthCheckTimeoutSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthchecktimeoutseconds
     * @external
     */
    healthCheckTimeoutSeconds: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.HealthyThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-healthythresholdcount
     * @external
     */
    healthyThresholdCount: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Matcher`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-matcher
     * @external
     */
    matcher: CfnTargetGroup.MatcherProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Protocol`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-protocol
     * @external
     */
    protocol: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetGroupAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattributes
     * @external
     */
    targetGroupAttributes: Array<CfnTargetGroup.TargetGroupAttributeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.Targets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targets
     * @external
     */
    targets: Array<CfnTargetGroup.TargetDescriptionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.TargetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-targettype
     * @external
     */
    targetType: string | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.UnhealthyThresholdCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-unhealthythresholdcount
     * @external
     */
    unhealthyThresholdCount: number | undefined;
    /**
     * `AWS::ElasticLoadBalancingV2::TargetGroup.VpcId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html#cfn-elasticloadbalancingv2-targetgroup-vpcid
     * @external
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::TargetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTargetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 */
export declare namespace CfnTargetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html
     * @external
     */
    interface MatcherProperty {
        /**
         * `CfnTargetGroup.MatcherProperty.HttpCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-matcher.html#cfn-elasticloadbalancingv2-targetgroup-matcher-httpcode
         * @external
         */
        readonly httpCode: string;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 */
export declare namespace CfnTargetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html
     * @external
     */
    interface TargetDescriptionProperty {
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.AvailabilityZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-availabilityzone
         * @external
         */
        readonly availabilityZone?: string;
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-id
         * @external
         */
        readonly id: string;
        /**
         * `CfnTargetGroup.TargetDescriptionProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetdescription.html#cfn-elasticloadbalancingv2-targetgroup-targetdescription-port
         * @external
         */
        readonly port?: number;
    }
}
/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::TargetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-targetgroup.html
 * @external
 * @cloudformationResource AWS::ElasticLoadBalancingV2::TargetGroup
 */
export declare namespace CfnTargetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html
     * @external
     */
    interface TargetGroupAttributeProperty {
        /**
         * `CfnTargetGroup.TargetGroupAttributeProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnTargetGroup.TargetGroupAttributeProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-targetgroup-targetgroupattribute.html#cfn-elasticloadbalancingv2-targetgroup-targetgroupattribute-value
         * @external
         */
        readonly value?: string;
    }
}
