"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IpTarget = exports.InstanceTarget = void 0;
const enums_1 = require("./enums");
/**
 * (deprecated) An EC2 instance that is the target for load balancing.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 *
 * @deprecated Use IpTarget from the
 * @aws-cdk /aws-elasticloadbalancingv2-targets package instead.
 */
class InstanceTarget {
    /**
     * (deprecated) Create a new Instance target.
     *
     * @param instanceId Instance ID of the instance to register to.
     * @param port Override the default port for the target group.
     * @deprecated
     */
    constructor(instanceId, port) {
        this.instanceId = instanceId;
        this.port = port;
    }
    /**
     * (deprecated) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @deprecated
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * (deprecated) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @deprecated
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: enums_1.TargetType.INSTANCE,
            targetJson: { id: this.instanceId, port: this.port },
        };
    }
}
exports.InstanceTarget = InstanceTarget;
/**
 * (deprecated) An IP address that is a target for load balancing.
 *
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 *
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 *
 * @deprecated Use IpTarget from the
 * @aws-cdk /aws-elasticloadbalancingv2-targets package instead.
 */
class IpTarget {
    /**
     * (deprecated) Create a new IPAddress target.
     *
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     *
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     *
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     *
     * Default is automatic.
     *
     * @param ipAddress The IP Address to load balance to.
     * @param port Override the group's default port.
     * @param availabilityZone Availability zone to send traffic from.
     * @deprecated
     */
    constructor(ipAddress, port, availabilityZone) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.availabilityZone = availabilityZone;
    }
    /**
     * (deprecated) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @deprecated
     */
    attachToApplicationTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    /**
     * (deprecated) Register this instance target with a load balancer.
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     *
     * @deprecated
     */
    attachToNetworkTargetGroup(targetGroup) {
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: enums_1.TargetType.IP,
            targetJson: { id: this.ipAddress, port: this.port, availabilityZone: this.availabilityZone },
        };
    }
}
exports.IpTarget = IpTarget;
//# sourceMappingURL=data:application/json;base64,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