# Generated by Django 2.2.28 on 2022-07-20 13:27

from django.db import migrations
from pagemeta_example.models import Blog

from ._utils import copy_file_to_storage

def migrate_blog_data(apps, schema_editor):
    '''
    Migrates two random blog data.
    '''

    print('\n  Migrating Blog data...')
    Blog.objects.create(
        title='Lorem ipsum dolor sit amet, consectetur adipiscing elit',
        photo=copy_file_to_storage('pagemeta_example/static/images/blog1.jpg'),
        description='Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt' 
            ' ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation'
            ' ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit'
            ' in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat'
            ' non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
    )

    Blog.objects.create(
        title='Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium',
        photo=copy_file_to_storage('pagemeta_example/static/images/blog2.jpg'),
        description='Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque'
            ' laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae'
            ' vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit,'
            ' sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est,'
            ' qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi'
            ' tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam,'
            ' quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?'
            ' Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur,'
            ' vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?',
    )
    print('  Blog data migrated.')

class Migration(migrations.Migration):
    dependencies = [
        ('pagemeta_example', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(migrate_blog_data),
    ]
