# Generated by Django 3.1.14 on 2022-05-24 06:12

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("stores", "0017_auto_20220524_0912"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="TapPayment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "langid",
                    models.CharField(
                        help_text="Capture language for debugging & analytical only purposes (ARA for Arabic & ENG for English)",
                        max_length=10,
                    ),
                ),
                (
                    "result",
                    models.CharField(
                        help_text="Status response from TAP gateway", max_length=100
                    ),
                ),
                (
                    "payment_url",
                    models.CharField(
                        help_text="Captures generated URL for user payment",
                        max_length=250,
                    ),
                ),
                (
                    "charge_id",
                    models.CharField(
                        db_index=True,
                        help_text="Charge ID returned from TAP",
                        max_length=250,
                        unique=True,
                    ),
                ),
                (
                    "init_response",
                    models.JSONField(
                        blank=True,
                        help_text="Response received when initiating the payment",
                        null=True,
                    ),
                ),
                (
                    "callback_response",
                    models.JSONField(
                        blank=True,
                        help_text="Callback response received after the payment is done",
                        null=True,
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Datetime when payment was initiated",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Updated at"),
                ),
                (
                    "payment",
                    models.OneToOneField(
                        help_text="Reference local payment transaction table",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="stores.payment",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="Captured the User ID for both registered users and Guests (Every guest user has a user_id assigned by device_id)",
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "TAP Payment",
            },
        ),
    ]
