"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsStorage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class EfsStorage extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const urlsuffix = cdk.Stack.of(this).urlSuffix;
        const efsApps = new efs.FileSystem(this, 'EFSApps', {
            vpc: props.vpc,
            encrypted: true,
            throughputMode: efs.ThroughputMode.BURSTING,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            vpcSubnets: {
                subnetType: ec2.SubnetType.PRIVATE,
            },
            securityGroup: props.computeNodeSecurityGroup,
        });
        efsApps.connections.addSecurityGroup(props.schedulerSecurityGroup);
        const efsData = new efs.FileSystem(this, 'EFSData', {
            vpc: props.vpc,
            encrypted: true,
            throughputMode: efs.ThroughputMode.BURSTING,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            vpcSubnets: {
                subnetType: ec2.SubnetType.PRIVATE,
            },
            securityGroup: props.computeNodeSecurityGroup,
        });
        efsData.connections.addSecurityGroup(props.schedulerSecurityGroup);
        this.efsDataDns = `${efsData.fileSystemId}.efs.${region}.${urlsuffix}`;
        this.efsAppsDns = `${efsApps.fileSystemId}.efs.${region}.${urlsuffix}`;
        new cdk.CfnOutput(this, 'EFSAppsOutput', { value: efsApps.fileSystemId });
        new cdk.CfnOutput(this, 'EFSDataOutput', { value: efsData.fileSystemId });
        new cdk.CfnOutput(this, 'EFSAppsDnsOutput', { value: this.efsAppsDns });
        new cdk.CfnOutput(this, 'EFSDataDnsOutput', { value: this.efsDataDns });
        new cdk.CfnOutput(this, 'EFSMountParametersOutput', {
            value: 'nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport',
        });
    }
}
exports.EfsStorage = EfsStorage;
_a = JSII_RTTI_SYMBOL_1;
EfsStorage[_a] = { fqn: "cdk-soca.EfsStorage", version: "0.1.125" };
//# sourceMappingURL=data:application/json;base64,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