from datetime import datetime
from typing import Dict, Optional

from pydantic import BaseModel


class MssqlConnectConfig(BaseModel):
    endpoint: str
    username: str
    password: str


class MssqlDatabase(BaseModel):
    id: int
    name: str
    create_time: datetime
    collation_name: str


class MssqlColumn(BaseModel):
    name: str
    type: str
    max_length: float
    precision: float
    is_nullable: bool
    is_unique: Optional[bool]
    is_primary_key: Optional[bool]


class MssqlForeignKey(BaseModel):
    name: str
    table_id: str
    column_name: str
    referenced_table_id: str
    referenced_column: str


class MssqlTable(BaseModel):
    id: str
    name: str
    schema_name: str
    type: str
    column_dict: Dict[str, MssqlColumn]
    create_time: datetime
    is_external: bool
    external_source: Optional[str]
    external_file_format: Optional[str]


class MssqlQueryLog(BaseModel):
    request_id: str
    session_id: Optional[str]
    sql_query: str
    login_name: str
    start_time: datetime
    end_time: datetime
    duration_in_ms: int
    query_size_in_mb: Optional[int]
    error: Optional[str]
    row_count: Optional[int]
    query_operation: Optional[str]
