import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#active User#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#administrator User#administrator}
    */
    readonly administrator?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#email User#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#first_name User#first_name}
    */
    readonly firstName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#force_sec_auth User#force_sec_auth}
    */
    readonly forceSecAuth?: boolean | cdktf.IResolvable;
    /**
    * Ids of the groups that the user is a member of
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#group_ids User#group_ids}
    */
    readonly groupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#last_name User#last_name}
    */
    readonly lastName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#password User#password}
    */
    readonly password: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#timeouts User#timeouts}
    */
    readonly timeouts?: UserTimeouts;
}
export interface UserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#create User#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#default User#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#delete User#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/user#update User#update}
    */
    readonly update?: string;
}
export declare function userTimeoutsToTerraform(struct?: UserTimeoutsOutputReference | UserTimeouts | cdktf.IResolvable): any;
export declare class UserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): UserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: UserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/user ionoscloud_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/user ionoscloud_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _administrator?;
    get administrator(): boolean | cdktf.IResolvable;
    set administrator(value: boolean | cdktf.IResolvable);
    resetAdministrator(): void;
    get administratorInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    get firstNameInput(): string | undefined;
    private _forceSecAuth?;
    get forceSecAuth(): boolean | cdktf.IResolvable;
    set forceSecAuth(value: boolean | cdktf.IResolvable);
    resetForceSecAuth(): void;
    get forceSecAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _groupIds?;
    get groupIds(): string[];
    set groupIds(value: string[]);
    resetGroupIds(): void;
    get groupIdsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    get s3CanonicalUserId(): string;
    get secAuthActive(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): UserTimeoutsOutputReference;
    putTimeouts(value: UserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | UserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
