# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['nox_poetry']

package_data = \
{'': ['*']}

install_requires = \
['nox>=2020.5.24,<2021.0.0']

setup_kwargs = {
    'name': 'nox-poetry',
    'version': '0.4.0',
    'description': 'nox-poetry',
    'long_description': 'nox-poetry\n==========\n\n|PyPI| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/nox-poetry.svg\n   :target: https://pypi.org/project/nox-poetry/\n   :alt: PyPI\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/nox-poetry\n   :target: https://pypi.org/project/nox-poetry\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/nox-poetry\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/nox-poetry/latest.svg?label=Read%20the%20Docs\n   :target: https://nox-poetry.readthedocs.io/\n   :alt: Read the documentation at https://nox-poetry.readthedocs.io/\n.. |Tests| image:: https://github.com/cjolowicz/nox-poetry/workflows/Tests/badge.svg\n   :target: https://github.com/cjolowicz/nox-poetry/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/cjolowicz/nox-poetry/branch/master/graph/badge.svg\n   :target: https://codecov.io/gh/cjolowicz/nox-poetry\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\n\nUse Poetry_ inside Nox_ sessions\n\nThis package provides a drop-in replacement for ``session.install`` in Nox sessions.\nIt modifies its behavior in two ways:\n\n- Packages are pinned to the versions specified in Poetry\'s lock file.\n- The argument ``"."`` is replaced by a wheel built from the package.\n\n\nInstallation\n------------\n\nInstall ``nox-poetry`` from the Python Package Index:\n\n.. code:: console\n\n   $ pip install nox-poetry\n\n\n**Important:**\nThis package must be installed into the same environment that Nox is run from.\nIf you installed Nox using pipx_,\nuse the following command to install this package into the same environment:\n\n.. code:: console\n\n   $ pipx inject nox nox-poetry\n\n\nUsage\n-----\n\nInvoke ``nox_poetry.patch()`` at the top of your ``noxfile.py``, and you\'re good to go.\n``nox-poetry`` intercepts calls to ``session.install``\nand uses Poetry to export a `constraints file`_ and build the package behind the scenes.\n\nIf you prefer a less magical, more explicit approach,\nyou can also invoke ``nox_poetry.install(session, ...)`` instead of ``session.install(...)``.\nPass ``nox_poetry.WHEEL`` or ``nox_poetry.SDIST`` to build and install the local package\nusing the specified distribution format.\n\nPackages installed in this way must be managed as dependencies in Poetry.\n\nFor example, the following Nox session runs your test suite:\n\n.. code:: python\n\n   # noxfile.py\n   import nox\n   import nox_poetry\n\n   nox_poetry.patch()\n\n   @nox.session\n   def tests(session: Session) -> None:\n       """Run the test suite."""\n       session.install(".")\n       session.install("pytest")\n       session.run("pytest")\n\nMore precisely, the session builds a wheel from the local package,\ninstalls the wheel as well as the ``pytest`` package, and\ninvokes ``pytest`` to run the test suite against the installation.\n\n\nWhy?\n----\n\nConsider what would happen in the above session with an unpatched ``session.install``:\n\n- Package dependencies would only be constrained by the wheel metadata, not by the lock file.\n  In other words, their versions would not be *pinned*.\n- The ``pytest`` dependency would not be constrained at all.\n- Poetry would be installed as a build backend every time\n  (although this could be avoided by passing the ``"--no-build-isolation"`` option).\n\nUnpinned dependencies mean that your checks are not reproducible and deterministic,\nwhich can lead to surprises in Continuous Integration and when collaborating with others.\nYou can solve these issues by declaring ``pytest`` as a development dependency,\nand installing your package and its dependencies using ``poetry install``:\n\n.. code:: python\n\n   @nox.session\n   def tests(session: Session) -> None:\n       """Run the test suite."""\n       session.run("poetry", "install", external=True)\n       session.run("pytest")\n\nUnfortunately, this approach comes with its own set of problems:\n\n- Checks run against an editable installation of your package,\n  i.e. your local copy of the code, instead of the installed wheel your users see.\n- The package is installed, as well as all of its core and development dependencies.\n  This is wasteful when you only need to run ``black`` or ``flake8``.\n  It also goes against the idea of running checks in isolated environments.\n- Poetry may decide to install packages into its own virtual environment instead of the one provided by Nox.\n\n``nox-poetry`` uses a third approach.\nThird-party packages are installed by exporting the lock file in ``requirements.txt`` format,\nand passing it as a `constraints file`_ to pip.\nWhen installing your own package, Poetry is used to build a wheel, which is then installed by pip.\n\nIn summary, this approach brings the following advantages:\n\n- You can manage tools like ``pytest`` as development dependencies in Poetry.\n- Dependencies are pinned by Poetry\'s lock file, making checks predictable and deterministic.\n- You can run checks against an installed wheel, instead of your local copy of the code.\n- Every tool can run in an isolated environment with minimal dependencies.\n- No need to install your package with all its dependencies if all you need is some linter.\n\nFor more details, take a look at `this article`__.\n\n__ https://cjolowicz.github.io/posts/hypermodern-python-03-linting/#managing-dependencies-in-nox-sessions-with-poetry\n\n\nAPI\n---\n\n``nox_poetry.patch(*, distribution_format=nox_poetry.WHEEL)``:\n   Monkey-patch `nox.sessions.Session.install`_ to use ``nox_poetry.install``.\n   The optional ``distribution_format`` parameter determines\n   how to handle the special ``"."`` argument.\n   By default, this is replaced by a wheel built from the package.\n   Pass ``nox_poetry.SDIST`` to build an sdist archive instead.\n\n``nox_poetry.install(session, *args, **kwargs)``:\n   Install packages into a Nox session using Poetry.\n\n   The ``nox_poetry.install`` function\n   installs dependencies into a Nox session,\n   using the versions specified in Poetry\'s lock file.\n   The function arguments are the same as those for `nox.sessions.Session.install`_:\n   The first argument is the ``Session`` object,\n   and the remaining arguments are command-line arguments for `pip install`_,\n   typically just the package or packages to be installed.\n   The constants ``WHEEL`` and ``SDIST`` are replaced by a distribution archive\n   built for the local package.\n   Keyword arguments are the same as those for `nox.sessions.Session.run`_.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\n``nox-poetry`` is free and open source software,\ndistributed under the terms of the MIT_ license.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\nThis project was generated from `@cjolowicz`_\'s `Hypermodern Python Cookiecutter`_ template.\n\n\n.. _@cjolowicz: https://github.com/cjolowicz\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _MIT: http://opensource.org/licenses/MIT\n.. _Nox: https://nox.thea.codes/\n.. _Poetry: https://python-poetry.org/\n.. _constraints file: https://pip.pypa.io/en/stable/user_guide/#constraints-files\n.. _file an issue: https://github.com/cjolowicz/nox-poetry/issues\n.. _nox.sessions.Session.install: https://nox.thea.codes/en/stable/config.html#nox.sessions.Session.install\n.. _nox.sessions.Session.run: https://nox.thea.codes/en/stable/config.html#nox.sessions.Session.run\n.. _pip install: https://pip.pypa.io/en/stable/reference/pip_install/\n.. _pip: https://pip.pypa.io/\n.. _pipx: https://pipxproject.github.io/pipx/\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n',
    'author': 'Claudio Jolowicz',
    'author_email': 'mail@claudiojolowicz.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cjolowicz/nox-poetry',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
