ASA_SANITIZE_FILTERS = {
    r"^(\s+enable password)\s.*$": r"\1 <removed>",
    r"^(\snmp-server community).*$": r"\1 <removed>",
    r"^(\s+username .+ (password|secret)) .+$": r"\1 <removed>",
    r"^(\snmp-server host \S+( vrf \S+)?( version (1|2c|3))?)\s+\S+((\s+\S*)*)\s*$": r"\1 <removed> \5",  # noqa
    r"^(\s+(?:password|secret)) (?:\d )?\S+$": r"\1 <removed>",
    r"^(.*wpa-psk ascii \d) (\S+)$": r"\1 <removed>",
    r"^(.*key 7) (\d.+)$": r"\1 <removed>",
    r"^(tacacs-server (.+ )?key) .+$": r"\1 <removed>",
    r"^(crypto isakmp key) (\S+) (.*)$": r"\1 <removed> \3",
    r"^(\s+ip ospf message-digest-key \d+ md5) .+$": r"\1 <removed>",
    r"^(\s+ip ospf authentication-key) .+$": r"\1 <removed>",
    r"^(\s+neighbor \S+ password) .+$": r"\1 <removed>",
    r"^(\s+vrrp \d+ authentication text) .+$": r"\1 <removed>",
    r"^(\s+standby \d+ authentication) .{1,8}$": r"\1 <removed>",
    r"^(\s+standby \d+ authentication md5 key-string) .+?( timeout \d+)?$": r"\1 <removed> \2",
    r"^(\s+key-string) .+$": r"\1 <removed>",
    r"^((tacacs|radius) server [^\n]+\n(\s+[^\n]+\n)*\s+key) [^\n]+$": r"\1 <removed>",
    r"^(\s+ppp (chap|pap) password \d) .+$": r"\1 <removed>",
}
