import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Allows for the creation and modification of a Snowflake Role. https://docs.snowflake.com/en/user-guide/security-access-control-overview.html#roles
 *
 * @schema CfnRoleProps
 */
export interface CfnRoleProps {
    /**
     * Specifies the identifier for the role; must be unique for your account.
     *
     * @schema CfnRoleProps#Name
     */
    readonly name: string;
    /**
     * Specifies a comment for the role.
     *
     * @schema CfnRoleProps#Comment
     */
    readonly comment?: string;
}
/**
 * Converts an object of type 'CfnRoleProps' to JSON representation.
 */
export declare function toJson_CfnRoleProps(obj: CfnRoleProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Snowflake::Role::Role`
 *
 * @cloudformationResource Snowflake::Role::Role
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
export declare class CfnRole extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Snowflake::Role::Role";
    /**
     * Resource props.
     */
    readonly props: CfnRoleProps;
    /**
     * Create a new `Snowflake::Role::Role`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnRoleProps);
}
