"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnRole = exports.toJson_CfnRoleProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnRoleProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnRoleProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Comment': obj.comment,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnRoleProps = toJson_CfnRoleProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Snowflake::Role::Role`
 *
 * @cloudformationResource Snowflake::Role::Role
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
class CfnRole extends cdk.CfnResource {
    /**
     * Create a new `Snowflake::Role::Role`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnRole.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnRoleProps(props) });
        this.props = props;
    }
}
exports.CfnRole = CfnRole;
_a = JSII_RTTI_SYMBOL_1;
CfnRole[_a] = { fqn: "@cdk-cloudformation/snowflake-role-role.CfnRole", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnRole.CFN_RESOURCE_TYPE_NAME = "Snowflake::Role::Role";
//# sourceMappingURL=data:application/json;base64,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