"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyMongo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) MongoDB Stateful Set class.
 *
 * @experimental
 */
class MyMongo extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, name);
        const volumerequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const defaultReplicas = (_b = opts.defaultReplicas) !== null && _b !== void 0 ? _b : 3;
        const replicas = defaultReplicas;
        const imageName = opts.image;
        const namespace = (_c = opts.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.namespace = namespace;
        var storageClassName = (_d = opts.storageClassName) !== null && _d !== void 0 ? _d : 'gp2-expandable';
        const volumeProvisioner = (_e = opts.volumeProvisioner) !== null && _e !== void 0 ? _e : 'kubernetes.io/aws-ebs';
        const storageClassParams = (_f = opts.storageClassParams) !== null && _f !== void 0 ? _f : { type: 'gp2', fsType: 'ext4' };
        const nodeSelectorParams = (_g = opts.nodeSelectorParams) !== null && _g !== void 0 ? _g : undefined;
        const resources = {
            limits: convertQuantity((_h = opts.resources) === null || _h === void 0 ? void 0 : _h.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_j = opts.resources) === null || _j === void 0 ? void 0 : _j.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const labels = { db: name };
        if (opts.createStorageClass === true) {
            const storageClassOpts = {
                metadata: {
                    name: storageClassName,
                },
                provisioner: volumeProvisioner,
                allowVolumeExpansion: true,
                reclaimPolicy: 'Retain',
                parameters: {
                    ...storageClassParams,
                },
            };
            const storageclass = new k8s.KubeStorageClass(this, 'storageclass', storageClassOpts);
            this.name = storageclass.name;
            var storageClassName = storageclass.name;
        }
        const serviceOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                type: 'ClusterIP',
                clusterIP: 'None',
                ports: [{ port: 27017, targetPort: k8s.IntOrString.fromNumber(27017) }],
                selector: labels,
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const clusterroleOpts = {
            metadata: {
                namespace: namespace,
                name: 'get-pods-role',
            },
            rules: [
                {
                    verbs: ['list'],
                    apiGroups: ['*'],
                    resources: ['pods'],
                },
            ],
        };
        const clusterrole = new k8s.KubeClusterRole(this, 'clusterrole', clusterroleOpts);
        this.name = clusterrole.name;
        const serviceaccountOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
        };
        const sa = new k8s.KubeServiceAccount(this, 'serviceaccount', serviceaccountOpts);
        this.name = sa.name;
        const bindingOpts = {
            roleRef: {
                kind: 'ClusterRole',
                apiGroup: '',
                name: 'get-pods-role',
            },
            metadata: {
                namespace: namespace,
                name: name,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: name,
                    namespace: namespace,
                },
            ],
        };
        const clusterrolebinding = new k8s.KubeClusterRoleBinding(this, 'rolebinding', bindingOpts);
        this.name = clusterrolebinding.name;
        const pvcProps = {
            metadata: {
                name: name,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: storageClassName,
                resources: {
                    requests: volumerequest,
                },
            },
        };
        const stsOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                serviceName: name,
                selector: { matchLabels: labels },
                replicas: replicas,
                template: {
                    metadata: { labels: labels },
                    spec: {
                        containers: [
                            {
                                name: 'mongo-sidecar',
                                image: 'cvallance/mongo-k8s-sidecar',
                                env: [
                                    {
                                        name: 'MONGO_SIDECAR_POD_LABELS',
                                        value: `db=${name}`,
                                    },
                                    {
                                        name: 'KUBE_NAMESPACE',
                                        value: namespace,
                                    },
                                    {
                                        name: 'MONGODB_DATABASE',
                                        value: 'admin',
                                    },
                                    {
                                        name: 'MONGODB_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGODB_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                            },
                            {
                                name: name,
                                image: imageName,
                                env: [
                                    {
                                        name: 'MONGO_INITDB_ROOT_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGO_INITDB_ROOT_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                                resources: resources,
                                ports: [
                                    {
                                        containerPort: 27017,
                                    },
                                ],
                                args: [
                                    '--replSet',
                                    'rs0',
                                    '--bind_ip',
                                    '0.0.0.0',
                                    '--dbpath',
                                    '/data/db',
                                    '--oplogSize',
                                    '128',
                                ],
                                volumeMounts: [
                                    {
                                        name: name,
                                        mountPath: '/data/db',
                                    },
                                ],
                            },
                        ],
                        terminationGracePeriodSeconds: 10,
                        serviceAccountName: name,
                        nodeSelector: nodeSelectorParams,
                        securityContext: {
                            fsGroup: 999,
                            runAsGroup: 999,
                            runAsUser: 999,
                        },
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'sts', stsOpts);
        this.name = sts.name;
    }
}
exports.MyMongo = MyMongo;
_a = JSII_RTTI_SYMBOL_1;
MyMongo[_a] = { fqn: "@opencdk8s/cdk8s-mongo-sts.MyMongo", version: "0.0.10" };
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBdUM7QUFFdkMscUNBQXFDOzs7Ozs7QUE2RnJDLE1BQWEsT0FBUSxTQUFRLHNCQUFTOzs7O0lBSXBDLFlBQVksS0FBZ0IsRUFBRSxJQUFZLEVBQUUsSUFBZ0I7O1FBQzFELEtBQUssQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFbkIsTUFBTSxhQUFhLEdBQUc7WUFDcEIsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7U0FDMUQsQ0FBQztRQUNGLE1BQU0sZUFBZSxTQUFHLElBQUksQ0FBQyxlQUFlLG1DQUFJLENBQUMsQ0FBQztRQUNsRCxNQUFNLFFBQVEsR0FBRyxlQUFlLENBQUM7UUFDakMsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztRQUM3QixNQUFNLFNBQVMsU0FBRyxJQUFJLENBQUMsU0FBUyxtQ0FBSSxTQUFTLENBQUM7UUFDOUMsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7UUFDM0IsSUFBSSxnQkFBZ0IsU0FBRyxJQUFJLENBQUMsZ0JBQWdCLG1DQUFJLGdCQUFnQixDQUFDO1FBQ2pFLE1BQU0saUJBQWlCLFNBQUcsSUFBSSxDQUFDLGlCQUFpQixtQ0FBSSx1QkFBdUIsQ0FBQztRQUM1RSxNQUFNLGtCQUFrQixTQUFHLElBQUksQ0FBQyxrQkFBa0IsbUNBQUksRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUUsQ0FBQztRQUN0RixNQUFNLGtCQUFrQixTQUFHLElBQUksQ0FBQyxrQkFBa0IsbUNBQUksU0FBUyxDQUFDO1FBQ2hFLE1BQU0sU0FBUyxHQUFHO1lBQ2hCLE1BQU0sRUFBRSxlQUFlLE9BQUMsSUFBSSxDQUFDLFNBQVMsMENBQUUsTUFBTSxFQUFFO2dCQUM5QyxHQUFHLEVBQUUsTUFBTTtnQkFDWCxNQUFNLEVBQUUsT0FBTzthQUNoQixDQUFDO1lBQ0YsUUFBUSxFQUFFLGVBQWUsT0FBQyxJQUFJLENBQUMsU0FBUywwQ0FBRSxRQUFRLEVBQUU7Z0JBQ2xELEdBQUcsRUFBRSxNQUFNO2dCQUNYLE1BQU0sRUFBRSxPQUFPO2FBQ2hCLENBQUM7U0FDSCxDQUFDO1FBQ0YsTUFBTSxNQUFNLEdBQUcsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLENBQUM7UUFFNUIsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEtBQUssSUFBSSxFQUFFO1lBQ3BDLE1BQU0sZ0JBQWdCLEdBQThCO2dCQUNsRCxRQUFRLEVBQUU7b0JBQ1IsSUFBSSxFQUFFLGdCQUFnQjtpQkFDdkI7Z0JBQ0QsV0FBVyxFQUFFLGlCQUFpQjtnQkFDOUIsb0JBQW9CLEVBQUUsSUFBSTtnQkFDMUIsYUFBYSxFQUFFLFFBQVE7Z0JBQ3ZCLFVBQVUsRUFBRTtvQkFDVixHQUFHLGtCQUFrQjtpQkFDdEI7YUFDRixDQUFDO1lBQ0YsTUFBTSxZQUFZLEdBQUcsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLGNBQWMsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO1lBQ3RGLElBQUksQ0FBQyxJQUFJLEdBQUcsWUFBWSxDQUFDLElBQUksQ0FBQztZQUM5QixJQUFJLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxJQUFJLENBQUM7U0FDMUM7UUFFRCxNQUFNLFdBQVcsR0FBeUI7WUFDeEMsUUFBUSxFQUFFO2dCQUNSLFNBQVMsRUFBRSxTQUFTO2dCQUNwQixJQUFJLEVBQUUsSUFBSTthQUNYO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLElBQUksRUFBRSxXQUFXO2dCQUNqQixTQUFTLEVBQUUsTUFBTTtnQkFDakIsS0FBSyxFQUFFLENBQUMsRUFBRSxJQUFJLEVBQUUsS0FBSyxFQUFFLFVBQVUsRUFBRSxHQUFHLENBQUMsV0FBVyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDO2dCQUN2RSxRQUFRLEVBQUUsTUFBTTthQUNqQjtTQUNGLENBQUM7UUFDRixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUM5RCxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUM7UUFFckIsTUFBTSxlQUFlLEdBQTZCO1lBQ2hELFFBQVEsRUFBRTtnQkFDUixTQUFTLEVBQUUsU0FBUztnQkFDcEIsSUFBSSxFQUFFLGVBQWU7YUFDdEI7WUFDRCxLQUFLLEVBQUU7Z0JBQ0w7b0JBQ0UsS0FBSyxFQUFFLENBQUMsTUFBTSxDQUFDO29CQUNmLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztvQkFDaEIsU0FBUyxFQUFFLENBQUMsTUFBTSxDQUFDO2lCQUNwQjthQUNGO1NBQ0YsQ0FBQztRQUNGLE1BQU0sV0FBVyxHQUFHLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FDekMsSUFBSSxFQUNKLGFBQWEsRUFDYixlQUFlLENBQ2hCLENBQUM7UUFDRixJQUFJLENBQUMsSUFBSSxHQUFHLFdBQVcsQ0FBQyxJQUFJLENBQUM7UUFFN0IsTUFBTSxrQkFBa0IsR0FBZ0M7WUFDdEQsUUFBUSxFQUFFO2dCQUNSLFNBQVMsRUFBRSxTQUFTO2dCQUNwQixJQUFJLEVBQUUsSUFBSTthQUNYO1NBQ0YsQ0FBQztRQUNGLE1BQU0sRUFBRSxHQUFHLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUNuQyxJQUFJLEVBQ0osZ0JBQWdCLEVBQ2hCLGtCQUFrQixDQUNuQixDQUFDO1FBQ0YsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDO1FBRXBCLE1BQU0sV0FBVyxHQUFvQztZQUNuRCxPQUFPLEVBQUU7Z0JBQ1AsSUFBSSxFQUFFLGFBQWE7Z0JBQ25CLFFBQVEsRUFBRSxFQUFFO2dCQUNaLElBQUksRUFBRSxlQUFlO2FBQ3RCO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLFNBQVMsRUFBRSxTQUFTO2dCQUNwQixJQUFJLEVBQUUsSUFBSTthQUNYO1lBQ0QsUUFBUSxFQUFFO2dCQUNSO29CQUNFLElBQUksRUFBRSxnQkFBZ0I7b0JBQ3RCLElBQUksRUFBRSxJQUFJO29CQUNWLFNBQVMsRUFBRSxTQUFTO2lCQUNyQjthQUNGO1NBQ0YsQ0FBQztRQUNGLE1BQU0sa0JBQWtCLEdBQUcsSUFBSSxHQUFHLENBQUMsc0JBQXNCLENBQ3ZELElBQUksRUFDSixhQUFhLEVBQ2IsV0FBVyxDQUNaLENBQUM7UUFDRixJQUFJLENBQUMsSUFBSSxHQUFHLGtCQUFrQixDQUFDLElBQUksQ0FBQztRQUVwQyxNQUFNLFFBQVEsR0FBdUM7WUFDbkQsUUFBUSxFQUFFO2dCQUNSLElBQUksRUFBRSxJQUFJO2FBQ1g7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osV0FBVyxFQUFFLENBQUMsZUFBZSxDQUFDO2dCQUM5QixnQkFBZ0IsRUFBRSxnQkFBZ0I7Z0JBQ2xDLFNBQVMsRUFBRTtvQkFDVCxRQUFRLEVBQUUsYUFBYTtpQkFDeEI7YUFDRjtTQUNGLENBQUM7UUFFRixNQUFNLE9BQU8sR0FBNkI7WUFDeEMsUUFBUSxFQUFFO2dCQUNSLFNBQVMsRUFBRSxTQUFTO2dCQUNwQixJQUFJLEVBQUUsSUFBSTthQUNYO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLFdBQVcsRUFBRSxJQUFJO2dCQUNqQixRQUFRLEVBQUUsRUFBRSxXQUFXLEVBQUUsTUFBTSxFQUFFO2dCQUNqQyxRQUFRLEVBQUUsUUFBUTtnQkFDbEIsUUFBUSxFQUFFO29CQUNSLFFBQVEsRUFBRSxFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUU7b0JBQzVCLElBQUksRUFBRTt3QkFDSixVQUFVLEVBQUU7NEJBQ1Y7Z0NBQ0UsSUFBSSxFQUFFLGVBQWU7Z0NBQ3JCLEtBQUssRUFBRSw2QkFBNkI7Z0NBQ3BDLEdBQUcsRUFBRTtvQ0FDSDt3Q0FDRSxJQUFJLEVBQUUsMEJBQTBCO3dDQUNoQyxLQUFLLEVBQUUsTUFBTSxJQUFJLEVBQUU7cUNBQ3BCO29DQUNEO3dDQUNFLElBQUksRUFBRSxnQkFBZ0I7d0NBQ3RCLEtBQUssRUFBRSxTQUFTO3FDQUNqQjtvQ0FDRDt3Q0FDRSxJQUFJLEVBQUUsa0JBQWtCO3dDQUN4QixLQUFLLEVBQUUsT0FBTztxQ0FDZjtvQ0FDRDt3Q0FDRSxJQUFJLEVBQUUsa0JBQWtCO3dDQUN4QixTQUFTLEVBQUU7NENBQ1QsWUFBWSxFQUFFO2dEQUNaLEdBQUcsRUFBRSxVQUFVO2dEQUNmLElBQUksRUFBRSxJQUFJOzZDQUNYO3lDQUNGO3FDQUNGO29DQUNEO3dDQUNFLElBQUksRUFBRSxrQkFBa0I7d0NBQ3hCLFNBQVMsRUFBRTs0Q0FDVCxZQUFZLEVBQUU7Z0RBQ1osR0FBRyxFQUFFLFVBQVU7Z0RBQ2YsSUFBSSxFQUFFLElBQUk7NkNBQ1g7eUNBQ0Y7cUNBQ0Y7aUNBQ0Y7NkJBQ0Y7NEJBQ0Q7Z0NBQ0UsSUFBSSxFQUFFLElBQUk7Z0NBQ1YsS0FBSyxFQUFFLFNBQVM7Z0NBQ2hCLEdBQUcsRUFBRTtvQ0FDSDt3Q0FDRSxJQUFJLEVBQUUsNEJBQTRCO3dDQUNsQyxTQUFTLEVBQUU7NENBQ1QsWUFBWSxFQUFFO2dEQUNaLEdBQUcsRUFBRSxVQUFVO2dEQUNmLElBQUksRUFBRSxJQUFJOzZDQUNYO3lDQUNGO3FDQUNGO29DQUNEO3dDQUNFLElBQUksRUFBRSw0QkFBNEI7d0NBQ2xDLFNBQVMsRUFBRTs0Q0FDVCxZQUFZLEVBQUU7Z0RBQ1osR0FBRyxFQUFFLFVBQVU7Z0RBQ2YsSUFBSSxFQUFFLElBQUk7NkNBQ1g7eUNBQ0Y7cUNBQ0Y7aUNBQ0Y7Z0NBQ0QsU0FBUyxFQUFFLFNBQVM7Z0NBQ3BCLEtBQUssRUFBRTtvQ0FDTDt3Q0FDRSxhQUFhLEVBQUUsS0FBSztxQ0FDckI7aUNBQ0Y7Z0NBQ0QsSUFBSSxFQUFFO29DQUNKLFdBQVc7b0NBQ1gsS0FBSztvQ0FDTCxXQUFXO29DQUNYLFNBQVM7b0NBQ1QsVUFBVTtvQ0FDVixVQUFVO29DQUNWLGFBQWE7b0NBQ2IsS0FBSztpQ0FDTjtnQ0FDRCxZQUFZLEVBQUU7b0NBQ1o7d0NBQ0UsSUFBSSxFQUFFLElBQUk7d0NBQ1YsU0FBUyxFQUFFLFVBQVU7cUNBQ3RCO2lDQUNGOzZCQUNGO3lCQUNGO3dCQUNELDZCQUE2QixFQUFFLEVBQUU7d0JBQ2pDLGtCQUFrQixFQUFFLElBQUk7d0JBQ3hCLFlBQVksRUFBRSxrQkFBa0I7d0JBQ2hDLGVBQWUsRUFBRTs0QkFDZixPQUFPLEVBQUUsR0FBRzs0QkFDWixVQUFVLEVBQUUsR0FBRzs0QkFDZixTQUFTLEVBQUUsR0FBRzt5QkFDZjtxQkFDRjtpQkFDRjtnQkFDRCxvQkFBb0IsRUFBRSxDQUFDLFFBQVEsQ0FBQzthQUNqQztTQUNGLENBQUM7UUFFRixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQztRQUMxRCxJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUM7SUFFdkIsQ0FBQzs7QUF2UEgsMEJBd1BDOzs7QUFFRDs7Ozs7Ozs7O0dBU0c7QUFFSCxTQUFTLGVBQWUsQ0FDdEIsSUFBa0MsRUFDbEMsUUFBeUM7SUFFekMsV0FBVztJQUNYLElBQUksQ0FBQyxJQUFJLEVBQUU7UUFDVCxPQUFPO1lBQ0wsR0FBRyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUM7WUFDMUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUM7U0FDakQsQ0FBQztLQUNIO0lBRUQsTUFBTSxNQUFNLEdBQW9DLEVBQUUsQ0FBQztJQUVuRCxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDWixNQUFNLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxRQUFRLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztLQUNoRDtJQUVELElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRTtRQUNmLE1BQU0sQ0FBQyxNQUFNLEdBQUcsR0FBRyxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQ3REO0lBRUQsT0FBTyxNQUFNLENBQUM7QUFDaEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5pbXBvcnQgKiBhcyBrOHMgZnJvbSAnLi9pbXBvcnRzL2s4cyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgU1RTT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmFtZXNwYWNlPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaW1hZ2U6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZWZhdWx0UmVwbGljYXM/OiBudW1iZXI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZvbHVtZVNpemU/OiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNyZWF0ZVN0b3JhZ2VDbGFzcz86IGJvb2xlYW47XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdG9yYWdlQ2xhc3NOYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZvbHVtZVByb3Zpc2lvbmVyPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN0b3JhZ2VDbGFzc1BhcmFtcz86IHsgW25hbWU6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBub2RlU2VsZWN0b3JQYXJhbXM/OiB7IFtuYW1lOiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVzb3VyY2VzPzogUmVzb3VyY2VSZXF1aXJlbWVudHM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVzb3VyY2VSZXF1aXJlbWVudHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsaW1pdHM/OiBSZXNvdXJjZVF1YW50aXR5O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXF1ZXN0cz86IFJlc291cmNlUXVhbnRpdHk7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVzb3VyY2VRdWFudGl0eSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY3B1Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbWVtb3J5Pzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuXG5leHBvcnQgY2xhc3MgTXlNb25nbyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBuYW1lc3BhY2U6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBuYW1lOiBzdHJpbmcsIG9wdHM6IFNUU09wdGlvbnMpIHtcbiAgICBzdXBlcihzY29wZSwgbmFtZSk7XG5cbiAgICBjb25zdCB2b2x1bWVyZXF1ZXN0ID0ge1xuICAgICAgc3RvcmFnZTogazhzLlF1YW50aXR5LmZyb21TdHJpbmcoU3RyaW5nKG9wdHMudm9sdW1lU2l6ZSkpLFxuICAgIH07XG4gICAgY29uc3QgZGVmYXVsdFJlcGxpY2FzID0gb3B0cy5kZWZhdWx0UmVwbGljYXMgPz8gMztcbiAgICBjb25zdCByZXBsaWNhcyA9IGRlZmF1bHRSZXBsaWNhcztcbiAgICBjb25zdCBpbWFnZU5hbWUgPSBvcHRzLmltYWdlO1xuICAgIGNvbnN0IG5hbWVzcGFjZSA9IG9wdHMubmFtZXNwYWNlID8/ICdkZWZhdWx0JztcbiAgICB0aGlzLm5hbWVzcGFjZSA9IG5hbWVzcGFjZTtcbiAgICB2YXIgc3RvcmFnZUNsYXNzTmFtZSA9IG9wdHMuc3RvcmFnZUNsYXNzTmFtZSA/PyAnZ3AyLWV4cGFuZGFibGUnO1xuICAgIGNvbnN0IHZvbHVtZVByb3Zpc2lvbmVyID0gb3B0cy52b2x1bWVQcm92aXNpb25lciA/PyAna3ViZXJuZXRlcy5pby9hd3MtZWJzJztcbiAgICBjb25zdCBzdG9yYWdlQ2xhc3NQYXJhbXMgPSBvcHRzLnN0b3JhZ2VDbGFzc1BhcmFtcyA/PyB7IHR5cGU6ICdncDInLCBmc1R5cGU6ICdleHQ0JyB9O1xuICAgIGNvbnN0IG5vZGVTZWxlY3RvclBhcmFtcyA9IG9wdHMubm9kZVNlbGVjdG9yUGFyYW1zID8/IHVuZGVmaW5lZDtcbiAgICBjb25zdCByZXNvdXJjZXMgPSB7XG4gICAgICBsaW1pdHM6IGNvbnZlcnRRdWFudGl0eShvcHRzLnJlc291cmNlcz8ubGltaXRzLCB7XG4gICAgICAgIGNwdTogJzQwMG0nLFxuICAgICAgICBtZW1vcnk6ICc1MTJNaScsXG4gICAgICB9KSxcbiAgICAgIHJlcXVlc3RzOiBjb252ZXJ0UXVhbnRpdHkob3B0cy5yZXNvdXJjZXM/LnJlcXVlc3RzLCB7XG4gICAgICAgIGNwdTogJzIwMG0nLFxuICAgICAgICBtZW1vcnk6ICcyNTZNaScsXG4gICAgICB9KSxcbiAgICB9O1xuICAgIGNvbnN0IGxhYmVscyA9IHsgZGI6IG5hbWUgfTtcblxuICAgIGlmIChvcHRzLmNyZWF0ZVN0b3JhZ2VDbGFzcyA9PT0gdHJ1ZSkge1xuICAgICAgY29uc3Qgc3RvcmFnZUNsYXNzT3B0czogazhzLkt1YmVTdG9yYWdlQ2xhc3NQcm9wcyA9IHtcbiAgICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgICBuYW1lOiBzdG9yYWdlQ2xhc3NOYW1lLFxuICAgICAgICB9LFxuICAgICAgICBwcm92aXNpb25lcjogdm9sdW1lUHJvdmlzaW9uZXIsXG4gICAgICAgIGFsbG93Vm9sdW1lRXhwYW5zaW9uOiB0cnVlLFxuICAgICAgICByZWNsYWltUG9saWN5OiAnUmV0YWluJyxcbiAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgIC4uLnN0b3JhZ2VDbGFzc1BhcmFtcyxcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgICBjb25zdCBzdG9yYWdlY2xhc3MgPSBuZXcgazhzLkt1YmVTdG9yYWdlQ2xhc3ModGhpcywgJ3N0b3JhZ2VjbGFzcycsIHN0b3JhZ2VDbGFzc09wdHMpO1xuICAgICAgdGhpcy5uYW1lID0gc3RvcmFnZWNsYXNzLm5hbWU7XG4gICAgICB2YXIgc3RvcmFnZUNsYXNzTmFtZSA9IHN0b3JhZ2VjbGFzcy5uYW1lO1xuICAgIH1cblxuICAgIGNvbnN0IHNlcnZpY2VPcHRzOiBrOHMuS3ViZVNlcnZpY2VQcm9wcyA9IHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWVzcGFjZTogbmFtZXNwYWNlLFxuICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgfSxcbiAgICAgIHNwZWM6IHtcbiAgICAgICAgdHlwZTogJ0NsdXN0ZXJJUCcsXG4gICAgICAgIGNsdXN0ZXJJUDogJ05vbmUnLFxuICAgICAgICBwb3J0czogW3sgcG9ydDogMjcwMTcsIHRhcmdldFBvcnQ6IGs4cy5JbnRPclN0cmluZy5mcm9tTnVtYmVyKDI3MDE3KSB9XSxcbiAgICAgICAgc2VsZWN0b3I6IGxhYmVscyxcbiAgICAgIH0sXG4gICAgfTtcbiAgICBjb25zdCBzdmMgPSBuZXcgazhzLkt1YmVTZXJ2aWNlKHRoaXMsICdzZXJ2aWNlJywgc2VydmljZU9wdHMpO1xuICAgIHRoaXMubmFtZSA9IHN2Yy5uYW1lO1xuXG4gICAgY29uc3QgY2x1c3RlcnJvbGVPcHRzOiBrOHMuS3ViZUNsdXN0ZXJSb2xlUHJvcHMgPSB7XG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBuYW1lc3BhY2U6IG5hbWVzcGFjZSxcbiAgICAgICAgbmFtZTogJ2dldC1wb2RzLXJvbGUnLFxuICAgICAgfSxcbiAgICAgIHJ1bGVzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICB2ZXJiczogWydsaXN0J10sXG4gICAgICAgICAgYXBpR3JvdXBzOiBbJyonXSxcbiAgICAgICAgICByZXNvdXJjZXM6IFsncG9kcyddLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICB9O1xuICAgIGNvbnN0IGNsdXN0ZXJyb2xlID0gbmV3IGs4cy5LdWJlQ2x1c3RlclJvbGUoXG4gICAgICB0aGlzLFxuICAgICAgJ2NsdXN0ZXJyb2xlJyxcbiAgICAgIGNsdXN0ZXJyb2xlT3B0cyxcbiAgICApO1xuICAgIHRoaXMubmFtZSA9IGNsdXN0ZXJyb2xlLm5hbWU7XG5cbiAgICBjb25zdCBzZXJ2aWNlYWNjb3VudE9wdHM6IGs4cy5LdWJlU2VydmljZUFjY291bnRQcm9wcyA9IHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWVzcGFjZTogbmFtZXNwYWNlLFxuICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgfSxcbiAgICB9O1xuICAgIGNvbnN0IHNhID0gbmV3IGs4cy5LdWJlU2VydmljZUFjY291bnQoXG4gICAgICB0aGlzLFxuICAgICAgJ3NlcnZpY2VhY2NvdW50JyxcbiAgICAgIHNlcnZpY2VhY2NvdW50T3B0cyxcbiAgICApO1xuICAgIHRoaXMubmFtZSA9IHNhLm5hbWU7XG5cbiAgICBjb25zdCBiaW5kaW5nT3B0czogazhzLkt1YmVDbHVzdGVyUm9sZUJpbmRpbmdQcm9wcyA9IHtcbiAgICAgIHJvbGVSZWY6IHtcbiAgICAgICAga2luZDogJ0NsdXN0ZXJSb2xlJyxcbiAgICAgICAgYXBpR3JvdXA6ICcnLFxuICAgICAgICBuYW1lOiAnZ2V0LXBvZHMtcm9sZScsXG4gICAgICB9LFxuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbmFtZXNwYWNlOiBuYW1lc3BhY2UsXG4gICAgICAgIG5hbWU6IG5hbWUsXG4gICAgICB9LFxuICAgICAgc3ViamVjdHM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGtpbmQ6ICdTZXJ2aWNlQWNjb3VudCcsXG4gICAgICAgICAgbmFtZTogbmFtZSxcbiAgICAgICAgICBuYW1lc3BhY2U6IG5hbWVzcGFjZSxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgfTtcbiAgICBjb25zdCBjbHVzdGVycm9sZWJpbmRpbmcgPSBuZXcgazhzLkt1YmVDbHVzdGVyUm9sZUJpbmRpbmcoXG4gICAgICB0aGlzLFxuICAgICAgJ3JvbGViaW5kaW5nJyxcbiAgICAgIGJpbmRpbmdPcHRzLFxuICAgICk7XG4gICAgdGhpcy5uYW1lID0gY2x1c3RlcnJvbGViaW5kaW5nLm5hbWU7XG5cbiAgICBjb25zdCBwdmNQcm9wczogazhzLkt1YmVQZXJzaXN0ZW50Vm9sdW1lQ2xhaW1Qcm9wcyA9IHtcbiAgICAgIG1ldGFkYXRhOiB7XG4gICAgICAgIG5hbWU6IG5hbWUsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBhY2Nlc3NNb2RlczogWydSZWFkV3JpdGVPbmNlJ10sXG4gICAgICAgIHN0b3JhZ2VDbGFzc05hbWU6IHN0b3JhZ2VDbGFzc05hbWUsXG4gICAgICAgIHJlc291cmNlczoge1xuICAgICAgICAgIHJlcXVlc3RzOiB2b2x1bWVyZXF1ZXN0LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuXG4gICAgY29uc3Qgc3RzT3B0czogazhzLkt1YmVTdGF0ZWZ1bFNldFByb3BzID0ge1xuICAgICAgbWV0YWRhdGE6IHtcbiAgICAgICAgbmFtZXNwYWNlOiBuYW1lc3BhY2UsXG4gICAgICAgIG5hbWU6IG5hbWUsXG4gICAgICB9LFxuICAgICAgc3BlYzoge1xuICAgICAgICBzZXJ2aWNlTmFtZTogbmFtZSxcbiAgICAgICAgc2VsZWN0b3I6IHsgbWF0Y2hMYWJlbHM6IGxhYmVscyB9LFxuICAgICAgICByZXBsaWNhczogcmVwbGljYXMsXG4gICAgICAgIHRlbXBsYXRlOiB7XG4gICAgICAgICAgbWV0YWRhdGE6IHsgbGFiZWxzOiBsYWJlbHMgfSxcbiAgICAgICAgICBzcGVjOiB7XG4gICAgICAgICAgICBjb250YWluZXJzOiBbXG4gICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBuYW1lOiAnbW9uZ28tc2lkZWNhcicsXG4gICAgICAgICAgICAgICAgaW1hZ2U6ICdjdmFsbGFuY2UvbW9uZ28tazhzLXNpZGVjYXInLFxuICAgICAgICAgICAgICAgIGVudjogW1xuICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICBuYW1lOiAnTU9OR09fU0lERUNBUl9QT0RfTEFCRUxTJyxcbiAgICAgICAgICAgICAgICAgICAgdmFsdWU6IGBkYj0ke25hbWV9YCxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIG5hbWU6ICdLVUJFX05BTUVTUEFDRScsXG4gICAgICAgICAgICAgICAgICAgIHZhbHVlOiBuYW1lc3BhY2UsXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICBuYW1lOiAnTU9OR09EQl9EQVRBQkFTRScsXG4gICAgICAgICAgICAgICAgICAgIHZhbHVlOiAnYWRtaW4nLFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgbmFtZTogJ01PTkdPREJfVVNFUk5BTUUnLFxuICAgICAgICAgICAgICAgICAgICB2YWx1ZUZyb206IHtcbiAgICAgICAgICAgICAgICAgICAgICBzZWNyZXRLZXlSZWY6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGtleTogJ3VzZXJuYW1lJyxcbiAgICAgICAgICAgICAgICAgICAgICAgIG5hbWU6IG5hbWUsXG4gICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIG5hbWU6ICdNT05HT0RCX1BBU1NXT1JEJyxcbiAgICAgICAgICAgICAgICAgICAgdmFsdWVGcm9tOiB7XG4gICAgICAgICAgICAgICAgICAgICAgc2VjcmV0S2V5UmVmOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBrZXk6ICdwYXNzd29yZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgICAgICAgICAgIGltYWdlOiBpbWFnZU5hbWUsXG4gICAgICAgICAgICAgICAgZW52OiBbXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgIG5hbWU6ICdNT05HT19JTklUREJfUk9PVF9VU0VSTkFNRScsXG4gICAgICAgICAgICAgICAgICAgIHZhbHVlRnJvbToge1xuICAgICAgICAgICAgICAgICAgICAgIHNlY3JldEtleVJlZjoge1xuICAgICAgICAgICAgICAgICAgICAgICAga2V5OiAndXNlcm5hbWUnLFxuICAgICAgICAgICAgICAgICAgICAgICAgbmFtZTogbmFtZSxcbiAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgbmFtZTogJ01PTkdPX0lOSVREQl9ST09UX1BBU1NXT1JEJyxcbiAgICAgICAgICAgICAgICAgICAgdmFsdWVGcm9tOiB7XG4gICAgICAgICAgICAgICAgICAgICAgc2VjcmV0S2V5UmVmOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICBrZXk6ICdwYXNzd29yZCcsXG4gICAgICAgICAgICAgICAgICAgICAgICBuYW1lOiBuYW1lLFxuICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgcmVzb3VyY2VzOiByZXNvdXJjZXMsXG4gICAgICAgICAgICAgICAgcG9ydHM6IFtcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgY29udGFpbmVyUG9ydDogMjcwMTcsXG4gICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAgICAgYXJnczogW1xuICAgICAgICAgICAgICAgICAgJy0tcmVwbFNldCcsXG4gICAgICAgICAgICAgICAgICAncnMwJyxcbiAgICAgICAgICAgICAgICAgICctLWJpbmRfaXAnLFxuICAgICAgICAgICAgICAgICAgJzAuMC4wLjAnLFxuICAgICAgICAgICAgICAgICAgJy0tZGJwYXRoJyxcbiAgICAgICAgICAgICAgICAgICcvZGF0YS9kYicsXG4gICAgICAgICAgICAgICAgICAnLS1vcGxvZ1NpemUnLFxuICAgICAgICAgICAgICAgICAgJzEyOCcsXG4gICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgICB2b2x1bWVNb3VudHM6IFtcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgbmFtZTogbmFtZSxcbiAgICAgICAgICAgICAgICAgICAgbW91bnRQYXRoOiAnL2RhdGEvZGInLFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIHRlcm1pbmF0aW9uR3JhY2VQZXJpb2RTZWNvbmRzOiAxMCxcbiAgICAgICAgICAgIHNlcnZpY2VBY2NvdW50TmFtZTogbmFtZSxcbiAgICAgICAgICAgIG5vZGVTZWxlY3Rvcjogbm9kZVNlbGVjdG9yUGFyYW1zLFxuICAgICAgICAgICAgc2VjdXJpdHlDb250ZXh0OiB7XG4gICAgICAgICAgICAgIGZzR3JvdXA6IDk5OSxcbiAgICAgICAgICAgICAgcnVuQXNHcm91cDogOTk5LFxuICAgICAgICAgICAgICBydW5Bc1VzZXI6IDk5OSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgICAgdm9sdW1lQ2xhaW1UZW1wbGF0ZXM6IFtwdmNQcm9wc10sXG4gICAgICB9LFxuICAgIH07XG5cbiAgICBjb25zdCBzdHMgPSBuZXcgazhzLkt1YmVTdGF0ZWZ1bFNldCh0aGlzLCAnc3RzJywgc3RzT3B0cyk7XG4gICAgdGhpcy5uYW1lID0gc3RzLm5hbWU7XG5cbiAgfVxufVxuXG4vKipcbiAqIENvbnZlcnRzIGEgYFJlc291cmNlUXVhbnRpdHlgIHR5cGUgdG8gYSBrOHMuUXVhbnRpdHkgbWFwLlxuICpcbiAqIElmIGB1c2VyYCBpcyBkZWZpbmVkLCB0aGUgdmFsdWVzIHByb3ZpZGVkIHRoZXJlIChvciBsYWNrIHRoZXJlb2YpIHdpbGwgYmVcbiAqIHBhc3NlZCBvbi4gVGhpcyBtZWFucyB0aGF0IGlmIHRoZSB1c2VyLCBmb3IgZXhhbXBsZSwgZGlkIG5vdCBzcGVjaWZ5IGEgdmFsdWVcbiAqIGZvciBgY3B1YCwgdGhpcyB2YWx1ZSB3aWxsIGJlIG9taXR0ZWQgZnJvbSB0aGUgcmVzb3VyY2UgcmVxdWlyZW1lbnRzLiBUaGlzIGlzXG4gKiBpbnRlbnRpb25hbCwgaW4gY2FzZSB0aGUgdXNlciBpbnRlbnRpb25hbGx5IHdhbnRzIHRvIG9taXQgYSBjb25zdHJhaW50LlxuICpcbiAqIElmIGB1c2VyYCBpcyBub3QgZGVmaW5lZCwgYGRlZmF1bHRzYCBhcmUgdXNlZC5cbiAqL1xuXG5mdW5jdGlvbiBjb252ZXJ0UXVhbnRpdHkoXG4gIHVzZXI6IFJlc291cmNlUXVhbnRpdHkgfCB1bmRlZmluZWQsXG4gIGRlZmF1bHRzOiB7IGNwdTogc3RyaW5nOyBtZW1vcnk6IHN0cmluZyB9LFxuKTogeyBba2V5OiBzdHJpbmddOiBrOHMuUXVhbnRpdHkgfSB7XG4gIC8vIGRlZmF1bHRzXG4gIGlmICghdXNlcikge1xuICAgIHJldHVybiB7XG4gICAgICBjcHU6IGs4cy5RdWFudGl0eS5mcm9tU3RyaW5nKGRlZmF1bHRzLmNwdSksXG4gICAgICBtZW1vcnk6IGs4cy5RdWFudGl0eS5mcm9tU3RyaW5nKGRlZmF1bHRzLm1lbW9yeSksXG4gICAgfTtcbiAgfVxuXG4gIGNvbnN0IHJlc3VsdDogeyBba2V5OiBzdHJpbmddOiBrOHMuUXVhbnRpdHkgfSA9IHt9O1xuXG4gIGlmICh1c2VyLmNwdSkge1xuICAgIHJlc3VsdC5jcHUgPSBrOHMuUXVhbnRpdHkuZnJvbVN0cmluZyh1c2VyLmNwdSk7XG4gIH1cblxuICBpZiAodXNlci5tZW1vcnkpIHtcbiAgICByZXN1bHQubWVtb3J5ID0gazhzLlF1YW50aXR5LmZyb21TdHJpbmcodXNlci5tZW1vcnkpO1xuICB9XG5cbiAgcmV0dXJuIHJlc3VsdDtcbn1cbiJdfQ==