# -*- coding: utf-8 -*-
# Generated by Django 1.11.16 on 2019-01-28 18:20

import django.contrib.auth.validators
from django.db import migrations, models

import evennia.accounts.manager


class Migration(migrations.Migration):

    dependencies = [("accounts", "0007_copy_player_to_account")]

    operations = [
        migrations.AlterModelManagers(
            name="accountdb", managers=[("objects", evennia.accounts.manager.AccountDBManager())]
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_attributes",
            field=models.ManyToManyField(
                help_text="attributes on this object. An attribute can hold any pickle-able python object (see docs for special cases).",
                to="typeclasses.Attribute",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_cmdset_storage",
            field=models.CharField(
                help_text="optional python path to a cmdset class. If creating a Character, this will default to settings.CMDSET_CHARACTER.",
                max_length=255,
                null=True,
                verbose_name="cmdset",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_date_created",
            field=models.DateTimeField(auto_now_add=True, verbose_name="creation date"),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_is_bot",
            field=models.BooleanField(
                default=False, help_text="Used to identify irc/rss bots", verbose_name="is_bot"
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_is_connected",
            field=models.BooleanField(
                default=False,
                help_text="If player is connected to game or not",
                verbose_name="is_connected",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_key",
            field=models.CharField(db_index=True, max_length=255, verbose_name="key"),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_lock_storage",
            field=models.TextField(
                blank=True,
                help_text="locks limit access to an entity. A lock is defined as a 'lock string' on the form 'type:lockfunctions', defining what functionality is locked and how to determine access. Not defining a lock means no access is granted.",
                verbose_name="locks",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_tags",
            field=models.ManyToManyField(
                help_text="tags on this object. Tags are simple string markers to identify, group and alias objects.",
                to="typeclasses.Tag",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="db_typeclass_path",
            field=models.CharField(
                help_text="this defines what 'type' of entity this is. This variable holds a Python path to a module with a valid Evennia Typeclass.",
                max_length=255,
                null=True,
                verbose_name="typeclass",
            ),
        ),
        migrations.AlterField(
            model_name="accountdb",
            name="username",
            field=models.CharField(
                error_messages={"unique": "A user with that username already exists."},
                help_text="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.",
                max_length=150,
                unique=True,
                validators=[django.contrib.auth.validators.UnicodeUsernameValidator()],
                verbose_name="username",
            ),
        ),
    ]
