# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-05 17:36


from django.db import migrations

# This migration only made sense earlier in the git history, during
# the player->account transition. Now it will do nothing since players.PlayerDB
# no longer exists.


def forwards(apps, schema_editor):

    try:
        apps.get_model("players", "PlayerDB")
    except LookupError:
        return
    AccountDB = apps.get_model("accounts", "AccountDB")

    Msg = apps.get_model("comms", "Msg")
    for msg in Msg.objects.all():
        for player in msg.db_sender_players.all():
            account = AccountDB.objects.get(id=player.id)
            msg.db_sender_accounts.add(account)
        for player in msg.db_receivers_players.all():
            account = AccountDB.objects.get(id=player.id)
            msg.db_receivers_accounts.add(account)
        for player in msg.db_hide_from_players.all():
            account = AccountDB.objects.get(id=player.id)
            msg.db_hide_from_accounts.add(account)

    ChannelDB = apps.get_model("comms", "ChannelDB")
    for channel in ChannelDB.objects.all():
        for player in channel.db_subscriptions.all():
            account = AccountDB.objects.get(id=player.id)
            channel.db_account_subscriptions.add(player)


class Migration(migrations.Migration):

    dependencies = [("comms", "0013_auto_20170705_1726")]

    operations = [migrations.RunPython(forwards)]
