import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudiotDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
     * If a device is blocked, connections or requests from this device will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#blocked CloudiotDevice#blocked}
     *
     * @stability stable
     */
    readonly blocked?: boolean | cdktf.IResolvable;
    /**
     * The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#log_level CloudiotDevice#log_level}
     *
     * @stability stable
     */
    readonly logLevel?: string;
    /**
     * The metadata key-value pairs assigned to the device.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#metadata CloudiotDevice#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A unique name for the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#name CloudiotDevice#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name of the device registry where this device should be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#registry CloudiotDevice#registry}
     *
     * @stability stable
     */
    readonly registry: string;
    /**
     * credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#credentials CloudiotDevice#credentials}
     *
     * @stability stable
     */
    readonly credentials?: CloudiotDeviceCredentials[];
    /**
     * gateway_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_config CloudiotDevice#gateway_config}
     *
     * @stability stable
     */
    readonly gatewayConfig?: CloudiotDeviceGatewayConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#timeouts CloudiotDevice#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudiotDeviceTimeouts;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceConfigA extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get binaryData(): string;
    /**
     * @stability stable
     */
    get cloudUpdateTime(): string;
    /**
     * @stability stable
     */
    get deviceAckTime(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceLastErrorStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get details(): any;
    /**
     * @stability stable
     */
    get message(): string;
    /**
     * @stability stable
     */
    get number(): number;
}
/**
 * @stability stable
 */
export declare class CloudiotDeviceState extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get binaryData(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceCredentialsPublicKey {
    /**
     * The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#format CloudiotDevice#format}
     *
     * @stability stable
     */
    readonly format: string;
    /**
     * The key data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#key CloudiotDevice#key}
     *
     * @stability stable
     */
    readonly key: string;
}
export declare function cloudiotDeviceCredentialsPublicKeyToTerraform(struct?: CloudiotDeviceCredentialsPublicKeyOutputReference | CloudiotDeviceCredentialsPublicKey): any;
/**
 * @stability stable
 */
export declare class CloudiotDeviceCredentialsPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudiotDeviceCredentialsPublicKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudiotDeviceCredentialsPublicKey | undefined);
    private _format?;
    /**
     * @stability stable
     */
    get format(): string;
    /**
     * @stability stable
     */
    set format(value: string);
    /**
     * @stability stable
     */
    get formatInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceCredentials {
    /**
     * The time at which this credential becomes invalid.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#expiration_time CloudiotDevice#expiration_time}
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#public_key CloudiotDevice#public_key}
     *
     * @stability stable
     */
    readonly publicKey: CloudiotDeviceCredentialsPublicKey;
}
export declare function cloudiotDeviceCredentialsToTerraform(struct?: CloudiotDeviceCredentials): any;
/**
 * @stability stable
 */
export interface CloudiotDeviceGatewayConfig {
    /**
     * Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_auth_method CloudiotDevice#gateway_auth_method}
     *
     * @stability stable
     */
    readonly gatewayAuthMethod?: string;
    /**
     * Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#gateway_type CloudiotDevice#gateway_type}
     *
     * @stability stable
     */
    readonly gatewayType?: string;
}
export declare function cloudiotDeviceGatewayConfigToTerraform(struct?: CloudiotDeviceGatewayConfigOutputReference | CloudiotDeviceGatewayConfig): any;
/**
 * @stability stable
 */
export declare class CloudiotDeviceGatewayConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudiotDeviceGatewayConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudiotDeviceGatewayConfig | undefined);
    private _gatewayAuthMethod?;
    /**
     * @stability stable
     */
    get gatewayAuthMethod(): string;
    /**
     * @stability stable
     */
    set gatewayAuthMethod(value: string);
    /**
     * @stability stable
     */
    resetGatewayAuthMethod(): void;
    /**
     * @stability stable
     */
    get gatewayAuthMethodInput(): string | undefined;
    private _gatewayType?;
    /**
     * @stability stable
     */
    get gatewayType(): string;
    /**
     * @stability stable
     */
    set gatewayType(value: string);
    /**
     * @stability stable
     */
    resetGatewayType(): void;
    /**
     * @stability stable
     */
    get gatewayTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudiotDeviceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#create CloudiotDevice#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#delete CloudiotDevice#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html#update CloudiotDevice#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cloudiotDeviceTimeoutsToTerraform(struct?: CloudiotDeviceTimeoutsOutputReference | CloudiotDeviceTimeouts): any;
/**
 * @stability stable
 */
export declare class CloudiotDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudiotDeviceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudiotDeviceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device}.
 *
 * @stability stable
 */
export declare class CloudiotDevice extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device.html google_cloudiot_device} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudiotDeviceConfig);
    private _blocked?;
    /**
     * @stability stable
     */
    get blocked(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set blocked(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBlocked(): void;
    /**
     * @stability stable
     */
    get blockedInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    config(index: string): CloudiotDeviceConfigA;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastConfigAckTime(): string;
    /**
     * @stability stable
     */
    get lastConfigSendTime(): string;
    /**
     * @stability stable
     */
    lastErrorStatus(index: string): CloudiotDeviceLastErrorStatus;
    /**
     * @stability stable
     */
    get lastErrorTime(): string;
    /**
     * @stability stable
     */
    get lastEventTime(): string;
    /**
     * @stability stable
     */
    get lastHeartbeatTime(): string;
    /**
     * @stability stable
     */
    get lastStateTime(): string;
    private _logLevel?;
    /**
     * @stability stable
     */
    get logLevel(): string;
    /**
     * @stability stable
     */
    set logLevel(value: string);
    /**
     * @stability stable
     */
    resetLogLevel(): void;
    /**
     * @stability stable
     */
    get logLevelInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get numId(): string;
    private _registry?;
    /**
     * @stability stable
     */
    get registry(): string;
    /**
     * @stability stable
     */
    set registry(value: string);
    /**
     * @stability stable
     */
    get registryInput(): string | undefined;
    /**
     * @stability stable
     */
    state(index: string): CloudiotDeviceState;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): CloudiotDeviceCredentials[];
    /**
     * @stability stable
     */
    set credentials(value: CloudiotDeviceCredentials[]);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): CloudiotDeviceCredentials[] | undefined;
    private _gatewayConfig;
    /**
     * @stability stable
     */
    get gatewayConfig(): CloudiotDeviceGatewayConfigOutputReference;
    /**
     * @stability stable
     */
    putGatewayConfig(value: CloudiotDeviceGatewayConfig): void;
    /**
     * @stability stable
     */
    resetGatewayConfig(): void;
    /**
     * @stability stable
     */
    get gatewayConfigInput(): CloudiotDeviceGatewayConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CloudiotDeviceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudiotDeviceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudiotDeviceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
