# Generated by Django 3.1.14 on 2022-04-22 19:58

import django.db.models.deletion
from django.db import migrations, models

import ob_dj_store.utils.model


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0002_auto_20220422_0205"),
    ]

    operations = [
        migrations.CreateModel(
            name="OpeningHours",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "weekday",
                    models.IntegerField(
                        choices=[
                            (1, "Monday"),
                            (2, "Tuesday"),
                            (3, "Wednesday"),
                            (4, "Thursday"),
                            (5, "Friday"),
                            (6, "Saturday"),
                            (7, "Sunday"),
                        ]
                    ),
                ),
                ("from_hour", models.TimeField(help_text="Opening hours: From hour ")),
                ("to_hour", models.TimeField(help_text="Opening hours: To hour ")),
                (
                    "store",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="opening_hours",
                        to="stores.store",
                    ),
                ),
            ],
            options={
                "ordering": ("weekday", "from_hour"),
                "unique_together": {("weekday", "store")},
            },
            bases=(ob_dj_store.utils.model.DjangoModelCleanMixin, models.Model),
        ),
    ]
