# Generated by Django 3.1.14 on 2022-08-25 14:36

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0036_productattribute_is_mandatory"),
    ]

    operations = [
        migrations.AlterField(
            model_name="order",
            name="shipping_address",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="orders",
                to="stores.address",
            ),
        ),
        migrations.CreateModel(
            name="Tax",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("description", models.TextField(blank=True, null=True)),
                ("name", models.CharField(help_text="Name", max_length=200)),
                (
                    "rate",
                    models.CharField(
                        choices=[("PERCENTAGE", "percentage"), ("FLAT", "flat")],
                        help_text="Tax Rate for the given payment",
                        max_length=32,
                    ),
                ),
                ("is_applied", models.BooleanField(default=True)),
                (
                    "value",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="Value for the given Payment -> 0.0625",
                        max_digits=5,
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "payment",
                    models.OneToOneField(
                        help_text="Reference local payment transaction",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment_tax",
                        to="stores.payment",
                    ),
                ),
            ],
        ),
    ]
