import datetime
from web3.contract import ContractFunction
from web3.main import Web3

# Honeypot Check Globals
maxTxAmount = 0
maxSell = 0

def GetSomeEther(toAddress):
    weth = '0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2'

    return None

def GetMaxes(w3:Web3, contract:ContractFunction):
    global maxTxAmount
    global maxSell

    try:
        maxTxAmount = contract.functions._maxTxAmount().call()
        print("MaxTxAmount {0}".format(maxTxAmount))
    except:
        try:
            maxSell = contract.functions.maxSellTransactionAmount().call()
            print("maxSell {0}".format(maxSell))
        except:
            print('no maxes')

def RunHonypotCheckNEW(address, w3):

    senderAddr = str('0x8894e0a0c962cb723c1976a4421c95949be2d4e3')
    amountIn = 10000000000000000

    valid1 = w3.toChecksumAddress(senderAddr)
    valid2 = w3.toChecksumAddress('0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7')

    # ORIGINAL: encodedAddress = web3.eth.abi.encodeParameter('address', address)
    #TODO: encodedAddress = requires eth_abi encoding
    encodedAddress = w3.toHex(w3.codec.encode_single('address', address))

    #encodedAddress = '0x000000000000000000000000ffeb6c443e2433c68af6345ebe267eeb1a333202'
    contractFuncData = '0xd66383cb'
    callData = contractFuncData+encodedAddress[2:]

    # 2) build a transaction:
    txn_params = {
        "from": valid1,
        "to": valid2,
        "value": hex(amountIn),
        "gas": hex(45000000),
        "data": callData  # Your function hash
    }

    # 3) sanity check - read from the contract: 
    #call_result = w3.eth.call(txn_params)
    #result = w3.codec.decode_single("string", call_result)
    #assert result == "Hello world!"

    # 4) tweak the contract in Remix, for example,
    #    then compile and grab the *runtime* bytecode
    bbCode = '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'

    # 5) make the call again, but with overridden bytecode:
    override_params = {
        "0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7": {"code": bbCode},
        "0xCD5312d086f078D1554e8813C27Cf6C9D1C3D9b3": {"code": '0x608060405234801561001057600080fd5b50600436106100365760003560e01c806312bdf4231461003b578063155d0ed914610062575b600080fd5b61004e610049366004610127565b6100b1565b604051901515815260200160405180910390f35b6100af610070366004610127565b6001600160a01b039283166000908152602081815260408083204390819055948616835260018252808320859055929094168152600290935290912055565b005b6001600160a01b0380821660009081526002602090815260408083205486851684526001835281842054948816845291839052822054919283926100f5919061016a565b6100ff919061016a565b50600095945050505050565b80356001600160a01b038116811461012257600080fd5b919050565b60008060006060848603121561013c57600080fd5b6101458461010b565b92506101536020850161010b565b91506101616040850161010b565b90509250925092565b6000821982111561018b57634e487b7160e01b600052601160045260246000fd5b50019056fea26469706673582212202288a2eeda68890e8bd67abf689f2c0469dcc2bc6b9cc73f7876d2f8d63dfea764736f6c63430008060033'},
        senderAddr: {"balance": hex(100000000000000000000)},
    }
    
    try:
        override_result = w3.eth.call(txn_params, "latest", override_params)
        decoded = w3.codec.decode_abi(['uint256', 'uint256', 'uint256', 'uint256', 'uint256', 'uint256'], override_result)
        
        #TODO: web3.utils.toBN(decoded[1])
        buyExpectedOut = decoded[0]
        buyActualOut = decoded[1]
        sellExpectedOut = decoded[2]
        sellActualOut = decoded[3]
        buyGasUsed = decoded[4]
        sellGasUsed = decoded[5]
        buy_tax = round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10
        sell_tax =round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10

        retData = {
        "buyExpectedOut": buyExpectedOut,
        "buyActualOut": buyActualOut,
        "sellExpectedOut": sellExpectedOut,
        "sellActualOut": sellActualOut,
        "buyGasUsed": buyGasUsed,
        "sellGasUsed": sellGasUsed,
        "buy_tax": round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10,
        "sell_tax": round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10
        }
        #print("buyExpectedOut: {0}".format(buyExpectedOut))
        #print("buyActualOut: {0}".format(buyActualOut))
        #print("sellExpectedOut: {0}".format(sellExpectedOut))
        #print("sellActualOut: {0}".format(sellActualOut))
        #print("buyGasUsed: {0}".format(buyGasUsed))
        #print("sellGasUsed: {0}".format(sellGasUsed))
        #print("buy_tax: {0}".format(buy_tax))
        #print("sell_tax: {0}".format(sell_tax))

        print("{0} - Result: {1}".format(datetime.datetime.now(), retData))
        return retData
    except:
        print("{0} - Result: Is a honeypot".format(datetime.datetime.now()))
        return "Is a honeypot!"

def RunHonypotCheckWithParams(tokenToCheck, amountInWei:int, addrSender, w3):

    senderAddr = str(addrSender)
    amountIn = int(amountInWei)

    valid1 = w3.toChecksumAddress(senderAddr)
    valid2 = w3.toChecksumAddress('0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7')

    # ORIGINAL: encodedAddress = web3.eth.abi.encodeParameter('address', address)
    #TODO: encodedAddress = requires eth_abi encoding
    encodedAddress = w3.toHex(w3.codec.encode_single('address', tokenToCheck))

    #encodedAddress = '0x000000000000000000000000ffeb6c443e2433c68af6345ebe267eeb1a333202'
    contractFuncData = '0xd66383cb'
    callData = contractFuncData+encodedAddress[2:]

    # 2) build a transaction:
    txn_params = {
        "from": valid1,
        "to": valid2,
        "value": hex(amountIn),
        "gas": hex(45000000),
        "data": callData  # Your function hash
    }

    # 3) sanity check - read from the contract: 
    #call_result = w3.eth.call(txn_params)
    #result = w3.codec.decode_single("string", call_result)
    #assert result == "Hello world!"

    # 4) tweak the contract in Remix, for example,
    #    then compile and grab the *runtime* bytecode
    bbCode = '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'

    # 5) make the call again, but with overridden bytecode:
    override_params = {
        "0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7": {"code": bbCode},
        "0xCD5312d086f078D1554e8813C27Cf6C9D1C3D9b3": {"code": '0x608060405234801561001057600080fd5b50600436106100365760003560e01c806312bdf4231461003b578063155d0ed914610062575b600080fd5b61004e610049366004610127565b6100b1565b604051901515815260200160405180910390f35b6100af610070366004610127565b6001600160a01b039283166000908152602081815260408083204390819055948616835260018252808320859055929094168152600290935290912055565b005b6001600160a01b0380821660009081526002602090815260408083205486851684526001835281842054948816845291839052822054919283926100f5919061016a565b6100ff919061016a565b50600095945050505050565b80356001600160a01b038116811461012257600080fd5b919050565b60008060006060848603121561013c57600080fd5b6101458461010b565b92506101536020850161010b565b91506101616040850161010b565b90509250925092565b6000821982111561018b57634e487b7160e01b600052601160045260246000fd5b50019056fea26469706673582212202288a2eeda68890e8bd67abf689f2c0469dcc2bc6b9cc73f7876d2f8d63dfea764736f6c63430008060033'},
        senderAddr: {"balance": hex(100000000000000000000)},
    }
    
    try:
        override_result = w3.eth.call(txn_params, "latest", override_params)
        decoded = w3.codec.decode_abi(['uint256', 'uint256', 'uint256', 'uint256', 'uint256', 'uint256'], override_result)
        
        #TODO: web3.utils.toBN(decoded[1])
        buyExpectedOut = decoded[0]
        buyActualOut = decoded[1]
        sellExpectedOut = decoded[2]
        sellActualOut = decoded[3]
        buyGasUsed = decoded[4]
        sellGasUsed = decoded[5]
        buy_tax = round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10
        sell_tax =round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10

        retData = {
        "buyExpectedOut": buyExpectedOut,
        "buyActualOut": buyActualOut,
        "sellExpectedOut": sellExpectedOut,
        "sellActualOut": sellActualOut,
        "buyGasUsed": buyGasUsed,
        "sellGasUsed": sellGasUsed,
        "buy_tax": round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10,
        "sell_tax": round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10
        }
        #print("buyExpectedOut: {0}".format(buyExpectedOut))
        #print("buyActualOut: {0}".format(buyActualOut))
        #print("sellExpectedOut: {0}".format(sellExpectedOut))
        #print("sellActualOut: {0}".format(sellActualOut))
        #print("buyGasUsed: {0}".format(buyGasUsed))
        #print("sellGasUsed: {0}".format(sellGasUsed))
        #print("buy_tax: {0}".format(buy_tax))
        #print("sell_tax: {0}".format(sell_tax))

        return retData
    except Exception as e:
        #print("{0}|{1}| - Result: Is a honeypot! Exception: {2}".format(datetime.datetime.now(), tokenToCheck, e))
        return "Is a honeypot!"

def RunHonypotCheckWithParamsBSC(tokenToCheck, amountInWei:int, addrSender, w3):

    senderAddr = str(addrSender)
    amountIn = int(amountInWei)

    toAddr = w3.toChecksumAddress('0x2bf75fd2fab5fc635a4c6073864c708dfc8396fc')
    fromAddr = w3.toChecksumAddress('0x8894e0a0c962cb723c1976a4421c95949be2d4e3')

    # ORIGINAL: encodedAddress = web3.eth.abi.encodeParameter('address', address)
    #TODO: encodedAddress = requires eth_abi encoding
    encodedAddress = w3.toHex(w3.codec.encode_single('address', tokenToCheck))

    #encodedAddress = '0x000000000000000000000000ffeb6c443e2433c68af6345ebe267eeb1a333202'
    contractFuncData = '0xd66383cb'
    callData = contractFuncData+encodedAddress[2:]

    # 2) build a transaction:
    txn_params = {
        "from": fromAddr,
        "to": toAddr,
        "value": hex(amountInWei),
        "gas": hex(45000000),
        "data": callData  # Your function hash
    }

    try:
        override_result = w3.eth.call(txn_params)
        decoded = w3.codec.decode_abi(['uint256', 'uint256', 'uint256', 'uint256', 'uint256', 'uint256'], override_result)
        
        #TODO: web3.utils.toBN(decoded[1])
        buyExpectedOut = decoded[0]
        buyActualOut = decoded[1]
        sellExpectedOut = decoded[2]
        sellActualOut = decoded[3]
        buyGasUsed = decoded[4]
        sellGasUsed = decoded[5]
        buy_tax = round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10
        sell_tax =round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10

        retData = {
        "buyExpectedOut": buyExpectedOut,
        "buyActualOut": buyActualOut,
        "sellExpectedOut": sellExpectedOut,
        "sellActualOut": sellActualOut,
        "buyGasUsed": buyGasUsed,
        "sellGasUsed": sellGasUsed,
        "buy_tax": round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10,
        "sell_tax": round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10
        }
        #print("buyExpectedOut: {0}".format(buyExpectedOut))
        #print("buyActualOut: {0}".format(buyActualOut))
        #print("sellExpectedOut: {0}".format(sellExpectedOut))
        #print("sellActualOut: {0}".format(sellActualOut))
        #print("buyGasUsed: {0}".format(buyGasUsed))
        #print("sellGasUsed: {0}".format(sellGasUsed))
        #print("buy_tax: {0}".format(buy_tax))
        #print("sell_tax: {0}".format(sell_tax))

        return retData
    except Exception as e:
        #print("{0}|{1}| - Result: Is a honeypot! Exception: {2}".format(datetime.datetime.now(), tokenToCheck, e))
        return "Is a honeypot!"

def RunHoneypotCMen(tokenToCheck, amountInWei:int, addrSender, w3):

    senderAddr = str(addrSender)
    amountIn = int(amountInWei)
    valid1 = w3.toChecksumAddress(senderAddr)
    valid2 = w3.toChecksumAddress('0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7')

    # ORIGINAL: encodedAddress = web3.eth.abi.encodeParameter('address', address)
    #TODO: encodedAddress = requires eth_abi encoding
    encodedAddress = w3.toHex(w3.codec.encode_single('address', tokenToCheck))

    #encodedAddress = '0x000000000000000000000000ffeb6c443e2433c68af6345ebe267eeb1a333202'
    #contractFuncData = '0xd66383cb'
    contractFuncData = '0x117791a8'
    callData = contractFuncData+encodedAddress[2:]
    
    # 2) build a transaction:
    txn_params = {
        "from": valid1,
        "to": valid2,
        "value": hex(amountIn),
        "gas": hex(45000000),
        "data": callData  # Your function hash
    }

    # 3) sanity check - read from the contract: 
    #call_result = w3.eth.call(txn_params)
    #result = w3.codec.decode_single("string", call_result)
    #assert result == "Hello world!"

    # 4) tweak the contract in Remix, for example,
    #    then compile and grab the *runtime* bytecode
    #bbCode = '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'
    bbCode = '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'

    # 5) make the call again, but with overridden bytecode:
    override_params = {
        "0x5bf62ec82af715ca7aa365634fab0e8fd7bf92c7": {"code": bbCode},
        #"0xCD5312d086f078D1554e8813C27Cf6C9D1C3D9b3": {"code": '0x608060405234801561001057600080fd5b50600436106100365760003560e01c806312bdf4231461003b578063155d0ed914610062575b600080fd5b61004e610049366004610127565b6100b1565b604051901515815260200160405180910390f35b6100af610070366004610127565b6001600160a01b039283166000908152602081815260408083204390819055948616835260018252808320859055929094168152600290935290912055565b005b6001600160a01b0380821660009081526002602090815260408083205486851684526001835281842054948816845291839052822054919283926100f5919061016a565b6100ff919061016a565b50600095945050505050565b80356001600160a01b038116811461012257600080fd5b919050565b60008060006060848603121561013c57600080fd5b6101458461010b565b92506101536020850161010b565b91506101616040850161010b565b90509250925092565b6000821982111561018b57634e487b7160e01b600052601160045260246000fd5b50019056fea26469706673582212202288a2eeda68890e8bd67abf689f2c0469dcc2bc6b9cc73f7876d2f8d63dfea764736f6c63430008060033'},
        senderAddr: {"balance": hex(100000000000000000000)}
    }
    
    try:
        override_result = w3.eth.call(txn_params, "latest", override_params)
        #decoded = w3.codec.decode_abi(['uint256', 'uint256'], override_result)
        decoded = w3.codec.decode_abi(['uint256', 'uint256', 'uint256'], override_result)
        
        #TODO: web3.utils.toBN(decoded[1])
        #buyExpectedOut = decoded[0]
        #buyActualOut = decoded[1]
        #sellExpectedOut = decoded[2]
        #sellActualOut = decoded[3]
        buyGasUsed = decoded[0]
        sellGasUsed = decoded[1]
        #buy_tax = round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10
        #sell_tax =round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10

        retData = {
        #"buyExpectedOut": buyExpectedOut,
        #"buyActualOut": buyActualOut,
        #"sellExpectedOut": sellExpectedOut,
        #"sellActualOut": sellActualOut,
        "buyGasUsed": buyGasUsed,
        "sellGasUsed": sellGasUsed,
        #"buy_tax": round((buyExpectedOut - buyActualOut) / buyExpectedOut * 100 * 10) / 10,
        #"sell_tax": round((sellExpectedOut - sellActualOut) / sellExpectedOut * 100 * 10) / 10
        }
        #print("buyExpectedOut: {0}".format(buyExpectedOut))
        #print("buyActualOut: {0}".format(buyActualOut))
        #print("sellExpectedOut: {0}".format(sellExpectedOut))
        #print("sellActualOut: {0}".format(sellActualOut))
        #print("buyGasUsed: {0}".format(buyGasUsed))
        #print("sellGasUsed: {0}".format(sellGasUsed))
        #print("buy_tax: {0}".format(buy_tax))
        #print("sell_tax: {0}".format(sell_tax))

        return retData
    except Exception as e:
        #print("{0}|{1}| - Result: Is a honeypot! Exception: {2}".format(datetime.datetime.now(), tokenToCheck, e))
        return "Is a honeypot!"