Grizli Image Release v6.0 - 8 March 2023
========================================

This release provides a repository of the primary public JWST imaging datasets,
now uniformly reprocessed with updated calibration files and `grizli==1.8`.

Data
----

  - **S** "science" data, `sci.fits`
  - **W** inverse variance weights `wht.fits`
  - **RGB** Field image generated from F115W + F277W + F444W
  - **ir** combined LW image for source detection
  - Catalogs and photo-zs TBD


| field            | note                         | IMG                                                                                                                                                                                               | f070w                                                                                                                                                                                                     | f090w                                                                                                                                                                                                                           | f115w                                                                                                                                                                                                                           | f150w                                                                                                                                                                                                                           | f182m                                                                                                                                                                                                 | f200w                                                                                                                                                                                                                           | f210m                                                                                                                                                                                                 | f277w                                                                                                                                                                                                                           | f300m                                                                                                                                                                                                     | f356w                                                                                                                                                                                                                           | f410m                                                                                                                                                                                                                           | f430m                                                                                                                                                                                                 | f444w                                                                                                                                                                                                                           | f460m                                                                                                                                                                                                 | f480m                                                                                                                                                                                                           | ir                                                                                                                                                                                              | NIS-f356w                                                                                                                                                                                                                 | NIS-f430m                                                                                                                                                                                               | NIS-f444w                                                                                                                                                                                                                 | NIS-f480m                                                                                                                                                                                               | NIS-f115w                                                                                                                                                                                                                 | NIS-f150w                                                                                                                                                                                                                 | NIS-f200w                                                                                                                                                                                                                 |
|:-----------------|:-----------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| ceers-full       | ERS-1345                     | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0.f444w.jpg)             |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f115w-clear_drc_wht.fits.gz)             | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f150w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f200w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f277w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f356w-clear_drc_wht.fits.gz)             | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f410m-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ceers-full-grizli-v6.0-f444w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| cosweb           | First epoch                  | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0.f444w.jpg)                     |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                     | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                       |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                       |                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/cosweb-grizli-v6.0-ir_drc_wht.fits.gz)       |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| primer-cosmos    | GO-1837                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0.f444w.jpg)       |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f090w-clear_drc_wht.fits.gz)       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f115w-clear_drc_wht.fits.gz)       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f150w-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f200w-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f277w-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f356w-clear_drc_wht.fits.gz)       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f410m-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-cosmos-grizli-v6.0-f444w-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| primer-uds       | GO-1837                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0.f444w.jpg)             |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f090w-clear_drc_wht.fits.gz)             | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f115w-clear_drc_wht.fits.gz)             | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f150w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f200w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f277w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f356w-clear_drc_wht.fits.gz)             | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f410m-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/primer-uds-grizli-v6.0-f444w-clear_drc_wht.fits.gz)             |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| gdn              | FRESCO                       | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0.f444w.jpg)                           |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f182m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f182m-clear_drc_wht.fits.gz) |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f210m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f210m-clear_drc_wht.fits.gz) |                                                                                                                                                                                                                                 |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gdn-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                           |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| gds              | FRESCO, GO-1963              | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0.f444w.jpg)                           |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f182m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f182m-clear_drc_wht.fits.gz) |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f210m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f210m-clear_drc_wht.fits.gz) |                                                                                                                                                                                                                                 |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f430m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f430m-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f460m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f460m-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f480m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f480m-clear_drc_wht.fits.gz)           |                                                                                                                                                                                                 |                                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-clearp-f430m_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-clearp-f430m_drc_wht.fits.gz) |                                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-clearp-f480m_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-clearp-f480m_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f115wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f115wn-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f150wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f150wn-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f200wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/gds-grizli-v6.0-f200wn-clear_drc_wht.fits.gz)                   |
| ngdeep           | GO-2079                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0.f444w.jpg)                     |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                     | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                     |                                                                                                                                                                                                       |                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/ngdeep-grizli-v6.0-ir_drc_wht.fits.gz)       |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| j1235            | COM-1063                     | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0.f444w.jpg)                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f070w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f070w-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f090w-clear_drc_wht.fits.gz)                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f300m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f300m-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                       |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                       |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f480m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/j1235-grizli-v6.0-f480m-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| jwst-nep-tdf-nrc | GTO-2738                     | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0.f444w.jpg) |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f090w-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f115w-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f150w-clear_drc_wht.fits.gz) |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f200w-clear_drc_wht.fits.gz) |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f277w-clear_drc_wht.fits.gz) |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f356w-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f410m-clear_drc_wht.fits.gz) |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/jwst-nep-tdf-nrc-grizli-v6.0-f444w-clear_drc_wht.fits.gz) |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |

Lensing clusters
----------------

| field            | note                         | IMG                                                                                                                                                                                               | f070w                                                                                                                                                                                                     | f090w                                                                                                                                                                                                                           | f115w                                                                                                                                                                                                                           | f150w                                                                                                                                                                                                                           | f182m                                                                                                                                                                                                 | f200w                                                                                                                                                                                                                           | f210m                                                                                                                                                                                                 | f277w                                                                                                                                                                                                                           | f300m                                                                                                                                                                                                     | f356w                                                                                                                                                                                                                           | f410m                                                                                                                                                                                                                           | f430m                                                                                                                                                                                                 | f444w                                                                                                                                                                                                                           | f460m                                                                                                                                                                                                 | f480m                                                                                                                                                                                                           | ir                                                                                                                                                                                              | NIS-f356w                                                                                                                                                                                                                 | NIS-f430m                                                                                                                                                                                               | NIS-f444w                                                                                                                                                                                                                 | NIS-f480m                                                                                                                                                                                               | NIS-f115w                                                                                                                                                                                                                 | NIS-f150w                                                                                                                                                                                                                 | NIS-f200w                                                                                                                                                                                                                 |
|:-----------------|:-----------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
| abell2744clu     | GLASS-ERS, UNCOVER, DD-2756  | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0.f444w.jpg)         |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f090w-clear_drc_wht.fits.gz)         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f115w-clear_drc_wht.fits.gz)         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f150w-clear_drc_wht.fits.gz)         |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f200w-clear_drc_wht.fits.gz)         |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f277w-clear_drc_wht.fits.gz)         |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f356w-clear_drc_wht.fits.gz)         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f410m-clear_drc_wht.fits.gz)         |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f444w-clear_drc_wht.fits.gz)         |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-clearp-f356w_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-clearp-f356w_drc_wht.fits.gz) |                                                                                                                                                                                                         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-clearp-f444w_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-clearp-f444w_drc_wht.fits.gz) |                                                                                                                                                                                                         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f115wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f115wn-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f150wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f150wn-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f200wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/abell2744clu-grizli-v6.0-f200wn-clear_drc_wht.fits.gz) |
| macs0647         | GO-1433                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0.f444w.jpg)                 |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f480m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-f480m-clear_drc_wht.fits.gz) | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/macs0647-grizli-v6.0-ir_drc_wht.fits.gz)   |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| rxj2129          | DD-2767                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0.f444w.jpg)                   |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       |                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/rxj2129-grizli-v6.0-ir_drc_wht.fits.gz)     |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| sgas1723         | ERS-1355                     | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0.f444w.jpg)                 |                                                                                                                                                                                                           |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sgas1723-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                 |                                                                                                                                                                                                       |                                                                                                                                                                                                                 |                                                                                                                                                                                                 |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
| smacs0723        | ERO-2736                     | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0.f444w.jpg)               |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f090w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f150w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f200w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f277w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f356w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                                                 |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f444w-clear_drc_wht.fits.gz)               |                                                                                                                                                                                                       |                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-ir_drc_wht.fits.gz) |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f115wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f115wn-clear_drc_wht.fits.gz)       |                                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f200wn-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/smacs0723-grizli-v6.0-f200wn-clear_drc_wht.fits.gz)       |
| sunrise          | GO-2282                      | [RGB](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0.field.jpg) [f444w](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0.f444w.jpg)                   |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f090w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f090w-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f115w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f115w-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f150w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f150w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f200w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f200w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f277w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f277w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                           | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f356w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f356w-clear_drc_wht.fits.gz)                   | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f410m-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f410m-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f444w-clear_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-f444w-clear_drc_wht.fits.gz)                   |                                                                                                                                                                                                       |                                                                                                                                                                                                                 | [S](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-ir_drc_sci.fits.gz) [W](https://s3.amazonaws.com/grizli-v2/JwstMosaics/v6/sunrise-grizli-v6.0-ir_drc_wht.fits.gz)     |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                         |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |                                                                                                                                                                                                                           |
