import * as iot from '@aws-cdk/aws-iot';
import * as logs from '@aws-cdk/aws-logs';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for CloudWatch Logs.
 *
 * @experimental
 */
export interface CloudWatchLogsActionProps extends CommonActionProps {
}
/**
 * (experimental) The action to send data to Amazon CloudWatch Logs.
 *
 * @experimental
 */
export declare class CloudWatchLogsAction implements iot.IAction {
    private readonly logGroup;
    private readonly role?;
    /**
     * @param logGroup The CloudWatch log group to which the action sends data.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(logGroup: logs.ILogGroup, props?: CloudWatchLogsActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
