"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data stream.
 *
 * @experimental
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(stream, props) {
        this.stream = stream;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_KinesisPutRecordActionProps(props);
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.KinesisPutRecordAction = KinesisPutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.KinesisPutRecordAction", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpcy1wdXQtcmVjb3JkLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImtpbmVzaXMtcHV0LXJlY29yZC1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsd0NBQXdDO0FBSXhDLHlDQUFxRDs7Ozs7O0FBU3JELE1BQWEsc0JBQXNCOzs7Ozs7SUFLakMsWUFBNkIsTUFBdUIsRUFBRSxLQUFrQztRQUEzRCxXQUFNLEdBQU4sTUFBTSxDQUFpQjs7UUFDbEQsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztLQUN4Qjs7Ozs7O0lBRUQsSUFBSSxDQUFDLElBQW9COztRQUN2QixNQUFNLElBQUksU0FBRyxJQUFJLENBQUMsSUFBSSxtQ0FBSSwwQkFBbUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwRCxJQUFJLENBQUMsb0JBQW9CLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ2hELE9BQU8sRUFBRSxDQUFDLG1CQUFtQixDQUFDO1lBQzlCLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDO1NBQ25DLENBQUMsQ0FBQyxDQUFDO1FBRUosT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixPQUFPLEVBQUU7b0JBQ1AsVUFBVSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVTtvQkFDbEMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZLElBQUksU0FBUztvQkFDNUMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO2lCQUN0QjthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQTFCSCx3REEyQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBpb3QgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdCc7XG5pbXBvcnQgKiBhcyBraW5lc2lzIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzJztcbmltcG9ydCB7IENvbW1vbkFjdGlvblByb3BzIH0gZnJvbSAnLi9jb21tb24tYWN0aW9uLXByb3BzJztcbmltcG9ydCB7IHNpbmdsZXRvbkFjdGlvblJvbGUgfSBmcm9tICcuL3ByaXZhdGUvcm9sZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEtpbmVzaXNQdXRSZWNvcmRBY3Rpb25Qcm9wcyBleHRlbmRzIENvbW1vbkFjdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcGFydGl0aW9uS2V5OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBLaW5lc2lzUHV0UmVjb3JkQWN0aW9uIGltcGxlbWVudHMgaW90LklBY3Rpb24ge1xuICBwcml2YXRlIHJlYWRvbmx5IHBhcnRpdGlvbktleT86IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSByb2xlPzogaWFtLklSb2xlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgc3RyZWFtOiBraW5lc2lzLklTdHJlYW0sIHByb3BzOiBLaW5lc2lzUHV0UmVjb3JkQWN0aW9uUHJvcHMpIHtcbiAgICB0aGlzLnBhcnRpdGlvbktleSA9IHByb3BzLnBhcnRpdGlvbktleTtcbiAgICB0aGlzLnJvbGUgPSBwcm9wcy5yb2xlO1xuICB9XG5cbiAgYmluZChydWxlOiBpb3QuSVRvcGljUnVsZSk6IGlvdC5BY3Rpb25Db25maWcge1xuICAgIGNvbnN0IHJvbGUgPSB0aGlzLnJvbGUgPz8gc2luZ2xldG9uQWN0aW9uUm9sZShydWxlKTtcbiAgICByb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFsna2luZXNpczpQdXRSZWNvcmQnXSxcbiAgICAgIHJlc291cmNlczogW3RoaXMuc3RyZWFtLnN0cmVhbUFybl0sXG4gICAgfSkpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAga2luZXNpczoge1xuICAgICAgICAgIHN0cmVhbU5hbWU6IHRoaXMuc3RyZWFtLnN0cmVhbU5hbWUsXG4gICAgICAgICAgcGFydGl0aW9uS2V5OiB0aGlzLnBhcnRpdGlvbktleSB8fCB1bmRlZmluZWQsXG4gICAgICAgICAgcm9sZUFybjogcm9sZS5yb2xlQXJuLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=