"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const cdk_nag_1 = require("cdk-nag");
const constructs_1 = require("constructs");
const nag_helper_1 = require("./nag-helper");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool", {
                passwordPolicy: {
                    minLength: 8,
                    requireLowercase: true,
                    requireUppercase: true,
                    requireDigits: true,
                    requireSymbols: true,
                },
                mfa: aws_cognito_1.Mfa.REQUIRED,
                accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
                autoVerify: {
                    email: true,
                },
            });
            this.userPool.node.defaultChild.userPoolAddOns = {
                advancedSecurityMode: "ENFORCED",
            };
            const stack = aws_cdk_lib_1.Stack.of(this);
            cdk_nag_1.NagSuppressions.addResourceSuppressionsByPath(stack, `${nag_helper_1.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                {
                    id: "AwsSolutions-IAM5",
                    reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                    appliesTo: ["Resource::*"],
                },
            ]);
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({ userPool: this.userPool })]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.3.7" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci1pZGVudGl0eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy91c2VyLWlkZW50aXR5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7Ozs7Ozs7Ozs7Ozs7O3dIQWN3SDtBQUN4SCw0RkFJaUQ7QUFDakQsNkNBQW9DO0FBQ3BDLHlEQU1pQztBQUNqQyxxQ0FBMEM7QUFDMUMsMkNBQXVDO0FBQ3ZDLDZDQUE4QztBQW1COUM7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxzQkFBUztJQUt6QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsZ0ZBQWdGO1FBQ2hGLElBQUksQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO1lBQ3BCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxzQkFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7Z0JBQzdDLGNBQWMsRUFBRTtvQkFDZCxTQUFTLEVBQUUsQ0FBQztvQkFDWixnQkFBZ0IsRUFBRSxJQUFJO29CQUN0QixnQkFBZ0IsRUFBRSxJQUFJO29CQUN0QixhQUFhLEVBQUUsSUFBSTtvQkFDbkIsY0FBYyxFQUFFLElBQUk7aUJBQ3JCO2dCQUNELEdBQUcsRUFBRSxpQkFBRyxDQUFDLFFBQVE7Z0JBQ2pCLGVBQWUsRUFBRSw2QkFBZSxDQUFDLFVBQVU7Z0JBQzNDLFVBQVUsRUFBRTtvQkFDVixLQUFLLEVBQUUsSUFBSTtpQkFDWjthQUNGLENBQUMsQ0FBQztZQUVGLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFlBQTRCLENBQUMsY0FBYyxHQUFHO2dCQUNoRSxvQkFBb0IsRUFBRSxVQUFVO2FBQ2pDLENBQUM7WUFFRixNQUFNLEtBQUssR0FBRyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUM3Qix5QkFBZSxDQUFDLDZCQUE2QixDQUMzQyxLQUFLLEVBQ0wsR0FBRywyQkFBYyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsNEJBQTRCLEVBQ3pEO2dCQUNFO29CQUNFLEVBQUUsRUFBRSxtQkFBbUI7b0JBQ3ZCLE1BQU0sRUFDSiwrRkFBK0Y7b0JBQ2pHLFNBQVMsRUFBRSxDQUFDLGFBQWEsQ0FBQztpQkFDM0I7YUFDRixDQUNGLENBQUM7WUFFRixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLFdBQVcsRUFBRTtnQkFDekQsU0FBUyxFQUFFO29CQUNULFlBQVksRUFBRSxJQUFJO29CQUNsQixPQUFPLEVBQUUsSUFBSTtpQkFDZDthQUNGLENBQUMsQ0FBQztTQUNKO2FBQU07WUFDTCxJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7U0FDaEM7UUFFRCxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksNkNBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3pELEdBQUcsS0FBSyxFQUFFLG1CQUFtQjtZQUM3Qix1QkFBdUIsRUFBRTtnQkFDdkIsR0FBRyxLQUFLLEVBQUUsbUJBQW1CLEVBQUUsdUJBQXVCO2dCQUN0RCxTQUFTLEVBQUU7b0JBQ1QsR0FBRyxDQUFDLEtBQUssRUFBRSxtQkFBbUIsRUFBRSx1QkFBdUIsRUFBRSxTQUFTO3dCQUNoRSxFQUFFLENBQUM7b0JBQ0wsR0FBRyxDQUFDLENBQUMsS0FBSyxFQUFFLFFBQVE7d0JBQ2xCLENBQUMsQ0FBQyxDQUFDLElBQUksK0RBQThCLENBQUMsRUFBRSxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7d0JBQ25FLENBQUMsQ0FBQyxFQUFFLENBQUM7aUJBQ1I7YUFDRjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBbEVILG9DQW1FQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbiBDb3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblxuIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuXG4gaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG5cbiBVbmxlc3MgcmVxdWlyZWQgYnkgYXBwbGljYWJsZSBsYXcgb3IgYWdyZWVkIHRvIGluIHdyaXRpbmcsIHNvZnR3YXJlXG4gZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9ucyBhbmRcbiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiAqL1xuaW1wb3J0IHtcbiAgSWRlbnRpdHlQb29sLFxuICBJZGVudGl0eVBvb2xQcm9wcyxcbiAgVXNlclBvb2xBdXRoZW50aWNhdGlvblByb3ZpZGVyLFxufSBmcm9tIFwiQGF3cy1jZGsvYXdzLWNvZ25pdG8taWRlbnRpdHlwb29sLWFscGhhXCI7XG5pbXBvcnQgeyBTdGFjayB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHtcbiAgQWNjb3VudFJlY292ZXJ5LFxuICBDZm5Vc2VyUG9vbCxcbiAgTWZhLFxuICBVc2VyUG9vbCxcbiAgVXNlclBvb2xDbGllbnQsXG59IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY29nbml0b1wiO1xuaW1wb3J0IHsgTmFnU3VwcHJlc3Npb25zIH0gZnJvbSBcImNkay1uYWdcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBnZXRTdGFja1ByZWZpeCB9IGZyb20gXCIuL25hZy1oZWxwZXJcIjtcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHdoaWNoIGNvbmZpZ3VyZXMgdGhlIElkZW50aXR5IFBvb2wuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVXNlcklkZW50aXR5UHJvcHMge1xuICAvKipcbiAgICogVXNlciBwcm92aWRlZCBDb2duaXRvIFVzZXJQb29sLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgdXNlcnBvb2wgd2lsbCBiZSBjcmVhdGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgdXNlclBvb2w/OiBVc2VyUG9vbDtcblxuICAvKipcbiAgICogQ29uZmlndXJhdGlvbiBmb3IgdGhlIElkZW50aXR5IFBvb2wuXG4gICAqL1xuICByZWFkb25seSBpZGVudGl0eVBvb2xPcHRpb25zPzogSWRlbnRpdHlQb29sUHJvcHM7XG59XG5cbi8qKlxuICogQ3JlYXRlcyBhbiBJZGVudGl0eSBQb29sIHdpdGggc2FuZSBkZWZhdWx0cyBjb25maWd1cmVkLlxuICovXG5leHBvcnQgY2xhc3MgVXNlcklkZW50aXR5IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGlkZW50aXR5UG9vbDogSWRlbnRpdHlQb29sO1xuICBwdWJsaWMgcmVhZG9ubHkgdXNlclBvb2w6IFVzZXJQb29sO1xuICBwdWJsaWMgcmVhZG9ubHkgdXNlclBvb2xDbGllbnQ/OiBVc2VyUG9vbENsaWVudDtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IFVzZXJJZGVudGl0eVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIC8vIFVubGVzcyBleHBsaWNpdGx5IHN0YXRlZCwgY3JlYXRlZCBhIGRlZmF1bHQgQ29nbml0byBVc2VyIFBvb2wgYW5kIFdlYiBDbGllbnQuXG4gICAgaWYgKCFwcm9wcz8udXNlclBvb2wpIHtcbiAgICAgIHRoaXMudXNlclBvb2wgPSBuZXcgVXNlclBvb2wodGhpcywgXCJVc2VyUG9vbFwiLCB7XG4gICAgICAgIHBhc3N3b3JkUG9saWN5OiB7XG4gICAgICAgICAgbWluTGVuZ3RoOiA4LFxuICAgICAgICAgIHJlcXVpcmVMb3dlcmNhc2U6IHRydWUsXG4gICAgICAgICAgcmVxdWlyZVVwcGVyY2FzZTogdHJ1ZSxcbiAgICAgICAgICByZXF1aXJlRGlnaXRzOiB0cnVlLFxuICAgICAgICAgIHJlcXVpcmVTeW1ib2xzOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBtZmE6IE1mYS5SRVFVSVJFRCxcbiAgICAgICAgYWNjb3VudFJlY292ZXJ5OiBBY2NvdW50UmVjb3ZlcnkuRU1BSUxfT05MWSxcbiAgICAgICAgYXV0b1ZlcmlmeToge1xuICAgICAgICAgIGVtYWlsOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG5cbiAgICAgICh0aGlzLnVzZXJQb29sLm5vZGUuZGVmYXVsdENoaWxkIGFzIENmblVzZXJQb29sKS51c2VyUG9vbEFkZE9ucyA9IHtcbiAgICAgICAgYWR2YW5jZWRTZWN1cml0eU1vZGU6IFwiRU5GT1JDRURcIixcbiAgICAgIH07XG5cbiAgICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2YodGhpcyk7XG4gICAgICBOYWdTdXBwcmVzc2lvbnMuYWRkUmVzb3VyY2VTdXBwcmVzc2lvbnNCeVBhdGgoXG4gICAgICAgIHN0YWNrLFxuICAgICAgICBgJHtnZXRTdGFja1ByZWZpeChzdGFjayl9JHtpZH0vVXNlclBvb2wvc21zUm9sZS9SZXNvdXJjZWAsXG4gICAgICAgIFtcbiAgICAgICAgICB7XG4gICAgICAgICAgICBpZDogXCJBd3NTb2x1dGlvbnMtSUFNNVwiLFxuICAgICAgICAgICAgcmVhc29uOlxuICAgICAgICAgICAgICBcIk1GQSByZXF1aXJlcyBzZW5kaW5nIGEgdGV4dCB0byBhIHVzZXJzIHBob25lIG51bWJlciB3aGljaCBjYW5ub3QgYmUga25vd24gYXQgZGVwbG95bWVudCB0aW1lLlwiLFxuICAgICAgICAgICAgYXBwbGllc1RvOiBbXCJSZXNvdXJjZTo6KlwiXSxcbiAgICAgICAgICB9LFxuICAgICAgICBdXG4gICAgICApO1xuXG4gICAgICB0aGlzLnVzZXJQb29sQ2xpZW50ID0gdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoXCJXZWJDbGllbnRcIiwge1xuICAgICAgICBhdXRoRmxvd3M6IHtcbiAgICAgICAgICB1c2VyUGFzc3dvcmQ6IHRydWUsXG4gICAgICAgICAgdXNlclNycDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnVzZXJQb29sID0gcHJvcHMudXNlclBvb2w7XG4gICAgfVxuXG4gICAgdGhpcy5pZGVudGl0eVBvb2wgPSBuZXcgSWRlbnRpdHlQb29sKHRoaXMsIFwiSWRlbnRpdHlQb29sXCIsIHtcbiAgICAgIC4uLnByb3BzPy5pZGVudGl0eVBvb2xPcHRpb25zLFxuICAgICAgYXV0aGVudGljYXRpb25Qcm92aWRlcnM6IHtcbiAgICAgICAgLi4ucHJvcHM/LmlkZW50aXR5UG9vbE9wdGlvbnM/LmF1dGhlbnRpY2F0aW9uUHJvdmlkZXJzLFxuICAgICAgICB1c2VyUG9vbHM6IFtcbiAgICAgICAgICAuLi4ocHJvcHM/LmlkZW50aXR5UG9vbE9wdGlvbnM/LmF1dGhlbnRpY2F0aW9uUHJvdmlkZXJzPy51c2VyUG9vbHMgfHxcbiAgICAgICAgICAgIFtdKSxcbiAgICAgICAgICAuLi4oIXByb3BzPy51c2VyUG9vbFxuICAgICAgICAgICAgPyBbbmV3IFVzZXJQb29sQXV0aGVudGljYXRpb25Qcm92aWRlcih7IHVzZXJQb29sOiB0aGlzLnVzZXJQb29sIH0pXVxuICAgICAgICAgICAgOiBbXSksXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG4iXX0=