"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsIntegration = void 0;
const cdk = require("@aws-cdk/core");
const integration_1 = require("../integration");
const util_1 = require("../util");
/**
 * This type of integration lets an API expose AWS service actions. It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 */
class AwsIntegration extends integration_1.Integration {
    constructor(props) {
        const backend = props.subdomain ? `${props.subdomain}.${props.service}` : props.service;
        const type = props.proxy ? integration_1.IntegrationType.AWS_PROXY : integration_1.IntegrationType.AWS;
        const { apiType, apiValue } = util_1.parseAwsApiCall(props.path, props.action, props.actionParameters);
        super({
            type,
            integrationHttpMethod: props.integrationHttpMethod || 'POST',
            uri: cdk.Lazy.stringValue({
                produce: () => {
                    if (!this.scope) {
                        throw new Error('AwsIntegration must be used in API');
                    }
                    return cdk.Stack.of(this.scope).formatArn({
                        service: 'apigateway',
                        account: backend,
                        resource: apiType,
                        sep: '/',
                        resourceName: apiValue,
                    });
                },
            }),
            options: props.options,
        });
    }
    bind(method) {
        const bindResult = super.bind(method);
        this.scope = method;
        return bindResult;
    }
}
exports.AwsIntegration = AwsIntegration;
//# sourceMappingURL=data:application/json;base64,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