"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const cdk = require("@aws-cdk/core");
const apigateway = require("../lib");
/*
 * Stack verification steps:
 * * `curl -s -o /dev/null -w "%{http_code}" <CFN output PetsURL>` should return HTTP code 200
 * * `curl -s -o /dev/null -w "%{http_code}" <CFN output BooksURL>` should return HTTP code 200
 */
const app = new cdk.App();
const stack = new cdk.Stack(app, 'integtest-restapi-fromdefinition-asset');
const api = new apigateway.SpecRestApi(stack, 'my-api', {
    apiDefinition: apigateway.ApiDefinition.fromAsset(path.join(__dirname, 'sample-definition.yaml')),
});
api.root.addResource('books').addMethod('GET', new apigateway.MockIntegration({
    integrationResponses: [{
            statusCode: '200',
        }],
    passthroughBehavior: apigateway.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [{ statusCode: '200' }],
});
new cdk.CfnOutput(stack, 'PetsURL', {
    value: api.urlForPath('/pets'),
});
new cdk.CfnOutput(stack, 'BooksURL', {
    value: api.urlForPath('/books'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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