## [Datasets](datasets.md)

## Online Courses

[HUML Syllabus](https://docs.google.com/spreadsheets/d/19HvN07XSNjlWF3TwLnyCUsCwXGBGwu15TemvVSIDwiI/edit?usp=sharing)

## Tutorials

- [PDX Python Guide](https://github.com/portlandpython/project-night)
- [Pandas Tutorial by Brandon Rhodes at PyCon 2015](https://github.com/brandon-rhodes/pycon-pandas-tutorial)
- [Pandas Documentation on `.fillna` and `.notnull`](http://pandas.pydata.org/pandas-docs/stable/missing_data.html)
- [SQL Tutorial by Mode Analytics](https://sqlschool.modeanalytics.com/toc/)
- ["NoSQL" Databases](https://www.thoughtworks.com/insights/blog/nosql-databases-overview)
- ["Excellent Interactive Neural Net Tutorial](http://neuralnetworksanddeeplearning.com/chap1.html)
- [Word Embedding and Word2Vec Interactive Visualization](http://ronxin.github.io/wevi/) with FOSS js, css, svg

## Videos

[Udacity IML videos](https://www.udacity.com/course/viewer#!/c-ud120/l-2254358555/e-3004778636/m-3022458587)
- [Udacity Naive Bayes Lesson](https://www.udacity.com/course/viewer#!/c-ud120/l-2254358555/m-3013708686)


## Code

### Springboard

Zip packages of code + data

- [JSON and DataFrame Queries](https://www.springboard.com/static/project_files/data_wrangling_json.zip)
- [Human Body Temperature Statistics](https://www.springboard.com/static/project_files/statistics_project1.zip)
- [Correlation between race and Job Application Call-backs](https://www.springboard.com/static/project_files/statistics_project2.zip)
- [Hospital Readmission Statistics](https://www.springboard.com/static/project_files/statistics_project3.zip)

### Python

Example algorithms and usage (code examples).

- [Pandas DataFrame Examples](https://gist.github.com/why-not/4582705])
- [Information Retrieval Metrics](https://gist.github.com/bwhite/3726239): Ranking models, like search results
  - RMSE, DCG, NDCG, MAP, Accuracy @ k, etc

## [Books](books.md)

This course will pull examples and ideas from multiple sources, but most closely resembles the content and structure of the second half of Grus's book Learning Data Science from Scratch from [O'Reilly $34](http://shop.oreilly.com/product/0636920033400.do). Google "promo code O'Reilly" and you should be able to get 50% off.

Raschka's book published by PackT ($35, but can sometimes get a promo code for 20% off) doesn't provide source code, but several people have worked some of the problems

- [Chapter 8: NLP on Movie Reviews](https://github.com/raul23/python-machine-learning/blob/master/notebooks/chapter08.ipynb)
- [Chapter 2: Perceptrons]
  - [p 21](https://github.com/hakeon/MachineLearning/blob/master/Perceptron%20Learning%20Algorithm.ipynb)
  - [with data](https://github.com/channelgrubb/PythonMachineLearning/tree/master/Ch2)

## [Papers](papers.md)

NIPS has a free, open database of all their papers. You can find a few others in the link above. Machine Intelligence engineers and publishers are usually pretty open with their research.

## Some Thunder

- [Think Stats](http://greenteapress.com/thinkstats2/)
- [Data Science from Scratch github repo](https://github.com/joelgrus/data-science-from-scratch) with ipython notebooks to complete. Uses pandas but not scipy.
- [Example ipython notebooks](https://github.com/donnemartin/data-science-ipython-notebooks)
- [Unfinished example project](https://github.com/ThunderShiviah/data_science_notes/blob/master/notebooks/friend_paradox_unfinished.ipynb)
- [How to set up a pyspark vagrant box](https://gist.github.com/ThunderShiviah/f340d7fe50bb751d8516)
- [Jupyter's recommended stacks](https://github.com/jupyter/docker-stacks)
- Use [conda](http://conda.pydata.org/) instead of pip on Windows


## [Datasets](datasets.md)

