# Meta Diversion: The Meaning of "Data Science"

We're going to talk about the meaning of the words "Data Science." And in the process you're going to form your own "meaning" of the words "Information Theory."

My boss at Sharp labs was a brilliant communication theorist. He holds dozens of patents that underlie the LTE protocol for high bandwidth cellphone radio communication. Information theorists spend their lives thinking about how to convey "information" or "knowledge" as efficently as possible, with as few "symbols" as possible. So when he talked about information and language and the meaning of words, I listened.

I was developing a Natural Language Processing system to comb through the haphazard "repair notes" of technicians as they inspected, tested and sometimes repaired the televisions returned by customers to Best Buy or wherever. So I was trying to extract "meaning" from the words in these databases. And whenever I used the word "meaning" in a sentence his hackles would rise and he'd interrupt me to say

> Words have no meaning

-- John Kowalski

Of course I argued with him a lot. But after watching a lot of Chomsky lectures and after processing a lot of Natural Language data I've come to believe him. Here's what he *meant.*

Words are a statistical phenomenon. Our brains are statistical machines. We "encode", in a very fuzzy way, all the sounds we hear (speech) and images we see (words) in our brains. And from an early age sounds trigger behaviors in us. Loud sounds scare us and soft sounds sooth us. And soon we begin to hear our name or the name of "Mommy" and we associate it with all the emotions and experiences surrounding our parent. But your word for "Mommy" and mine could be totally different. You or I could have two mommies or two dads that act as our "mother." 

So the word "mommy", in all its forms and translations, has no absolute "meaning." We try to record a "collective consciousness" in things called "dictionaires" and "encyclopedias." But, as you know, there is know "official" meaning for anything. Each year thousands of new words are being added to the dictionary. Imagine the Celts with pehaps fewer than 10k or so "English" words in common usage before the 10th century. Then, in 1066, the English language nearly doubled in size as it took on many French words (think "pork" vs "pig" and "beef" vs "cow"). By the time the [OED (Oxford English Dictionary)](http://public.oed.com/history-of-the-oed/) came out in 1857 (it took 4 decades and 4 volumes) there were nearly 400k words.  Depending on how you count, there are now [more than 1M words](http://www.languagemonitor.com/number-of-words/number-of-words-in-the-english-language-1008879/) in the English language.

The collective consciouness grows and evolves just as our childlike brains grow and evolve to absorb new meaning.

So lets talk abou the statistical "associations" of the words "Data" and "Science." What they mean to you and me will be hugely different. But I'd like to help you anticipate some of the things that speakers intend when they use those words.

Isn't all science about data? Isn't that what scientists do, model data in labs with long overcoats and microscopes and supercolliders?

Well it wasn't always that way. In the early days of Socrates and Plato it was all about thought experiments, geometry, algebra, and observing and recording the world by hand to create data in the form of symbols and drawings. Many of the algorithms we use today were invented in those days of scrolls and papyrus. Science is about experiemntation, making a prediction and testing it with observation. But in modern society we have become overwhelmed with observations. Information is being stored faster than we can play with it by hand. 

Hence, data science. So we have to have whole new techniques for thinking about problems. We have to expand our minds to incorporate the comptuational power of computers to fully grasp the "meaning" of the information flowing into our heads.

Now this is just the statistical impression that the phrase "Data Science" means to me. I've been the only "Data Scientist" at several small companies and gigantic labs, and I still don't know what it means. But taking this course you will gain an statistical impression of what it "means" t you.

By the way, my impression of Machine Learning is just doing data science with more data and less science. Letting machines do the science part of making and testing predictions using data and less physical experimentation in the world (one conventional impression of the word "science").

> Machine learning is automating Data Science


One of Noam Chompsky's more popular quotes

> Everybody's worried about stopping terrorism. Well, there's a really easy way: stop participating in it.


Noam Chomsky was one of the first proponents of the theory of a ["universal grammar"](https://en.wikipedia.org/wiki/Universal_Grammar) hardwired into all brains. Also, [Chomsky](https://en.wikipedia.org/wiki/Noam_Chomsky) appreciates "meaning." He came up with the idea of "deep structures" (grammars) for internal thought that are different from "generative structures" (regular grammars) for outward-facing communication.

So there is meaning after all.