# NLP Resources

## Text Retrieval and Search

[Python R-Tree Indexes](http://toblerity.org/rtree/tutorial.html#creating-an-index]: Multidimensional GIS-like indexes on topic-vectors?
[R*-Tree Indexes](https://en.wikipedia.org/wiki/R*_tree): R*-Tree indexes are the state of the art for multi-dimensional indexing
[Elastic Search N-Gram Definition](https://www.elastic.co/blog/significant-terms-aggregation): For Indexes "grams" are characters, not tokens or words
[PostGRESQL GIN Index Operators](https://www.postgresql.org/docs/9.4/static/functions-geometry.html): Multidimensional numerical array search in postgres?

## Academic Papers

- "A longitudinal study of cyberbullying: Examining risk and protective factors"[1]
- "Identifying Sarcasm on Twitter: A Closer Look"[2]
- "#Gamergate Trolls Aren't Ethics Crusaders; They're a Hate Group"[3]
- "The Effect of Social Network Sites on Adolescents' Social and Academic Development"[4]


[1]: http://www.dplabucy.com/uploads/2/5/9/0/25908118/fanti_demetriou_hawa_2012.pdf "A longitudinal study of cyberbullying"
[2]: http://www.aclweb.org/anthology/P11-2102 "Identifying Sarcasm on Twitter"
[3]: http://jezebel.com/gamergate-trolls-arent-ethics-crusaders-theyre-a-hate-1644984010 "#Gamergate Trolls Aren't Ethics Crusaders; They're a Hate Group"
[4]: http://ahnjune.com/wp-content/uploads/2011/11/0Final-Ahn2011JASIST.pdf "The Effect of Social Network Sites on Adolescents' Social and Academic Development"
[Warner]: http://www.aclweb.org/anthology/W12-2103 "Detecting Hate Speech on the World Wide Web"
[Xiang]: http://www.cs.cmu.edu/~lingwang/papers/sp250-xiang.pdf "Detecting Offensive Tweets via Topical Feature Discovery"
[Jones]: http://www.noswearing.com/about.php "No Swear List & Curse Filter"

## Corpora

- [twitter corpora and lexica](http://saifmohammad.com/WebPages/lexicons.html)
- [niderhoff list of NLP datasets](https://github.com/niderhoff/nlp-datasets)

## Software Tutorials

- [best-practice patterns for React](https://github.com/facebookincubator/create-react-app)
- [setting up a react + Django project](http://gregblogs.com/how-django-reactjs-and-browserify/)
- [grunt tutorial](https://lincolnloop.com/blog/simplifying-your-django-frontend-tasks-grunt/)
- [node.js in a python virtualenv](https://lincolnloop.com/blog/installing-nodejs-and-npm-python-virtualenv/)

## Collections

- [Public AI Datasets gathered by Analytics Insight](https://www.analyticsinsight.net/working-on-ai-get-these-free-public-data-sources-for-2019/)
- [State-of-the-Art Papers and Datasets](https://nlpprogress.com/)

## Open Source Software

- [Tweet Impact Predictor (twip)](http://github.com/totalgood/twip)
- [There's Hope for Chatbots (hope)](http://github.com/totalgood/hope)

## Talks

- [ODSC West Tutorial -- Prosocial Chatbots](https://www.youtube.com/embed/wI63y3LTOM8)