# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectAttachmentArgs', 'InterconnectAttachment']

@pulumi.input_type
class InterconnectAttachmentArgs:
    def __init__(__self__, *,
                 router: pulumi.Input[str],
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a InterconnectAttachment resource.
        :param pulumi.Input[str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
               that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
               attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
               gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
               Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
               values: ["NONE", "IPSEC"]
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
               the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
               interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
               address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
               paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
               from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
               attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
               the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        :param pulumi.Input[str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through
               this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        pulumi.set(__self__, "router", router)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if candidate_subnets is not None:
            pulumi.set(__self__, "candidate_subnets", candidate_subnets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_availability_domain is not None:
            pulumi.set(__self__, "edge_availability_domain", edge_availability_domain)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if ipsec_internal_addresses is not None:
            pulumi.set(__self__, "ipsec_internal_addresses", ipsec_internal_addresses)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_tag8021q is not None:
            pulumi.set(__self__, "vlan_tag8021q", vlan_tag8021q)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[str]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @candidate_subnets.setter
    def candidate_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "candidate_subnets", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @edge_availability_domain.setter
    def edge_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_availability_domain", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
        that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
        attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
        gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
        Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
        values: ["NONE", "IPSEC"]
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
        the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
        interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
        address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
        paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
        from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
        attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
        the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @ipsec_internal_addresses.setter
    def ipsec_internal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipsec_internal_addresses", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through
        this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> Optional[pulumi.Input[int]]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

    @vlan_tag8021q.setter
    def vlan_tag8021q(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_tag8021q", value)


@pulumi.input_type
class _InterconnectAttachmentState:
    def __init__(__self__, *,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None,
                 partner_asn: Optional[pulumi.Input[str]] = None,
                 private_interconnect_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering InterconnectAttachment resources.
        :param pulumi.Input[bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] cloud_router_ip_address: IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_router_ip_address: IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
               that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
               attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
               gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
               Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
               values: ["NONE", "IPSEC"]
        :param pulumi.Input[str] google_reference_id: Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity
               issues.
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
               the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
               interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
               address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
               paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
               from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
               attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
               the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        :param pulumi.Input[str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through
               this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] pairing_key: [Output only for type PARTNER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to
               initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[str] partner_asn: [Output only for type PARTNER. Not present for DEDICATED]. Optional BGP ASN for the router that should be supplied by a
               layer 3 Partner if they configured BGP on behalf of the customer.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]] private_interconnect_infos: Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached
               to is of type DEDICATED.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] state: [Output Only] The current state of this attachment's functionality.
        :param pulumi.Input[str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if candidate_subnets is not None:
            pulumi.set(__self__, "candidate_subnets", candidate_subnets)
        if cloud_router_ip_address is not None:
            pulumi.set(__self__, "cloud_router_ip_address", cloud_router_ip_address)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if customer_router_ip_address is not None:
            pulumi.set(__self__, "customer_router_ip_address", customer_router_ip_address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_availability_domain is not None:
            pulumi.set(__self__, "edge_availability_domain", edge_availability_domain)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if google_reference_id is not None:
            pulumi.set(__self__, "google_reference_id", google_reference_id)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if ipsec_internal_addresses is not None:
            pulumi.set(__self__, "ipsec_internal_addresses", ipsec_internal_addresses)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pairing_key is not None:
            pulumi.set(__self__, "pairing_key", pairing_key)
        if partner_asn is not None:
            pulumi.set(__self__, "partner_asn", partner_asn)
        if private_interconnect_infos is not None:
            pulumi.set(__self__, "private_interconnect_infos", private_interconnect_infos)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_tag8021q is not None:
            pulumi.set(__self__, "vlan_tag8021q", vlan_tag8021q)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @candidate_subnets.setter
    def candidate_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "candidate_subnets", value)

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @cloud_router_ip_address.setter
    def cloud_router_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_router_ip_address", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @customer_router_ip_address.setter
    def customer_router_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_router_ip_address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @edge_availability_domain.setter
    def edge_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_availability_domain", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
        that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
        attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
        gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
        Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
        values: ["NONE", "IPSEC"]
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity
        issues.
        """
        return pulumi.get(self, "google_reference_id")

    @google_reference_id.setter
    def google_reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_reference_id", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
        the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
        interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
        address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
        paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
        from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
        attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
        the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @ipsec_internal_addresses.setter
    def ipsec_internal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipsec_internal_addresses", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through
        this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to
        initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @pairing_key.setter
    def pairing_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pairing_key", value)

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. Optional BGP ASN for the router that should be supplied by a
        layer 3 Partner if they configured BGP on behalf of the customer.
        """
        return pulumi.get(self, "partner_asn")

    @partner_asn.setter
    def partner_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_asn", value)

    @property
    @pulumi.getter(name="privateInterconnectInfos")
    def private_interconnect_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]]:
        """
        Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached
        to is of type DEDICATED.
        """
        return pulumi.get(self, "private_interconnect_infos")

    @private_interconnect_infos.setter
    def private_interconnect_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]]):
        pulumi.set(self, "private_interconnect_infos", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The current state of this attachment's functionality.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> Optional[pulumi.Input[int]]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

    @vlan_tag8021q.setter
    def vlan_tag8021q(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_tag8021q", value)


class InterconnectAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Represents an InterconnectAttachment (VLAN attachment) resource. For more
        information, see Creating VLAN Attachments.

        ## Example Usage
        ### Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobarNetwork", auto_create_subnetworks=False)
        foobar_router = gcp.compute.Router("foobarRouter",
            network=foobar_network.name,
            bgp=gcp.compute.RouterBgpArgs(
                asn=16550,
            ))
        on_prem = gcp.compute.InterconnectAttachment("onPrem",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar_router.id,
            mtu="1500")
        ```
        ### Compute Interconnect Attachment Ipsec Encryption

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        address = gcp.compute.Address("address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link,
            opts=pulumi.ResourceOptions(provider=google_beta))
        router = gcp.compute.Router("router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp=gcp.compute.RouterBgpArgs(
                asn=16550,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ipsec_encrypted_interconnect_attachment = gcp.compute.InterconnectAttachment("ipsec-encrypted-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address.self_link],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        InterconnectAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
               that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
               attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
               gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
               Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
               values: ["NONE", "IPSEC"]
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
               the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
               interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
               address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
               paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
               from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
               attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
               the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        :param pulumi.Input[str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through
               this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an InterconnectAttachment (VLAN attachment) resource. For more
        information, see Creating VLAN Attachments.

        ## Example Usage
        ### Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobarNetwork", auto_create_subnetworks=False)
        foobar_router = gcp.compute.Router("foobarRouter",
            network=foobar_network.name,
            bgp=gcp.compute.RouterBgpArgs(
                asn=16550,
            ))
        on_prem = gcp.compute.InterconnectAttachment("onPrem",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar_router.id,
            mtu="1500")
        ```
        ### Compute Interconnect Attachment Ipsec Encryption

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        address = gcp.compute.Address("address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link,
            opts=pulumi.ResourceOptions(provider=google_beta))
        router = gcp.compute.Router("router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp=gcp.compute.RouterBgpArgs(
                asn=16550,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ipsec_encrypted_interconnect_attachment = gcp.compute.InterconnectAttachment("ipsec-encrypted-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address.self_link],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        InterconnectAttachment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InterconnectAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectAttachmentArgs.__new__(InterconnectAttachmentArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["candidate_subnets"] = candidate_subnets
            __props__.__dict__["description"] = description
            __props__.__dict__["edge_availability_domain"] = edge_availability_domain
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["interconnect"] = interconnect
            __props__.__dict__["ipsec_internal_addresses"] = ipsec_internal_addresses
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["type"] = type
            __props__.__dict__["vlan_tag8021q"] = vlan_tag8021q
            __props__.__dict__["cloud_router_ip_address"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["customer_router_ip_address"] = None
            __props__.__dict__["google_reference_id"] = None
            __props__.__dict__["pairing_key"] = None
            __props__.__dict__["partner_asn"] = None
            __props__.__dict__["private_interconnect_infos"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
        super(InterconnectAttachment, __self__).__init__(
            'gcp:compute/interconnectAttachment:InterconnectAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_enabled: Optional[pulumi.Input[bool]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            customer_router_ip_address: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            edge_availability_domain: Optional[pulumi.Input[str]] = None,
            encryption: Optional[pulumi.Input[str]] = None,
            google_reference_id: Optional[pulumi.Input[str]] = None,
            interconnect: Optional[pulumi.Input[str]] = None,
            ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mtu: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pairing_key: Optional[pulumi.Input[str]] = None,
            partner_asn: Optional[pulumi.Input[str]] = None,
            private_interconnect_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInterconnectInfoArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vlan_tag8021q: Optional[pulumi.Input[int]] = None) -> 'InterconnectAttachment':
        """
        Get an existing InterconnectAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] cloud_router_ip_address: IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_router_ip_address: IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
               that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
               attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
               gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
               Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
               values: ["NONE", "IPSEC"]
        :param pulumi.Input[str] google_reference_id: Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity
               issues.
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
               the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
               interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
               address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
               paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
               from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
               attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
               the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        :param pulumi.Input[str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through
               this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] pairing_key: [Output only for type PARTNER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to
               initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[str] partner_asn: [Output only for type PARTNER. Not present for DEDICATED]. Optional BGP ASN for the router that should be supplied by a
               layer 3 Partner if they configured BGP on behalf of the customer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInterconnectInfoArgs']]]] private_interconnect_infos: Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached
               to is of type DEDICATED.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] state: [Output Only] The current state of this attachment's functionality.
        :param pulumi.Input[str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterconnectAttachmentState.__new__(_InterconnectAttachmentState)

        __props__.__dict__["admin_enabled"] = admin_enabled
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["candidate_subnets"] = candidate_subnets
        __props__.__dict__["cloud_router_ip_address"] = cloud_router_ip_address
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["customer_router_ip_address"] = customer_router_ip_address
        __props__.__dict__["description"] = description
        __props__.__dict__["edge_availability_domain"] = edge_availability_domain
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["google_reference_id"] = google_reference_id
        __props__.__dict__["interconnect"] = interconnect
        __props__.__dict__["ipsec_internal_addresses"] = ipsec_internal_addresses
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["pairing_key"] = pairing_key
        __props__.__dict__["partner_asn"] = partner_asn
        __props__.__dict__["private_interconnect_infos"] = private_interconnect_infos
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["vlan_tag8021q"] = vlan_tag8021q
        return InterconnectAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, and `BPS_50G`.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> pulumi.Output[str]:
        """
        IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> pulumi.Output[str]:
        """
        IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> pulumi.Output[str]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: NONE is the default value, which means
        that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of
        attachment. IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN
        gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud
        Interconnect create the attachment using this option. Not currently available publicly. Default value: "NONE" Possible
        values: ["NONE", "IPSEC"]
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> pulumi.Output[str]:
        """
        Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity
        issues.
        """
        return pulumi.get(self, "google_reference_id")

    @property
    @pulumi.getter
    def interconnect(self) -> pulumi.Output[Optional[str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has
        the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the
        interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway's IP
        address will be allocated from the IP address range specified here. For example, if the HA VPN gateway's interface 0 is
        paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated
        from the IP address specified for this interconnect attachment. If this field is not specified for interconnect
        attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment,
        the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[str]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through
        this interconnect attachment. Currently, only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> pulumi.Output[str]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to
        initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> pulumi.Output[str]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. Optional BGP ASN for the router that should be supplied by a
        layer 3 Partner if they configured BGP on behalf of the customer.
        """
        return pulumi.get(self, "partner_asn")

    @property
    @pulumi.getter(name="privateInterconnectInfos")
    def private_interconnect_infos(self) -> pulumi.Output[Sequence['outputs.InterconnectAttachmentPrivateInterconnectInfo']]:
        """
        Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached
        to is of type DEDICATED.
        """
        return pulumi.get(self, "private_interconnect_infos")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        [Output Only] The current state of this attachment's functionality.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are `DEDICATED`, `PARTNER`, and `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> pulumi.Output[int]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

