# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKMSSecretAsymmetricResult',
    'AwaitableGetKMSSecretAsymmetricResult',
    'get_kms_secret_asymmetric',
]

@pulumi.output_type
class GetKMSSecretAsymmetricResult:
    """
    A collection of values returned by getKMSSecretAsymmetric.
    """
    def __init__(__self__, ciphertext=None, crc32=None, crypto_key_version=None, id=None, plaintext=None):
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crc32 and not isinstance(crc32, str):
            raise TypeError("Expected argument 'crc32' to be a str")
        pulumi.set(__self__, "crc32", crc32)
        if crypto_key_version and not isinstance(crypto_key_version, str):
            raise TypeError("Expected argument 'crypto_key_version' to be a str")
        pulumi.set(__self__, "crypto_key_version", crypto_key_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @property
    @pulumi.getter
    def ciphertext(self) -> str:
        return pulumi.get(self, "ciphertext")

    @property
    @pulumi.getter
    def crc32(self) -> Optional[str]:
        """
        Contains the crc32 checksum of the provided ciphertext.
        """
        return pulumi.get(self, "crc32")

    @property
    @pulumi.getter(name="cryptoKeyVersion")
    def crypto_key_version(self) -> str:
        return pulumi.get(self, "crypto_key_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def plaintext(self) -> str:
        """
        Contains the result of decrypting the provided ciphertext.
        """
        return pulumi.get(self, "plaintext")


class AwaitableGetKMSSecretAsymmetricResult(GetKMSSecretAsymmetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKMSSecretAsymmetricResult(
            ciphertext=self.ciphertext,
            crc32=self.crc32,
            crypto_key_version=self.crypto_key_version,
            id=self.id,
            plaintext=self.plaintext)


def get_kms_secret_asymmetric(ciphertext: Optional[str] = None,
                              crc32: Optional[str] = None,
                              crypto_key_version: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKMSSecretAsymmetricResult:
    """
    Use this data source to access information about an existing resource.

    :param str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param str crc32: The crc32 checksum of the `ciphertext` in hexadecimal notation. If not specified, it will be computed.
    :param str crypto_key_version: The id of the CryptoKey version that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}`.
    """
    __args__ = dict()
    __args__['ciphertext'] = ciphertext
    __args__['crc32'] = crc32
    __args__['cryptoKeyVersion'] = crypto_key_version
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKMSSecretAsymmetric:getKMSSecretAsymmetric', __args__, opts=opts, typ=GetKMSSecretAsymmetricResult).value

    return AwaitableGetKMSSecretAsymmetricResult(
        ciphertext=__ret__.ciphertext,
        crc32=__ret__.crc32,
        crypto_key_version=__ret__.crypto_key_version,
        id=__ret__.id,
        plaintext=__ret__.plaintext)
