import { CustomResource, ResourceProps } from 'aws-cdk-lib';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { AwsCustomResource } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
export interface PSTNResourceProps extends ResourceProps {
    readonly properties: {
        [propname: string]: any;
    };
    readonly resourceType: 'PhoneNumber' | 'VoiceConnector' | 'SMA' | 'SMALogging' | 'SMAAlexaSkill' | 'SMARule' | 'PhoneAssociation';
    readonly uid: string;
}
export declare class PSTNResources extends Construct {
    readonly lambda: IFunction;
    readonly pstnCustomResource: CustomResource;
    constructor(scope: Construct, id: string, props: PSTNResourceProps);
    private ensureLambda;
}
export interface PhoneAssociationProps extends ResourceProps {
    readonly voiceConnectorId: string;
    readonly e164PhoneNumber: string;
}
export declare class PhoneAssociation extends Construct {
    readonly phoneAssociationResource: AwsCustomResource;
    constructor(scope: Construct, id: string, props: PhoneAssociationProps);
}
