import * as cdk from 'aws-cdk-lib';
import { Function } from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { PSTNResources } from './pstnCustomResources';
/**
 * Props for `SipMediaApplication`.
 */
export interface SipMediaAppProps {
    /**
     * region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler
     *
     * @default - same region as stack deployment
     */
    readonly region?: string;
    /**
     * endpoint for SipMediaApplication(required)
     *
     * @default - none
     */
    readonly endpoint: Function['functionArn'];
    /**
     * name for SipMediaApplication (optional)
     *
     * @default - unique ID for resource
     */
    readonly name?: string;
}
/**
 * Props for `AppInstanceStreamingConfiguration`.
 * See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_AppInstanceStreamingConfiguration.html
 */
export interface SipMediaApplicationLoggingConfiguration {
    /**
     * Enables message logging for the specified SIP media application.
     */
    readonly enableSipMediaApplicationMessageLogs: boolean;
}
export declare enum AlexaSkillStatus {
    ACTIVE = "ACTIVE",
    INACTIVE = "INACTIVE"
}
export interface SipMediaApplicationAlexaSkillConfiguration {
    readonly alexaSkillIds: string[];
    readonly alexaSkillStatus: AlexaSkillStatus;
}
export declare class ChimeSipMediaApp extends Construct {
    readonly sipMediaAppId: string;
    constructor(scope: Construct, id: string, props: SipMediaAppProps);
    logging(sipMediaApplicationLoggingConfiguration: SipMediaApplicationLoggingConfiguration): PSTNResources;
    alexaSkill(sipMediaApplicationAlexaSkillConfiguration: SipMediaApplicationAlexaSkillConfiguration): cdk.Reference;
}
