"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.alexaSkillConfigurationValidator = exports.loggingValidator = exports.sipMediaApplicationValidator = void 0;
var ALEXA_SKILL_IDS = /^(amzn1\.application-oa2-client\.[0-9a-fA-F]{32})$/;
function sipMediaApplicationValidator(props) {
    if (props.region) {
        if (!(props.region.includes('Token[AWS.Region.') ||
            props.region === 'us-east-1' ||
            props.region === 'us-west-2' ||
            props.region === 'ap-northeast-1' ||
            props.region === 'ap-northeast-2' ||
            props.region === 'ap-southeast-1' ||
            props.region === 'ap-southeast-2' ||
            props.region === 'ca-central-1' ||
            props.region === 'eu-central-1' ||
            props.region === 'eu-west-1' ||
            props.region === 'eu-west-2')) {
            throw new Error('Region must be a valid region: https://docs.aws.amazon.com/chime-sdk/latest/dg/sdk-available-regions.html#sdk-pstn-regions');
        }
    }
    return true;
}
exports.sipMediaApplicationValidator = sipMediaApplicationValidator;
function loggingValidator(_props) {
    return true;
}
exports.loggingValidator = loggingValidator;
function alexaSkillConfigurationValidator(props) {
    if (props.alexaSkillIds) {
        for (var skillId of props.alexaSkillIds) {
            if (!ALEXA_SKILL_IDS.test(skillId)) {
                throw new Error('Invalid Alexa Skill Id.  Alexa Skill Id must match pattern: amzn1.application-oa2-client.[0-9a-fA-F]{32}');
            }
        }
    }
    return true;
}
exports.alexaSkillConfigurationValidator = alexaSkillConfigurationValidator;
//# sourceMappingURL=data:application/json;base64,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