"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAppInstance = exports.CreateAppInstance = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_1 = require("@aws-sdk/client-chime");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeClient = new client_chime_1.ChimeClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createAppInstanceCommandParams;
let createAppInstanceCommandResponse;
let getParameterCommandOutput;
let updatedTags;
exports.CreateAppInstance = async (uid, props) => {
    updatedTags = [];
    if (props.tags) {
        props.tags.forEach((tag) => {
            updatedTags.push({ Key: tag.key, Value: tag.value });
        });
    }
    createAppInstanceCommandParams = {
        Name: props.name,
        ...(props.metadata && { Metadata: props.metadata }),
        ...(props.clientRequestToken && {
            ClientRequestToken: props.clientRequestToken,
        }),
        ...(updatedTags.length > 0 && { Tags: updatedTags }),
    };
    try {
        createAppInstanceCommandResponse = await chimeClient.send(new client_chime_1.CreateAppInstanceCommand(createAppInstanceCommandParams));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: `/chime/appInstanceArn/${uid}`,
            Description: 'App Instance Arn',
            Value: createAppInstanceCommandResponse.AppInstanceArn,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        appInstanceArn: createAppInstanceCommandResponse.AppInstanceArn,
    };
};
exports.DeleteAppInstance = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: `/chime/appInstanceArn/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await chimeClient.send(new client_chime_1.DeleteAppInstanceCommand({
            AppInstanceArn: getParameterCommandOutput.Parameter.Value,
        }));
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/appInstanceArn/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwSW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvcmVzb3VyY2VzL21lc3NhZ2luZy9hcHBJbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxzREFBc0Q7QUFDdEQsd0RBTytCO0FBRS9CLG9EQU02QjtBQUU3QixNQUFNLFdBQVcsR0FBRyxJQUFJLDBCQUFXLENBQUM7SUFDbEMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsVUFBVTtDQUMvQixDQUFDLENBQUM7QUFFSCxNQUFNLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsRUFBRSxNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDO0FBRXBFLElBQUksOEJBQTZELENBQUM7QUFDbEUsSUFBSSxnQ0FBZ0UsQ0FBQztBQUNyRSxJQUFJLHlCQUFvRCxDQUFDO0FBQ3pELElBQUksV0FBa0IsQ0FBQztBQWNWLFFBQUEsaUJBQWlCLEdBQUcsS0FBSyxFQUNwQyxHQUFXLEVBQ1gsS0FBNkIsRUFDN0IsRUFBRTtJQUNGLFdBQVcsR0FBRyxFQUFFLENBQUM7SUFDakIsSUFBSSxLQUFLLENBQUMsSUFBSSxFQUFFO1FBQ2QsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRTtZQUN6QixXQUFXLENBQUMsSUFBSSxDQUFDLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxHQUFHLEVBQUUsS0FBSyxFQUFFLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3ZELENBQUMsQ0FBQyxDQUFDO0tBQ0o7SUFFRCw4QkFBOEIsR0FBRztRQUMvQixJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7UUFDaEIsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLElBQUksRUFBRSxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO1FBQ25ELEdBQUcsQ0FBQyxLQUFLLENBQUMsa0JBQWtCLElBQUk7WUFDOUIsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtTQUM3QyxDQUFDO1FBQ0YsR0FBRyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFLFdBQVcsRUFBRSxDQUFDO0tBQ3JELENBQUM7SUFFRixJQUFJO1FBQ0YsZ0NBQWdDLEdBQUcsTUFBTSxXQUFXLENBQUMsSUFBSSxDQUN2RCxJQUFJLHVDQUF3QixDQUFDLDhCQUE4QixDQUFDLENBQzdELENBQUM7S0FDSDtJQUFDLE9BQU8sS0FBSyxFQUFFO1FBQ2QsSUFBSSxLQUFLLFlBQVksS0FBSyxFQUFFO1lBQzFCLE9BQU8sQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDckIsTUFBTSxLQUFLLENBQUM7U0FDYjtLQUNGO0lBRUQsSUFBSTtRQUNGLE1BQU0sU0FBUyxDQUFDLElBQUksQ0FDbEIsSUFBSSxnQ0FBbUIsQ0FBQztZQUN0QixJQUFJLEVBQUUseUJBQXlCLEdBQUcsRUFBRTtZQUNwQyxXQUFXLEVBQUUsa0JBQWtCO1lBQy9CLEtBQUssRUFBRSxnQ0FBZ0MsQ0FBQyxjQUFjO1lBQ3RELFNBQVMsRUFBRSxJQUFJO1lBQ2YsSUFBSSxFQUFFLFFBQVE7U0FDZixDQUFDLENBQ0gsQ0FBQztLQUNIO0lBQUMsT0FBTyxLQUFLLEVBQUU7UUFDZCxJQUFJLEtBQUssWUFBWSxLQUFLLEVBQUU7WUFDMUIsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNyQixNQUFNLEtBQUssQ0FBQztTQUNiO0tBQ0Y7SUFFRCxPQUFPO1FBQ0wsY0FBYyxFQUFFLGdDQUFnQyxDQUFDLGNBQWM7S0FDaEUsQ0FBQztBQUNKLENBQUMsQ0FBQztBQUVXLFFBQUEsaUJBQWlCLEdBQUcsS0FBSyxFQUFFLEdBQVcsRUFBRSxFQUFFO0lBQ3JELElBQUk7UUFDRix5QkFBeUIsR0FBRyxNQUFNLFNBQVMsQ0FBQyxJQUFJLENBQzlDLElBQUksZ0NBQW1CLENBQUMsRUFBRSxJQUFJLEVBQUUseUJBQXlCLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FDbEUsQ0FBQztLQUNIO0lBQUMsT0FBTyxLQUFLLEVBQUU7UUFDZCxJQUFJLEtBQUssWUFBWSxLQUFLLEVBQUU7WUFDMUIsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNyQixNQUFNLEtBQUssQ0FBQztTQUNiO0tBQ0Y7SUFFRCxJQUFJO1FBQ0YsTUFBTSxXQUFXLENBQUMsSUFBSSxDQUNwQixJQUFJLHVDQUF3QixDQUFDO1lBQzNCLGNBQWMsRUFBRSx5QkFBeUIsQ0FBQyxTQUFVLENBQUMsS0FBSztTQUMzRCxDQUFDLENBQ0gsQ0FBQztRQUNGLE1BQU0sU0FBUyxDQUFDLElBQUksQ0FDbEIsSUFBSSxtQ0FBc0IsQ0FBQyxFQUFFLElBQUksRUFBRSx5QkFBeUIsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUNyRSxDQUFDO0tBQ0g7SUFBQyxPQUFPLEtBQUssRUFBRTtRQUNkLElBQUksS0FBSyxZQUFZLEtBQUssRUFBRTtZQUMxQixPQUFPLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3JCLE1BQU0sS0FBSyxDQUFDO1NBQ2I7S0FDRjtBQUNILENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qIGVzbGludC1kaXNhYmxlIGltcG9ydC9uby1leHRyYW5lb3VzLWRlcGVuZGVuY2llcyAqL1xuaW1wb3J0IHtcbiAgQ2hpbWVDbGllbnQsXG4gIENyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZCxcbiAgQ3JlYXRlQXBwSW5zdGFuY2VDb21tYW5kSW5wdXQsXG4gIENyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZE91dHB1dCxcbiAgRGVsZXRlQXBwSW5zdGFuY2VDb21tYW5kLFxuICBUYWcsXG59IGZyb20gJ0Bhd3Mtc2RrL2NsaWVudC1jaGltZSc7XG5cbmltcG9ydCB7XG4gIFNTTUNsaWVudCxcbiAgRGVsZXRlUGFyYW1ldGVyQ29tbWFuZCxcbiAgR2V0UGFyYW1ldGVyQ29tbWFuZCxcbiAgR2V0UGFyYW1ldGVyQ29tbWFuZE91dHB1dCxcbiAgUHV0UGFyYW1ldGVyQ29tbWFuZCxcbn0gZnJvbSAnQGF3cy1zZGsvY2xpZW50LXNzbSc7XG5cbmNvbnN0IGNoaW1lQ2xpZW50ID0gbmV3IENoaW1lQ2xpZW50KHtcbiAgcmVnaW9uOiBwcm9jZXNzLmVudi5BV1NfUkVHSU9OLFxufSk7XG5cbmNvbnN0IHNzbUNsaWVudCA9IG5ldyBTU01DbGllbnQoeyByZWdpb246IHByb2Nlc3MuZW52LkFXU19SRUdJT04gfSk7XG5cbmxldCBjcmVhdGVBcHBJbnN0YW5jZUNvbW1hbmRQYXJhbXM6IENyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZElucHV0O1xubGV0IGNyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZFJlc3BvbnNlOiBDcmVhdGVBcHBJbnN0YW5jZUNvbW1hbmRPdXRwdXQ7XG5sZXQgZ2V0UGFyYW1ldGVyQ29tbWFuZE91dHB1dDogR2V0UGFyYW1ldGVyQ29tbWFuZE91dHB1dDtcbmxldCB1cGRhdGVkVGFnczogVGFnW107XG5cbmludGVyZmFjZSBUYWdzIHtcbiAga2V5OiBzdHJpbmc7XG4gIHZhbHVlOiBzdHJpbmc7XG59XG5cbmludGVyZmFjZSBDcmVhdGVBcHBJbnN0YW5jZVByb3BzIHtcbiAgbmFtZT86IHN0cmluZztcbiAgbWV0YWRhdGE/OiBzdHJpbmc7XG4gIGNsaWVudFJlcXVlc3RUb2tlbj86IHN0cmluZztcbiAgdGFncz86IFRhZ3NbXTtcbn1cblxuZXhwb3J0IGNvbnN0IENyZWF0ZUFwcEluc3RhbmNlID0gYXN5bmMgKFxuICB1aWQ6IHN0cmluZyxcbiAgcHJvcHM6IENyZWF0ZUFwcEluc3RhbmNlUHJvcHMsXG4pID0+IHtcbiAgdXBkYXRlZFRhZ3MgPSBbXTtcbiAgaWYgKHByb3BzLnRhZ3MpIHtcbiAgICBwcm9wcy50YWdzLmZvckVhY2goKHRhZykgPT4ge1xuICAgICAgdXBkYXRlZFRhZ3MucHVzaCh7IEtleTogdGFnLmtleSwgVmFsdWU6IHRhZy52YWx1ZSB9KTtcbiAgICB9KTtcbiAgfVxuXG4gIGNyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZFBhcmFtcyA9IHtcbiAgICBOYW1lOiBwcm9wcy5uYW1lLFxuICAgIC4uLihwcm9wcy5tZXRhZGF0YSAmJiB7IE1ldGFkYXRhOiBwcm9wcy5tZXRhZGF0YSB9KSxcbiAgICAuLi4ocHJvcHMuY2xpZW50UmVxdWVzdFRva2VuICYmIHtcbiAgICAgIENsaWVudFJlcXVlc3RUb2tlbjogcHJvcHMuY2xpZW50UmVxdWVzdFRva2VuLFxuICAgIH0pLFxuICAgIC4uLih1cGRhdGVkVGFncy5sZW5ndGggPiAwICYmIHsgVGFnczogdXBkYXRlZFRhZ3MgfSksXG4gIH07XG5cbiAgdHJ5IHtcbiAgICBjcmVhdGVBcHBJbnN0YW5jZUNvbW1hbmRSZXNwb25zZSA9IGF3YWl0IGNoaW1lQ2xpZW50LnNlbmQoXG4gICAgICBuZXcgQ3JlYXRlQXBwSW5zdGFuY2VDb21tYW5kKGNyZWF0ZUFwcEluc3RhbmNlQ29tbWFuZFBhcmFtcyksXG4gICAgKTtcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICBpZiAoZXJyb3IgaW5zdGFuY2VvZiBFcnJvcikge1xuICAgICAgY29uc29sZS5lcnJvcihlcnJvcik7XG4gICAgICB0aHJvdyBlcnJvcjtcbiAgICB9XG4gIH1cblxuICB0cnkge1xuICAgIGF3YWl0IHNzbUNsaWVudC5zZW5kKFxuICAgICAgbmV3IFB1dFBhcmFtZXRlckNvbW1hbmQoe1xuICAgICAgICBOYW1lOiBgL2NoaW1lL2FwcEluc3RhbmNlQXJuLyR7dWlkfWAsXG4gICAgICAgIERlc2NyaXB0aW9uOiAnQXBwIEluc3RhbmNlIEFybicsXG4gICAgICAgIFZhbHVlOiBjcmVhdGVBcHBJbnN0YW5jZUNvbW1hbmRSZXNwb25zZS5BcHBJbnN0YW5jZUFybixcbiAgICAgICAgT3ZlcndyaXRlOiB0cnVlLFxuICAgICAgICBUeXBlOiAnU3RyaW5nJyxcbiAgICAgIH0pLFxuICAgICk7XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgaWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3IpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoZXJyb3IpO1xuICAgICAgdGhyb3cgZXJyb3I7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBhcHBJbnN0YW5jZUFybjogY3JlYXRlQXBwSW5zdGFuY2VDb21tYW5kUmVzcG9uc2UuQXBwSW5zdGFuY2VBcm4sXG4gIH07XG59O1xuXG5leHBvcnQgY29uc3QgRGVsZXRlQXBwSW5zdGFuY2UgPSBhc3luYyAodWlkOiBzdHJpbmcpID0+IHtcbiAgdHJ5IHtcbiAgICBnZXRQYXJhbWV0ZXJDb21tYW5kT3V0cHV0ID0gYXdhaXQgc3NtQ2xpZW50LnNlbmQoXG4gICAgICBuZXcgR2V0UGFyYW1ldGVyQ29tbWFuZCh7IE5hbWU6IGAvY2hpbWUvYXBwSW5zdGFuY2VBcm4vJHt1aWR9YCB9KSxcbiAgICApO1xuICB9IGNhdGNoIChlcnJvcikge1xuICAgIGlmIChlcnJvciBpbnN0YW5jZW9mIEVycm9yKSB7XG4gICAgICBjb25zb2xlLmVycm9yKGVycm9yKTtcbiAgICAgIHRocm93IGVycm9yO1xuICAgIH1cbiAgfVxuXG4gIHRyeSB7XG4gICAgYXdhaXQgY2hpbWVDbGllbnQuc2VuZChcbiAgICAgIG5ldyBEZWxldGVBcHBJbnN0YW5jZUNvbW1hbmQoe1xuICAgICAgICBBcHBJbnN0YW5jZUFybjogZ2V0UGFyYW1ldGVyQ29tbWFuZE91dHB1dC5QYXJhbWV0ZXIhLlZhbHVlLFxuICAgICAgfSksXG4gICAgKTtcbiAgICBhd2FpdCBzc21DbGllbnQuc2VuZChcbiAgICAgIG5ldyBEZWxldGVQYXJhbWV0ZXJDb21tYW5kKHsgTmFtZTogYC9jaGltZS9hcHBJbnN0YW5jZUFybi8ke3VpZH1gIH0pLFxuICAgICk7XG4gIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgaWYgKGVycm9yIGluc3RhbmNlb2YgRXJyb3IpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoZXJyb3IpO1xuICAgICAgdGhyb3cgZXJyb3I7XG4gICAgfVxuICB9XG59O1xuIl19