"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteChannelFlow = exports.CreateChannelFlow = exports.FallbackAction = exports.InvocationType = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_messaging_1 = require("@aws-sdk/client-chime-sdk-messaging");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKMessagingClient = new client_chime_sdk_messaging_1.ChimeSDKMessagingClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createChannelFlowCommandInput;
let createChannelFlowCommandOutput;
let getParameterCommandOutput;
let updatedProcessors;
let updatedTags;
var InvocationType;
(function (InvocationType) {
    InvocationType["ASYNC"] = "ASYNC";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
var FallbackAction;
(function (FallbackAction) {
    FallbackAction["CONTINUE"] = "CONTINUE";
    FallbackAction["ABORT"] = "ABORT";
})(FallbackAction = exports.FallbackAction || (exports.FallbackAction = {}));
exports.CreateChannelFlow = async (uid, props) => {
    updatedProcessors = [];
    if (props.processors) {
        props.processors.forEach((processor) => {
            updatedProcessors.push({
                Name: processor.name,
                ExecutionOrder: parseInt(processor.executionOrder),
                FallbackAction: processor.fallbackAction,
                Configuration: {
                    Lambda: {
                        ResourceArn: processor.configuration.lambda.resourceArn,
                        InvocationType: processor.configuration.lambda.invocationType,
                    },
                },
            });
        });
    }
    updatedTags = [];
    if (props.tags) {
        props.tags.forEach((tag) => {
            updatedTags.push({ Key: tag.key, Value: tag.value });
        });
    }
    createChannelFlowCommandInput = {
        AppInstanceArn: props.appInstanceArn,
        Name: props.name,
        ClientRequestToken: props.clientRequestToken,
        ...(updatedTags.length > 0 && { Tags: updatedTags }),
        Processors: updatedProcessors,
    };
    try {
        createChannelFlowCommandOutput = await chimeSDKMessagingClient.send(new client_chime_sdk_messaging_1.CreateChannelFlowCommand(createChannelFlowCommandInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: `/chime/channelFlowArn/${uid}`,
            Description: 'channelFlowArn',
            Value: createChannelFlowCommandOutput.ChannelFlowArn,
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        channelFlowArn: createChannelFlowCommandOutput.ChannelFlowArn,
    };
};
exports.DeleteChannelFlow = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: `/chime/channelFlowArn/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await chimeSDKMessagingClient.send(new client_chime_sdk_messaging_1.DeleteChannelFlowCommand({
            ChannelFlowArn: getParameterCommandOutput.Parameter?.Value,
        }));
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: `/chime/channelFlowArn/${uid}` }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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