"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const appInstance_1 = require("./appInstance");
const channelFlow_1 = require("./channelFlow");
const dataRetention_1 = require("./dataRetention");
const instanceAdmin_1 = require("./instanceAdmin");
const instanceUser_1 = require("./instanceUser");
const streamingConfig_1 = require("./streamingConfig");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', event);
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'AppInstance':
            switch (requestType) {
                case 'Create':
                    response.Data = await appInstance_1.CreateAppInstance(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstance successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await appInstance_1.DeleteAppInstance(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstance successful';
                    break;
            }
            break;
        case 'ChannelFlow':
            switch (requestType) {
                case 'Create':
                    response.Data = await channelFlow_1.CreateChannelFlow(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateChannelFlow successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await channelFlow_1.DeleteChannelFlow(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteChannelFlow successful';
                    break;
            }
            break;
        case 'DataRetention':
            switch (requestType) {
                case 'Create':
                    response.Data = await dataRetention_1.PutDataRetention(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutDataRetention successful';
                    break;
                case 'Update':
                    response.Data = await dataRetention_1.PutDataRetention(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutDataRetention successful';
                    break;
            }
            break;
        case 'AppInstanceAdmin':
            switch (requestType) {
                case 'Create':
                    response.Data = await instanceAdmin_1.CreateAppInstanceAdmin(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstanceAdmin successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await instanceAdmin_1.DeleteAppInstanceAdmin(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstanceAdmin successful';
                    break;
            }
            break;
        case 'AppInstanceUser':
            switch (requestType) {
                case 'Create':
                    response.Data = await instanceUser_1.CreateAppInstanceUser(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateAppInstanceUser successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await instanceUser_1.DeleteAppInstanceUser(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteAppInstanceUser successful';
                    break;
            }
            break;
        case 'StreamingConfig':
            switch (requestType) {
                case 'Create':
                    response.Data = await streamingConfig_1.PutStreamingConfiguration(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutStreamingConfiguration successful';
                    break;
                case 'Update':
                    response.Data = await streamingConfig_1.PutStreamingConfiguration(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutStreamingConfiguration successful';
                    break;
            }
            break;
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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