"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PutStreamingConfiguration = exports.AppInstanceDataType = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_1 = require("@aws-sdk/client-chime");
const chimeClient = new client_chime_1.ChimeClient({
    region: process.env.AWS_REGION,
});
var AppInstanceDataType;
(function (AppInstanceDataType) {
    AppInstanceDataType["CHANNEL"] = "Channel";
    AppInstanceDataType["CHANNELMESSAGE"] = "ChannelMessage";
})(AppInstanceDataType = exports.AppInstanceDataType || (exports.AppInstanceDataType = {}));
let putStreamingConfigurationOutput;
let putStreamingConfigurationInput;
let updatedConfiguration;
exports.PutStreamingConfiguration = async (props) => {
    updatedConfiguration = [];
    props.streamingConfigs?.forEach((streamingConfig) => {
        updatedConfiguration.push({
            AppInstanceDataType: streamingConfig.appInstanceDataType,
            ResourceArn: streamingConfig.resourceArn,
        });
    });
    putStreamingConfigurationInput = {
        AppInstanceArn: props.appInstanceArn,
        AppInstanceStreamingConfigurations: updatedConfiguration,
    };
    try {
        putStreamingConfigurationOutput = await chimeClient.send(new client_chime_1.PutAppInstanceStreamingConfigurationsCommand(putStreamingConfigurationInput));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        appInstanceStreamingConfiguration: putStreamingConfigurationOutput.AppInstanceStreamingConfigurations,
    };
};
//# sourceMappingURL=data:application/json;base64,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