"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const phoneNumber_1 = require("./phoneNumber");
const sipMediaApp_1 = require("./sipMediaApp");
const sipRule_1 = require("./sipRule");
const voiceConnector_1 = require("./voiceConnector");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', event);
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'PhoneNumber':
            switch (requestType) {
                case 'Create':
                    response.Data = await phoneNumber_1.CreatePhoneNumber(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreatePhoneNumber successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await phoneNumber_1.DeletePhoneNumber(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeletePhoneNumber successful';
                    break;
            }
            break;
        case 'SMARule':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipRule_1.CreateSIPRule(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateSMARule successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipRule_1.DeleteSIPRule(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteSMARule successful';
                    break;
            }
            break;
        case 'SMA':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.CreateSipMediaApplication(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create SMA successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipMediaApp_1.DeleteSipMediaApplication(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete SMA successful';
                    break;
            }
            break;
        case 'SMALogging':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging Delete NoOP';
                    break;
            }
            break;
        case 'SMAAlexaSkill':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill Delete NoOP';
                    break;
            }
            break;
        case 'VoiceConnector':
            switch (requestType) {
                case 'Create':
                    response.Data = await voiceConnector_1.CreateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create VC successful';
                    break;
                case 'Update':
                    await voiceConnector_1.UpdateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await voiceConnector_1.DeleteVoiceConnector(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete VC successful';
                    break;
            }
            break;
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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