"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListChannelBans = void 0;
const ChimeSDKMessagingClient_1 = require("../ChimeSDKMessagingClient");
const ListChannelBansCommand_1 = require("../commands/ListChannelBansCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChannelBansCommand_1.ListChannelBansCommand(input), ...args);
};
async function* paginateListChannelBans(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMessagingClient_1.ChimeSDKMessagingClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMessaging | ChimeSDKMessagingClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListChannelBans = paginateListChannelBans;
